;͸
;                                                                          
; (c) 1995 by Marc van Shaney , aka Kaya Memisoglu                         
;                                                                          
; This Source-Code was written by and is copyrighted by Kaya Memisoglu	    
; You may use the whole code or only parts of it in your own programs      
; whether they are commercial or not. BUT you must give credits for these  
; parts to me (Kaya Memisoglu  or  Marc van Shaney).                       
; I am not responsible for any damage or loss caused by this program, so   
; if you success in erasing your harddisk with this code, then it is your  
; own fault and you should not claim me to be responsible...               
; I would be very pleased if you also sent me a postcard or even a letter  
; if you can use this code. My address:                                    
;                                                                          
;        Kaya Memisoglu                                                    
;        Reichenberger Ring 50                                             
;        63512 Hainburg                                                    
;        Germany                                                           
;	                                                                    
;	  Internet: memisogl@stud.uni-frankfurt.de                          
;                                                                          
; You can also leave a message for Marc van Shaney on the Nirvana BBS:     
;                                                                          
;              Nirvana BBS     ++49-(0)6245-3056      Sysop:Raytrayza      
;                                                                          
;                                                                          
;;
;
;


P386
LOCALS
JUMPS
.MODEL USE16 TINY
DOSSEG


VGA_Mode          equ  13h
VGA_Width	  equ	320
Text_Mode         equ  3
CRTC_Index        equ 3d4h
CRTC_Data         equ 3d5h
CRTC_Status       equ 3dah
Display_Enable    equ 01
Vertical_Sync     equ 08

MATRIX STRUC
	E1	dd	?		;The matrix looks like this:
	E2	dd	?		;               
	E3	dd	?		; e1   e2   e3  
	E4	dd	?		; e4   e5   e6  
	E5	dd	?		; e7   e8   e9  
	E6	dd	?		;               
	E7	dd	?
	E8	dd	?
	E9	dd	?
MATRIX	ENDS

WAIT_RETRACE MACRO
	LOCAL Nope3,Nope4
	mov dx,CRTC_Status
  Nope3:
	in al,dx
	test al,Display_Enable
	jnz short Nope3
  Nope4:
	in al,dx
	test al,Vertical_Sync
	jz short Nope4
	ENDM


UDATASEG
   ;<<Any uninitialized data is defined here>>

   ;<<Set up room for user stack, if default stack is not desired>>

Line_Count		dw	?
Object1_Ptr		dw	?
Object2_Ptr		dw	?
Object3_Ptr		dw	?
ObjectM_Ptr		dw	?
LandScape_Ptr		dw	?
Timer_Ptr		dd	?
Char_Offset16		dw	?
Char_Segment16		dw	?
Char_Offset14		dw	?
Char_Segment14		dw	?
Counter			dw	?
BWidth  		dw 	?
BHeight 		dw 	?
YY      		dd 	?
XX      		dd 	?
XStep   		dd 	?
YStep   		dd 	?
iter    		dw 	?
Dummy			dd	?
MTX1			MATRIX <?>
MTX2			MATRIX <?>
MTX3			MATRIX <?>
Dots			dw	200h*16 dup (?)	;Enough for 16 tables...
SineTable		db	256 dup (?)
   DW 50H DUP (?)
MyStack  LABEL WORD


;[]-------------------------------------------------------------------------[]
;|
;| The following macro return a sine-vale like this:
;| ax=b*sin(a*cx)
;|
LSINE MACRO a,b
	mov ax,cx
	fastimul bx,ax,a
	sar bx,3
	xor bh,bh
	shl bx,1
	movzx ebx,word ptr cs:[bx+OFFSET SinTab]
	fastimul eax,ebx,b
	sar eax,15
       ENDM

;[]-------------------------------------------------------------------------[]
;|
;| This macro intializes the byte-sine table for the plasma...
;|
INIT_SINE MACRO
	LOCAL L1
	mov si,OFFSET SinTab
	mov di,OFFSET SineTable
	mov ax,cs
	mov es,ax
	xor cl,cl
	mov bx,24
L1:	lods word ptr cs:[si]
	imul bx
	shrd ax,dx,15
	add al,24
	stosb
	dec cl
	jnz short L1
	ENDM

;[]-------------------------------------------------------------------------[]
;|
;| This macro intiliazes the palette accordingly to the actual table
;| AL must hold the current table...
;|

SET_PALETTE MACRO
	LOCAL L01,L02,TP,ENDE
	mov bh,15
	sub bh,al
	shl bh,2
	mov dx,03c8h
	mov al,10
	out dx,al
	inc dx
	mov cl,16

	cmp cs:[Pal_Type],1
	je short L02

L01:   	xor al,al
	out dx,al
	out dx,al
	mov al,bh
	out dx,al

	add bh,4
	and bh,63
	dec cl
	jnz short L01
	jmp short ENDE

L02:    xor al,al
	out dx,al
	cmp bh,59
	jb short TP
	mov al,bh
TP:	out dx,al
	mov al,bh
	out dx,al

	add bh,4
	and bh,63
	dec cl
	jnz short L02

ENDE:
	ENDM

;[]-------------------------------------------------------------------------[]
;|
;| This is a little randomize generator used in this demo...
;|
MULTIPLIER      equ	015a4e35h
INCREMENT       equ	1

RAND MACRO
	mov eax,cs:[Noise]
	mov edx,MULTIPLIER
	imul edx
	shrd eax,edx,16
	add eax,INCREMENT
	mov cs:[Noise],eax
     ENDM

;[]-------------------------------------------------------------------------[]
;|
;| This macro draws a "Dot-line" used for objects.
;| ES:DI MUST point to an object !
;|
DISTANCE	equ     7
SCALE		equ	6

DRAW_DOT_LINE MACRO x1,y1,z1,x2,y2,z2,count
	LOCAL L1
	if x1 eq 0
		xor eax,eax
	else
		mov eax,x1 shl SCALE
	endif
	if y1 eq 0
		xor ebx,ebx
	else
		mov ebx,y1 shl SCALE
	endif
	if z1 eq 0
		xor edx,edx
	else
		mov edx,z1 shl SCALE
	endif
	mov cl,count
L1:	mov es:[di],eax
	mov es:[di+4],ebx
	mov es:[di+8],edx
	if x2-x1 ne 0
		add eax,((x2-x1) shl SCALE)/count
	endif
	if y2-y1 ne 0
		add ebx,((y2-y1) shl SCALE)/count
	endif
	if z2-z1 ne 0
		add edx,((z2-z1) shl SCALE)/count
	endif

	add di,32
	dec cl
	jnz short L1
	ENDM

;[]-------------------------------------------------------------------------[]
;|
;| Now comes the first test-object
;|
;| The first test object is a simple tetraeder:
;|
;|	A(-20;10;0)
;|	B(20;10;0)
;|	C(0;10;35)
;|	D(0;-10;11)
;| The following lines must be drawn:
;|	AB
;|	AC
;|	AD
;|	BC
;|	BD
;|	CD
;|
INIT_TETRADE MACRO
	xor di,di
	mov word ptr es:[di],360	;How many dots ?
	add di,2
	DRAW_DOT_LINE -20,10,0, 20,10,0,60
	DRAW_DOT_LINE -20,10,0, 0,10,36,60
	DRAW_DOT_LINE -20,10,0, 0,-20,11,60
	DRAW_DOT_LINE 20,10,0,  0,10,36,60
	DRAW_DOT_LINE 20,10,0,  0,-20,11,60
	DRAW_DOT_LINE 0,10,36,  0,-20,11,60
	ENDM

;[]-------------------------------------------------------------------------[]
;|
;| This is the second object:a simple cube
;| ES must point to the empty object
;|
INIT_CUBE MACRO
	LOCAL L1,L2,L3
	xor di,di
	mov word ptr es:[di],448
	add di,2

	mov ebx,-16 shl SCALE
	mov cl,7
L1:	mov ch,8
	mov ebp,-16 shl SCALE
L2:	mov dl,8
	mov esi,-16 shl SCALE
L3:	mov es:[di],esi		;X
	mov es:[di+4],ebp	;Y
	mov es:[di+8],ebx	;Z
	add esi,(32 shl SCALE)/8
	add di,32
	dec dl
	jnz short L3
	add ebp,(32 shl SCALE)/8
	dec ch
	jnz short L2
	add ebx,(32 shl SCALE)/7
	dec cl
	jnz short L1

	ENDM

;[]-------------------------------------------------------------------------[]
;|
;| This macro will build up another cube...
;| ES must point to the empty object
;|
INIT_CUBE2 MACRO
	LOCAL L1,L2,L3,L4
	xor di,di
	mov word ptr es:[di],480
	add di,2

	mov cl,40
	mov ebx,-12 shl SCALE
	mov eax,ebx			;EAX=-12
	mov edx,ebx
	neg edx				;EDX=12
L1:	mov es:[di],ebx
	mov dword ptr es:[di+4],eax
	mov dword ptr es:[di+8],eax

	mov es:[di+32],ebx
	mov dword ptr es:[di+36],edx
	mov dword ptr es:[di+40],eax

	mov es:[di+64],ebx
	mov dword ptr es:[di+68],eax
	mov dword ptr es:[di+72],edx

	mov es:[di+96],ebx
	mov dword ptr es:[di+100],edx
	mov dword ptr es:[di+104],edx

	add ebx,(24 shl SCALE)/40
	add di,4*32
	dec cl
	jnz short L1


	mov cl,40
	mov ebx,eax
L2:	mov dword ptr es:[di],eax
	mov dword ptr es:[di+4],ebx
	mov dword ptr es:[di+8],eax

	mov dword ptr es:[di+32],edx
	mov dword ptr es:[di+36],ebx
	mov dword ptr es:[di+40],eax

	mov dword ptr es:[di+64],eax
	mov dword ptr es:[di+68],ebx
	mov dword ptr es:[di+72],edx

	mov dword ptr es:[di+96],edx
	mov dword ptr es:[di+100],ebx
	mov dword ptr es:[di+104],edx

	add ebx,(24 shl SCALE)/40
	add di,4*32
	dec cl
	jnz short L2

	mov cl,40
	mov ebx,eax
L3:	mov dword ptr es:[di],eax
	mov dword ptr es:[di+4],eax
	mov dword ptr es:[di+8],ebx

	mov dword ptr es:[di+32],eax
	mov dword ptr es:[di+36],edx
	mov dword ptr es:[di+40],ebx

	mov dword ptr es:[di+64],edx
	mov dword ptr es:[di+68],eax
	mov dword ptr es:[di+72],ebx

	mov dword ptr es:[di+96],edx
	mov dword ptr es:[di+100],edx
	mov dword ptr es:[di+104],ebx

	add ebx,(24 shl SCALE)/40
	add di,4*32
	dec cl
	jnz short L3
	ENDM


;[]-------------------------------------------------------------------------[]
;|
;| This macro initilzes the landscape using the sine-tables (it is some
;| sort of plasma...)
;|
INIT_LANDSCAPE MACRO
	LOCAL L1,L2
	xor di,di

	mov ax,74c3h
	mov dx,39b4h

	xor bh,bh
	mov bp,255
L1:	mov cl,128
	push ax
	push dx

	mov bl,al
	mov al,cs:[OFFSET SineTable+bp]
	add al,cs:[OFFSET SineTable+bx]
	mov bl,ah
	add al,cs:[OFFSET SineTable+bx]
	mov ah,al			;AX holds first two levels
	mov si,ax

L2:	mov ax,si

	mov bl,dl
	add al,cs:[OFFSET SineTable+bx]
	mov bl,dh
	add al,cs:[OFFSET SineTable+bx]
	add dx,0907h

	mov bl,dl
	add ah,cs:[OFFSET SineTable+bx]
	mov bl,dh
	add ah,cs:[OFFSET SineTable+bx]
	add dx,0008h

	stosw
	dec cl
	jnz short L2


	pop dx
	pop ax
	add ax,0605h
	dec bp
	jnz short L1
	ENDM

;[]-------------------------------------------------------------------------[]
;|
;| This macro is needed to clear the speed-things for the fall-down
;| FS should again contain the object
;|
CLEAR_SPEED MACRO
	LOCAL L1
	xor si,si
	mov cx,fs:[si]
	add si,30
	xor eax,eax
L1:	mov fs:[si],eax
	add si,32
	dec cx
	jnz short L1
	ENDM




.Code
;[]-------------------------------------------------------------------------[]
;|
;| Sorry, this is the only way I could get it work...
;|
;|
main proc near
	.STARTUP
	cld
	mov sp,OFFSET MYSTACK
	mov bx,cs
	add ax,OFFSET MYSTACK+32
	shr ax,4
	add ax,bx
	mov cs:[Object1_Ptr],ax
	add ax,410h
	mov cs:[Object2_Ptr],ax
	add ax,410h
	mov cs:[Object3_Ptr],ax
	add ax,410h
	mov cs:[ObjectM_Ptr],ax
	add ax,410h
	mov cs:[LandScape_Ptr],ax


	xor ax,ax
	mov cl,16
	mov bx,OFFSET Dots
@@L1:	mov cs:[bx],ax		;Set old dot-count to zero
	add bx,400h
	dec cl
	jnz short @@L1

	mov ax,VGA_Mode
	int 10h

	;
	;First lets get the address of 8x14 bit font...
	;
	mov ax,1130h
	mov bh,2
	int 10h
	mov cs:[CHar_Segment14],es
	mov cs:[CHar_Offset14],bp
	;
	;First lets get the address of 8x16 bit font...
	;
	mov ax,1130h
	mov bh,6
	int 10h
	mov cs:[CHar_Segment16],es
	mov cs:[CHar_Offset16],bp

	;Now lets install a new timer...
	cli
	xor ax,ax
	mov es,ax
	mov eax,es:[8*4]
	mov cs:[Timer_Ptr],eax
	mov word ptr es:[8*4],OFFSET NewTimer
	mov es:[8*4+2],cs
	mov al,36h		;Set new timer constant...
	out 43h,al
	mov dx,40h
	mov al,0ffh
	out dx,al
	mov al,40h
	out dx,al

	sti

;[]-------------------------------------------------------------------------[]
;|
;| This is the intro-part
;|
	call Calc_Mandel

	mov dx,03c8h		;First lets set up a new palette....
	xor al,al
	out dx,al
	inc dx
	xor cl,cl

@@L01:  mov ch,8
@@L02:  xor al,al
	out dx,al
	mov al,cl
	mul ch
	out dx,al
	out dx,al
	dec ch
	jnz short @@L02

	inc cl
	cmp cl,32
	jne short @@L01


	mov cs:[Tick],0		;Ok. now starts the tunnel (the mapper...)
@@K:    mov bp,cs:[Tick]
	shl bp,1
	call VMap C,165,99,3,319,0,201
	call HMap C,155,101,10, 0,199,320
	add bp,128		;This is to compensate a bug in my code.....
	call HMap C,0,0,318, 155,99,10
	call VMap C,0,0,200, 155,99,2

	cmp cs:[Tick],256+64
	jb short @@K

	xor di,di		;lets clear the screen
	mov cx,320*200/4
	xor eax,eax
	rep stosd


;[]-------------------------------------------------------------------------[]
;|
;| First lets start up with a logo....
;|
	mov dx,03c8h		;First lets set up a new palette....
	xor al,al
	out dx,al
	inc dx
	xor al,al

@@L06:  out dx,al
	out dx,al
	out dx,al
	inc al
	cmp al,64
	jne short @@L06

	mov ax,0a000h
	mov es,ax
	mov di,36*320+16
	mov bp,OFFSET Start_Text1
	call FDraw_Text
	mov di,100*320+16
	mov bp,OFFSET Start_Text2
	call FDraw_Text

	mov bp,80
	std
@@KKK:	WAIT_RETRACE

	mov cx,78*320/2
	mov di,320*200
@@LKH:  mov eax,es:[di]
	add eax,es:[di-320]
	add eax,es:[di-318]
	add eax,es:[di-322]
	and eax,0fcfcfcfch
	shr eax,2
	stosd

	dec cx
	jnz short @@LKH

	dec bp
	jnz short @@KKK
	cld


	xor di,di		;Clear Screen
	xor eax,eax
	mov cx,320*200/4
	rep stosd


;[]-------------------------------------------------------------------------[]
;|
;| Now the objects will get intialized...
;|
	testa:
	INIT_SINE
	mov es,cs:[Object1_Ptr]
	INIT_TETRADE
	mov es,cs:[Object2_Ptr]
	INIT_CUBE
	mov es,cs:[Object3_Ptr]
	INIT_CUBE2
	mov es,cs:[LandScape_Ptr]
	INIT_LANDSCAPE

;[]-------------------------------------------------------------------------[]
;|
;| Now the dot-part start....
;|
	mov fs,cs:[Object1_Ptr]
	mov cx,230
@@1:    push cx
	call Transform_Object
	call TDraw_Object
	sub cs:[Rot_X],2
	inc cs:[Rot_Y]
	dec cs:[Rot_Z]
	add word ptr cs:[Move_X],(90 shl SCALE)/230
	pop cx
	dec cx
	jnz short @@1

	CLEAR_SPEED
	mov cx,230
@@2:    push cx
	call Fall_Down
	call TDraw_Object
	pop cx
	dec cx
	jnz short @@2

	;
	;Now the second object will be morphed in....
	;
	mov cs:[Rot_Z],0
	mov fs,cs:[Object2_Ptr]
	call Transform_Object
	xor ebp,ebp
@@3:	push ebp
	mov ds,cs:[Object1_Ptr]
	mov fs,cs:[Object2_Ptr]
	mov es,cs:[ObjectM_Ptr]
	call Morph_Tables
	mov fs,cs:[ObjectM_Ptr]
	call TDraw_Object
	pop ebp
	add ebp,2
	cmp ebp,256
	jne short @@3

	mov fs,cs:[Object2_Ptr]
	mov cx,512
@@4:    push cx
	mov bx,cx
	xor bh,bh
	shl bx,1
	movsx eax,cs:[OFFSET SinTab+bx]
	sar eax,5
	mov cs:[Move_X],eax
	call Transform_Object
	call TDraw_Object
	inc cs:[Rot_X]
	dec cs:[Rot_Y]
	pop cx
	dec cx
	jnz short @@4


	;
	;And now the third object will morph in...
	;
	xor ebp,ebp
@@5:    push cx
	push ebp
	mov bx,cx
	xor bh,bh
	shl bx,1
	movsx eax,cs:[OFFSET SinTab+bx]
	sar eax,5
	mov cs:[Move_X],eax
	mov fs,cs:[Object3_Ptr]
	call Transform_Object
	mov fs,cs:[Object2_Ptr]
	call Transform_Object

	pop ebp
	push ebp

	mov ds,cs:[Object2_Ptr]
	mov fs,cs:[Object3_Ptr]
	mov es,cs:[ObjectM_Ptr]
	call Morph_Tables
	mov fs,cs:[ObjectM_Ptr]
	call TDraw_Object

	inc cs:[Rot_X]
	dec cs:[Rot_Y]
	pop ebp
	pop cx
	dec cx
	add ebp,2
	cmp ebp,256
	jne short @@5

	mov fs,cs:[Object3_Ptr]
@@6:    push cx
	mov bx,cx
	xor bh,bh
	shl bx,1
	movsx eax,cs:[OFFSET SinTab+bx]
	sar eax,5
	mov cs:[Move_X],eax
	call Transform_Object
	call TDraw_Object
	inc cs:[Rot_X]
	dec cs:[Rot_Y]
	pop cx
	dec cx
	cmp cx,-210-310		;256
	jnz short @@6

	;
	;Now the tunnel-F/X will arrive...
	;
	mov es,cs:[ObjectM_Ptr]
	xor edx,edx
	mov cs:[Move_X],edx
	mov cs:[Rot_Y],dx
	call INIT_TUNNEL
	xor ebp,ebp
@@8:	push ebp
	mov ds,cs:[Object3_Ptr]
	mov fs,cs:[ObjectM_Ptr]
	mov es,cs:[Object1_Ptr]
	call Morph_Tables
	mov fs,cs:[Object1_Ptr]
	call TDraw_Object
	pop ebp
	add ebp,2
	cmp ebp,256
	jne short @@8

	tunnel:
	mov fs,cs:[ObjectM_Ptr]
	mov cx,500
	xor edx,edx
@@9:	push cx
	push edx
	mov es,cs:[ObjectM_Ptr]
	call INIT_TUNNEL
	call TDraw_Object
	pop edx
	add edx,32
	pop cx
	dec cx
	jnz @@9



	;
	; Now the landscape will morph in...
	;
	SCAPE:
	xor si,si
	mov dword ptr cs:[Move_Z],(40 shl SCALE)+400*32
	mov word ptr cs:[Rot_X],6
	mov dword ptr cs:[Move_X],0
	mov fs,cs:[Object2_Ptr]
	mov es,cs:[Landscape_Ptr]
	call FDraw_Scape
	call Transform_Object

	xor bp,bp
@@D:	push bp
	mov ds,cs:[ObjectM_Ptr]
	mov fs,cs:[Object2_Ptr]
	mov es,cs:[Object1_Ptr]
	call Morph_Tables
	mov fs,cs:[Object1_Ptr]
	call TDraw_Object
	pop bp
	add bp,2
	cmp bp,256
	jne short @@D


	mov fs,cs:[Object2_Ptr]
	mov bp,570
	xor bx,bx
	xor si,si
@@E:    push bp
	push si
	push bx
	mov es,cs:[Landscape_Ptr]
	call FDraw_Scape
	call Transform_Object
	call TDraw_Object
	dec cs:[Rot_Y]
	pop bx
	pop si
	pop bp
	add bl,56h
	adc si,0
	add bh,67h
	jnc short @@LAK
	add si,100h
@@LAK:  cmp bp,200
	jbe short @@G
	sub dword ptr cs:[Move_Z],32
@@G:	dec bp
	jnz short @@E



	CLEAR_SPEED
	mov cx,140
@@A:    push cx
	call Fall_Down
	call TDraw_Object
	pop cx
	dec cx
	jnz short @@A


	add dword ptr cs:[Move_Z],128
	;
	;Now the font-scroler comes
	;
	Scroller:
	mov cs:[Rot_Y],2
	mov dword ptr cs:[Move_Z],40 shl SCALE
	mov fs,cs:[Object3_Ptr]
	xor ax,ax
	call FDraw_Scroller
	call Transform_Object

	mov ebp,256
@@C:	push ebp
	mov ds,cs:[Object3_Ptr]
	mov fs,cs:[Object2_Ptr]
	mov es,cs:[Object1_Ptr]
	call Morph_Tables
	mov fs,cs:[Object1_Ptr]
	call TDraw_Object
	pop ebp
	sub bp,2
	jnz short @@C

	mov cs:[Pal_Type],1
	xor bp,bp
@@B:	push bp
	mov ax,bp
	shr ax,1
	call FDraw_Scroller
	call Transform_Object
	call TDraw_Object
	inc cs:[Rot_Z]
	dec cs:[Rot_Y]
	pop bp
	inc bp
	cmp bp,(OFFSET End_Text - OFFSET Scrolly_Text)*16
	jb short @@B



;[]-------------------------------------------------------------------------[]
;|
;| Now comes last but not least a boring "THE END"...
;|
Soften:
	mov dx,03c8h		;First lets set up a new palette....
	xor al,al
	out dx,al
	inc dx
	xor al,al

@@L03:  out dx,al
	out dx,al
	out dx,al
	inc al
	cmp al,64
	jne short @@L03

	mov ax,0a000h
	mov es,ax
	mov di,68*320+48
	mov bp,OFFSET End_Text
	call FDraw_Text
	mov bp,40
@@L9:   mov di,66*320
	WAIT_RETRACE
	mov cx,68*320
@@LA: 	movzx ax,es:[di]
	movzx bx,es:[di+1]
	add ax,bx
	mov bl,es:[di-1]
	add ax,bx
	mov bl,es:[di-320]
	add ax,bx
	mov bl,es:[di+320]
	add ax,bx
	mov bl,es:[di-319]
	add ax,bx
	mov bl,es:[di+321]
	add ax,bx
	mov bl,es:[di-321]
	add ax,bx
	shr ax,3
	stosb
	dec cx
	jnz short @@LA

	dec bp
	jnz short @@L9




;[]-------------------------------------------------------------------------[]
;|
;| Well, that's the end. Here will tidy up memory and set the screen back
;| to stupid old text mode
;|
;| And that's is ! bye....
;|
Ende:   mov al,36h		;restore timer-tick speed...
	out 43h,al
	mov dx,40h
	mov al,0ffh
	out dx,al
	out dx,al
	xor ax,ax		;Restore timer interrupt...
	mov es,ax
	mov eax,cs:[Timer_Ptr]
	mov es:[8*4],eax
	mov ax,Text_Mode
	int 10h
	.EXIT
main endp

Scrolly_Text db "CODED BY MARC VAN SHANEY   GREETINGS GO TO  FUNK!  "
	     db "INSANE FREQUENCIES  ",0,0
End_Text     db "THE END",0
Start_Text1  db "POINTS OF",0
Start_Text2  db "NO RETURN",0


;[]-------------------------------------------------------------------------[]
;|
;| This thing initializes a tunnel-F/X, but only in the *TRANFORMED* area.
;| This is due speed reasons...
;|
;| ES must point to the empty object
;| EDX must hold start-z coordinate...
;|
INIT_TUNNEL PROC NEAR
	xor di,di
	mov word ptr es:[di],510
	add di,2
	mov cl,16

	mov cs:[Dummy],edx
	cmp cs:[Dummy],10000
	jb short @@J1
	mov cs:[Dummy],10000
@@J1:	mov bx,dx
	shr bx,2
	and bx,1feh
	mov bp,bx
	neg edx
	and edx,255
	add edx,256			;EDX=Z

@@L2:   add edx,256
	push bx
	push bp
	push edx
	movsx eax,cs:[OFFSET CosTab+bx]
	imul cs:[Dummy]
	shrd eax,edx,19
	mov esi,eax
	movsx eax,cs:[OFFSET SinTab+bp]
	imul cs:[Dummy]
	shrd eax,edx,19
	mov ebp,eax
	pop edx
	xor bx,bx
@@L1:   movsx eax,cs:[OFFSET SinTab+bx]
	sar eax,5
	add eax,ebp
	mov es:[di+16],eax
	neg eax
	add eax,ebp
	add eax,ebp

	mov es:[di+16+32],eax

	movsx eax,cs:[OFFSET CosTab+bx]
	sar eax,5
	add eax,esi
	mov es:[di+20],eax
	mov es:[di+24],edx

	mov es:[di+20+32],eax
	mov es:[di+24+32],edx
	add di,64
	add bl,16
	jnz short @@L1

	pop bp
	pop bx
	add bx,12
	add bp,14
	and bx,1feh
	and bp,1feh
	dec cl
	jnz @@L2
	retn
INIT_TUNNEL ENDP



;[]-------------------------------------------------------------------------[]
;|
;| This routine fits an object into the dot-table
;| Note that the distance must be achieved by the fudging in fixed point
;| arithemtic. This saves expensive shld and shl-cycles !
;|
;| FS must point to the specific object !
;| The dot-table number will be automatically incremented and the last table
;| will be cleared...
;|

TDraw_Object PROC NEAR
	mov bx,0a000h
	mov gs,bx		;Video segment

	WAIT_RETRACE

	mov ax,cs:[This_Table]
	inc ax
	and ax,0fh
	mov cs:[This_Table],ax
	mov di,ax
	shl di,10
	add di,OFFSET Dots+2

	add al,10
	mov byte ptr cs:[@@C1-1],al
	sub al,10
	SET_PALETTE

	push cs
	pop es

	xor si,si
	lods word ptr fs:[si]	;Number of points...
	mov cx,ax
	xor bp,bp               ;BP will hold the number of set pixels
	jcxz @@E2
	push di

@@L1:   cmp dword ptr fs:[si+24],4
	jle short @@1
	mov eax,fs:[si+20]	;Y-coordinate
	shl eax,DISTANCE
	cdq
	idiv dword ptr fs:[si+24]
	add ax,100
	cmp ax,199
	jae short @@1
	fastimul bx,ax,320	;BX holds row-address

	mov eax,fs:[si+16]	;X-coordinate
	shl eax,DISTANCE
	cdq
	idiv dword ptr fs:[si+24]
	add ax,160
	cmp ax,319
	jae short @@1
	add ax,bx
	stosw			;Save address

	mov bx,ax		;Set pixel...
	mov byte ptr gs:[bx],12h
@@C1:	inc bp			;One object more...

@@1:    add si,32		;Size of one entry
	dec cx
	jnz short @@L1

	pop di
@@E2:	mov es:[di-2],bp	;Save number of set pixels...


	;Now lets clear the old dots...
	mov ax,cs:[This_Table]	;Get old table-number
	sub ax,0fh
	and ax,0fh
	mov si,ax
	shl si,10
	add si,OFFSET Dots
	movzx bx,al
	add bl,10
	lods word ptr cs:[si]	;Number of dots
	mov cx,ax
	jcxz short @@E
	xor eax,eax
@@L2:	lods word ptr cs:[si]
	cmp gs:[eax],bl		;Still the same colour ???
	jne short @@2
	mov gs:[eax],bh		;Clear pixel
@@2:	dec cx
	jnz short @@L2

@@E:	retn
TDraw_Object ENDP




;[]-------------------------------------------------------------------------[]
;|
;| Now follow two maacros for the SINE and COSINE functions including a
;| (Co)Sine-table
;|
;Sine and Cosine table (15 bit fixed point arithmetic (FPA) )


SinTab	dw 00000h,00324h,00647h,0096ah,00c8bh,00fabh,012c7h,015e1h,018f8h,01c0bh,01f19h,02223h,02527h,02826h,02b1eh,02e10h
	dw 030fbh,033deh,036b9h,0398ch,03c56h,03f16h,041cdh,0447ah,0471ch,049b3h,04c3fh,04ebfh,05133h,0539ah,055f4h,05842h
	dw 05a81h,05cb3h,05ed6h,060ebh,062f1h,064e7h,066ceh,068a5h,06a6ch,06c23h,06dc9h,06f5eh,070e1h,07254h,073b5h,07503h
	dw 07640h,0776bh,07883h,07989h,07a7ch,07b5ch,07c29h,07ce2h,07d89h,07e1ch,07e9ch,07f08h,07f61h,07fa6h,07fd7h,07ff5h
CosTab	dw 07fffh,07ff5h,07fd7h,07fa6h,07f61h,07f08h,07e9ch,07e1ch,07d89h,07ce2h,07c29h,07b5ch,07a7ch,07989h,07883h,0776bh
	dw 07640h,07503h,073b5h,07254h,070e1h,06f5eh,06dc9h,06c23h,06a6ch,068a5h,066ceh,064e7h,062f1h,060ebh,05ed6h,05cb3h
	dw 05a81h,05842h,055f4h,0539ah,05133h,04ebfh,04c3fh,049b3h,0471ch,0447ah,041cdh,03f16h,03c56h,0398ch,036b9h,033deh
	dw 030fbh,02e10h,02b1eh,02826h,02527h,02223h,01f19h,01c0bh,018f8h,015e1h,012c7h,00fabh,00c8bh,0096ah,00647h,00324h
	dw 00000h,0fcdch,0f9b9h,0f696h,0f375h,0f055h,0ed39h,0ea1fh,0e708h,0e3f5h,0e0e7h,0ddddh,0dad9h,0d7dah,0d4e2h,0d1f0h
	dw 0cf05h,0cc22h,0c947h,0c674h,0c3aah,0c0eah,0be33h,0bb86h,0b8e4h,0b64dh,0b3c1h,0b141h,0aecdh,0ac66h,0aa0ch,0a7beh
	dw 0a57fh,0a34dh,0a12ah,09f15h,09d0fh,09b19h,09932h,0975bh,09594h,093ddh,09237h,090a2h,08f1fh,08dach,08c4bh,08afdh
	dw 089c0h,08895h,0877dh,08677h,08584h,084a4h,083d7h,0831eh,08277h,081e4h,08164h,080f8h,0809fh,0805ah,08029h,0800bh
	dw 08001h,0800bh,08029h,0805ah,0809fh,080f8h,08164h,081e4h,08277h,0831eh,083d7h,084a4h,08584h,08677h,0877dh,08895h
	dw 089c0h,08afdh,08c4bh,08dach,08f1fh,090a2h,09237h,093ddh,09594h,0975bh,09932h,09b19h,09d0fh,09f15h,0a12ah,0a34dh
	dw 0a57fh,0a7beh,0aa0ch,0ac66h,0aecdh,0b141h,0b3c1h,0b64dh,0b8e4h,0bb86h,0be33h,0c0eah,0c3aah,0c674h,0c947h,0cc22h
	dw 0cf05h,0d1f0h,0d4e2h,0d7dah,0dad9h,0ddddh,0e0e7h,0e3f5h,0e708h,0ea1fh,0ed39h,0f055h,0f375h,0f696h,0f9b9h,0fcdch
	dw 00000h,00324h,00647h,0096ah,00c8bh,00fabh,012c7h,015e1h,018f8h,01c0bh,01f19h,02223h,02527h,02826h,02b1eh,02e10h
	dw 030fbh,033deh,036b9h,0398ch,03c56h,03f16h,041cdh,0447ah,0471ch,049b3h,04c3fh,04ebfh,05133h,0539ah,055f4h,05842h
	dw 05a81h,05cb3h,05ed6h,060ebh,062f1h,064e7h,066ceh,068a5h,06a6ch,06c23h,06dc9h,06f5eh,070e1h,07254h,073b5h,07503h
	dw 07640h,0776bh,07883h,07989h,07a7ch,07b5ch,07c29h,07ce2h,07d89h,07e1ch,07e9ch,07f08h,07f61h,07fa6h,07fd7h,07ff5h



;Cosinus und Sinus:
;    In : bx      -> Angel (from 0 to 256 for 2PI or 360 degerees)
;         eax     -> Value to multpiply sine with
;    Out: ebx     -> Sinus or Cosinus
;         edx:eax -> Multiplied result
Sinus MACRO
	xor bh,bh
	shl bx,1
	movsx ebx,cs:[OFFSET SinTab+bx]
	imul ebx
	shrd eax,edx,15
	sar edx,15
      ENDM
Cosinus MACRO
	xor bh,bh
	shl bx,1
	movsx ebx,cs:[OFFSET CosTab+bx]
	imul ebx
	shrd eax,edx,15
	sar edx,15
      ENDM

MSinusCosinus MACRO
	xor bh,bh
	shl bx,1
	movsx eax,cs:[OFFSET SinTab+bx]
	shl eax,1
	movsx edx,cs:[OFFSET CosTab+bx]
	shl edx,1
      ENDM
;[]-------------------------------------------------------------------------[]
;|
;| This routine applies a matrix to all dots on the screen...
;|
;| FS must contain the object
;|
;| MATRIX_Mul multiplies the following thing:
;|   C=B*A
;| DI  -  C
;| SI  -  B
;| BP  -  A
;|
;| The transformation A will be performed first !
;|
MATRIX_Mul PROC NEAR
	mov cl,3
@@L2:	mov ch,3
@@L1:	mov eax,cs:[si]
	imul dword ptr cs:[bp]
	shrd eax,edx,16
	mov ebx,eax		;Save it here
	mov eax,cs:[si+4]
	imul dword ptr cs:[bp+12]
	shrd eax,edx,16
	add ebx,eax		;Save it here
	mov eax,cs:[si+8]
	imul dword ptr cs:[bp+24]
	shrd eax,edx,16
	add eax,ebx		;Save it here
	mov cs:[di],eax		;C:= b11*a11+b12*a21+b13*a31
	add di,4		;Next matrix item...
	add bp,4		;Next coloumn
	dec ch
	jnz short @@L1

	sub bp,3*4              ;Reset coloumn-counter of A
	add si,3*4		;Next row in B
	dec cl
	jnz short @@L2

	retn
MATRIX_Mul ENDP



Transform_Object PROC NEAR
	xor eax,eax
	mov ebx,1 shl 16

	;First lets clear some matrix-entries that are NOT needed
	mov cs:[MTX1.E3],eax	;A:Z-axis rotation
	mov cs:[MTX1.E6],eax
	mov cs:[MTX1.E7],eax
	mov cs:[MTX1.E8],eax
	mov cs:[MTX1.E9],ebx

	mov cs:[MTX2.E1],ebx	;B:X-axis rotation
	mov cs:[MTX2.E2],eax
	mov cs:[MTX2.E3],eax
	mov cs:[MTX2.E4],eax
	mov cs:[MTX2.E7],eax

	mov bx,cs:[Rot_Z]
	MSinusCosinus
	mov cs:[MTX1.E4],eax
	neg eax
	mov cs:[MTX1.E2],eax
	mov cs:[MTX1.E1],edx
	mov cs:[MTX1.E5],edx


	mov bx,cs:[Rot_X]
	MSinusCosinus
	mov cs:[MTX2.E8],eax
	neg eax
	mov cs:[MTX2.E6],eax
	mov cs:[MTX2.E5],edx
	mov cs:[MTX2.E9],edx

	mov si,OFFSET MTX2
	mov bp,OFFSET MTX1
	mov di,OFFSET MTX3
	call MATRIX_Mul		;Result will be in MTX3


	xor eax,eax
	mov ebx,1 shl 16

	;First lets clear some matrix-entries that are NOT needed
	mov cs:[MTX2.E2],eax	;B:Y-axis rotation
	mov cs:[MTX2.E4],eax
	mov cs:[MTX2.E5],ebx
	mov cs:[MTX2.E6],eax
	mov cs:[MTX2.E8],eax

	mov bx,cs:[Rot_Y]
	MSinusCosinus
	mov cs:[MTX2.E3],eax
	neg eax
	mov cs:[MTX2.E7],eax
	mov cs:[MTX2.E1],edx
	mov cs:[MTX2.E9],edx

	mov si,OFFSET MTX2
	mov bp,OFFSET MTX3
	mov DI,OFFSET MTX1	;Result will be in MTX1
	call MATRIX_Mul

	xor si,si
	lods word ptr fs:[si]	;Number of points...
	mov cx,ax
	jcxz @@E
@@L1:	mov ebx,fs:[si]		;EBX : X
	mov ebp,fs:[si+4]	;EBP : Y
	mov edi,fs:[si+8]	;EDI : Z
	mov eax,cs:[MTX1.E1]
	imul ebx
	shrd eax,edx,16
	mov fs:[si+16],eax
	mov eax,cs:[MTX1.E2]
	imul ebp
	shrd eax,edx,16
	add fs:[si+16],eax
	mov eax,cs:[MTX1.E3]
	imul edi
	shrd eax,edx,16
	add eax,cs:[Move_X]
	add fs:[si+16],eax

	mov eax,cs:[MTX1.E4]
	imul ebx
	shrd eax,edx,16
	mov fs:[si+20],eax
	mov eax,cs:[MTX1.E5]
	imul ebp
	shrd eax,edx,16
	add fs:[si+20],eax
	mov eax,cs:[MTX1.E6]
	imul edi
	shrd eax,edx,16
	add eax,cs:[Move_Y]
	add fs:[si+20],eax

	mov eax,cs:[MTX1.E7]
	imul ebx
	shrd eax,edx,16
	mov fs:[si+24],eax
	mov eax,cs:[MTX1.E8]
	imul ebp
	shrd eax,edx,16
	add fs:[si+24],eax
	mov eax,cs:[MTX1.E9]
	imul edi
	shrd eax,edx,16
	add eax,cs:[Move_Z]
	add fs:[si+24],eax

	add si,32
	dec cx
	jnz @@L1
@@E:	retn
Transform_Object ENDP



;[]-------------------------------------------------------------------------[]
;|
;| This is the falldown-code
;|
;| FS must contain the paragraph of thje TRANSFORMED object that will
;| fall down to the floor
;|
MIN_FLOOR	equ	(16 shl SCALE)
ACCELERATION 	equ	2
Fall_Down PROC NEAR
	xor si,si
	lods word ptr fs:[si]	;Number of points...
	mov cx,ax
@@L1:   mov eax,fs:[si+20]	;EAX : Y
	mov ebx,fs:[si+28]	;EBX : V
	add eax,ebx
	cmp eax,MIN_FLOOR
	jl short @@1
		sub eax,2*MIN_FLOOR
		neg eax
		fastimul edx,ebx,-50
		sar edx,SCALE
		mov ebx,edx
@@1:	mov fs:[si+20],eax
	add ebx,ACCELERATION
	mov fs:[si+28],ebx

	add si,32
	dec cx
	jnz short @@L1
	retn
Fall_Down ENDP


;[]-------------------------------------------------------------------------[]
;|
;| This is the morphing code
;|
;| Ok, look at the following rules:
;| FS contains src 1
;| DS contains src 2
;| ES contains dst
;| EBP should contain how much of FS should be used (8 bit fudge)
;|
;|
;| FS _MUST_ have defined most points !
;|
;| Only the *TRANSFORMED* points will be interpolated !
;|
Morph_tables PROC NEAR
	xor si,si               ;SI will index FS and ES
	xor di,di		;DI will index DS
	mov cx,fs:[si]
	mov es:[si],cx		;How many points must get transformed...
	mov cs:[Counter],cx
	mov bx,ds:[si]
	add di,2
	mov si,di
	mov ecx,256		;ECX is factor for src2
	sub ecx,ebp		;EBP is factor for src1

@@L1:	mov eax,fs:[si+16]
	imul eax,ebp
	mov edx,ds:[di+16]
	imul edx,ecx
	add eax,edx
	sar eax,8
	mov es:[si+16],eax

	mov eax,fs:[si+20]
	imul eax,ebp
	mov edx,ds:[di+20]
	imul edx,ecx
	add eax,edx
	sar eax,8
	mov es:[si+20],eax

	mov eax,fs:[si+24]
	imul eax,ebp
	mov edx,ds:[di+24]
	imul edx,ecx
	add eax,edx
	sar eax,8
	mov es:[si+24],eax

	add si,32
	add di,32
	dec bx
	jnz short @@1
		xor di,di
		mov bx,ds:[di]
		add di,2
@@1:	dec cs:[Counter]
	jnz short @@L1

	retn
Morph_Tables ENDP



;[]-------------------------------------------------------------------------[]
;|
;| Ok... this MACRO is used to draw the scroller in the mandelbrot-part
;| AX must contains pixel-position....
;| FS must point to 3D-Vector-Table
;|
Font_Width	  equ  8
Font_Height	  equ  14

FDraw_Scroller PROC NEAR
	mov ds,cs:[CHar_Segment14]

	xor dx,dx
	mov bx,Font_Width
	idiv bx                 ;AX holds first char to draw
				;DX holds pixels to draw from this char
	xor bx,bx         	;BX holds screen-row
	sub bx,dx		;We are in the negative
	mov bp,OFFSET Scrolly_Text
	add bp,ax		;CS:BP points to first char to draw

	movsx eax,bx
	shl eax,SCALE
	add eax,-20 shl SCALE
	mov dword ptr cs:[@@C1-4],eax
	mov dword ptr cs:[@@C2-4],-4 shl SCALE

	xor dx,dx
	mov di,2
@@S212:                      ;Buchstabenschleife
	movzx ax,byte ptr cs:[bp] ;AX=Zeichen
	fastimul si,ax,Font_Height
	jz short Font_End
	add si,cs:[Char_Offset14]

	mov cs:[Line_Count],Font_Height
  @@Font_V_Loop:                    ;Zeilenschleife
	  lods byte ptr ds:[si]   ;Bitmuster in AL geladen
	  mov cx,Font_Width-1
    @@Font_H_Loop:                  ;Punktschleife
	    inc bx
	    cmp bx,50
	    jae short @@N
	    bt ax,cx
	    jnc short @@N
	    inc dx		  ;One point more...
	    mov fs:[di],12345678h
     @@C1:  mov fs:[di+4],12345678h
     @@C2:  mov dword ptr fs:[di+8],1 shl SCALE
	    add di,32

     @@N:   add dword ptr cs:[@@C1-4],1 shl SCALE
	    dec cx
    jns short @@Font_H_Loop
	    sub dword ptr cs:[@@C1-4],(1 shl SCALE)*Font_Width
	    add dword ptr cs:[@@C2-4],1 shl SCALE
	    sub bx,Font_Width

  dec cs:[Line_Count]
  jnz short @@Font_V_Loop
	add dword ptr cs:[@@C1-4],(1 shl SCALE)*Font_Width
	sub dword ptr cs:[@@C2-4],(1 shl SCALE)*Font_Height
	cmp bx,50
	jg short Font_End

	add bx,Font_Width
	inc bp
jmp @@S212

Font_End:
	mov fs:[0],dx
	retn
FDraw_Scroller ENDP



;[]-------------------------------------------------------------------------[]
;|
;| This s the landscape-init routine....
;|
;| FS must point to the object and ES must hold the landscape.
;| SI should contain the landscape-start address
;|
FDraw_Scape PROC NEAR
	xor di,di
	mov word ptr fs:[di],22*22	;Size of the scape...

	mov edx,-(22 shl SCALE)-(11 shl (SCALE-1))	;EDX=Y
	add di,2
	mov cl,22
@@L1:	mov ch,22
	mov ebx,-(22 shl SCALE)-(11 shl (SCALE-1))	;EBX=X
@@L2:	movzx eax,byte ptr es:[si]
	sub eax,120
	shl eax,SCALE-2
	mov fs:[di],ebx  		;X
	mov fs:[di+4],eax		;Y
	mov fs:[di+8],edx		;Z
	add di,32
	add ebx,(2 shl SCALE)+(1 shl (SCALE-1))

	inc si
	dec ch
	jnz short @@L2


	add si,256-22
	add edx,(2 shl SCALE)+(1 shl (SCALE-1))
	dec cl
	jnz short @@L1

	retn
FDraw_Scape ENDP



;[]-------------------------------------------------------------------------[]
;|
;| This is the mapper for the intro
;|
HMap PROC NEAR
	ARG x0:word,y0:word,w0:word,x1:word,y1:word,w1:word
	mov word ptr cs:[@@C3-2],bp
	push bp
	mov bp,sp

	mov ax,0a000h
	mov es,ax			;ES will point to VRAM
	mov ds,cs:[LandScape_Ptr]       ;DS will point to 64x64 texture

	mov cx,[y1]
	mov di,[y0]
	sub cx,di			;CX holds y1-y0
	movsx ecx,cx

	mov ax,[x1]
	mov si,[x0]			;SI holds x-start position
	sub ax,si
	shl eax,16
	cdq
	idiv ecx			;EAX=(x1-x0)/(y1-y0)
	add eax,320 shl 16
	mov dword ptr cs:[@@C1-4],eax	;   is port of x-coordinate
	mov ax,di
	fastimul bx,ax,320
	add si,bx
	shl esi,16			;ESI holds x-start

	mov ax,[w1]
	mov bp,[w0]			;BP holds width
	sub ax,bp			;AX holds width-difference
	shl eax,16
	cdq
	idiv ecx
	mov dword ptr cs:[@@C2-4],eax
	shl ebp,16


@@L1:   push di
	push cx
	push ebp

	mov bx,100
	sub bx,di			;BX=100-y
	mov ax,di
	shl ax,6                        ;DX:AX=c*y
	xor dx,dx
	idiv bx
	test ax,ax
	jns short @@1
	neg ax
@@1:	add ax,1234h
@@C3:   cmp ax,12*64
	jae @@Empty
	and ax,3fh
	mov bx,ax			;EBX holds row
	shl ebx,22
	shld edi,esi,16                 ;Get integer part of x-port

	mov ecx,ebp
	sar ecx,16
	xor edx,edx
	mov eax,64 shl 16
	idiv ecx
	mov edx,eax
	shr eax,13
	cmp al,7
	jb short @@2
	mov al,7
@@2:	mov ah,al
	mov word ptr cs:[@@C4-2],ax

	shr cx,1
	jnc short @@L2
	shld ebp,ebx,16
	add ebx,edx
	mov al,ds:[bp]
	add al,ah
	stosb

@@L2:   shld ebp,ebx,16
	add ebx,edx
	mov al,ds:[bp]

	shld ebp,ebx,16
	add ebx,edx
	mov ah,ds:[bp]

	add ax,1234h
@@C4:   stosw
	dec cl
	jnz short @@L2



@@E:	pop ebp
	pop cx

	add esi,12345678h		;Add to x-start position
@@C1:	add ebp,12345678h		;Add to width
@@C2:	pop di
	inc di				;Next line
	dec cx
	jnz @@L1

	pop bp
	retn

@@Empty:
	shld edi,esi,16                 ;Get integer part of x-port
	mov ecx,ebp
	sar ecx,16
	xor eax,eax
	rep stosb
	jmp short @@E
HMap ENDP




VMap PROC NEAR
	ARG x0:word,y0:word,h0:word,x1:word,y1:word,h1:word
	mov word ptr cs:[@@C3-2],bp
	push bp
	mov bp,sp

	mov ax,0a000h
	mov es,ax			;ES will point to VRAM
	mov ds,cs:[LandScape_Ptr]       ;DS will point to 64x64 texture

	mov cx,[x1]
	mov di,[x0]                     ;DI holds coloumn
	sub cx,di			;CX holds x1-x0
	movsx ecx,cx

	mov ax,[y1]
	mov si,[y0]			;SI holds x-start position
	sub ax,si
	shl eax,16
	cdq
	idiv ecx			;EAX=(y1-y0)/(x1-x0)
	mov dword ptr cs:[@@C1-4],eax
	shl esi,16			;ESI holds current row

	mov ax,[h1]
	mov bp,[h0]			;BP holds height
	sub ax,bp			;AX holds height-difference
	shl eax,16
	cdq
	idiv ecx
	mov dword ptr cs:[@@C2-4],eax
	shl ebp,16


@@L1:   push di
	push cx
	push ebp

	mov bx,160
	sub bx,di			;BX=160-y
	mov ax,di
	shl ax,6                        ;DX:AX=c*y
	xor dx,dx
	idiv bx
	test ax,ax
	jns short @@1
	neg ax
@@1:	add ax,1234h
@@C3:   cmp ax,12*64
	jae @@Empty
	and ax,3fh
	mov bx,ax			;EBX holds row
	shl ebx,22

	mov eax,esi
	sar eax,16
	fastimul dx,ax,320
	add di,dx

	mov ecx,ebp
	sar ecx,16
	xor edx,edx
	mov eax,64 shl 16
	idiv ecx
	mov edx,eax
	shr eax,13
	cmp al,7
	jb short @@2
	mov al,7
@@2:    mov ah,al
	mov word ptr cs:[@@C4-2],ax

	shr cl,1
	jnc short @@L2
	shld ebp,ebx,16
	add ebx,edx
	mov al,ds:[bp]
	add al,ah
	mov es:[di],al
	add di,320

@@L2:   shld ebp,ebx,16
	add ebx,edx
	mov al,ds:[bp]

	shld ebp,ebx,16
	add ebx,edx
	mov ah,ds:[bp]

	add ax,1234h
@@C4:	mov es:[di],al
	mov es:[di+320],ah
	add di,640

	dec cl
	jnz short @@L2


@@E:	pop ebp
	pop cx

	add esi,12345678h		;Add to x-start position
@@C1:	add ebp,12345678h		;Add to height
@@C2:	pop di
	inc di				;Next line
	dec cx
	jnz @@L1

	pop bp
	retn

@@Empty:
	mov eax,esi
	sar eax,16
	fastimul dx,ax,320
	add di,dx
	mov ecx,ebp
	sar ecx,16
	xor al,al
@@L3:	mov es:[di],al
	add di,320
	dec cx
	jnz short @@L3
	jmp short @@E
VMap ENDP



;[]-------------------------------------------------------------------------[]
;|
;| This subroutine caclulates a mandelbrot-picture
;|
MP_NUMBER         equ  4
MAX_ITER          equ  32
MP_ALIGN          equ  27
BAIL_OUT          equ  4

MANDEL_X1	equ	-335544320
MANDEL_Y1	equ	 201326592
MANDEL_X2	equ	 201326592
MANDEL_y2	equ	-201326592


Calc_Mandel PROC NEAR
	mov es,cs:[LandScape_Ptr]
	xor di,di

	mov eax,MANDEL_X2-MANDEL_X1
	cdq
	mov ebx,64
	mov cs:[BWidth],bx 	;Breite sichern fr loop
	idiv ebx		;Durch Breite teilen
	mov cs:[XStep],eax	;Step abspeichern

	mov eax,MANDEL_Y2-MANDEL_Y1
	cdq
	mov ebx,64
	mov cs:[BHeight],bx	;Hhe sichern fr loop
	idiv ebx		;Durch Breite teilen
	mov cs:[YStep],eax	;Step abspeichern

	mov cx,cs:[BHeight]
	mov cs:[XX],MANDEL_X1
	mov cs:[YY],MANDEL_Y1

	Schleife64:
		push cx			;CX sichern
		mov cx,cs:[BWidth]	;Breite
		mov esi,cs:[XX] 	;In ESI ist X (also REAL-Teil)


		Schleife67:
			push cx
			mov cs:[iter],MAX_ITER

			mov ebp,esi		;X in EBP
			mov ecx,cs:[YY]		;Y in EBX

			Schleife72:
				mov eax,ebp
				imul eax                ;X*X
				shrd eax,edx,MP_ALIGN
				mov ebx,eax		;X*X in EBX

				mov eax,ecx		;Y einladen
				imul eax                ;Y*Y
				shrd eax,edx,MP_ALIGN
				mov edx,eax		;Y*Y in EDX
				add edx,ebx             ;X*X + Y*Y in EDX
				sub ebx,eax		;X*X - Y*Y in EBX

				shr edx,MP_ALIGN
				cmp dl,BAIL_OUT
				ja short @@Set_Pixel

				mov eax,ebp	;X einalden
				imul ecx	;X*Y
				shrd eax,edx,MP_ALIGN-1	;*2
				add eax,cs:[YY]	;+c (Hier ist neues Y)
				mov ecx,eax	;neues Y

				mov eax,ebx	;X*X - Y*Y einladen
				add eax,esi     ;+c (Hier ist neues X)
				mov ebp,eax	;neues X

				dec cs:[iter]
				jnz Schleife72
				xor al,al
				jmp short @@1
		     @@Set_Pixel:
			mov ax,MAX_ITER+1	;MODIFY THIS IF YA DONT LIKE COLOURS
			sub ax,cs:[iter]	;Farbe

		@@1:	add esi,cs:[XStep]
			shl al,3
			stosb
			pop cx
		dec cx
		jnz Schleife67

		mov eax,cs:[YStep]
		add cs:[YY],eax
		pop cx
	dec cx
	jnz Schleife64

	retn
Calc_Mandel ENDP

;[]-------------------------------------------------------------------------[]
;|
;| This is the new timer-interrupt
;|
NewTimer PROC FAR
	push ax
	inc cs:[Tick]
	mov al,20h
	out 20h,al
	pop ax
	iret
NewTimer ENDP


;[]-------------------------------------------------------------------------[]
;|
;| A small routine to draw really big text on the screen
;| ES:DI m,ust point to screen
;| BP must point to text...
;|
FDraw_Text PROC NEAR
	mov fs,cs:[CHar_Segment16]
	mov edx,3f3f3f3fh	  	;Farbe

Schleife212:                      	;Buchstabenschleife
	movzx si,byte ptr cs:[bp] 	;AX=Zeichen
	shl si,4		  	;16 bytes per char
	jz short @@FE
	add si,cs:[Char_Offset16]

	mov ah,16
  _V_Loop:                    		;Zeilenschleife
	  lods byte ptr fs:[si]   	;Bitmuster in AL geladen
	  mov cx,8-1
    _H_Loop:                  		;Punktschleife
	    bt ax,cx
	    jnc short @@N
	    mov es:[di],edx 		;Set pixels...
	    mov es:[di+320],edx
	    mov es:[di+640],edx
	    mov es:[di+960],edx
     @@N:   add di,4
    dec cx
    jns short _H_Loop

	  add di,4*VGA_Width-4*Font_Width
  dec ah
  jnz short _V_Loop

	sub di,4*16*VGA_Width-4*Font_Width
	inc bp
jmp short Schleife212
@@FE:	retn
FDraw_Text ENDP




This_Table		dw	0
Rot_X			dw	0
Rot_Y			dw	0
Rot_Z			dw	0
Move_Y                  dd      0
Tick			dw	0
Move_X                  dd      -90 shl SCALE
Move_Z                  dd      40 shl SCALE
Pal_Type		db	0

END