;[]------------------------------------------------------------------------[]
;|                                                                          |
;| (c) 1993,1994 by Marc van Shaney , aka Kaya Memisoglu                    |
;|                                                                          |
;| Dieser Assembler-Source-Code unterliegt dem Urheberrecht von Kaya        |
;| Memisoglu und darf auch nur mit seiner schriftlichen Genehmigung         |
;| in kommerziellen Programmen verwendet werden.                            |
;| Ich bernehme keinerlei Verantwortung fr eventuelle Schden,die dieses  |
;| Programm verursacht.                                                     |
;|                                                                          |
;|                                                                          |
;| 18.1.1994 Kaya Memisoglu                                                 |
;|                                                                          |
;[]------------------------------------------------------------------------[]



P386

LOCALS
VGA_Width         equ  320
VGA_Height        equ  200
Black             equ  240
Background        equ  0
TRUE              equ  1
FALSE             equ  -1
MP_NUMBER         equ  4
DISTANCE          equ  5
ZOOM_ADD          equ  100
MAX_ITER          equ  130
MP_ALIGN          equ  27
BAIL_OUT          equ  4

.MODEL USE16 LARGE
.Code

BWidth  	dw ?
BHeight 	dw ?
YY      	dd ?
XX      	dd ?
XStep   	dd ?
YStep   	dd ?
iter    	dw ?
LSkip   	dw ?
divrest_x 	dw ?
divrest_y 	dw ?




PUBLIC C Calc_Mandel
Calc_Mandel PROC
	ARG dest:dword,x0:dword,y0:dword,x1:dword,y1:dword
	push bp
	mov bp,sp
	push esi
	push edi
	push ebp

	les di,[dest]
	mov eax,[x1]
	sub eax,[x0]		;Differenz bilden
	cdq
	movzx ebx,word ptr es:[di]
	mov cs:[BWidth],bx 	;Breite sichern fr loop
	idiv ebx		;Durch Breite teilen
	mov cs:[XStep],eax	;Step abspeichern

	mov eax,[y1]		;Y1 laden
	sub eax,[y0]		;Differenz
	cdq
	movzx ebx,word ptr es:[di+2]
	mov cs:[BHeight],bx	;Hhe sichern fr loop
	idiv ebx		;Durch Breite teilen
	mov cs:[YStep],eax	;Step abspeichern

	add di,16		;Header berspringen
	push di			;DI sichern
	mov ax,cs:[BWidth]
	mul cs:[BHeight]	;Anzahl Bytes in diesem Bild
	add di,ax		;ES:DI an das ENDE vom Bitmap

	mov eax,[x0]
	stosd			;Am Ende in ES:DI speichern
	mov cs:[XX],eax
	mov eax,[y0]
	stosd			;Am Ende speichern
	mov cs:[YY],eax
	mov eax,cs:[XStep]	;X_Step speichern
	stosd
	mov eax,cs:[YSTep]	;Y_Step speichern
	stosd
	pop di			;DI zurcksetzen

	mov cx,cs:[BHeight]

	Schleife64:
		push cx			;CX sichern
		mov cx,cs:[BWidth]	;Breite
		mov esi,cs:[XX] 	;In ESI ist X (also REAL-Teil)


		Schleife67:
			push cx
			mov cs:[iter],MAX_ITER

			mov ebp,esi		;X in EBP
			mov ecx,cs:[YY]		;Y in EBX

			Schleife72:
				mov eax,ebp
				imul eax                ;X*X
				shrd eax,edx,MP_ALIGN
				mov ebx,eax		;X*X in EBX

				mov eax,ecx		;Y einladen
				imul eax                ;Y*Y
				shrd eax,edx,MP_ALIGN
				mov edx,eax		;Y*Y in EDX
				add edx,ebx             ;X*X + Y*Y in EDX
				sub ebx,eax		;X*X - Y*Y in EBX

				shr edx,MP_ALIGN
				cmp dl,BAIL_OUT
				ja short Set_Pixel

				mov eax,ebp	;X einalden
				imul ecx	;X*Y
				shrd eax,edx,MP_ALIGN-1	;*2
				add eax,cs:[YY]	;+c (Hier ist neues Y)
				mov ecx,eax	;neues Y

				mov eax,ebx	;X*X - Y*Y einladen
				add eax,esi     ;+c (Hier ist neues X)
				mov ebp,eax	;neues X

				dec cs:[iter]
				jnz Schleife72
				xor al,al
				jmp short @@1
		     Set_Pixel:
			mov ax,MAX_ITER+1
			sub ax,cs:[iter]	;Farbe

		@@1:	add esi,cs:[XStep]
			stosb
			pop cx
		dec cx
		jnz Schleife67

		mov eax,cs:[YStep]
		add cs:[YY],eax
		pop cx
	dec cx
	jnz Schleife64

	pop ebp
	pop edi
	pop esi
	pop bp
	retf
Calc_Mandel ENDP




;[]-------------------------------------------------------------------------[]
;|
;| This IFS code was adapted from Tricks of the Graphics Gurus and optimized
;| in assembler for faster results.
;|
IFS_A		equ	0
IFS_B		equ	4
IFS_C		equ	8
IFS_D		equ	12
IFS_E		equ	16
IFS_F		equ	20
IFS_P		equ	24

PUBLIC C Prepare_IFS
Prepare_IFS PROC FAR
	ARG frac:dword
	push bp
	mov bp,sp
	push si
	push ds
	push edi

	lds si,[frac]
	mov cx,ds:[si]
	add si,16
	xor edi,edi

@@L1:   mov eax,ds:[si+IFS_A]
	imul dword ptr ds:[si+IFS_D]
	shrd eax,edx,24			;Unfudge
	mov ebx,eax			;Save a*d in EBX
	mov eax,ds:[si+IFS_B]
	imul dword ptr ds:[si+IFS_C]
	shrd eax,edx,24
	sub ebx,eax			;EBX=a*d - b*c
	jnz short @@3
	mov ebx,100h
	jmp short @@1
@@3:	jns short @@1
	neg ebx
@@1:	add edi,ebx
	mov ds:[si+IFS_P],ebx		;Save relative probability
	add si,28
	dec cx
	jnz short @@L1

	xor edx,edx
	mov eax,0ffffffffh
	div edi
	mov edi,eax			;Get factor

	lds si,[frac]
	mov cx,ds:[si]
	add si,16
	xor ebx,ebx
@@L2:	mov eax,ds:[si+IFS_P]
	mul edi
	add ebx,eax
	mov ds:[si+IFS_P],ebx
	add si,28
	dec cx
	jnz short @@L2

	pop edi
	pop ds
	pop si
	pop bp
	retf
Prepare_IFS ENDP


_TWEEN_M MACRO a
	mov eax,ds:[si+a]
	sub eax,fs:[bp+a]
	imul ebx
	shrd eax,edx,8
	add eax,fs:[bp+a]
	stosd
	ENDM

PUBLIC C Tween_IFS
Tween_IFS PROC FAR
	ARG src1:dword,src2:dword,dest:dword,strength:word
	push bp
	mov bp,sp
	push si
	push di
	push ds

@@Ok1:	;Here starts the real tweening !
	lds si,[src2]
	les di,[dest]
	movzx ebx,[strength]
	lfs bp,[src1]
	mov cx,ds:[si]
	mov es:[di],cx
	add si,16
	add di,16
	add bp,16
@@L1:	_TWEEN_M 0
	_TWEEN_M 4
	_TWEEN_M 8
	_TWEEN_M 12
	_TWEEN_M 16
	_TWEEN_M 20
	stosd
	add bp,28
	add si,28

	dec cx
	jnz @@L1

	pop ds
	pop di
	pop si
	pop bp
	retf
Tween_IFS ENDP




Noise		dd	1
MULTIPLIER      equ	015a4e35h
INCREMENT       equ	1

RAND MACRO
	mov eax,cs:[Noise]
	mov edx,MULTIPLIER
	mul edx
	shrd eax,edx,16
	add eax,INCREMENT
	mov cs:[Noise],eax
     ENDM

DO_IFS MACRO
	mov eax,ds:[si+bx+IFS_A]
	imul cs:[LastX]
	shrd eax,edx,24
	mov ebp,eax
	mov eax,ds:[si+bx+IFS_B]
	imul cs:[LastY]
	shrd eax,edx,24
	add ebp,eax
	add ebp,ds:[si+bx+IFS_E]

	mov eax,ds:[si+bx+IFS_C]
	imul cs:[LastX]
	shrd eax,edx,24
	mov ecx,eax
	mov eax,ds:[si+bx+IFS_D]
	imul cs:[LastY]
	shrd eax,edx,24
	add ecx,eax
	add ecx,ds:[si+bx+IFS_F]

	mov cs:[LastX],ebp
	mov cs:[LastY],ecx
     ENDM

LastX		dd	?
LastY		dd	?
Counter		dw	?
Trans_Count	dw	?

PUBLIC C FDraw_IFS
FDraw_IFS PROC FAR
	ARG frame:dword,frac:dword,count:word
	push bp
	mov bp,sp
	push si
	push di
	push ds
	push ebp

	les di,[frame]
	lds si,[frac]
	mov ax,ds:[si]
	mov cs:[Trans_Count],ax
	xor eax,eax
	mov cs:[LastX],eax
	mov cs:[LastY],eax
	add si,16

	mov cs:[Counter],16
	push bp
@@L1: 	RAND
	xor dx,dx
	div cs:[Trans_Count]
	fastimul bx,dx,28		;Size of one entry
	DO_IFS
	dec cs:[Counter]
	jnz @@L1
	pop bp

	mov ax,[count]
	mov cs:[Counter],ax
	dec cs:[Trans_Count]
@@L2:	RAND
	mov cx,cs:[Trans_Count]
	xor bx,bx
@@S1:	cmp ds:[si+bx+IFS_P],eax
	ja short @@1
	add bx,28
	dec cx
	jnz short @@S1
@@1:	DO_IFS
	sar ebp,20
	add bp,VGA_Width/2
	cmp bp,VGA_Width
	ja short @@3
	sar ecx,20
	neg cx
	add cx,VGA_Height*2/3
	cmp cx,VGA_Height
	ja short @@3
	fastimul ax,cx,VGA_Width
	add bp,ax
	cmp byte ptr es:[di+bp],128
	jb short @@4
	mov byte ptr es:[di+bp],44
@@4:	add byte ptr es:[di+bp],4	;60
@@3:	dec cs:[Counter]
	jnz @@L2

	pop ebp
	pop ds
	pop di
	pop si
	pop bp
	retf
FDraw_IFS ENDP





;[]-------------------------------------------------------------------------[]
;|
;| This routine draws a Moire pattern on the screen using the famous Circle-
;| algorithm
;|
MFactor dd ?
PUBLIC C FDraw_Moire
FDraw_Moire PROC FAR
	ARG frame:dword,factor:dword
	push bp
	mov bp,sp
	push di
	push esi

	mov esi,[factor]
	les di,[frame]
	add di,25*320+40
	mov cs:[yy],150		;How many rows

@@L1:	mov ebx,cs:[yy]
	imul ebx,ebx		;EBX holds y
	imul ebx,esi		;EBX now holds a*y

	mov edx,esi
	imul edx,edx,240*240	;EDX holds a*x
	sub edx,ebx		;EDX holds a*x-a*y

	shl esi,1
	mov eax,esi
	fastimul ecx,eax,240	;ECX holds 2*a*x

@@L2:	sub edx,ecx		;a*x-a*y - 2*a*x + a
	shld ebx,edx,17
	sub ecx,esi		;Subtract 2a
	sub edx,ecx		;a*x-a*y - 2*a*x + a
	shld eax,edx,17+8
	mov al,bl
	stosw
	sub ecx,esi		;Subtract 2a
	jnz short @@L2

	shr esi,1
	add di,80
	dec cs:[yy]
	jnz short @@L1

	pop esi
	pop di
	pop bp
	retf
FDraw_Moire ENDP



;[]-------------------------------------------------------------------------[]
;|
;| This routine draws a real-time plasma on the screen using four independant
;| cosine functions
;|

SineTable db   0,  1,  2,  3,  4,  6,  7,  8,  9, 11, 12, 13, 14, 15, 17, 18
db  19, 20, 21, 22, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35
db  36, 36, 37, 38, 39, 40, 40, 41, 42, 43, 43, 44, 44, 45, 46, 46
db  47, 47, 48, 48, 48, 49, 49, 49, 50, 50, 50, 50, 50, 50, 50, 50
db  51, 50, 50, 50, 50, 50, 50, 50, 50, 49, 49, 49, 48, 48, 48, 47
db  47, 46, 46, 45, 44, 44, 43, 43, 42, 41, 40, 40, 39, 38, 37, 36
db  36, 35, 34, 33, 32, 31, 30, 29, 28, 27, 26, 25, 24, 22, 21, 20
db  19, 18, 17, 15, 14, 13, 12, 11,  9,  8,  7,  6,  4,  3,  2,  1
db   0, -1, -2, -3, -4, -6, -7, -8, -9,-11,-12,-13,-14,-15,-17,-18
db -19,-20,-21,-22,-24,-25,-26,-27,-28,-29,-30,-31,-32,-33,-34,-35
db -36,-36,-37,-38,-39,-40,-40,-41,-42,-43,-43,-44,-44,-45,-46,-46
db -47,-47,-48,-48,-48,-49,-49,-49,-50,-50,-50,-50,-50,-50,-50,-50
db -51,-50,-50,-50,-50,-50,-50,-50,-50,-49,-49,-49,-48,-48,-48,-47
db -47,-46,-46,-45,-44,-44,-43,-43,-42,-41,-40,-40,-39,-38,-37,-36
db -36,-35,-34,-33,-32,-31,-30,-29,-28,-27,-26,-25,-24,-22,-21,-20
db -19,-18,-17,-15,-14,-13,-12,-11, -9, -8, -7, -6, -4, -3, -2, -1

PUBLIC C FDraw_Plasma
FDraw_Plasma PROC FAR
	ARG frame:dword,x1:word,x2:word,x3:word,x4:word
	push bp
	mov bp,sp
	push di
	push si

	les di,[frame]
	add di,25*320+40

	mov al,byte ptr [x1]
	mov ah,byte ptr [x2]
	mov dl,byte ptr [x3]
	mov dh,byte ptr [x4]

	xor bh,bh
	mov bp,150
@@L1:	mov cl,120
	push ax
	push dx

	mov bl,al
	mov al,cs:[OFFSET SineTable+bp]
	add al,cs:[OFFSET SineTable+bx]
	mov bl,ah
	add al,cs:[OFFSET SineTable+bx]
	mov ah,al			;AX holds first two levels
	mov si,ax

@@L2:	mov ax,si

	mov bl,dl
	add al,cs:[OFFSET SineTable+bx]
	mov bl,dh
	add al,cs:[OFFSET SineTable+bx]
	add dx,0101h

	mov bl,dl
	add ah,cs:[OFFSET SineTable+bx]
	mov bl,dh
	add ah,cs:[OFFSET SineTable+bx]
	add dx,0001h

	stosw
	dec cl
	jnz short @@L2


	pop dx
	pop ax
	add ax,0101h
	add di,80
	dec bp
	jnz short @@L1

	pop si
	pop di
	pop bp
	retf
FDraw_Plasma ENDP
END