;[]------------------------------------------------------------------------[]
;|                                                                          |
;| (c) 1993,1994 by Marc van Shaney , aka Kaya Memisoglu                    |
;|                                                                          |
;| Dieser Assembler-Source-Code unterliegt dem Urheberrecht von Kaya        |
;| Memisoglu und darf auch nur mit seiner schriftlichen Genehmigung         |
;| in kommerziellen Programmen verwendet werden.                            |
;| Ich bernehme keinerlei Verantwortung fr eventuelle Schden,die dieses  |
;| Programm verursacht.                                                     |
;|                                                                          |
;|                                                                          |
;| 18.1.1994 Kaya Memisoglu                                                 |
;|                                                                          |
;[]------------------------------------------------------------------------[]



P386

LOCALS
VGA_Width         equ  320
VGA_Height        equ  200
Font_Width	  equ  8
Font_Height	  equ  12
Black             equ  240
Background        equ  0
TRUE              equ  1
FALSE             equ  -1


.MODEL USE16 LARGE
.Code



PUBLIC C Clear_Frame
Clear_Frame PROC FAR
      ARG frame:dword,farbe:byte
      push bp
      mov bp,sp
      push di

      les di,frame
      mov ah,[farbe]
      mov al,ah                 ;Farbe einladen
      rol eax,16
      mov al,[farbe]
      mov ah,al
      mov cx,03e80h             ;Bank lschen (DoppelWortweise !!!)
      rep stosd

      pop di
      pop bp
      retf
Clear_Frame ENDP










PUBLIC C Copy_Frame
Copy_Frame PROC FAR
      ARG dest:dword,src:dword
      push bp
      mov bp,sp
      push si
      push di
      push ds

      lds si,src
      les di,dest
      mov cx,03e80h             ;Bank lschen (DoppelWortweise !!!)
      rep movsd

      pop ds
      pop di
      pop si
      pop bp
      retf
Copy_Frame ENDP








PUBLIC C FDraw_Text
FDraw_Text PROC FAR
      ARG frame:dword,x:word,y:word,string:dword,farbe:byte
      push bp
      mov bp,sp
      push si
      push di

      les di,[frame]          	;Frame in ES:DI
      mov dl,[farbe]
      mov cx,[y]
      fastimul bx,cx,VGA_Width
      add di,bx                 ;ES:DI points to destination
      add di,[x]
      lgs bp,[string]

@@Schleife212:                      	;Buchstabenschleife
	movzx ax,byte ptr gs:[bp] 	;AX=Zeichen
        or al,al
	jz short @@Font_End
        fastimul si,ax,Font_Height
        add si,OFFSET STDFONT

	mov dh,Font_Height
  @@Font_V_Loop:                    	;Zeilenschleife
	  lods byte ptr cs:[si]   	;Bitmuster in AL geladen
	  mov cx,Font_Width-1
    @@Font_H_Loop:                  	;Punktschleife
	    bt ax,cx
	    jnc short @@Weiter233
	    mov [es:di],dl        	;Punkt setzen
      @@Weiter233:
	    inc di
    dec cx
    jns short @@Font_H_Loop

	  add di,VGA_Width-Font_Width
  dec dh
  jnz short @@Font_V_Loop

	sub di,Font_Height*VGA_Width-Font_Width
	inc bp
jmp short @@Schleife212

@@Font_End:
      pop di
      pop si
      pop bp
      retf
FDraw_Text ENDP







PUBLIC C FDraw_Scroller
FDraw_Scroller PROC FAR
      ARG frame:dword,y:word,string:dword,farbe:byte,pos:word
      push bp
      mov bp,sp
      push di
      push si

      les di,[frame]          	;Frame in ES:DI
      mov ax,[pos]
      xor dx,dx
      mov ax,[pos]
      mov bx,Font_Width
      idiv bx                   ;AX holds first char to draw
      				;DX holds pixels to draw from this char
      mov bx,0          	;BX holds screen-row
      sub bx,dx			;We are in the negative
      mov cx,[y]
      fastimul si,cx,VGA_Width
      add di,si                 ;ES:DI points to destination
      sub di,dx
      mov dl,[farbe]
      lgs bp,[string]
      add bp,ax			;GS:BP points to first char to draw


Schleife212:                      ;Buchstabenschleife
	movzx ax,byte ptr gs:[bp] ;AX=Zeichen
        or al,al
        jz short Font_End
        fastimul si,ax,Font_Height
        add si,OFFSET STDFONT

        mov dh,Font_Height
  Font_V_Loop:                    ;Zeilenschleife
	  lods byte ptr cs:[si]   ;Bitmuster in AL geladen
	  mov cx,Font_Width-1
    Font_H_Loop:                  ;Punktschleife
    	    cmp bx,VGA_Width-1
            ja short Weiter233
	    bt ax,cx
	    jnc short Weiter233
	    mov [es:di],dl        ;Punkt setzen
      Weiter233:
	    inc di
            inc dl
            inc bx
    dec cx
    jns short Font_H_Loop

          sub dl,Font_Width-1
	  add di,VGA_Width-Font_Width
          sub bx,Font_Width
  dec dh
  jnz short Font_V_Loop

	sub di,Font_Height*VGA_Width-Font_Width
	sub dl,Font_Height
        add bx,Font_Width
	cmp bx,VGA_Width
        ja short Font_End
	inc bp
jmp short Schleife212

Font_End:
      pop si
      pop di
      pop bp
      retf
FDraw_Scroller ENDP







PUBLIC C FPut_Sprite
FPut_Sprite PROC FAR
      ARG frame:dword,x1:word,y1:word,mem:dword
      push bp
      mov bp,sp
      push si
      push di

      les di,frame
      lfs si,mem                ;Startadresse des Spritespeichers in FS:SI

      mov ax,[y1]               ;ax=y1
      mov bx,VGA_Width
      mul bx
      add ax,[x1]
      add di,ax                 ;Startadresse jetzt in BX:DI

      mov dx,[fs:si]            ;x2 Laden
      sub bx,dx                 ;diff=VGA_Width-Breite
      shr dx,2                  ;Breite/4 jetzt in DX
      mov cx,[fs:si+2]          ;Hhe in CX Laden
      add si,16                 ;2 Bytes weiter

Schleife767:
	push cx                 ;CX sichern
	mov cx,dx               ;Breite/4 in CX
   Schleife742:
         lods dword ptr [fs:si] ;In EAX FS:SI einladen
         cmp al,Background
         je short Weiter747
         mov [es:di],al

     Weiter747:
         cmp ah,Background
	 je short Weiter748
         mov [es:di+1],ah

     Weiter748:
         rol eax,16
         cmp al,Background
         je short Weiter749
         mov [es:di+2],al

     Weiter749:
         cmp ah,Background
         je short Weiter750
         mov [es:di+3],ah

     Weiter750:
         add di,4
   loop Schleife742

End_Put_Sprite:
	pop cx                  ;In CX wieder Hhe holen
	add di,bx
loop Schleife767

      pop di
      pop si
      pop bp
      retf
FPut_Sprite ENDP





PUBLIC C FPut_Image
FPut_Image PROC FAR
      ARG frame:dword,x1:word,y1:word,mem:dword
      push bp
      mov bp,sp
      push si
      push di

      les di,frame
      lfs si,mem                ;Startadresse des Spritespeichers in FS:SI

      mov ax,[y1]               ;ax=y1
      mov bx,VGA_Width
      mul bx
      add ax,[x1]
      add di,ax                 ;Startadresse jetzt in ES:DI

      mov dx,[fs:si]            ;x2 Laden
      sub bx,dx                 ;BX=VGA_Width-Breite
      shr dx,2                  ;Breite/4 jetzt in DX
      mov ax,[fs:si+2]          ;Hhe in CX Laden
      add si,16                 ;2 Bytes weiter

Schleife752:
	mov cx,dx               ;Breite/4 in CX
        rep movs dword ptr [es:di],[fs:si]
	add di,bx
dec ax
jnz short Schleife752

      pop di
      pop si
      pop bp
      retf
FPut_Image ENDP





Row_Size	dw	?
PUBLIC C FZoom_Sprite
FZoom_Sprite PROC FAR
	ARG frame:dword,x1:word,y1:word,x2:word,y2:word,mem:dword
	push bp
	mov bp,sp
        push si
        push di

	cld
      	les di,[frame]            ;Framebuffer
      	lfs si,[mem]              ;Startadresse des Spritespeichers in FS:SI

        movzx ebx,[y2]
        sub bx,[y1]
	inc bx			  	;Final Height in EBX
      	fastimul cx,[y1],VGA_Width
      	add cx,[x1]
      	add di,cx                 	;Startadresse jetzt in ES:DI

      	movzx ecx,[x2]
      	sub cx,[x1]
      	inc cx                    	;Final Width
	mov cs:[Row_Size],cx
        push ecx			;Save Final width for later...
        sub cx,VGA_Width
        neg cx
        mov word ptr cs:[@@4-2],cx	;Save in code

        pop ecx
      	xor edx,edx
      	mov ax,word ptr fs:[si]		;Source width
	shl eax,16			;Fixed-point shift
        div ecx
        mov word ptr cs:[@@5-2],ax      ;Save fractional part
	shr eax,16
        mov word ptr cs:[@@6-2],ax	;Save integer part

        xor edx,edx
	mov ax,word ptr fs:[si+2]	;Now comes the height
        shl eax,16
        div ebx				;Divide by final height
        mov word ptr cs:[@@2-2],ax	;Fractional part
	shr eax,16
        mov cx,fs:[si]            	;AX*Width
        mul cx
        mov word ptr cs:[@@1-2],ax
        mov word ptr cs:[@@3-2],cx

      	add si,16                 	;Skip over header
	xor dx,dx
  @@Zoom_Y_Loop:
	push si
	mov cx,cs:[Row_Size]
	xor bp,bp
    @@Zoom_X_Loop:
		mov al,fs:[si]		;Get one byte
		add bp,1234h		;Fractional part of x in BP
	   @@5: adc si,1234h
	   @@6: cmp al,0
		je short No_Pixel
		mov es:[di],al
    No_Pixel:	inc di
		dec cx			;CX ist x-counter
    jnz short @@Zoom_X_Loop

	pop si
	add si,1234h			;Row-Increment
   @@1: add dx,1234h			;Fractional part of y in DX
   @@2: jnc @@3
	add si,1234h			;Add one row
   @@3: add di,1234h			;Next scan-line
   @@4: dec bx				;BX is y-counter
  jnz short @@Zoom_Y_Loop

	pop di
	pop si
	pop bp
	retf
FZoom_Sprite ENDP






PUBLIC C FZoom_Image
FZoom_Image PROC FAR
	ARG frame:dword,x1:word,y1:word,x2:word,y2:word,mem:dword
	push bp
	mov bp,sp
        push si
        push di

	cld
      	les di,[frame]            ;Framebuffer
      	lfs si,[mem]              ;Startadresse des Spritespeichers in FS:SI

        movzx ebx,[y2]
        sub bx,[y1]
	inc bx			  	;Final Height in EBX
      	fastimul cx,[y1],VGA_Width
      	add cx,[x1]
      	add di,cx                 	;Startadresse jetzt in ES:DI

      	movzx ecx,[x2]
      	sub cx,[x1]
      	inc cx                    	;Final Width
	mov cs:[Row_Size],cx
        push ecx			;Save Final width for later...
        sub cx,VGA_Width
        neg cx
        mov word ptr cs:[@@4-2],cx	;Save in code

        pop ecx
      	xor edx,edx
      	mov ax,word ptr fs:[si]		;Source width
	shl eax,16			;Fixed-point shift
        div ecx
        mov word ptr cs:[@@5-2],ax      ;Save fractional part
	shr eax,16
        mov word ptr cs:[@@6-2],ax	;Save integer part

        xor edx,edx
	mov ax,word ptr fs:[si+2]	;Now comes the height
        shl eax,16
        div ebx				;Divide by final height
        mov word ptr cs:[@@2-2],ax	;Fractional part
	shr eax,16
        mov cx,fs:[si]            	;AX*Width
        mul cx
        mov word ptr cs:[@@1-2],ax
        mov word ptr cs:[@@3-2],cx

      	add si,16                 	;Skip over header
	xor dx,dx
  @@Zoom_Y_Loop:
	push si
	mov cx,cs:[Row_Size]
	xor bp,bp
    @@Zoom_X_Loop:
		mov al,fs:[si]		;Get one byte
		add bp,1234h		;Fractional part of x in BP
	   @@5: adc si,1234h
	   @@6: stosb
		dec cx			;CX ist x-counter
    jnz short @@Zoom_X_Loop

	pop si
	add si,1234h			;Row-Increment
   @@1: add dx,1234h			;Fractional part of y in DX
   @@2: jnc @@3
	add si,1234h			;Add one row
   @@3: add di,1234h			;Next scan-line
   @@4: dec bx				;BX is y-counter
  jnz short @@Zoom_Y_Loop

	pop di
	pop si
	pop bp
	retf
FZoom_Image ENDP




;============================================================================
;=                                                                          =
;=                                                                          =
;=                 Hier sind alle Special-effects                           =
;=                                                                          =
;=                                                                          =
;=                                                                          =
;=                                                                          =
;=                                                                          =
;============================================================================




Noise		dd	1
MULTIPLIER      equ	015a4e35h
INCREMENT       equ	1

RAND MACRO
	mov eax,cs:[Noise]
	mov edx,MULTIPLIER
	mul edx
	shrd eax,edx,16
	add eax,INCREMENT
	mov cs:[Noise],eax
     ENDM


SinTable  db   0, 24, 49, 74, 97,120,141,161,180,197,212,224,235,244
	  db 250,253,255,253,250,244,235,224,212,197,180,161,141,120
	  db  97, 74, 49, 24
Water_Pos	dw	0
PUBLIC C FDraw_Water
FDraw_Water PROC FAR
      ARG frame:dword,y:word,len:word
      push bp
      mov bp,sp
      push si
      push di

      les di,[frame]
      lfs si,[frame]
      mov bx,cs:[Water_Pos]

      mov ax,[y]
      fastimul cx,ax,VGA_Width
      add di,cx
      add si,cx
      sub si,VGA_Width

      mov bp,[len]
 Schleife971:
       movzx ax,cs:[bx+ OFFSET SinTable]
       sub ax,127
       sar ax,4
       add si,ax
       mov cx,VGA_Width/4
       rep movs dword ptr [es:di],[fs:si]
       sub si,ax
       sub si,3*VGA_Width
       inc bx
       and bx,1fh
 dec bp
 jnz short Schleife971

      inc cs:[Water_Pos]
      and cs:[Water_Pos],1fh
      pop di
      pop si
      pop bp
      retf
FDraw_Water ENDP




;[]-----------------------------------------------------------------------[]
;|
;| Now follow some lens routines (one horizontal and one vertical)
;|
;|


LENS_A		equ	7
LENS_B		equ	22




Src_Pos		dd	?
PUBLIC C FDraw_HLens
FDraw_HLens PROC FAR
	ARG frame:dword,y0:word,y1:word,multi:dword,start:dword
	push bp
	mov bp,sp
	push si
	push di
	push ds

	lds si,[frame]
	les di,[frame]

	mov ax,[y0]
	fastimul bx,ax,VGA_Width
	add si,bx
	add di,bx




	pop ds
	pop di
	pop si
	pop bp
	retf
FDraw_HLens ENDP




;[]-----------------------------------------------------------------------[]
;|
;| This routine lets explode the last image
;|

PUBLIC C FGet_Vector_Table
FGet_Vector_Table PROC FAR
	ARG src:dword,dest:dword
	push bp
	mov bp,sp
	push ds
	push si
	push di

	lds si,[src]
	les di,[dest]


	pop di
	pop si
	pop ds
	pop bp
	retf
FGet_Vector_Table ENDP



;[]-----------------------------------------------------------------------[]
;|
;| This is the Image-rotator. Mostly (C) by The Faker of Aardvark
;|

PUBLIC C FDraw_Texture
FDraw_Texture PROC FAR
	ARG frame:dword,incx:word,incy:word,image:dword
	LOCAL px:word,py:word,count:word
	push bp
	mov bp,sp
	sub sp,8
	push ds
	push si
	push di

	cld
	lds si,[image]
	les di,[frame]

	mov ax,[incy]
	fastimul bx,ax,-VGA_Width/2
	mov [py],bx
	mov ax,[incx]
	fastimul bx,ax,-VGA_Height/2
	mov [px],bx

	mov [count],VGA_Height
	mov si,[incy]
	shl esi,16
	mov si,[incx]

 @@2:	mov dx,[py]
	shl edx,16
	mov dx,[px]

	mov cx,VGA_Width/2
 @@1: 	add edx,esi
	shld ebx,edx,16
	mov bl,dh
	mov al,[bx]
	add edx,esi
	shld ebx,edx,16
	mov bl,dh
	mov ah,[bx]
	stosw
	dec cx
	jnz short @@1

	mov ax,[incx]
	add [py],ax
	mov ax,[incy]
	sub [px],ax
	dec [count]
	jnz short @@2

	pop di
	pop si
	pop ds
	add sp,8
	pop bp
	retf
FDraw_Texture ENDP




PUBLIC C FZoom_Texture
FZoom_Texture PROC FAR
	ARG frame:dword,x1:word,y1:word,x2:word,y2:word,mem:dword
	push bp
	mov bp,sp
	push si
	push di

	cld
	les di,[frame]            ;Framebuffer
	lfs si,[mem]              ;Startadresse des Spritespeichers in FS:SI

	movzx ebx,[y2]
	sub bx,[y1]
	inc bx			  	;Final Height in EBX
	fastimul cx,[y1],VGA_Width
	add cx,[x1]
	add di,cx                 	;Startadresse jetzt in ES:DI

	movzx ecx,[x2]
	sub cx,[x1]
	inc cx                    	;Final Width
	mov cs:[Row_Size],cx
	push ecx			;Save Final width for later...
	sub cx,VGA_Width
	neg cx
	mov word ptr cs:[@@4-2],cx	;Save in code

	pop ecx
	xor edx,edx
	mov eax,256 shl 16
	div ecx
	mov word ptr cs:[@@5-2],ax      ;Save fractional part
	shr eax,16
	mov word ptr cs:[@@6-2],ax	;Save integer part

	xor edx,edx
	mov eax,256 shl 16
	div ebx				;Divide by final height
	mov word ptr cs:[@@2-2],ax	;Fractional part
	shr eax,16
	shl eax,8

	xor dx,dx
  @@Zoom_Y_Loop:
	push si
	mov cx,cs:[Row_Size]
	xor bp,bp
    @@Zoom_X_Loop:
		mov al,fs:[si]		;Get one byte
		add bp,1234h		;Fractional part of x in BP
	   @@5: adc si,1234h
	   @@6: stosb
		dec cx			;CX ist x-counter
    jnz short @@Zoom_X_Loop

	pop si
	add si,256			;Row-Increment
	add dx,1234h			;Fractional part of y in DX
   @@2: jnc @@3
	add si,256			;Add one row
   @@3:	add di,1234h			;Next scan-line
   @@4: dec bx				;BX is y-counter
  jnz short @@Zoom_Y_Loop

	pop di
	pop si
	pop bp
	retf
FZoom_Texture ENDP




;[]-----------------------------------------------------------------------[]
;|
;| Now follows the Ground-mapper
;|

PUBLIC C FMap_Image
FMap_Image PROC FAR
	ARG frame:dword,incF:dword,image:dword
	LOCAL srcwidth:dword,srcheight:dword,xpos:dword,ypos:dword
	push bp
	mov bp,sp
	sub sp,16
	push ds
	push esi
	push edi

	mov [xpos],0
	mov [ypos],0

	les di,[frame]
	lds si,[image]
	movzx eax,word ptr ds:[si]
	movzx ebx,word ptr ds:[si+2]
	shl ebx,16
	mov [srcheight],ebx
	shl eax,16
	mov [srcwidth],eax
	add si,16
	shl esi,16


@@L1:   push esi
	push di
	mov eax,[srcwidth]
	shr eax,16
	mov ebx,[ypos]
	shr ebx,16
	mul ebx
	shl eax,16
	add esi,eax

	xor edx,edx
	mov eax,[srcwidth]
	mov ecx,eax
	sub ecx,[xpos]
	sar ecx,16
	jng short @@End
	div ecx
	mov edx,eax			;EDX holds current increment
	mov ebx,esi

	mov eax,[xpos]
	shr eax,17
	add di,ax
	shr cx,1
	jz short @@End
@@L2:   shld esi,ebx,16
	mov al,ds:[si]
	add ebx,edx
	shld esi,ebx,16
	mov ah,ds:[si]
	add ebx,edx
	stosw
	dec cx
	jnz short @@L2

	pop di
	pop esi

	mov eax,[incF]
	add [xpos],eax
	add di,320
	mov eax,[ypos]
	add eax,edx
	mov [ypos],eax
	cmp [Srcheight],eax
	ja short @@L1

	pop edi
	pop esi
	pop ds
	add sp,16
	pop bp
	retf

@@End:	add sp,6
	pop edi
	pop esi
	pop ds
	add sp,16
	pop bp
	retf
FMap_Image ENDP



;[]-----------------------------------------------------------------------[]
;|
;| This little function draws a shade-bob
;|
PUBLIC C FDraw_Bob
FDraw_Bob PROC FAR
	ARG frame:dword,x:word,y:word,bob:dword
	push bp
	mov bp,sp
	push ds
	push si
	push di

	les di,[frame]
	lds si,[bob]
	mov ax,[y]
	fastimul bx,ax,VGA_Width
	add bx,[x]
	add di,bx

	mov dx,ds:[si]
	mov bx,VGA_Width
	sub bx,dx
	shr dx,2                  ;Breite/4 jetzt in DX
	mov bp,ds:[si+2]          ;Hhe in CX Laden
	add si,16                 ;2 Bytes weiter

@@L1:	mov cx,dx               ;Breite/4 in CX
@@L2:	lodsd
	add es:[di],eax
	add di,4
	dec cx
	jnz short @@L2
	add di,bx
dec bp
jnz short @@L1

	pop di
	pop si
	pop ds
	pop bp
	retf
FDraw_Bob ENDP




PUBLIC C FDelete_Bob
FDelete_Bob PROC FAR
	ARG frame:dword,x:word,y:word,bob:dword
	push bp
	mov bp,sp
	push ds
	push si
	push di

	les di,[frame]
	lds si,[bob]
	mov ax,[y]
	fastimul bx,ax,VGA_Width
	add bx,[x]
	add di,bx

	mov dx,ds:[si]
	mov bx,VGA_Width
	sub bx,dx
	shr dx,2                  ;Breite/4 jetzt in DX
	mov bp,ds:[si+2]          ;Hhe in CX Laden
	add si,16                 ;2 Bytes weiter

@@L1:	mov cx,dx               ;Breite/4 in CX
@@L2:	lodsd
	sub es:[di],eax
	add di,4
	dec cx
	jnz short @@L2
	add di,bx
dec bp
jnz short @@L1

	pop di
	pop si
	pop ds
	pop bp
	retf
FDelete_Bob ENDP



;[]-----------------------------------------------------------------------[]
;|
;| This routine is used to stretch an image
;|
PUBLIC C FStretch_Image
FStretch_Image PROC FAR
	ARG frame:dword,x1:word,y:word,x2:word,image:dword
	push bp
	mov bp,sp
	push ds
	push si
	push di

	les di,[frame]
	lds si,[image]
	mov ax,[y]
	fastimul bx,ax,VGA_Width
	add bx,[x1]
	add di,bx

	movzx ecx,word ptr ds:[si]
	mov ax,[x2]
	sub ax,[x1]
	shl eax,16
	cdq
	idiv ecx
	mov edx,eax		;EDX = Destination-Increment
	mov bp,ds:[si+2]          ;Hhe in CX Laden
	add si,16                 ;2 Bytes weiter

	shr cx,1
@@L1:	push cx
	push di
	mov bx,di
	shl ebx,16

@@L2:	lodsw
	shld edi,ebx,16
	mov es:[di],al
	add ebx,edx
	shld edi,ebx,16
	mov es:[di],ah
	add ebx,edx
	dec cx
	jnz short @@L2

	pop di
	pop cx
	add di,VGA_Width
dec bp
jnz short @@L1


	pop di
	pop si
	pop ds
	pop bp
	retf
FStretch_Image ENDP



;[]-----------------------------------------------------------------------[]
;|
;| Routine for the end-scroller
;|
PUBLIC C FMagnify_Frame
FMagnify_Frame PROC FAR
	ARG frame:dword,pos:word,image:dword
	push bp
	mov bp,sp
	push ds
	push si
	push di

	les di,[frame]
	lds si,[image]
	add di,20*VGA_Width

	mov bx,[pos]

	mov bp,70			;200 rows to process
	mov dx,1			;Increment
@@L1:   push si
	mov cx,bx
	shr cx,8
	fastimul ax,cx,VGA_Width
	add si,ax

	mov cx,VGA_Width/4
	push edx
	shl dx,6
	mov dl,dh
	push dx
	shl edx,16
	pop dx
@@L2:	lodsd
	add eax,edx
	stosd
	dec cx
	jnz short @@L2

	pop edx
	add bx,dx
	add dx,4
	pop si

dec bp
jnz short @@L1


	mov bp,70
@@L3:   push si
	mov cx,bx
	shr cx,8
	fastimul ax,cx,VGA_Width
	add si,ax

	mov cx,VGA_Width/4
	push edx
	shl dx,6
	mov dl,dh
	push dx
	shl edx,16
	pop dx
@@L4:	lodsd
	add eax,edx
	stosd
	dec cx
	jnz short @@L4

	pop edx
	add bx,dx
	sub dx,4
	pop si

dec bp
jnz short @@L3

	pop di
	pop si
	pop ds
	pop bp
	retf
FMagnify_Frame ENDP




;[]-----------------------------------------------------------------------[]
;|
;| This is a nice non-fake sine-wobbler
;|
SineTable db   0,  0,  0, -1,  0,  0, -1,  0, -1,  0,  0, -1,  0, -1,  0,  0
db  -1,  0,  0, -1,  0,  0, -1,  0,  0, -1,  0,  0, -1,  0,  0, -1
db   0,  0,  0, -1,  0,  0,  0, -1,  0,  0,  0,  0, -1,  0,  0,  0
db   0,  0, -1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
db  -1,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1
db   0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  1,  0,  0,  0,  1,  0
db   0,  0,  1,  0,  0,  1,  0,  0,  1,  0,  0,  1,  0,  0,  1,  0
db   0,  1,  0,  0,  1,  0,  1,  0,  0,  1,  0,  1,  0,  0,  1,  0
db   0,  0,  0,  1,  0,  0,  1,  0,  1,  0,  0,  1,  0,  1,  0,  0
db   1,  0,  0,  1,  0,  0,  1,  0,  0,  1,  0,  0,  1,  0,  0,  1
db   0,  0,  0,  1,  0,  0,  0,  1,  0,  0,  0,  0,  1,  0,  0,  0
db   0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
db   1, -1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, -1
db   0,  0,  0,  0,  0, -1,  0,  0,  0,  0, -1,  0,  0,  0, -1,  0
db   0,  0, -1,  0,  0, -1,  0,  0, -1,  0,  0, -1,  0,  0, -1,  0
db   0, -1,  0,  0, -1,  0, -1,  0,  0, -1,  0, -1,  0,  0, -1,  0

PUBLIC C FWobble_Texture
FWobble_Texture PROC FAR
	ARG frame:dword,posx:word,posy:word,image:dword
	LOCAL count:word
	push bp
	mov bp,sp
	sub sp,8
	push ds
	push si
	push di

	cld
	lds si,[image]
	les di,[frame]
	add di,160-128

	mov [count],VGA_Height
	movzx edx,si
	mov bx,[posy]
	and bx,0ffh
	mov si,[posx]
	and si,0ffh

 @@2:	mov cx,128
	push edx

 @@1:   inc dl				;Increment coloum
	add dh,cs:[bx+OFFSET SineTable]
	mov al,[edx]
	inc dl				;Increment coloum
	inc bl
	add dh,cs:[bx+OFFSET SineTable]
	mov ah,[edx]
	inc bl
	stosw
	dec cx
	jnz short @@1

	pop edx

	xor eax,eax
	mov cx,(320-256)/4
	rep stosd
	inc dh				;Next row
	movsx ax,cs:[OFFSET SineTable+si]
	add di,ax
	inc si
	and si,0ffh
	dec [count]
	jnz short @@2

	pop di
	pop si
	pop ds
	add sp,8
	pop bp
	retf
FWobble_Texture ENDP



;[]-----------------------------------------------------------------------[]
;|
;| This is the special Dither-like outfader for the end
;|
DITHER_LINE MACRO a
	LOCAL L1
	mov cx,320/a
	xor ax,ax
L1:	mov es:[di],al
	add di,a
	dec cx
	jnz short L1
	add di,320
	ENDM

PUBLIC C FDither_Frame
FDither_Frame PROC FAR
	ARG frame:dword,line:word
	push bp
	mov bp,sp
	push ds
	push di

	les di,[frame]
	mov ax,[line]
	fastimul bx,ax,320
	add di,bx

	DITHER_LINE 64
	DITHER_LINE 32
	DITHER_LINE 16
	DITHER_LINE 8
	DITHER_LINE 4
	DITHER_LINE 2
	DITHER_LINE 1

	pop di
	pop ds
	pop bp
	retf
FDither_Frame ENDP




;[]-----------------------------------------------------------------------[]
;|
;| This is the vectotr-engine for the exploding last logo
;|

include 8x12font.inc
END


