/***************************************************************************/
/*                                                                         */
/*                                                                         */
/*                   (c) 1993,1994 by Kaya Memisoglu                       */
/*                                    aka Marc van Shaney                  */
/*                                                                         */
/* Die kommerzielle Nutzung des Source-Codes ohne meine schriftliche       */
/* Genehmigung ist untersagt. Desweiteren hafte ich fr keinerlei          */
/* Schaden den das Programm verursacht.                                    */
/*                                                                         */
/* Geschrieben mit Borland C++ 3.1                                         */
/*     Borland C++ ist eingetragenes Warenzeichen der                      */
/*                                  Borland Inernational INC               */
/*                                                                         */
/*                                                                         */
/* 18.1.1994 - Kaya Memisoglu                                              */
/*                                                                         */
/***************************************************************************/

#include <io.h>
#include <stdio.h>
#include <fcntl.h>
#include <alloc.h>


 typedef struct {
		 int Magic;
		 long File_Size;
		 int Reserved_1;
		 int Reserved_2;
		 long Data_Offset;
		 long Info_Size;
		 long Width;
		 long Height;
		 int Colour_Planes;
		 int Bits_per_Pixel;
		 long Pack_Type;
		 long Image_Size;
		 long X_Resolution;
		 long Y_Resolution;
		 long Colours_Used;
		 long Colours_Important;
		} BMP_Header;
typedef struct {
		char R;
		char G;
		char B;
		char Alpha;
	       } Color;
typedef struct
	       {
		Color Colour[256];
	       } Palette;




void main (void)
{
 char sname[128],dname[128],*Line;
 FILE *Out;
 int h,j;
 long i;
 static Palette Pal;
 BMP_Header BMP;

 printf("\nGet BMP-file                                          (c) 1995 by CyberDyne\n");
 printf("This tool only reads in 256x256 8 bit uncompressed BMP files !\n");
 printf("Enter source filename:");
 scanf("%s",sname);
 printf("Enter destination filename:");
 scanf("%s",dname);

 Line=(char far *)malloc(2048);
 Out=fopen(dname,"w");
 h=open(sname,O_BINARY|O_RDWR);

 _read(h,&BMP,sizeof(BMP_Header));
 _read(h,Line,4*256);
 for (i=0;i<256;i++)
	{
	 Pal.Colour[i].R=Line[i*4+2];
	 Pal.Colour[i].G=Line[i*4+1];
	 Pal.Colour[i].B=Line[i*4];
	}

 fprintf(Out,";[]-------------------------------------------------------------------------[]\n");
 fprintf(Out,";|                                                                           |\n");
 fprintf(Out,";|   Assemblerfile created by gettex                                         |\n");
 fprintf(Out,";|          gettex (C) 1995 by Marc van Shaney   &   Cyberdyne               |\n");
 fprintf(Out,";|                                                                           |\n");
 fprintf(Out,";|                                                                           |\n");
 fprintf(Out,";[]-------------------------------------------------------------------------[]\n");
 fprintf(Out,"\n\n\n\nP386\n");
 fprintf(Out,".MODEL USE16 LARGE\n");
 fprintf(Out,".FARDATA\n\n\n");
 fprintf(Out,"PALETTE ");

 for (i=0;i<256;i++)
	fprintf(Out,"DB %3d,%3d,%3d,0\n",Pal.Colour[i].R,Pal.Colour[i].G,Pal.Colour[i].B);


 fprintf(Out,"\n\nTEXTURE db ");
 for (i=256;i>0;i--)
	{
	 lseek(h,BMP.Data_Offset+i*256L-256L,SEEK_SET);
	 _read(h,Line,128);
	 for (j=0;j<31;j++)
		fprintf(Out,"%3d,",Line[j]);
	 fprintf(Out,"%3d\ndb ",Line[31]);
	 for (j=0;j<31;j++)
		fprintf(Out,"%3d,",Line[j+32]);
	 fprintf(Out,"%3d\ndb ",Line[31+32]);
	 for (j=0;j<31;j++)
		fprintf(Out,"%3d,",Line[j+64]);
	 fprintf(Out,"%3d\ndb ",Line[31+64]);
	 for (j=0;j<31;j++)
		fprintf(Out,"%3d,",Line[j+96]);
	 fprintf(Out,"%3d\ndb ",Line[31+96]);
	 _read(h,Line,128);
	 for (j=0;j<31;j++)
		fprintf(Out,"%3d,",Line[j]);
	 fprintf(Out,"%3d\ndb ",Line[31]);
	 for (j=0;j<31;j++)
		fprintf(Out,"%3d,",Line[j+32]);
	 fprintf(Out,"%3d\ndb ",Line[31+32]);
	 for (j=0;j<31;j++)
		fprintf(Out,"%3d,",Line[j+64]);
	 fprintf(Out,"%3d\ndb ",Line[31+64]);
	 for (j=0;j<31;j++)
		fprintf(Out,"%3d,",Line[j+96]);
	 fprintf(Out,"%3d\ndb ",Line[31+96]);
	}


 fclose(Out);
 close(h);

 free(Line);
}