;[]------------------------------------------------------------------------[]
;|                                                                          |
;| (c) 1993,1994,1995 by Marc van Shaney , aka Kaya Memisoglu               |
;|                                                                          |
;| This Source-Code was written by and is copyrighted by Kaya Memisoglu	    |
;| You may use the whole code or only parts of it in your own programs      |
;| whether they are commercial or not. BUT you must give credits for these  |
;| parts to me (Kaya Memisoglu  or  Marc van Shaney).                       |
;| I am not responsible for any damage or loss caused by this program, so   |
;| if you success in erasing your harddisk with this code, then it is your  |
;| own fault and you should not claim me to be responsible...               |
;| I would be very pleased if you also sent me a postcard or even a letter  |
;| if you can use this code. My address:                                    |
;|                                                                          |
;|        Kaya Memisoglu                                                    |
;|        Reichenberger Ring 50                                             |
;|        63512 Hainburg                                                    |
;|        Germany                                                           |
;|                                                                          |
;| You can also leave a message for Marc van Shaney on the Nirvana BBS:     |
;|                                                                          |
;|              Nirvana BBS     ++49-(0)6245-3056      Sysop:Raytrayza      |
;|                                                                          |
;|                                                                          |
;[]------------------------------------------------------------------------[]
; !!! WARNING !!! WARNING !!! WARNING !!! WARNING !!! WARNING !!! WARNING !!!
; !!! WARNING !!! WARNING !!! WARNING !!! WARNING !!! WARNING !!! WARNING !!!
;
; I DO NOT SAVE THE REGISTER VARIABLES SI AND DI IN THIS CODE AND IN SOME
; OTHER MODULES. SO MAKE SURE BEFORE COMPILING THIS CODE THAT THE REGISTER
; VARIABLES IN BORLAND C ARE SET TO *NONE*.
; BUT IF YOU STILL WANT TO USE THEM, YOU HAVE TO SAVE THEM BY CHANGING THIS
; CODE !!!
;
; !!! WARNING !!! WARNING !!! WARNING !!! WARNING !!! WARNING !!! WARNING !!!
; !!! WARNING !!! WARNING !!! WARNING !!! WARNING !!! WARNING !!! WARNING !!!
;
;Play_Structure (32 bytes):
;    dword Change_Flags
;    dword Sample_Handle
;    dword Sample_Start
;    dword Sample_Len
;    dword Sample_Rep_Start
;    dword Sample_Rep_End
;    dword Play_Freq
;    byte Volume
;    byte Panning


P386
LOCALS

_DEVICE_SYSTEM_FILE	equ	1
include devices.inc
include cdmi.inc

TRUE        		equ   	1
FALSE       		equ   	-1






.MODEL USE16 LARGE
.Data
PUBLIC C GUS_Driver
GUS_Driver   dw	OFFSET drv
	     dw SEG DRV

.Code
drv:  DB 'Cyberdyne Driver',0,'               '  ; 32 Bytes
      DB 'WAVETABLE',0,'      '               ;16 Bytes
      DB 'Gravis Ultrasound driver       ',0  ; 32 Bytes
      DW 0100h              ;Version
      DW 9                  ;Anzahl der Funktionen (und damit
			    ; Segmentprfixe !!!)
      DW Config_Info
      DW SEG Config_Info

      DW Init_Driver
      DW SEG Config_Info
      DW Exit_Driver
      DW SEG Config_Info
      DW Detect_Device
      DW SEG Config_Info

      DW Init_Channels
      DW SEG Config_Info
      DW Play_Sample
      DW SEG Config_Info
      DW Stop_Sample
      DW SEG Config_Info
      DW Set_Play_Handler
      DW SEG Config_Info
      DW Load_Sample
      DW SEG Config_Info
      DW Stop_GUS
      dw SEG Config_Info


Config_Port 	dw 2
Config_IRQ	dw 5
Config_DMA	dw 1
Config_Memory	dw 256
Active_Voices	db ?
GF1_Int		db ?
u_Base LABEL WORD
GF1_Base	dw ?
GF1_DMA		db ?
IntOffset	dw ?
IntSegment	dw ?
u_Voice		dw ?
u_Command	dw ?
u_DataLo	dw ?
u_DataHi	dw ?
u_Status	dw ?
u_TimerControl  dw ?
u_TimerData	dw ?

Bank0_Pos	dd ?
Bank1_Pos	dd ?
Bank2_Pos	dd ?
Bank3_Pos	dd ?

Channel_Info	dd 32 dup (?)


Period_Factor 	dd	?

mt_VolTable	dw	00E00h,0B000h,0B800h,0BC00h,0BE00h,0C000h,0C400h,0C800h,0CC00h
		dw	0D000h,0D200h,0D400h,0D600h,0D800h,0DA00h,0DC00h,0DE00h
		dw	0E000h,0E100h,0E200h,0E300h,0E400h,0E500h,0E600h,0E700h
		dw	0E800h,0E900h,0EA00h,0EB00h,0EC00h,0ED00h,0EE00h,0EF00h
		dw	0F080h,0F100h,0F180h,0F200h,0F280h,0F300h,0F380h,0F400h
		dw	0F480h,0F500h,0F580h,0F600h,0F680h,0F700h,0F780h,0F800h
		dw	0F880h,0F900h,0F980h,0FA00h,0FA80h,0FB00h,0FB80h,0FC00h
		dw      0FC80h,0FD00h,0FD80h,0FE00h,0FE80h,0FF00h,0FF80h,0FFF0h


SET_VARS MACRO
	mov     [cs:u_Base],dx
	add     dx,102h
	mov     [cs:u_Voice],dx
	inc     dx
	mov     [cs:u_Command],dx
	inc     dx
	mov     [cs:u_DataLo],dx
	inc     dx
	mov     [cs:u_DataHi],dx
	mov     dx,[cs:u_Base]
	add     dx,6
	mov     [cs:u_Status],dx
	add     dx,2
	mov     [cs:u_TimerControl],dx
	inc     dx
	mov     [cs:u_TimerData],dx
	 ENDM


;[]------------------------------------------------------------------------[]
;|
;| Now some nice interrupt flag routines
;|
Set_Interrupt_Flag PROC NEAR
      mov bx,cs:[Config_IRQ]
      cmp bl,7
      ja short @@1
      in al,21h
      bts ax,bx
      out 21h,al

      retn

@@1:  sub bl,8
      in al,0a1h
      bts ax,bx
      out 0a1h,al

      retn
Set_Interrupt_Flag ENDP





Clear_Interrupt_Flag PROC NEAR
      mov bx,cs:[Config_IRQ]
      cmp bl,7
      ja short @@1
      in al,21h
      btr ax,bx
      out 21h,al

      retn

@@1:  sub bl,8
      in al,0a1h
      btr ax,bx
      out 0a1h,al

      retn
Clear_Interrupt_Flag ENDP


;[]------------------------------------------------------------------------[]
;|
;| First comes some general shit like delay commands etc...
;|

proc    UDelay
	push    dx ax
	mov     dx,300h
	in      al,dx
	in      al,dx
	in      al,dx
	in      al,dx
	in      al,dx
	in      al,dx
	in      al,dx
	pop     ax dx
	ret
endp    UDelay


; BX:CX Set to whatever.
u_Peek PROC NEAR
	push dx
	mov     dx,[cs:u_Command]
	mov     al,43h
	out     dx,al
	inc     dx                      ; 104h
	mov     ax,cx
	out     dx,ax
	dec     dx                      ; 103h
	mov     al,44h
	out     dx,al
	add     dx,2
	mov     al,bl
	out     dx,al
	add     dx,2
	in      al,dx
	pop dx
	retn
u_Peek ENDP


; BX:CX Set to whatever.
; AX Value to poke
u_Poke PROC NEAR
	push 	dx
	push    ax
	mov     dx,[cs:u_Command]
	mov     al,43h
	out     dx,al
	inc     dx
	mov     ax,cx
	out     dx,ax
	dec     dx
	mov     al,44h
	out     dx,al
	add     dx,2
	mov     al,bl
	out     dx,al
	add     dx,2
	pop     ax
	out     dx,al
	in      al,dx
	pop 	dx
	retn
u_Poke ENDP



; Dump sample to DRAM
;   ES:ESI  - Max 256k sample to dump to RAM.
;   EDI     - DRAM location to dump to.
;   ECX     - Max bytes to dump.
u_LoadSample proc near
	cli
	cld
	mov     dx,[cs:u_Command]
	mov     al,44h          ; Dump upper byte, only do it on carry from now
	out     dx,al           ; on.
	add     dx,2
	push    ax
	mov     eax,edi
	shr 	eax,16
	out     dx,al
	pop     ax
	sub     dx,2
@@MainLoop:
	mov     al,43h
	out     dx,al
	inc     dx
	push    ax
	mov     ax,di
	out     dx,ax
	pop     ax
	dec     dx
@@DumpByte:
	add     dx,4
	lods 	byte ptr es:[esi]
	out     dx,al
	sub     dx,4
	add     di,1
	jnc     short @@DoLoop
	add	edi,10000h
	mov     al,44h
	out     dx,al
	add     dx,2
	push    ax
	mov     eax,edi
	shr 	eax,16
	out     dx,al
	pop     ax
	sub     dx,2
@@DoLoop:
	dec 	ecx
	jnz    	short @@MainLoop
	sti
	retn
u_LoadSample endp



;
;Slides the volume to specific volume
; BX   -   destination
; AX   -   current volume
;
slideramp PROC NEAR
	shr     ax,8
	shr     bx,8
	cmp     ax,bx
	jb 	short @@OK
	je 	short @@End
	xchg    bx,ax
@@Ok:   pushf
	push    ax
	mov     dx,[cs:u_Command]
	mov     al,6
	out     dx,al
	add     dx,2
	mov     al,00111111b		;Set rate
	out     dx,al
	mov     dx,[cs:u_Command]
	mov     al,7
	out     dx,al
	add     dx,2
	pop     ax
	out     dx,al			;Set start
	mov     dx,[cs:u_Command]
	mov     al,8
	out     dx,al
	add     dx,2
	mov     ax,bx
	out     dx,al                   ;Set end
	xor	bl,bl
	popf
	jb      short @@OK3
	or      bl,01000000b		;Ramp backwards
@@OK3:	mov     dx,[cs:u_Command]
	mov     al,0Dh
	out     dx,al
	add     dx,2
	mov     al,bl
	out     dx,al
	call	uDelay
	out	dx,al
@@End:	retn
slideramp endp




;
;This macro slides the current volume to zero and enables the IRQ
;
slide_away MACRO
	mov     dx,[cs:u_Command]

	mov     al,0dh
	out     dx,al
	add     dx,2
	mov     al,3	              	;Stop ramping !
	out     dx,al
	call	uDelay
	out	dx,al

	sub     dx,2
	mov     al,89h
	out     dx,al
	inc     dl
	in      ax,dx
	cmp     ax,0f00h		;Already zero ???
	jb      short @@Is_Already_Zero
	mov	bx,ax			;BX=end volume (Bigger than 0)

	shr     bx,8
	mov     dx,[cs:u_Command]
	mov     al,6
	out     dx,al
	add     dx,2
	mov     al,00111111b		;Set rate
	out     dx,al

	mov     dx,[cs:u_Command]
	mov     al,7
	out     dx,al
	add     dx,2
	mov 	al,0Eh
	out     dx,al			;Set start

	mov     dx,[cs:u_Command]
	mov     al,8
	out     dx,al
	add     dx,2
	mov     ax,bx
	out     dx,al                   ;Set end

	mov     dx,[cs:u_Command]
	mov     al,0Dh
	out     dx,al
	add     dx,2
	mov     al,01100000b		;Set backwards & IRQ
	out     dx,al
	call	uDelay
	out	dx,al
	ENDM

;[]------------------------------------------------------------------------[]
;|
;| Now some init code for the driver follows includeing the autodetect
;| routine
;|
Init_Driver PROC FAR
	mov al,byte ptr cs:[Config_IRQ]
	cmp al,7
	ja short @@HighINT
	add al,8
	mov cs:[GF1_Int],al
	jmp short @@1
@@HighInt:
	add al,70h-8
	mov cs:[GF1_Int],al

@@1:	mov ah,35h
	mov dx,cs:[Config_Port]
	shl dx,4
	add dx,200h
	SET_VARS
	mov bx,cs:[Config_DMA]
	mov cs:[GF1_DMA],bl

	mov ax,204h
	mov bl,cs:[GF1_Int]
	int 31h
	mov cs:[IntOffset],dx
	mov cs:[IntSegment],cx
	mov ax,TRUE
	retf
Init_Driver ENDP




Exit_Driver PROC FAR
	mov ax,205h
	mov bl,cs:[GF1_Int]
	mov cx,cs:[IntSegment]
	mov dx,cs:[IntOffset]
	int 31h                      	;Vector setzen
	mov ax,TRUE
	retf
Exit_Driver ENDP



;[]------------------------------------------------------------------------[]
;|
;| This routine will try to detect a GUS by searching the port address
;| If found, then the environment will be analyzed for further information
;|
EnvString	db	"ULTRASND"
EnvSize		equ	8
EnvInfo		dw	5 dup (255)

Detect_Device PROC FAR
	push di
	push si
	push ds
	mov di,1f0h
   @@Detect_Loop:
		add di,10h
		mov dx,di
		SET_VARS
		mov dx,cs:[u_Command]
		mov al,4ch
		out dx,al		;Reset
		add dx,2                ; 105h
		xor al,al
		out dx,al               ;Reset command (all bits 0)
		call uDelay
		call uDelay		;Give some time to reset....
		sub dx,2                ; 103h
		mov al,4Ch
		out dx,al
		add dx,2                ; 105h
		mov al,1
		out dx,al
		call UDelay
		call UDelay
		mov ax,0AAh		;Poke AA to 0000:0000
		xor bx,bx
		xor cx,cx
		call u_Poke
		mov ax,055h             ;Poke 55 to 0000:0100
		mov cx,100h
		call u_Poke
		xor cx,cx		;Peek from 0000:0000
		call u_Peek
		push ax			;Save peeked value
		xor ax,ax
		call u_Poke             ;Clear again 0000:0000
		sub dx,2                ; 103h
		mov al,4Ch          	;Reset
		out dx,al
		add dx,2                ; 105h
		xor al,al
		out dx,al
		pop ax
		cmp al,0AAh		;Is it the same ???
		je @@Success

	cmp 	di,280h
	jb 	@@Detect_Loop
        jmp     @@Not_Found


	@@Success:
		;
		;When we are here, we were successful !
		;
		mov ax,di
		shr ax,4
		and ax,0fh
		mov cs:[Config_Port],ax


		;
		;Now lets check how much memory is on board
		;
		mov dx,cs:[u_Command]
		mov al,4Ch          	;Reset
		out dx,al
		add dx,2                ; 105h
		mov al,1
		out dx,al		;Turn off reset

		call uDelay
		call uDelay

		xor ax,ax		;Poke 00 to 0000:0000
		xor bx,bx
		xor cx,cx
		call u_Poke

		mov di,1		;Counter
    @@GusSize:	xor bx,bx
		xor cx,cx
		call u_Peek		;Get value from 0000:0000
		test al,al
		jnz short @@GotMem

		movzx ecx,di
		shl ecx,10
		xor ebx,ebx
		shld ebx,ecx,16		;BX:CX points to test location
		mov ax,0aah
		call u_Poke
		call u_Peek
		cmp al,0aah
		jne short @@GotMem

		inc di
		cmp di,1024
		jb short @@GusSize

    @@GotMem:	mov cs:[Config_Memory],di


		;
		;Now we should try to detect the used IRQ in any way...
		;
		push cs
		pop ds                          ;DS=CS

		mov 	dword ptr cs:[Envinfo],0ff00ffh
		mov 	dword ptr cs:[Envinfo+4],0ff00ffh

		mov 	ax,150h
		int 	31h			;Get PSP address in DX:AX
		mov 	es,dx
		mov     es,[es:2Ch]             ;ES:DI points at environment
		xor     di,di                   ;which is paragraph-aligned

		mov     ah,al                   ;otherwise, save in AH
		xor     al,al                   ;make a zero
@@Compare:      mov   	cx,EnvSize              ;get length
		mov     si,OFFSET EnvString     ;get pointer to string sought
		repe    cmpsb                   ;compare bytes
		jne     @@Skip                  ;if compare fails, try next string
		cmp     byte ptr es:[di],'='   	;compare succeeded. Is next char '='?
		jne     @@NoEqual               ;if not, still no match
@@Found:        mov     ax,es                   ;make DS:SI point to string we found
		mov     ds,ax
		mov     si,di
		inc     si                      ;get past the equal (=) sign

		;
		;Here we have found our environment...
		;
		push cs
		pop es
		mov di,OFFSET EnvInfo
		xor dx,dx			;Clear thing
		xor ah,ah
@@Scan_Loop:	lodsb
		test al,al			;Terminating 0 ???
		jz short @@All_Scanned
		cmp al,','
		jne short @@Still_This
		mov ax,dx
		stosw
		cmp di,OFFSET EnvInfo+8
		je short @@All_Scanned
		xor dx,dx
		xor ah,ah
		jmp short @@Scan_Loop
@@Still_This:	fastimul cx,dx,10
		add cx,ax
		sub cx,'0'
		mov dx,cx
		jmp short @@Scan_Loop

@@All_Scanned:	mov ax,cs:[EnvInfo+2]		;Get first DMA
		cmp ax,0ffh
		je @@Not_found
		mov cs:[Config_DMA],ax
		mov ax,cs:[EnvInfo+6]		;Get first IRQ
		cmp ax,0ffh
		je @@Not_found
		mov cs:[Config_IRQ],ax

		mov ax,TRUE
		pop ds
		pop si
		pop di
		retf

		;
		;Here we skip to the next entry in the environment
		;
@@Skip:         dec     di                      ;check for null from this char on
@@NoEqual:      mov     cx,7FFFh                ;search a long way if necessary
		sub     cx,di                   ;environment never >32K
		jbe     @@Not_Found           	;if we're past end, leave
		repne   scasb                   ;look for the next null
		jcxz    @@Not_Found             ;exit if not found
		cmp     byte ptr es:[di],al     ;second null in a row?
		jne     @@Compare               ;if not, try again
		jmp 	short @@Not_Found


@@Not_Found:
	mov ax,FALSE

	pop ds
	pop si
	pop di
	retf
Detect_Device ENDP




;[]------------------------------------------------------------------------[]
;|
;| Now follows the init-code for the channels. This routine will set the
;| currently used number of channels and bla-di-bla-di-bla.....
;|
Init_Channels PROC FAR
	ARG num_voices:byte
	push 	bp
	mov	bp,sp
	push 	di
	cli
	mov     bx,[cs:u_Command]
	mov     cx,[cs:u_DataHi]
	mov     dx,bx
	mov     al,4Ch
	out     dx,al
	mov     dx,cx
	mov     al,0
	out     dx,al
	call    UDelay
	call    UDelay
	mov     dx,bx
	mov     al,4Ch
	out     dx,al
	mov     dx,cx
	mov     al,1
	out     dx,al
	call    UDelay
	call    UDelay

	mov     dx,[cs:u_Voice]
	add     dx,100h
	mov     al,3
	out     dx,al
	call    UDelay
	mov     dx,[cs:u_Voice]
	add     dx,100h
	mov     al,0
	out     dx,al


	mov     dx,bx
	mov     al,41h			;DMA register clear
	out     dx,al
	mov     dx,cx
	xor     al,al
	out     dx,al

	mov     dx,bx
	mov     al,45h			;Turn off timers
	out     dx,al
	mov     dx,cx
	xor     al,al
	out     dx,al

	mov     dx,bx
	mov     al,49h			;Stop sampling
	out     dx,al
	mov     dx,cx
	xor     al,al
	out     dx,al

	mov     dx,bx
	mov     al,0Eh			;Set number of voices
	out     dx,al
	add     dx,2
	mov     al,[num_voices]
	cmp 	al,14
	ja 	short @@1
	mov	al,14
@@1:	mov	cs:[Active_Voices],al
	dec 	al
	or      al,0C0h
	out     dx,al

	mov     dx,[cs:u_Status]
	in      al,dx
	mov     dx,bx
	mov     al,41h
	out     dx,al
	mov     dx,cx
	in      al,dx
	mov     dx,bx
	mov     al,49h
	out     dx,al
	mov     dx,cx
	in      al,dx
	mov     dx,bx
	mov     al,8Fh
	out     dx,al
	mov     dx,cx
	in      al,dx

	push    bx cx
	mov     cx,0
@@VoiceClearLoop:
	mov     dx,[cs:u_Voice]
	mov     al,cl
	out     dx,al
	inc     dx
	mov     al,9
	out     dx,al
	inc     dl
	mov     ax,0
	out     dx,ax
	dec     dl
	mov     al,0
	out     dx,al
	add     dx,2
	mov     al,3                    ; Turn voice off
	out     dx,al
	sub     dx,2
	mov     al,0Dh
	out     dx,al
	add     dx,2
	mov     al,3
	out     dx,al
	sub     dx,2
	inc     cx
	cmp     cx,32
	jnz     @@VoiceClearLoop
	pop     cx bx

	mov     dx,bx
	mov     al,41h
	out     dx,al
	mov     dx,cx
	in      al,dx
	mov     dx,bx
	mov     al,49h
	out     dx,al
	mov     dx,cx
	in      al,dx
	mov     dx,bx
	mov     al,8Fh
	out     dx,al
	mov     dx,cx
	in      al,dx


	mov     dx,bx
	mov     al,4Ch
	out     dx,al
	mov     dx,cx
	mov     al,7			;Turn on IRQ,DAC
	out     dx,al


	mov     dx,[cs:u_Base]
	mov	al,8
	out     dx,al

	mov 	eax,32
	mov 	cs:[Bank0_Pos],eax
	mov 	cs:[Bank1_Pos],eax
	mov 	cs:[Bank2_Pos],eax
	mov 	cs:[Bank3_Pos],eax

	movzx 	ebx,cs:[Active_Voices]
	xor 	edx,edx
	mov 	eax,96bb8h
	div 	ebx
	mov 	cs:[Period_Factor],eax

	mov 	ax,205h
	mov 	bl,cs:[GF1_Int]
	mov 	cx,cs
	mov 	dx,OFFSET GUS_IRQ
	int 	31h                   	;Vector setzen

	push	cs
	pop 	es			;ES=CS
	mov 	di,OFFSET Channel_Info
	mov	cx,32
	xor	eax,eax
	rep	stosd

	call 	Clear_Interrupt_Flag

	pop 	di
	pop 	bp
	mov 	ax,TRUE
	sti
	retf
Init_Channels ENDP




Stop_GUS PROC FAR
	mov     dx,[cs:u_Base]
	mov     al,00001011b
	out     dx,al

	mov     dx,cs:[u_Command]
	mov     al,4Ch
	out     dx,al
	add     dx,2
	mov     al,1			;Turn off IRQ,DAC
	out     dx,al

	mov ax,205h
	mov bl,cs:[GF1_Int]
	mov cx,cs:[IntSegment]
	mov dx,cs:[IntOffset]
	int 31h                      	;Vector setzen

	mov ax,TRUE
	retf
Stop_GUS ENDP


;[]------------------------------------------------------------------------[]
;|
;| This is the loading routine which loads samples into the GUS-Ram. It
;| returns the memory-handle in eax and dx:ax
;|
Load_Sample PROC FAR
	ARG sample:dword,ssize:dword,flags:word
	push bp
	mov bp,sp
	push esi
	push edi

	xor ax,ax
	mov es,ax

	mov esi,[sample]
	mov ecx,[ssize]
	add ecx,31
	and cl,not 31
	test [flags],IF_16BIT
	jz short @@1
	shl ecx,1


	;
	;Now we try to find a bank that is big enough to hold that sample
	;
@@1:    mov bx,OFFSET Bank0_Pos
	mov dx,256			;Required memory
	xor edi,edi


@@L0:	cmp cs:[Config_Memory],dx	;Enough memory
	jb short @@Error
	mov eax,40000h			;Bank size
	sub eax,cs:[bx]			;Bank position
	cmp eax,ecx
	jae short @@Success

	add edx,256
	add edi,40000h
	add bx,4			;Next bank
	jmp short @@L0

@@Error:
	mov eax,0ffffffffh              ;Error
	mov edx,eax
	pop edi
	pop esi
	pop bp
	retf


	;
	;Now lets load the sample into gusram
	;
@@Success:
	add edi,cs:[bx]			;Add current position
	add cs:[bx],ecx			;Increment position
	push edi			;Save address as handle
	call u_LoadSample
	pop eax
	shld edx,eax,16
	pop edi
	pop esi
	pop bp
	retf
Load_Sample ENDP



;[]------------------------------------------------------------------------[]
;|
;| Finally this is a routine in order to play and stop samples
;|

uStop_Ramp MACRO
	mov     dx,[cs:u_Command]
	mov 	al,8dh		;Volume control
	out	dx,al
	add	dx,2
	in	al,dx
	mov	cl,al
	or	cl,3		;Stop ramping
	sub 	dx,2

	mov     al,0dh
	out     dx,al
	add     dx,2
	mov     al,cl       	;Stop ramping !
	out     dx,al
	call	uDelay
	out	dx,al
	ENDM

;
;Sets the current/start address of the sample
;Start address in EBX
;
uSet_Start MACRO
	mov     dx,[cs:u_Command]
	mov     al,0ah
	out     dx,al
	inc     dx              ; 104h
	mov     eax,ebx
	shr 	eax,7
	out     dx,ax
	call	uDelay
	out	dx,ax
	dec     dx              ; 103h
	mov     al,0bh
	out     dx,al
	inc     dx              ; 104h
	mov     ax,bx
	shl     ax,9
	out     dx,ax
	call	uDelay
	out	dx,ax
	ENDM
;
;Sets the loop-start address of the current voice
;EBX = loop start address
;
uSet_LoopStart MACRO
	mov     dx,[cs:u_Command]
	mov     al,2
	out     dx,al
	inc     dx              ; 104h
	mov 	eax,ebx
	shr 	eax,7
	out     dx,ax
	dec     dx              ; 103h
	mov     al,3
	out     dx,al
	inc     dx              ; 104h
	mov     ax,bx
	shl     ax,9
	out     dx,ax
	ENDM


;
;Sets the sample-size / loop-end
;EBX = loop end address
;CL  = loop flag:
;
uSet_End MACRO
	mov     dx,[cs:u_Command]
	mov     al,4
	out     dx,al
	inc     dx              ; 104h
	mov 	eax,ebx
	shr	eax,7
	out     dx,ax
	dec     dx              ; 103h
	mov     al,5
	out     dx,al
	inc     dx              ; 104h
	mov 	ax,bx
	shl     ax,9
	out     dx,ax
	ENDM

;
;Sets the voice-control flags:
;CL flags: 4   -   16bit data
;          8   -   loop enabled
;         16   -   bidirectional loop
;         64   -   play backwards
uSet_Control MACRO
	mov     dx,cs:[u_Command]
	xor     al,al
	out     dx,al
	add     dx,2
	mov     al,cl
	out     dx,al
	call 	uDelay
	out	dx,al
	ENDM


;
;Gets the voice-control flags
;
uGet_Control MACRO
	mov     dx,cs:[u_Command]
	mov	al,80h
	out     dx,al
	add     dx,2
	in      al,dx
	ENDM


;
;Sets pan position
;BL = pan position (0-255)
;
uSet_Panning MACRO
	mov     dx,[cs:u_Command]
	mov     al,0ch
	out     dx,al
	add     dx,2
	mov     al,bl
	shr 	al,4
	out     dx,al
	ENDM


;
;Sets the new volume
;BX = new volume
;
uRamp_Volume MACRO
	mov     dx,[cs:u_Command]

	mov     al,0dh
	out     dx,al
	add     dx,2
	mov     al,3	              	;Stop ramping !
	out     dx,al
	call	uDelay
	out	dx,al

	shl 	bx,1
	mov 	bx,cs:[mt_VolTable+bx]
	sub     dx,2
	mov     al,89h
	out     dx,al
	inc     dl
	in      ax,dx
	call    slideramp
	ENDM



;
;Sets the new volume
;BX = new volume (logarithmic)
;
uSet_Volume MACRO
	local   Done
	mov     dx,[cs:u_Command]

	mov     al,0dh
	out     dx,al
	add     dx,2
	mov     al,3	              	;Stop ramping !
	out     dx,al

	sub     dx,2
	mov     al,89h
	out     dx,al
	inc     dl
	in      ax,dx
	cmp     ax,bx
	je      short Done

	dec 	dl
	mov	al,9h
	out 	dx,al
	inc	dl
	mov	ax,bx
	out	dx,ax
	call 	uDelay
	out	dx,ax

Done:
	ENDM


;
;Sets a new frequency
; fc = (unsigned int)(((speed_khz<<9L)+(divisor>>1L)) / divisor);
; EAX - frequency
;
uSet_Frequency MACRO
	local   Done
	xor 	edx,edx
	shl 	eax,10
	div 	cs:[Period_Factor]
	and	al,NOT 1
	mov 	bx,ax
	mov     dx,[cs:u_Command]
	mov     al,81h
	out     dx,al
	inc     dl
	in      ax,dx
	cmp     ax,bx
	je      short Done
	dec     dl
	mov     al,1
	out     dx,al
	inc     dl
	mov     ax,bx
	out     dx,ax
Done:
	ENDM



;
;This MACRO stops the active voice
;
uStop_Voice MACRO
	mov     dx,[cs:u_Command]
	xor 	al,al
	out     dx,al
	add     dl,2
	mov     al,3
	out     dx,al
	call	uDelay
	out	dx,al
	ENDM



;
;This macro sets most relevant information
;
uSet_All MACRO
	LOCAL NoLp,Ende
	mov 	bl,gs:[si+25]
	uSet_Panning
	mov 	eax,gs:[si+20]
	uSet_Frequency
	mov 	ebx,gs:[si+4]
	add 	ebx,gs:[si+12]
	sub 	ebx,1
	jc 	Ende		;Length=0 ???

	xor 	cl,cl		;CL holds flags
	cmp 	gs:[si+16],0fffffffh
	jae 	short NoLp
		inc 	ebx	;Increment it again
		push 	ebx
		mov 	cl,8	;Enable loop
		mov 	ebx,gs:[si+4]
		add 	ebx,gs:[si+16]
		uSet_LoopStart
		pop 	ebx
		testflag dword ptr gs:[si],IF_PINGPONG_LOOP
		jz 	short NoLp
		or 	cl,16  	;Bidirectional looping
NoLp:   uSet_End
	mov 	ebx,gs:[si+4]
	add 	ebx,gs:[si+8]
	uSet_Start
	uSet_Control
Ende:
	ENDM





Play_Sample PROC FAR
	ARG channel:byte,info:dword
	push bp
	mov bp,sp
	push esi
	push edi


	lgs si,[info]		;Info structure !

	cli			;Dont change my GUS !
	mov dx,[cs:u_Voice]
	mov al,[channel]
	out dx,al


	mov edi,gs:[si]		;Get info-flags
	test edi,CF_NEW_HANDLE	;Everything new ???
	jz @@2
		movzx bx,al	;Get channel
		shl bx,2
		mov eax,[info]
		mov cs:[Channel_Info+bx],eax
		slide_away
		sti
		pop edi
		pop esi
		pop bp
		retf


@@Is_Already_Zero:
		uStop_Voice
		movzx bx,gs:[si+24]
		uRamp_Volume
		uSet_All
		sti
		pop edi
		pop esi
		pop bp
		retf

@@2:    test edi,CF_NEW_PANNING
	jz short @@3
		mov bl,gs:[si+25]
		uSet_Panning
@@3:	test edi,CF_NEW_START
	jz short @@4
		mov ebx,gs:[si+4]
		add ebx,gs:[si+8]
		uSet_Start
@@4:	test edi,CF_NEW_SIZE
	jz short @@5
		mov ebx,gs:[si+4]
		add ebx,gs:[si+12]
		uSet_End
@@5:	test edi,CF_NEW_LOOP
	jz short @@6
		mov cl,32
		cmp gs:[si+16],0fffffffh
		jae short @@NoLp2
		mov cl,8		;Enable loop
		mov ebx,gs:[si+4]
		add ebx,gs:[si+16]
		uSet_LoopStart
		test edi,IF_PINGPONG_LOOP
		jz short @@NoLp2
		or cl,16		;Bidirectional looping
	@@NoLp2:uSet_Control
@@6:	test edi,CF_NEW_FREQ
	jz short @@7
		mov eax,gs:[si+20]
		uSet_Frequency
@@7:

@@End:  movzx bx,gs:[si+24]
	uRamp_Volume


@@TEnd:	sti
	pop edi
	pop esi
	pop bp
	retf
Play_Sample ENDP




Stop_Sample PROC FAR
	ARG channel:byte
	push bp
	mov bp,sp

	mov     dx,[cs:u_Voice]
	mov     al,[channel]
	out     dx,al
	uStop_Voice

	pop bp
	retf
Stop_Sample ENDP



Set_Play_Handler PROC FAR
	retf
Set_Play_Handler ENDP




;[]------------------------------------------------------------------------[]
;|
;| This is the IRQ handler for the GUS
;|
GUS_IRQ PROC FAR
	push gs
	pushad


@@Main:	mov	dx,[cs:u_Status]
	in      al,dx
	test 	al,al
	jz	@@Finish
	test 	al,1100000b
	jz 	@@Main

@@GF1_Loop:
	mov	dx,cs:[u_Command]
	mov 	al,8fh
	out	dx,al
	add     dx,2
	in      al,dx
	mov     cl,al

	shr	al,6
	cmp	al,11b
	je 	short @@Main

	mov 	al,cl
	and 	al,1fh		;Get Voice

	mov 	dx,[cs:u_Voice]
	out 	dx,al		;Select Voice

	test 	cl,64
	jnz 	@@Wave
		movzx bx,al	;Get channel
		shl bx,2
		cmp cs:[Channel_Info+bx],0
		je @@Wave
		lgs si,cs:[Channel_Info+bx]
		mov cs:[Channel_Info+bx],0
		uStop_Voice
		movzx bx,gs:[si+24]
		uRamp_Volume
		uSet_All
		jmp @@GF1_Loop


@@Wave:	test 	cl,128
	jnz 	@@GF1_Loop
		uStop_Voice

	jmp @@GF1_Loop

@@Finish:
	mov     al,20h
	out     0A0h,al
	out     20h,al
	sti

	popad
	pop gs
	iret
GUS_IRQ ENDP




Config_Info 	dd 036bea73fh
		dw 4		;Eintrge

		db 2,14
		dw OFFSET Config_Port
		dw 0,8,1
		dw 0,0,0
		DB "I/O Port 2x0h",0

		db 2,10
		dw OFFSET Config_IRQ
		dw 1,15,1
		dw 0,0,0
		db "Interrupt",0

		db 2,12
		dw OFFSET Config_DMA
		dw 0,3,1
		dw 0,0,0
		db "DMA Channel",0

		db 2,16
		dw OFFSET Config_Memory
		dw 256,1024,256
		dw 0,0,0
		DB "Memory on board",0
END