;[]------------------------------------------------------------------------[]
;|                                                                          |
;| (c) 1993,1994,1995 by Marc van Shaney , aka Kaya Memisoglu               |
;|                                                                          |
;| This Source-Code was written by and is copyrighted by Kaya Memisoglu	    |
;| You may use the whole code or only parts of it in your own programs      |
;| whether they are commercial or not. BUT you must give credits for these  |
;| parts to me (Kaya Memisoglu  or  Marc van Shaney).                       |
;| I am not responsible for any damage or loss caused by this program, so   |
;| if you success in erasing your harddisk with this code, then it is your  |
;| own fault and you should not claim me to be responsible...               |
;| I would be very pleased if you also sent me a postcard or even a letter  |
;| if you can use this code. My address:                                    |
;|                                                                          |
;|        Kaya Memisoglu                                                    |
;|        Reichenberger Ring 50                                             |
;|        63512 Hainburg                                                    |
;|        Germany                                                           |
;|                                                                          |
;| You can also leave a message for Marc van Shaney on the Nirvana BBS:     |
;|                                                                          |
;|              Nirvana BBS     ++49-(0)6245-3056      Sysop:Raytrayza      |
;|                                                                          |
;|                                                                          |
;[]------------------------------------------------------------------------[]
; !!! WARNING !!! WARNING !!! WARNING !!! WARNING !!! WARNING !!! WARNING !!!
; !!! WARNING !!! WARNING !!! WARNING !!! WARNING !!! WARNING !!! WARNING !!!
;
; I DO NOT SAVE THE REGISTER VARIABLES SI AND DI IN THIS CODE AND IN SOME
; OTHER MODULES. SO MAKE SURE BEFORE COMPILING THIS CODE THAT THE REGISTER
; VARIABLES IN BORLAND C ARE SET TO *NONE*.
; BUT IF YOU STILL WANT TO USE THEM, YOU HAVE TO SAVE THEM BY CHANGING THIS
; CODE !!!
;
; !!! WARNING !!! WARNING !!! WARNING !!! WARNING !!! WARNING !!! WARNING !!!
; !!! WARNING !!! WARNING !!! WARNING !!! WARNING !!! WARNING !!! WARNING !!!

;The Sound_Block structure:
;	word 		Sample_rate
;	word 		Sample_Size
;	byte 		Bits_per_Sample
;	byte 		Channels
;	10 bytes 	resreved


P386
LOCALS


Delay MACRO
	LOCAL L1
	push ecx
	pushfd
	mov ecx,010000h
L1:	nop
	nop
	dec ecx
	jnz short L1
	popfd
	pop ecx
      ENDM



TRUE        		equ   1
FALSE       		equ   -1
SAMPLE_RATE     	equ   0
SAMPLE_SIZE		equ   2
SAMPLE_RESOLUTION	equ   4
SAMPLE_CHANNELS		equ   5


DSP_Retry		equ  50h
DSP_Out_DMA         	equ  14h
DSP_Reset_Port      	equ  6
DSP_Read_Port       	equ  0ah
DSP_Write_Port      	equ  0ch
DSP_Status_Port     	equ  0eh
SOUND_READY             equ  2
SOUND_PLAYING		equ  1
SOUND_RECORDING		equ  4

SOUND_CAN_PLAY		equ	1
SOUND_CAN_RECORD	equ	2
SOUND_CAN_STEREO	equ	4
SOUND_CAN_MONO		equ	8
SOUND_CAN_8BIT		equ	16
SOUND_CAN_16BIT		equ	32
SOUND_USES_TIMER	equ	64




.MODEL USE16 LARGE
.Data
PUBLIC C SBDMA_Driver
SBDMA_Driver dw	OFFSET drv
	     dw SEG DRV
.Code


drv:  DB 'Cyberdyne Driver',0,'               '  ; 32 Bytes
      DB 'SOUND',0,'          '               ;16 Bytes
      DB 'Sound-Blaster DMA driver       ',0  ; 32 Bytes
      DW 0305h              ;Version
      DW 9                  ;Anzahl der Funktionen (und damit
			    ; Segmentprfixe !!!)
      DW Config_Info
      DW SEG Config_Info

      DW Init_Driver
      DW SEG Config_Info
      DW Exit_Driver
      DW SEG Config_Info
      DW Detect_Device
      DW SEG Config_Info
      DW Play_Voice
      DW SEG Config_Info
      DW Stop_Voice
      DW SEG Config_Info
      DW Record_Voice
      DW SEG Config_Info
      DW Set_Play_Handler
      DW SEG Config_Info
      DW Set_Record_Handler
      DW SEG Config_Info
      DW Set_Next_Block
      DW SEG Config_Info

      DD SOUND_CAN_PLAY or SOUND_CAN_MONO or SOUND_CAN_8BIT or SOUND_CAN_STEREO
      DW 44000
      DW 44000


Status		DW ?
Data_Adress     DD ?
Data_Size       DW ?

DSP_Base        DW 220h
DSP_Int         DB 0dh
DSP_DMA         DB 1
IntOffset       DW ?
IntSegment      DW ?

Voice_Rate      DW ?
Play_Handler	DD 0
Record_Handler	DD 0
Next_Block	DD ?

SB_Pro		DB ?

Config_Port	DW 2
Config_IRQ	DW 5
Config_DMA	DW 1


Channels	DW ?

;=========================================================================
;====                                                                 ====
;====                                                                 ====
;====                    DMA-Routinen                                 ====
;====                                                                 ====
;====                                                                 ====
;=========================================================================


DMA_Page_Table db 87h,83h,81h,82h

;CX holds Data_Size
;BH holds mode

DMA_Setup PROC NEAR
      xor al,al
      out 0ch,al         		;FlipFlop lschen

      mov bl,cs:[DSP_DMA]		;BL holds DMA_Channel
;      mov al,bl
;      or al,0100b
;      out 0ah,al                        ;Set mask

      movzx dx,bl
      shl dx,1
      inc dx
      mov ax,cx
      dec ax
      out dx,al
      shr ax,8
      out dx,al                         ;Set size

      mov al,bl
      add al,bh
      out 0bh,al			;Set Mode

      mov eax,cs:[Data_Adress]
      dec dx
      out dx,al
      shr eax,8
      out dx,al
      shr eax,8				;Set Offset

      xor bh,bh            		;BX holds DSP_DMA_Channel
      mov dl,cs:[bx+OFFSET DMA_Page_Table]
      out dx,al				;Page
;      shr eax,8
;      mov dh,4
;      out dx,al

      mov al,cs:[DSP_DMA]               ;Clear mask
      out 0ah,al
      retn
DMA_Setup ENDP




Set_Interrupt_Flag PROC NEAR
      mov bx,cs:[Config_IRQ]
      cmp bl,7
      ja short @@1
      in al,21h
      bts ax,bx
      out 21h,al

      retn

@@1:  sub bl,8
      in al,0a1h
      bts ax,bx
      out 0a1h,al

      retn
Set_Interrupt_Flag ENDP





Clear_Interrupt_Flag PROC NEAR
      mov bx,cs:[Config_IRQ]
      cmp bl,7
      ja short @@1
      in al,21h
      btr ax,bx
      out 21h,al

      retn

@@1:  sub bl,8
      in al,0a1h
      btr ax,bx
      out 0a1h,al

      retn
Clear_Interrupt_Flag ENDP



;=========================================================================
;====                                                                 ====
;====                                                                 ====
;====                    DSP-Routinen                                 ====
;====                                                                 ====
;====                                                                 ====
;=========================================================================






DSP_Init PROC NEAR
      mov dx,cs:[DSP_Base]
      add dx,DSP_Reset_Port
      mov al,1
      out dx,al
      Delay
      xor al,al
      out dx,al

      mov dx,cs:[DSP_Base]
      add dx,DSP_Read_Port
      mov cx,8000h
 Schleife51:
	push cx
	mov dx,cs:[DSP_Base]
	add dx,DSP_Status_Port
	mov cx,8000h
   Schleife61:
	 in al,dx
	 test al,128
   loope Schleife61
       mov dx,cs:[DSP_Base]
       add dx,DSP_Read_Port
       in al,dx
       pop cx
       cmp al,0aah
       je OK
 loopne Schleife51

      mov ax,FALSE
      retn
  OK:
      mov ax,TRUE
      retn
 DSP_Init ENDP






DSP_Read PROC NEAR
      mov dx,cs:[DSP_Base]
      add dx,DSP_Status_Port
      mov cx,DSP_Retry
 Schleife73:
       in al,dx
       test al,128
 loope Schleife73
      mov dx,cs:[DSP_Base]
      add dx,DSP_Read_Port
      in al,dx
      movzx ax,al
      retn
DSP_Read ENDP






DSP_Write PROC NEAR
      ARG Value:word
      push bp
      mov bp,sp

      mov dx,cs:[DSP_Base]
      add dx,DSP_Write_Port
      mov cx,DSP_Retry
 Schleife97:
       in al,dx
       test al,128
 loopne Schleife97

      mov ax,Value
      out dx,al
      pop bp
      retn
DSP_Write ENDP








DSP_WriteM MACRO value
	LOCAL @L1
	mov cx,DSP_Retry
 @L1:
	in al,dx
	test al,128
 loopne @L1
	mov al,value
	out dx,al
       ENDM




;Rate in BX
Init_Voice MACRO
      LOCAL @NoProCommand,Channel_1,Ende
      mov cs:[Voice_Rate],bx
      mov cs:[Status],SOUND_READY
      call DSP_Write C,040h

      movzx ebx,cs:[Voice_Rate]
      movzx eax,cs:[Channels]
      mul ebx
      mov ebx,eax

      xor edx,edx
      mov eax,1000000
      div ebx
      neg al

      cmp ebx,23000
      jb @NoProCommand
      mov cl,1

  @NoProCommand:
      mov bl,al
      mov cs:[SB_Pro],cl
      mov dx,cs:[DSP_Base]
      add dx,DSP_Write_Port
      DSP_WriteM bl

      cmp cs:[Channels],1
      je short Channel_1
      mov dx,cs:[DSP_Base]
      add dx,4
      mov al,0eh
      out dx,al
      inc dx
      in al,dx
      or al,2
      out dx,al
      jmp Ende

  Channel_1:
      mov dx,cs:[DSP_Base]
      add dx,4
      mov al,0eh
      out dx,al
      inc dx
      in al,dx
      and al,NOT 2
      out dx,al
  Ende:
  ENDM





DSP_Status MACRO
      mov dx,cs:[DSP_Base]
      add dx,DSP_Status_Port
      in al,dx
      add dx,DSP_Read_Port-DSP_Status_Port
      in al,dx
      ENDM





;BlockGre in BX
Play_VoiceM MACRO
	LOCAL @NoPro,@End_Play
	mov bh,72
	mov cx,cs:[Data_Size]
	call DMA_Setup
	mov dx,cs:[DSP_Base]
	add dx,DSP_Write_Port
	mov bx,cs:[Data_Size]
	dec bx
	cmp cs:[SB_Pro],1
	jne short @NoPro
	DSP_WriteM 48h
	DSP_WriteM bl
	DSP_WriteM bh
	DSP_WriteM 91h
	jmp short @End_Play

   @NoPro:
	DSP_WriteM 14h
	DSP_WriteM bl
	DSP_WriteM bh
   @End_Play:
ENDM




;=========================================================================
;====                                                                 ====
;====                                                                 ====
;====                    Sound-Routinen                               ====
;====                                                                 ====
;====                                                                 ====
;=========================================================================



Init_Driver PROC FAR
      mov al,byte ptr cs:[Config_IRQ]
      cmp al,7
      ja short @@HighINT
      add al,8
      jmp short @@1
@@HighINT:
      add al,70h-8
@@1:  mov cs:[DSP_Int],al
      mov ah,35h
      mov bx,cs:[Config_Port]
      shl bx,4
      add bx,200h
      mov cs:[DSP_Base],bx
      mov bx,cs:[Config_DMA]
      mov cs:[DSP_DMA],bl

      mov ax,204h
      mov bl,cs:[DSP_Int]
      int 31h
      mov cs:[IntOffset],dx
      mov cs:[IntSegment],cx

      mov cs:[Play_Handler],0
      mov cs:[Record_Handler],0
      mov cs:[Status],0
      call DSP_Init

      retf
Init_Driver ENDP





Exit_Driver PROC FAR
      mov ax,205h
      mov bl,cs:[DSP_Int]
      mov cx,cs:[IntSegment]
      mov dx,cs:[IntOffset]
      int 31h                      ;Vector setzen
      mov ax,TRUE
      retf
Exit_Driver ENDP




;[]-------------------------------------------------------------------------[]
;|
;| Now follows the auto-detect and auto-config-routine
;|
SB_Test_Retry		equ	300
EnvString	db	"BLASTER"
EnvSize		equ	7



Detect_Device PROC FAR
	push 	bp
	push	di
	push	si
	push	ds

	;
	;Now we should try to detect the used IRQ in any way...
	;
	push cs
	pop ds                          ;DS=CS

	mov 	ax,150h
	int 	31h			;Get PSP address in DX:AX
	mov 	es,dx
	mov     es,[es:2Ch]             ;ES:DI points at environment
	xor     di,di                   ;which is paragraph-aligned

		mov     ah,al                   ;otherwise, save in AH
		xor     al,al                   ;make a zero
@@Compare:      mov   	cx,EnvSize              ;get length
		mov     si,OFFSET EnvString     ;get pointer to string sought
		repe    cmpsb                   ;compare bytes
		jne     @@Skip                  ;if compare fails, try next string
		cmp     byte ptr es:[di],'='   	;compare succeeded. Is next char '='?
		jne     @@NoEqual               ;if not, still no match
		mov     ax,es                   ;make DS:SI point to string we found
		mov     ds,ax
		mov     si,di
		inc     si                      ;get past the equal (=) sign

		;
		;Here we have found our environment...
		;
		xor 	dx,dx			;Clear thing
		xor 	ah,ah
@@Scan_Loop:	lodsb
		test 	al,al			;Terminating 0 ???
		jz 	short @@Found
		cmp 	al,32
		je 	short @@Scan_Loop	;Is it a silly space ?

		cmp	al,'9'
		ja	short @@NoNumber
		cmp	al,'0'
		jb	short @@NoNumber
		sub	al,'0'
		shl	dx,4
		or	dl,al
		jmp	short @@Scan_Loop

@@NoNumber:	cmp	ah,'A'
		jne	short @@No_Address
			shr	dx,4
			and	dx,0fh
			mov	cs:[Config_Port],dx
			mov	ah,al
			xor	dx,dx
			jmp	short @@Scan_Loop

@@No_Address:	cmp	ah,'I'
		jne	short @@No_Interrupt
			cmp	dl,9
			jbe	short @@Ok
			sub	dl,6
		@@Ok:	mov	cs:[Config_IRQ],dx
			mov	ah,al
			xor	dx,dx
			jmp	short @@Scan_Loop
@@No_Interrupt:	cmp	ah,'D'
		jne	short @@No_DMA
			mov	cs:[Config_DMA],dx
			mov	ah,al
			xor	dx,dx
			jmp	short @@Scan_Loop
@@No_DMA:	xor	dx,dx
		mov	ah,al
		jmp	short @@Scan_Loop



	;
	;Here we skip to the next entry in the environment
	;
@@Skip:	dec     di                      ;check for null from this char on
@@NoEqual:      mov     cx,7FFFh        ;search a long way if necessary
	sub     cx,di                   ;environment never >32K
	jbe     @@Not_Found           	;if we're past end, leave
	repne   scasb                   ;look for the next null
	jcxz    @@Not_Found             ;exit if not found
	cmp     byte ptr es:[di],al     ;second null in a row?
	jne     @@Compare               ;if not, try again
	jmp 	short @@Not_Found



	;
	;Now lets perform a little hardware check...
	;
@@Found:
	mov 	dx,cs:[Config_Port]
	shl 	dx,4
	add 	dx,206h
	mov 	al,1
	out 	dx,al
	mov 	al,0
	out 	dx,al
	mov 	cx,SB_Test_Retry
	mov 	dx,cs:[Config_Port]
	shl 	dx,4
	add 	dx,20eh
    SBLoop1:
		in 	al,dx
		cmp 	al,128
		jae 	short @@EndLoop1
    loop 	SBLoop1
    @@EndLoop1:
	cmp 	cx,0
	je 	short @@Not_Found
	mov 	dx,cs:[Config_Port]
	shl 	dx,4
	add 	dx,20ah
	in 	al,dx
	cmp 	al,0aah
	jne 	short @@Not_Found

	call 	DSP_Init
	mov 	ax,TRUE
	pop 	ds
	pop 	si
	pop 	di
	pop 	bp
	retf



@@Not_Found:
	mov 	ax,FALSE
	pop 	ds
	pop 	si
	pop 	di
	pop 	bp
	retf
Detect_Device ENDP








Play_Voice PROC FAR
	ARG Data:dword
	push bp
	mov bp,sp
	push esi
	cli

	xor ax,ax
	mov es,ax
	mov esi,[Data]
	cmp word ptr es:[esi+SAMPLE_SIZE],0
	je Return_Info

	call DSP_Init

	movzx ax,es:[esi+SAMPLE_CHANNELS]
	mov cs:[Channels],ax
	mul word ptr es:[esi+SAMPLE_SIZE]
	mov cs:[Data_Size],ax
	mov bx,es:[esi+SAMPLE_RATE]
	Init_Voice
	mov eax,[Data]
	add eax,10h
	mov cs:[Data_Adress],eax
	or cs:[Status],SOUND_PLAYING
	mov cs:[Next_Block],0

	call DSP_Write C,0d1h          ;Lautsprecher einschalten

	mov bl,cs:[DSP_Int]
	mov ax,205h
	mov cx,cs
	mov dx,OFFSET Play_Interrupt
	int 31h                        ;Vector setzen
	call Clear_Interrupt_Flag

	DSP_Status
	Play_VoiceM

	sti
	pop esi
	pop bp
	mov ax,TRUE
	retf

Return_Info:
	mov byte ptr es:[esi+SAMPLE_RESOLUTION],8
	mov al,es:[esi+SAMPLE_CHANNELS]
	cmp al,2
	je short Info_Stereo
	mov bx,es:[esi+SAMPLE_RATE]
	cmp bx,45500
	jbe short @@1
	mov bx,45500
@@1:	mov dx,1000000 shr 16
	mov ax,1000000 and 0ffffh
	div bx
	movzx bx,al
	mov dx,1000000 shr 16
	mov ax,1000000 and 0ffffh
	div bx
	mov es:[esi+SAMPLE_RATE],ax
	jmp short Ende

Info_Stereo:
	movzx ebx,word ptr es:[esi+SAMPLE_RATE]
	cmp ebx,22222
	jbe short @@2
	mov ebx,22222
@@2:	xor edx,edx
	mov eax,1000000
	shl ebx,1
	div ebx
	movzx ebx,al
	xor edx,edx
	mov eax,1000000
	div ebx
	shr eax,1
	mov es:[esi+SAMPLE_RATE],ax

Ende:	sti
	pop esi
	pop bp
	retf
Play_Voice ENDP








Stop_Voice PROC FAR
      pushf
      cli

      mov ax,205h
      mov bl,cs:[DSP_Int]
      mov cx,cs:[IntSegment]
      mov dx,cs:[IntOffset]
      int 31h                      ;Vector setzen

      call DSP_Write C,0d0h             ;Stop !
      call Set_Interrupt_Flag
      call DSP_Write C,0d3h		;Lautsprecher ausschalten

      mov bl,cs:[DSP_DMA]		;BL holds DMA_Channel
      mov al,bl
      or al,0100b
      out 0ah,al                        ;Set mask

      mov cs:[Data_Size],0
      mov cs:[Data_Adress],0ffffffffh
      and cs:[Status],0ffffh-SOUND_PLAYING-SOUND_RECORDING

      popf
      mov ax,TRUE
      retf
Stop_Voice ENDP






Record_Voice PROC FAR
	retf
Record_Voice ENDP






Play_Interrupt PROC FAR
      pushad
      push ds
      push es

      DSP_Status
      mov al,20h
      out 20h,al
      out 0A0h,al
      cmp cs:[Next_Block],0
      je PlyNo_Next_Block
      xor ax,ax
      mov ds,ax
      mov ebx,cs:[Next_Block]
      movzx ax,ds:[ebx+SAMPLE_CHANNELS]
      mul word ptr ds:[ebx+SAMPLE_SIZE]
      mov cs:[Data_Size],ax
      add ebx,10h			;this is one paragraph
      mov cs:[Data_Adress],ebx
      Play_VoiceM
      mov cs:[Next_Block],0
      cmp cs:[Play_Handler],0
      je short No_Handler
      sti
      call cs:[Play_Handler]
      cmp ax,0
      jl short Stop_Output

    No_Handler:
      pop es
      pop ds
      popad
      iret


    PlyNo_Next_Block:
      cmp cs:[Play_Handler],0
      je short Stop_Output
      sti
      call cs:[Play_Handler]
      cmp ax,0
      jl short Stop_Output
      pop es
      pop ds
      popad
      iret

   Stop_Output:
      call Stop_Voice
      pop es
      pop ds
      popad
      iret
Play_Interrupt ENDP







Set_Play_Handler PROC FAR
	ARG handler:dword
	push bp
	mov bp,sp

	mov eax,[handler]
	mov cs:[Play_Handler],eax

	pop bp
	retf
Set_Play_Handler ENDP





Set_Record_Handler PROC FAR
	ARG handler:dword
	push bp
	mov bp,sp

	mov eax,[handler]
	mov cs:[Play_Handler],eax

	pop bp
	retf
Set_Record_Handler ENDP





Set_Next_Block PROC FAR
      ARG Data:dword
      push bp
      mov bp,sp

      mov eax,[Data]
      mov cs:[Next_Block],eax

      pop bp
      retf
Set_Next_Block ENDP








Config_Info 	dd 036bea73fh
		dw 3		;Eintrge

		db 2,14
		dw OFFSET Config_Port
		dw 0,8,1
		dw 0,0,0
		DB "I/O Port 2x0h",0

		db 2,10
		dw OFFSET Config_IRQ
		dw 1,15,1
		dw 0,0,0
		db "Interrupt",0

		db 2,12
		dw OFFSET Config_DMA
		dw 0,3,1
		dw 0,0,0
		db "DMA Channel",0

END