/***************************************************************************
 **
 ** (c) 1993,1994,1995 by Marc van Shaney , aka Kaya Memisoglu
 **
 ** This Source-Code was written by and is copyrighted by Kaya Memisoglu
 ** You may use the whole code or only parts of it in your own programs
 ** whether they are commercial or not. BUT you must give credits for these
 ** parts to me (Kaya Memisoglu  or  Marc van Shaney).
 ** I am not responsible for any damage or loss caused by this program, so
 ** if you success in erasing your harddisk with this code, then it is your
 ** own fault and you should not claim me to be responsible...
 ** I would be very pleased if you also sent me a postcard or even a letter
 ** if you can use this code. My address:
 **
 **        Kaya Memisoglu
 **        Reichenberger Ring 50
 **        63512 Hainburg
 **        Germany
 **
 ** You can also leave a message for Marc van Shaney on the Nirvana BBS:
 **
 **              Nirvana BBS     ++49-(0)6245-3056      Sysop:Raytrayza
 **
 **
 **/


#ifndef __SOUNDDRV_H
#define __SOUNDDRV_H

#define SOUND_PLAYING		1
#define SOUND_READY		2
#define SOUND_RECORDING		4
#define SOUND_CAN_PLAY		1
#define SOUND_CAN_RECORD	2
#define SOUND_CAN_STEREO	4
#define SOUND_CAN_MONO		8
#define SOUND_CAN_8BIT		16
#define SOUND_CAN_16BIT		32
#define SOUND_USES_TIMER	64

#ifndef __SOUND_BLOCK
#define __SOUND_BLOCK
typedef struct {
		unsigned int Speed;
		unsigned int Size;
		unsigned char Bits_per_Sample;
		unsigned char Channels;
		char Reserved[10];
	       } Sound_Block;
#endif




typedef struct
	     {
	      char Ident[32];
	      char Type[16];
	      char Name[32];
	      int Version;
	      int Function_Count;
	      char *Driver_Setup;

	      int (*Init_Driver) (void);
	      int (*Exit_Driver) (void);
	      int (*Detect_Device) (void);
	      int (*Play_Voice) (Sound_Block *);
	      int (*Stop_Voice) (void);
	      int (*Record_Voice) (Sound_Block *);
	      int (*Set_Play_Handler) (int (*Handler) (void));
	      int (*Set_Record_Handler) (int (*Handler) (void));
	      int (*Set_Next_Block) (Sound_Block *);

	      long Capabilities;
	      int MaxRecordRate;
	      int MaxPlayRate;
	      int Status;
	      char far *Voice;
	     } SoundDrv;

extern SoundDrv *SPEAKER_Driver;
extern SoundDrv *SBDMA_Driver;
extern SoundDrv *LPT_Driver;
extern SoundDrv *SILENT_Driver;
extern SoundDrv *SBTIMER_Driver;
extern SoundDrv *ADLIB_Driver;
extern SoundDrv *GUS_Driver;



#endif