;[]------------------------------------------------------------------------[]
;|                                                                          |
;| (c) 1993,1994,1995 by Marc van Shaney , aka Kaya Memisoglu               |
;|                                                                          |
;| This Source-Code was written by and is copyrighted by Kaya Memisoglu	    |
;| You may use the whole code or only parts of it in your own programs      |
;| whether they are commercial or not. BUT you must give credits for these  |
;| parts to me (Kaya Memisoglu  or  Marc van Shaney).                       |
;| I am not responsible for any damage or loss caused by this program, so   |
;| if you success in erasing your harddisk with this code, then it is your  |
;| own fault and you should not claim me to be responsible...               |
;| I would be very pleased if you also sent me a postcard or even a letter  |
;| if you can use this code. My address:                                    |
;|                                                                          |
;|        Kaya Memisoglu                                                    |
;|        Reichenberger Ring 50                                             |
;|        63512 Hainburg                                                    |
;|        Germany                                                           |
;|                                                                          |
;| You can also leave a message for Marc van Shaney on the Nirvana BBS:     |
;|                                                                          |
;|              Nirvana BBS     ++49-(0)6245-3056      Sysop:Raytrayza      |
;|                                                                          |
;|                                                                          |
;[]------------------------------------------------------------------------[]

P386
LOCALS
JUMPS
DOSSEG
.MODEL USE16 LARGE

CDMI_SYSTEM_FILE	equ	1
;SHAREWARE		equ	1

include ext386.inc
include cdmi.inc
include devices.inc




.Data
PUBLIC C CDMI_Pattern_No
PUBLIC C CDMI_Beat_No
PUBLIC C CDMI_Entry_No
PUBLIC C CDMI_DMA_Address
PUBLIC C CDMI_DMA_Size
PUBLIC C CDMI_Flags
PUBLIC C CDMI_Channel_Flags
PUBLIC C CDMI_Volume
PUBLIC C CDMI_Channels
PUBLIC C CDMI_Tick
PUBLIC C CDMI_Speed
PUBLIC C CDMI_Tempo
PUBLIC C CDMI_Song
PUBLIC C CDMI_Tick_Speed
PUBLIC C CDMI_Version
PUBLIC C CDMI_Sample_Rate
PUBLIC C CDMI_Sample_Volume
PUBLIC C CDMI_Poll_Counter
PUBLIC C CDMI_Reverb


CDMI_Version		dw 200h+80

CDMI_Pattern_No		DW ?			;Current Pattern-no (read only)
CDMI_Beat_No		DW ?			;Row-position (read only)
CDMI_Entry_No		DW ?			;Sequency-Position (read only)
CDMI_Flags		DD ?			;Active flags (read only)

CDMI_DMA_Address	DD 0			;Current DMA-Address (read only)
CDMI_DMA_Size		DW 0			;Current DMA-Block size (read only)
CDMI_Volume		DW 0 			;Current volume (read only)
CDMI_Sample_Rate	DW ?
CDMI_Sample_Volume	DW ?

CDMI_Channel_Flags	DD 0ffffffffh		;Bits for (de)activating the
CDMI_Channels		DW ?			;      Channels (read/write)
CDMI_Tick		DW ?			;Tick-counter
CDMI_Speed		DW ?
CDMI_Tempo		DW ?
CDMI_Tick_Speed		DW ?
CDMI_Poll_Counter	DW ?			;How many polls left to do ?

CDMI_Song		DD 0			;Points to the song-header
CDMI_Reverb		REVERB_INFO <>


.Code
Copyright		db "CyberDyne Music Interface (c) 1994,1995 Marc van Shaney  aka  K.M.",0

Reverb_Ptr		DD 0		;LPTR to buffers for reverb-engine
Boost_Table		DD 0		;LPTR to boost-table
Volume_Table		DD 0		;LPTR to volume table
Buffer_One		DD 0		;MUST BE ZERO !!!
Buffer_Two		DD 0		; --""--
Buffer_Ticks		DW ?
Buffer_Tick_No		DW ?
Sample_Freq		DW 0           	;The frequency of the original samples

Ticks_Left		DW 0    	;Ticks
BPM_Divider		DW 125
BPM_Count		DW ?
DMA_Left		DW 0
DMA_Increment		DW ?		;Size of DMA buffer in bytes

Current_Pattern		DD ?		;Pattern-Address
Current_Len		DW ?		;How many beats are in this pattern ?
Current_Channel		DW ?
Empty_pattern		DD 0		;This pattern is really empty

Channel_Info    	DB MAX_CHANNELS*CI_ENTRY_SIZE DUP (?)
Period_Factor		DD ?		;Factor for calculating the resampling
Volume_Factor		DW ?		;Factor for the volume
Reverb_Count		DW ?		;Buffer-counter for reverb-engine

Sound_Start		dd ?		;FAR-Ptr to PLAY_VOICE of DRV
Sound_End		dd ?		;FAR-Ptr to STOP_VOICE of DRV
Sound_Continue		dd ?		;FAR-Ptr to SET_NEXT_BLOCK of DRV
Sound_Interrupt 	dd ?		;FAR-Ptr to SET_INTERRUPT of DRV
Sound_Flags		dd ?

Wave_Init		dd ?
Wave_Play_Sample	dd ?
Wave_Load_Sample	dd ?
Wave_Stop_Sample	dd ?
Wave_Set_Volume		dd ?
Wave_Stop_All		dd ?
Wave_Interrupt		dd ?

Old_Timer		dd ?		;FAR-Ptr to old timer interrupt
Timer_Inc		dw ?
Timer_Pos		dw ?

Postprocessing		dw ?		;NEAR-Pointer to postprocessing routines
Mixing			dw ?		;NEAR-Pointer to mixing-routines
Filters			dw ?		;NEAR-Pointer to filter-routines

Busy			db ?		;Set to 1 in interrupt and cleared before iret

LOOP_Pattern_No		dw ?		;These variables are for a pattern-loop
LOOP_Entry_No		dw ?
LOOP_Beat_No		dw ?
LOOP_Pattern		dd ?
LOOP_Len		dw ?
LOOP_Count		dw 0

COMMAND_Flags		dw 0		;Flags for commands
;[]-------------------------------------------------------------------------[]
;|									     |
;|  Setup_Pattern                                                            |
;|  This Macro is used for setting up various values with the beginning of   |
;|  each new pattern (Number of channels, pattern-len etc)                   |
;|  DS must contain zero for linear addressing mode			     |
;|                                                                           |
;[]-------------------------------------------------------------------------[]

SETUP_CHANNELS MACRO
	LOCAL L1
	push es
	push di
	mov cx,MAX_CHANNELS*CI_ENTRY_SIZE/4
	mov di,OFFSET Channel_Info	;ES:DI points to Channel_Info
	mov ax,cs
	mov es,ax
	xor eax,eax			;Zero means "NO NOTE"
	mov bx,ds:[esi+SH_SAMPLE_FREQ]
	rep stosd
	mov di,OFFSET Channel_Info	;ES:DI points to Channel_Info
	mov cx,MAX_CHANNELS
 L1:	mov cs:[di+CI_RESAMPLE],bx
	add di,CI_ENTRY_SIZE
	dec cx
	jnz short L1
	pop di
	pop es
	ENDM

SETUP_PATTERN MACRO
	LOCAL J1
	mov esi,gs:[CDMI_Song]
	movzx ebx,gs:[CDMI_Entry_No]
	movzx bx,ds:[ebx+SH_ORDER_LIST+esi]	;Pattern-Nummer einladen
	mov gs:[CDMI_Pattern_No],bx		; ...und sichern
	movzx ax,ds:[ebx+SH_PATTERN_LEN+esi]
	mov cs:[Current_Len],ax
	shl ebx,2
	mov eax,ds:[esi+SH_PATTERN_PTR+ebx]
	test eax,eax
	jnz short J1
	mov eax,cs:[Empty_Pattern]
J1:	mov cs:[Current_Pattern],eax
	ENDM

START_PATTERN MACRO
	mov gs:[CDMI_Beat_No],0
	ENDM

SETUP_BALANCE MACRO
	LOCAL L1,L2,L3,E1
	push si
	mov si,OFFSET Channel_Info
	mov cx,gs:[CDMI_Channels]
	testflag gs:[CDMI_Flags],CDMI_USE_FAST_PANNING
	jnz short L2
	xor ax,ax
	mov dx,1
	div cx
	mov bx,ax
	shr bx,1
   L1:	mov cs:[si+CI_PANNING],bh
	add bx,ax
	add si,CI_ENTRY_SIZE
	dec cx
	jnz short L1
	jmp short E1

   L2:	mov ax,00ffh
   L3:	mov cs:[si+CI_PANNING],al
	xchg al,ah
	add si,CI_ENTRY_SIZE
	dec cx
	jnz short L3

   E1:	pop si
	ENDM

SETUP_VOLUME_TABLE MACRO
	LOCAL L1,L2,L3,A1,A2
	push esi
	push edi
	push es

	mov ax,4*256
	testflag gs:[CDMI_Flags],CDMI_USE_STEREO
	jz short A1
	mov ax,6*256
 A1:    testflag gs:[CDMI_Flags],CDMI_USE_REVERB
	jz short A2
	fastimul dx,ax,3
	mov ax,dx
	shr ax,2
 A2:	mov dx,64
;	sub dx,gs:[CDMI_Sample_Volume]
	mul dx
	shrd ax,dx,6
	shr dx,6
	div gs:[CDMI_Channels]
	mov cs:[Volume_Factor],ax

	;
	;Now lets setup the normal volume table
	;
	xor ax,ax
	mov es,ax
	mov edi,cs:[Volume_Table]

	xor bx,bx
L1:     mov ax,bx
	mul cs:[Volume_Factor]
	mov si,ax
	xor cx,cx			;DH=Current sample-value
L2:     movsx ax,cl
	imul si
	shrd ax,dx,8
	stos word ptr es:[edi]
	inc cl
	jnz short L2

	inc bx
	cmp bx,64
	jbe short L1

	;
	;Now lets setup the volume table for the F/X channel
	;
	mov ax,256*4*63             	;Fudge*256/MaxVol
	mul gs:[CDMI_Sample_Volume]
	shrd ax,dx,6
	shr dx,6
	div gs:[CDMI_Channels]
	mov dl,ah

	xor dh,dh			;DH=Current sample-value
L3:     mov al,dh
	imul dl
	stos word ptr es:[edi]
	add dh,1
	jnc short L3

	pop es
	pop edi
	pop esi
	ENDM

SETUP_BOOST_TABLE MACRO
	LOCAL Loop1,End1,End2,Over,Loop2
	testflag gs:[CDMI_Flags],CDMI_USE_16BIT
	jnz End2
	push bp
	push esi
	push edi
	push ds
	xor ax,ax
	mov ds,ax
	mov esi,cs:[Boost_Table]
	mov edi,esi
	add edi,3ffh
	mov bx,gs:[CDMI_Volume]
	mov cx,1ffh
	mov ax,8080h
	xor dx,dx
Loop1:	add dl,bl
	adc al,bh
	jc short Over
	add dh,bl
	sbb ah,bh
	mov ds:[esi],al
	mov ds:[edi],ah
	inc esi
	dec edi
	dec cx
	jnz short Loop1
	jmp short End1

Over:   mov ax,0ffh
Loop2:  mov ds:[esi],al
	mov ds:[edi],ah
	inc esi
	dec edi
	dec cx
	jnz short Loop2

End1:
	pop ds
	pop edi
	pop esi
	pop bp
End2:
	ENDM

GET_BUFFER_SIZE MACRO
	LOCAL A1
	movzx ecx,cs:[DMA_Increment]
	testflag gs:[CDMI_Flags],CDMI_USE_16_BIT
	jnz short A1
	shl ecx,1				;16 bit values
A1:
	ENDM






;[]-------------------------------------------------------------------------[]
;|									     |
;| Filter-Routines:                                                          |
;|    Apply_Filters                                                          |
;|    gs:[CDMI_DMA_Address] must point to samples to be filtered             |
;|    gs:[CDMI_Flags] contains the sampole flags 		             |
;|    The following flags are defined:                                       |
;|	    CDMI_LOW_PASS				     		     |
;|          CDMI_MID_PASS                                                    |
;|          CDMI_HIGH_PASS                                                   |
;|                                                                           |
;|                                                                           |
;[]-------------------------------------------------------------------------[]
;|
LastSample LABEL WORD
LastSample_R dw ?
LastSample_L dw ?
Apply_Filters_Mono PROC NEAR
	ifndef SHAREWARE
	testflag gs:[CDMI_Flags],CDMI_HIGH_PASS
	jz short No_High_Pass
	mov cx,gs:[CDMI_DMA_Size]
	mov edi,gs:[CDMI_DMA_Address]
	mov bx,cs:[LastSample]
    Highpass_Loop:
		mov ax,es:[edi]
		sub bx,ax
		xchg bx,ax
		stos word ptr es:[edi]
    dec cx
    jnz short Highpass_Loop
	mov cs:[LastSample],bx


    No_High_Pass:
	testflag gs:[CDMI_Flags],CDMI_MID_PASS
	jz short No_Mid_Pass
	mov cx,gs:[CDMI_DMA_Size]
	mov edi,gs:[CDMI_DMA_Address]
	mov bx,cs:[LastSample]
	MidPass_Loop:
		mov ax,word ptr es:[edi]
		sar ax,1
		add bx,ax
		xchg ax,bx
		stos word ptr es:[edi]
	dec cx
	jnz short Midpass_Loop
	mov cs:[LastSample],bx


    No_Mid_Pass:
	testflag gs:[CDMI_Flags],CDMI_LOW_PASS
	jz short No_Low_Pass
	mov cx,gs:[CDMI_DMA_Size]
	sub cx,2
	mov edi,gs:[CDMI_DMA_Address]
	mov bx,cs:[LastSample]
    Lowpass_Loop:
		mov ax,word ptr es:[edi]
		sar ax,2
		add bx,ax
		mov dx,word ptr es:[edi+2]
		sar dx,2
		add bx,dx
		mov dx,word ptr es:[edi+4]
		sar dx,2
		add bx,dx
		xchg ax,bx
		stos word ptr es:[edi]
    dec cx
    jnz short Lowpass_Loop
    mov cs:[LastSample],bx


    No_Low_Pass:
	endif
	retn
Apply_Filters_Mono ENDP





Apply_Filters_Stereo PROC NEAR
	ifndef SHAREWARE
	testflag gs:[CDMI_Flags],CDMI_HIGH_PASS
	jz short @@1
	mov cx,gs:[CDMI_DMA_Size]
	mov edi,gs:[CDMI_DMA_Address]
	mov bx,cs:[LastSample_L]
	mov dx,cs:[LastSample_R]
    @@L1:
		mov ax,es:[edi]
		sub bx,ax
		xchg bx,ax
		stos word ptr es:[edi]
		mov ax,es:[edi]
		sub dx,ax
		xchg dx,ax
		stos word ptr es:[edi]
    dec cx
    jnz short @@L1
	mov cs:[LastSample_L],bx
	mov cs:[LastSample_R],dx


    @@1:
	testflag gs:[CDMI_Flags],CDMI_MID_PASS
	jz short @@2
	mov cx,gs:[CDMI_DMA_Size]
	mov edi,gs:[CDMI_DMA_Address]
	mov bx,cs:[LastSample_L]
	mov dx,cs:[LastSample_R]
    @@L2:
		mov ax,es:[edi]
		sar ax,1
		add bx,ax
		xchg ax,bx
		stos word ptr es:[edi]
		mov ax,es:[edi]
		sar ax,1
		add dx,ax
		xchg ax,dx
		stos word ptr es:[edi]
    dec cx
    jnz short @@L2
	mov cs:[LastSample_L],bx
	mov cs:[LastSample_R],dx


    @@2:
	testflag gs:[CDMI_Flags],CDMI_LOW_PASS
	jz short @@3
	mov cx,gs:[CDMI_DMA_Size]
	sub cx,2
	mov edi,gs:[CDMI_DMA_Address]
	mov bx,cs:[LastSample_L]
	mov dx,cs:[LastSample_R]
    @@L3:
		mov ax,es:[edi]
		sar ax,2
		add bx,ax
		mov si,es:[edi+4]
		sar si,2
		add bx,si
		mov si,es:[edi+8]
		sar si,2
		add bx,si
		xchg ax,bx
		stos word ptr es:[edi]
		mov ax,es:[edi]
		sar ax,2
		add dx,ax
		mov si,es:[edi+4]
		sar si,2
		add bx,si
		add si,es:[edi+8]
		sar si,2
		add dx,si
		xchg ax,dx
		stos word ptr es:[edi]
    dec cx
    jnz short @@L3
	mov cs:[LastSample_L],bx
	mov cs:[LastSample_R],dx


    @@3:
	endif
	retn
Apply_Filters_Stereo ENDP






Apply_No_Filters PROC NEAR
	retn
Apply_No_Filters ENDP





;[]------------------------------------------------------------------------[]
;|
;| These are the postprocessing routines that convert the 16bit data to
;| 8 bit and that apply the boost-factors to the raw sample-data
;|

Postprocess_10Bit PROC NEAR
	mov cx,gs:[CDMI_DMA_Size]
	testflag gs:[CDMI_Flags],CDMI_USE_STEREO
	jz short @@1
	shl cx,1
@@1:	xor eax,eax
	xor ebx,ebx
	mov edi,gs:[CDMI_DMA_Address]
	mov esi,cs:[Boost_Table]
    @@RLoop:
		mov ax,ds:[edi+2*ebx]
		shr ax,6		;Only 10 bits precision
		mov al,ds:[esi+eax]	;Get new byte
		mov ds:[edi+ebx],al	;Save byte to ES:DI
		inc bx
    dec cx
    jnz short @@RLoop
	retn
Postprocess_10bit ENDP




Postprocess_8Bit PROC NEAR
	mov cx,gs:[CDMI_DMA_Size]
	testflag gs:[CDMI_Flags],CDMI_USE_STEREO
	jz short @@1
	shl cx,1
@@1:	xor eax,eax
	xor ebx,ebx
	mov edi,gs:[CDMI_DMA_Address]
    @@RLoop:
		mov ax,ds:[edi+2*ebx]
		xor ah,80h
		mov ds:[edi+ebx],ah	;Save byte to DS:DI
		inc bx
    dec cx
    jnz short @@RLoop
	retn
Postprocess_8bit ENDP




Postprocess_16bit PROC NEAR
	movzx ecx,gs:[CDMI_DMA_Size]
	testflag gs:[CDMI_Flags],CDMI_USE_STEREO
	jz short @@3
	shl cx,1
@@3:	xor eax,eax
	movzx ebx,gs:[CDMI_Volume]
	mov edi,gs:[CDMI_DMA_Address]
    @@RLoop:
		movsx eax,word ptr ds:[edi+2*ecx]
		imul ebx
		sar eax,6		;Unfudge
		cmp eax,-7ffeh		;And now: CLIP !
		jg short @@1
		mov eax,-7fffh
		jmp short @@2
     @@1:	cmp eax,7ffeh
		jl short @@2
		mov eax,7ffeh
     @@2:	mov ds:[edi+2*ecx],ax	;Save byte to ES:DI
    dec cx
    jnz short @@RLoop
	retn
Postprocess_16bit ENDP




Postprocess_Nothing PROC NEAR		;HEY,this is used for the GUS!
	retn
Postprocess_Nothing ENDP




;[]------------------------------------------------------------------------[]
;|
;| This macro calculates the volume by processing the fade-out and the volume
;| envelope
;|
Process_Volume MACRO
	LOCAL J1,J2,E1
	movzx eax,byte ptr cs:[si+CI_REAL_VOLUME]
	testflag dword ptr cs:[si+CI_FLAGS],IF_VOLUME_ENVELOPE
	jz short E1
	;
	;First lets process the volume fade out if appropriate
	;
	cmp word ptr cs:[si+CI_FADE_POS],0
	je short J1
	mov bx,cs:[si+CI_FADE_POS]
	mul bx
	mov ax,dx
	sub bx,cs:[si+CI_FADE_OUT]
	jnc short J2
	xor bx,bx
	mov cs:[si+CI_REAL_VOLUME],bl
J2:	mov cs:[si+CI_FADE_POS],bx

	;
	;Now lets process the volume envelope
	;
J1:	mul byte ptr cs:[si+CI_ENVELOPE_VOLUME]
	shr ax,6
E1:
	ENDM


Process_Panning MACRO
	LOCAL J1,E1
	mov cl,byte ptr cs:[si+CI_BALANCE]
	testflag dword ptr cs:[si+CI_FLAGS],IF_PANNING_ENVELOPE
	jz short E1
	push ax
	mov ch,cs:[si+CI_ENVELOPE_PANNING]
	sub ch,32		;E_Pan-32
	movzx ax,cl		;AX=Pan
	sub ax,128		;Pan-128
	cwd
	xor ax,dx
	sub ax,dx		;Abs (AX)
	sub ax,128
	neg ax			;128-abs(pan-128))
	mul ch			;(EPan-32)*(128-abs(pan-128))
	shr ax,5		;.../32
	add cl,al		;CL=EndVolume
	pop ax
E1:
	ENDM

;[]------------------------------------------------------------------------[]
;|
;| This is the actual mixing routine:
;|   It adds a sample described in the channel-info to the output DMA-
;|   Buffer. The pitch is simulated by resampling the sample to a new
;|   frequency. There is no interpolation or soemthing like that done.
;|   The formula for resampling would be:
;|
;|   sample_increment=old_period/new_period
;|
;|   This increment is implemented as a fixed point variable using two
;|   word registers: One for the integer part and the other for the
;|   fractional part. The integer part is always added to the current
;|   sample pointer and there is a second variable holding the current
;|   fractional part of the pointer. When this second variable overflows,
;|   then the integerpart will be incremented.
;|   The  mixing itself is done using a word-size buffer for better
;|   when mixing multiple channels accuracy. These words are reduced later
;|   back to bytes using a simple but fast algorithm:
;|   ES:DI points to destination byte size buffer
;|   DS:SI points to source word size buffer
;|         The word have Intel-order (low-byte first)
;|   First we increment SI, so it will point to the first high-byte
;|   Then we'll use a loop:
;|   	   lodsw - AL will contain the hih-byte and AH the low byte of
;|                 the next sample
;|         stosb - store only the high-byte
;|   This is a very easy and efficient method. But one could do it even
;|   faster using the 386 SIB-byte (Scalar Index Byte):
;|         EBX contains the number of samples to be converted
;|         ES:EDI points to destination
;|         DS:ESI points to source
;|   @@1:  mov al,ds:[ESI+2*EBX+1]
;|         mov es:[EDI+EBX],al
;|         dec BX
;|	   jnz short @@1
;|   BTW using a DEC CX and JNZ @@1 is faster than a loop-command on
;|   a 386+ (Isn't this paradox ?!?). I still had to modify this code
;|   because the source and destination buffer are the same and I had to
;|   prevent overwriting data which has not been processed as would happen
;|   in this example.
;|
;|   But there are still some problems I want to comment:
;|   First there is the problem that the source-pointer must always be
;|   inside the sample - in other words we must check, if SI is still
;|   in range, or if we have to stop this sample.
;|   One could do so by checking SI versus another register inside the
;|   resampling loop:
;|          cmp si,MAX_SI
;|          jae short Stop_Sample
;|   But having these instructions INSIDE a loop is not very efficient.
;|   So I have choosen another method:
;|   First I calculate how often the sample can be read before SI gets
;|   out of range. This is simply done by dividing the size by the
;|   Increment - remember to shift the size by the fixed-point value,
;|   e.g. 16 bits:
;|          xor edx,edx
;|          mov eax,SampleSize
;|          shld edx,eax,16
;|          shl eax,16
;|          div dword Increment
;|   Now EAX contains the number of possible increments (=MAX_CX).
;|   This calculus is done far below when a new note is parsed or when
;|   the effect changes the pitch.
;|   Then it is easy to predict when the loop will get outise the sample.
;|   This is prevented simply by moving the remaining icrements to CX,
;|   when MAX_CX < DMA_Size.
;|
;|   Another thing are the loops:
;|   I simmply check for a loop when I get outside the sample as described
;|   above. When the instrument has a loop, then I will recalculate some
;|   constants (MAX_CX , etc) and continue the resampling at the LOOP_START
;|   position. But see below !
;|
;|   The last thing is magic SELF-MODIFYING CODE !!!
;|   Well, an Intel CPU has not many registersl, so I use a technique
;|   called self-modifing code. Here we substitute a constant value while
;|   running the programm. Example:
;|         add ax,1234h		;Now a 1234h will be added
;|    @@1: mul bx
;|         (...)
;|         mov cs:[OFFSET @@1-2],9999	;Now the immediate is substituted !!!
;|   This technique is especially fast when you add a constant to a register
;|   in a loop and this constant does not change within the loop. Here you
;|   may save a valuable register by using this trick. I used this trick
;|   inside the resampling loop, because I did not have enough registers.
;|   (See below; One could also substite ADD BP,DX with a immediate, but
;|   I do not need a further register. )
;|
;| Needed parameters for this routine:
;|   In CS:SI must be Channel-Info-structure
;|   gs:[CDMI_DMA_Address] must be destination buffer
;|   gs:[CDMI_DMA_Size] must be buffer-size in samples(e.g. 16bit stereo has
;|                  4 bytes per sample)
;|   DS must be set to zero for linear addressing
;|
STEREO		equ	1
MONO		equ	2
FAST_STEREO	equ	3
WAVE		equ	4



Normal_Mixing_Chunk1 MACRO a
	push si				;Save channel-info pointer

	cmp dword ptr cs:[si+CI_REST],0	;Is this a valid period ???
	je @@End
	cmp dword ptr cs:[si+CI_MAX_CX],0
	je @@End


	mov edi,gs:[CDMI_DMA_Address]
	if a eq STEREO
		Process_Volume
		test al,al
		jz @@End
		Process_Panning
		mov ebx,eax
		mul cl
		sub bl,ah
		and eax,0ff00h
		shl eax,1
		shl ebx,9
		add eax,cs:[Volume_Table]	;EAX points to volume table
		mov dword ptr cs:[OFFSET @@V1+4],eax
		add ebx,cs:[Volume_Table]	;EBX points to volume table
		mov dword ptr cs:[OFFSET @@V2+4],ebx
	endif
	if a eq MONO
		Process_Volume
		test al,al
		jz @@End			;Is volume Zero ???
		shl eax,9			;256 entries * 2 bytes per entry
		add eax,cs:[Volume_Table]	;EAX points to volume table
		mov dword ptr cs:[OFFSET @@V1+4],eax
	endif
	if a eq FAST_STEREO
		Process_Volume
		test al,al
		jz @@End			;Is volume Zero ???
		shl eax,9			;256 entries * 2 bytes per entry
		add eax,cs:[Volume_Table]	;EAX points to volume table
		mov dword ptr cs:[OFFSET @@V1+4],eax
		Process_Panning
		cmp cl,80h
		jb short @@3
		add edi,2
	    @@3:
	endif
	if a eq WAVE
		test al,al			;EAX still contains volume
		jz @@End			;Is volume Zero ???
		shl eax,9			;256 entries * 2 bytes per entry
		add eax,cs:[Volume_Table]	;EAX points to volume table
		mov dword ptr cs:[OFFSET @@V1+4],eax
	endif

	mov bp,cs:[si+CI_OVERFLOW]	;BP = Overflow
	mov ax,cs:[si+CI_INCREMENT]	;AX = Increment
	mov word ptr cs:[OFFSET @@C1+3],ax
	mov dx,cs:[si+CI_REST]		;DX = Rest
	movzx ecx,gs:[CDMI_DMA_Size]	;ECX = DMA_Buffersize
	cmp ecx,cs:[si+CI_MAX_CX]	;Does the instrument fit completely
	jb short @@1     		;JB: yes
	sub ecx,cs:[si+CI_MAX_CX]	;No: Sub MAX_CX from DMA_Size
	mov cs:[DMA_Left],cx		;Save remaining part for later (loops)
	mov ecx,cs:[si+CI_MAX_CX]	;Move MAX_CX to counter as new DMA_Size
  @@1: 	sub cs:[si+CI_MAX_CX],ecx	;Sub current counter from MAX_CX

	mov eax,cs:[si+CI_ADDRESS]
	mov esi,cs:[si+CI_POSITION]	;ESI = linear address
	add esi,eax
  @@Instrument_Loop_Entry_Point:
	ENDM




Normal_Mixing_Chunk2 MACRO
	mov ebx,esi			;save Address in EBX
	pop si				;CS:SI points to Channel_Info
	mov cs:[si+CI_OVERFLOW],bp	;Save fraction for re-use
	cmp dword ptr cs:[si+CI_MAX_CX],0
	je short @@Check_For_Loop
	sub ebx,cs:[si+CI_ADDRESS]	;Subtract start address
	mov cs:[si+CI_POSITION],ebx	;Save position
	retn

;Here we have to check whether the instrument had a loop or not.
;If it had a loop , we have to continue playing it from the loop-start
;position.
;ES:DI points to the current position in the DMA-Buffer
;After this routine DS:ESI points to the source-sample
;		    BP has overflow register
;		    DX has frictional increment
@@Check_For_Loop:
	push si				;Save again

	cmp dword ptr cs:[si+CI_LOOP_START],0fffffffh
	jae short @@End			;JAE: Nein,keine Schleife vorhanden
	mov ebx,cs:[si+CI_LOOP_START]	;Schleifenbeginn
	mov cs:[si+CI_POSITION],ebx	;Position=Schleifenbeginn
	mov eax,cs:[si+CI_SIZE]         ;EAX holds SampleEND
	sub eax,ebx                  	;sub Loop_Start_Position
	xor edx,edx			;EDX:EAX holds CDMI_Sample_Size
	shld edx,eax,16
	shl eax,16			;Fudge for division
	div dword ptr cs:[si+CI_REST]	;Divide by Increment
	mov cs:[si+CI_MAX_CX],eax	;Save for later

	cmp cs:[DMA_Left],0		;Have we got to do something ???
	je short @@End			;JE : Nope , bail out

	mov dx,cs:[si+CI_REST]		;DX = Rest
	movzx ecx,cs:[DMA_Left]		;ECX hat Puffergre
	cmp ecx,cs:[si+CI_MAX_CX]	;Does the instrument fit completely
	jb short @@2			;JB: yes
	sub ecx,cs:[si+CI_MAX_CX]	;Sub MAX_CX
	mov cs:[DMA_Left],cx		;Save for later (loops)
	mov ecx,cs:[si+CI_MAX_CX]	;Move Max_CX to counter
  @@2:	sub cs:[si+CI_MAX_CX],ecx	;Sub current counter
	add ebx,cs:[si+CI_ADDRESS]	;EBX still holds Loop_Begin
	mov esi,ebx			;Save for later in EAX

	xor bp,bp
	jmp @@Instrument_Loop_Entry_Point

@@End: 	pop si
	retn
	ENDM




Add_Voice_Mono PROC NEAR
	Normal_Mixing_Chunk1 MONO
	xor ebx,ebx
	add edi,ecx
	add edi,ecx
	neg ecx
@@loop1:
		mov bl,ds:[esi]		;Load sample value
	   @@V1:mov ax,ds:[2*ebx+12345678h]
		add ds:[edi+2*ecx],ax  	;Add to DMA-Buffer
		add bp,dx		;Add fractional part
	   @@C1:adc esi,1234h        	;Add integer part
		inc ecx			;Decrease buffer-counter...
jnz short @@loop1			; ...and to the next sample
	Normal_Mixing_Chunk2
Add_Voice_Mono ENDP





Add_Voice_Stereo PROC NEAR
	Normal_Mixing_Chunk1 STEREO
	xor ebx,ebx
	shl ecx,2
	add edi,ecx
	shr ecx,2
	neg ecx
@@loop1:
		mov bl,ds:[esi]		;Load sample value
	   @@V1:mov ax,ds:[2*ebx+12345678h]
		shl eax,16
	   @@V2:mov ax,ds:[2*ebx+12345678h]
		add ds:[edi+4*ecx],eax  ;Add to DMA-Buffer
		add bp,dx		;Add fractional part
	   @@C1:adc esi,1234h        	;Add integer part
		inc ecx			;Decrease buffer-counter...
jnz short @@loop1			; ...and to the next sample
	Normal_Mixing_Chunk2
Add_Voice_Stereo ENDP





Add_Voice_FastStereo PROC NEAR
	Normal_Mixing_Chunk1 FAST_STEREO
	xor ebx,ebx
	shl ecx,2
	add edi,ecx
	shr ecx,2
	neg ecx
@@loop1:
		mov bl,ds:[esi]		;Load sample value
	   @@V1:mov ax,ds:[2*ebx+12345678h]
		add ds:[edi+4*ecx],ax  	;Add to DMA-Buffer
		add bp,dx		;Add fractional part
	   @@C1:adc esi,1234h        	;Add integer part
		inc ecx			;Decrease buffer-counter...
jnz short @@loop1			; ...and to the next sample
	Normal_Mixing_Chunk2
Add_Voice_FastStereo ENDP




;[]------------------------------------------------------------------------[]
;|
;| These mixing-routines are for interpolated mixing. This means when a
;| sample is resamples so slow, that there are repitions of amplitudes, then
;| these repetitions will be interpolated. The disadvantage is that this
;| works only with high sample-rates (because only there can be interpolated)
;| and it is very time-consumpting. I guess it takes more than twice of
;| our computer power than normal mixing !!!
;|

Interpolated_Mixing_Chunk1 MACRO a
	push si				;Save channel-info pointer

	cmp dword ptr cs:[si+CI_REST],0	;Is this a valid period ???
	je @@End
	cmp dword ptr cs:[si+CI_MAX_CX],0	;Is the size equal to 0 ?
	je @@End

	mov edi,gs:[CDMI_DMA_Address]
	if a eq STEREO
		Process_Volume
		Process_Panning
	endif
	if a eq FAST_STEREO
		Process_Volume
		test al,al
		jz @@End			;Is volume Zero ???
		shl eax,9			;256 entries * 2 bytes per entry
		add eax,cs:[Volume_Table]	;EAX points to volume table
		mov dword ptr cs:[OFFSET @@V1+4],eax
		mov dword ptr cs:[OFFSET @@V2+4],eax
		Process_Panning
		cmp cl,80h
		jb short @@3
		add edi,2
	    @@3:
	endif
	if a eq MONO
		Process_Volume
		test al,al
		jz @@End
		shl eax,9			;256 entries * 2 bytes per entry
		add eax,cs:[Volume_Table]	;EAX points to volume table
		mov dword ptr cs:[OFFSET @@V1+4],eax
		mov dword ptr cs:[OFFSET @@V2+4],eax
	endif

	mov bp,cs:[si+CI_OVERFLOW]	;BP = Overflow
	mov dx,cs:[si+CI_INCREMENT]	;DX = Increment (will be saved directly
	mov ax,cs:[si+CI_REST]		;AX = Rest
	mov word ptr cs:[@@C1+2],ax
	mov word ptr cs:[@@C3+3],ax
	mov word ptr cs:[@@C5+3],ax
	mov word ptr cs:[@@C6+2],ax
	movzx ecx,gs:[CDMI_DMA_Size]	;ECX = DMA_Buffersize
	cmp ecx,cs:[si+CI_MAX_CX]	;Does the instrument fit completely
	jb short @@1     		;JB: yes
	sub ecx,cs:[si+CI_MAX_CX]	;No: Sub MAX_CX from DMA_Size
	mov cs:[DMA_Left],cx		;Save remaining part for later (loops)
	mov ecx,cs:[si+CI_MAX_CX]	;Move MAX_CX to counter as new DMA_Size
  @@1: 	sub cs:[si+CI_MAX_CX],ecx	;Sub current counter from MAX_CX

	mov eax,cs:[si+CI_ADDRESS]
	mov esi,cs:[si+CI_POSITION]	;ESI = linear address
	add esi,eax
  @@Instrument_Loop_Entry_Point:
	ENDM




Interpolated_Mixing_Chunk2 MACRO
	mov ebx,esi			;save Address in EBX
	pop si				;CS:SI points to Channel_Info
	mov cs:[si+CI_OVERFLOW],bp	;Save fraction for re-use
	cmp dword ptr cs:[si+CI_MAX_CX],0
	je short @@Check_For_Loop
	sub ebx,cs:[si+CI_ADDRESS]	;Subtract start address
	mov cs:[si+CI_POSITION],ebx	;Save position
	retn

;Here we have to check whether the instrument had a loop or not.
;If it had a loop , we have to continue playing it from the loop-start
;position.
;ES:DI points to the current position in the DMA-Buffer
;After this routine DS:ESI points to the source-sample
;		    BP has overflow register
;		    DX has frictional increment
@@Check_For_Loop:
	push si				;Save again

	cmp dword ptr cs:[si+CI_LOOP_START],0fffffffh
	jae short @@End			;JAE: Nein,keine Schleife vorhanden
	mov ebx,cs:[si+CI_LOOP_START]	;Schleifenbeginn
	mov cs:[si+CI_POSITION],ebx	;Position=Schleifenbeginn
	mov eax,cs:[si+CI_SIZE]         ;EAX holds SampleEND
	sub eax,ebx                  	;sub Loop_Start_Position
	xor edx,edx			;EDX:EAX holds CDMI_Sample_Size
	shld edx,eax,16
	shl eax,16			;Fudge for division
	div dword ptr cs:[si+CI_REST]	;Divide by Increment
	mov cs:[si+CI_MAX_CX],eax	;Save for later

	cmp cs:[DMA_Left],0		;Have we got to do something ???
	je short @@End			;JE : Nope , bail out
	add ebx,cs:[si+CI_ADDRESS]	;EBX still holds Loop_Begin
	mov eax,ebx			;Save for later in EAX
	mov dx,cs:[si+CI_REST+2]	;DX = Increment
	movzx ecx,cs:[DMA_Left]		;ECX hat Puffergre
	cmp ecx,cs:[si+CI_MAX_CX]	;Does the instrument fit completely
	jb short @@2			;JB: yes
	sub ecx,cs:[si+CI_MAX_CX]	;Sub MAX_CX
	mov cs:[DMA_Left],cx		;Save for later (loops)
	mov ecx,cs:[si+CI_MAX_CX]	;Move Max_CX to counter
  @@2:	sub cs:[si+CI_MAX_CX],ecx	;Sub current counter

	xor bp,bp
	mov esi,eax
	jmp @@Instrument_Loop_Entry_Point

@@End: 	pop si
	retn
	ENDM




Add_Voice_Mono_Interpolated PROC NEAR
	Interpolated_Mixing_Chunk1 MONO
	add edi,ecx
	add edi,ecx
	neg ecx
	test dx,dx
	jnz short @@NoInterpolation

	mov ebx,dword ptr cs:[@@V1+4]
	movzx eax,byte ptr ds:[esi]
	mov dx,ds:[ebx+2*eax]
	mov al,ds:[esi+1]
	mov ax,ds:[ebx+2*eax]
	sub ax,dx
	cwde
   @@C5:imul eax,1234h		;Fractional increment
	sar eax,16
@@loop1:
		add ds:[edi+2*ecx],dx
		add dx,ax   		;Add delta-increment
	   @@C1:add bp,1234h		;Add fractional part
		jnc short @@6
		inc esi            	;Add integer part
		movzx eax,byte ptr ds:[esi]
	   @@V1:mov ax,ds:[2*eax+12345678h]
		sub ax,dx
		cwde
	   @@C3:imul eax,1234h
		sar eax,16
	   @@6:	inc ecx			;Decrease buffer-counter...
jnz short @@loop1			; ...and to the next sample
	jmp @@Finish



@@NoInterpolation:
	and edx,0ffffh
	xor ebx,ebx
@@loop2:
		mov bl,ds:[esi]	;Load sample value
	   @@V2:mov ax,ds:[2*ebx+12345678h]
		add ds:[edi+2*ecx],ax  	;Add to DMA-Buffer
	   @@C6:add bp,1234h		;Add fractional part
		adc esi,edx        	;Add integer part
		inc ecx			;Decrease buffer-counter...
jnz short @@loop2			; ...and to the next sample


@@Finish:
	Interpolated_Mixing_Chunk2
Add_Voice_Mono_Interpolated ENDP






Add_Voice_FastStereo_Interpolated PROC NEAR
	Interpolated_Mixing_Chunk1 FAST_STEREO
	shl ecx,2
	add edi,ecx
	shr ecx,2
	neg ecx
	test dx,dx
	jnz @@NoInterpolation

	mov ebx,dword ptr cs:[@@V1+4]
	movzx eax,byte ptr ds:[esi]
	mov dx,ds:[ebx+2*eax]
	mov al,ds:[esi+1]
	mov ax,ds:[ebx+2*eax]
	sub ax,dx
	cwde
   @@C5:imul eax,1234h		;Fractional increment
	sar eax,16
@@loop1:
		add ds:[edi+4*ecx],dx
		add dx,ax   		;Add delta-increment
	   @@C1:add bp,1234h		;Add fractional part
		jnc short @@6
		inc esi            	;Add integer part
		movzx eax,byte ptr ds:[esi]
	   @@V1:mov ax,ds:[2*eax+12345678h]
		sub ax,dx
		cwde
	   @@C3:imul eax,1234h
		sar eax,16
	   @@6:	inc ecx			;Decrease buffer-counter...
jnz short @@loop1			; ...and to the next sample
	jmp @@Finish



@@NoInterpolation:
	and edx,0ffffh
	xor ebx,ebx
@@loop2:
		mov bl,ds:[esi]		;Load sample value
	   @@V2:mov ax,ds:[2*ebx+12345678h]
		add ds:[edi+4*ecx],ax  	;Add to DMA-Buffer
	   @@C6:add bp,1234h		;Add fractional part
		adc esi,edx        	;Add integer part
		inc ecx			;Decrease buffer-counter...
jnz short @@loop2			; ...and to the next sample


@@Finish:
	Interpolated_Mixing_Chunk2
Add_Voice_FastStereo_Interpolated ENDP






Add_Voice_Stereo_Interpolated PROC NEAR
	Normal_Mixing_Chunk1 STEREO
	xor ebx,ebx
	shl ecx,2
	add edi,ecx
	shr ecx,2
	neg ecx
@@loop1:
		mov bl,ds:[esi]		;Load sample value
	   @@V1:mov ax,ds:[2*ebx+12345678h]
		shl eax,16
	   @@V2:mov ax,ds:[2*ebx+12345678h]
		add ds:[edi+4*ecx],eax  ;Add to DMA-Buffer
		add bp,dx		;Add fractional part
	   @@C1:adc esi,1234h        	;Add integer part
		inc ecx			;Decrease buffer-counter...
jnz short @@loop1			; ...and to the next sample
	Normal_Mixing_Chunk2
Add_Voice_Stereo_Interpolated ENDP






;[]------------------------------------------------------------------------[]
;|
;| These two routines are used for wavetable cards. They both call the
;| specific device routines and tell them the current channel-information.
;| The devices have to check for changes and then do them...
;| One routine also mixes using the old way for oscilloscopes etc...
;|
Add_Voice_Wave PROC NEAR
	Process_Volume
	push eax
	mov cs:[si+CI_GUS_VOLUME],al
	testflag dword ptr cs:[si+CI_FLAGS],CF_NEW_INSTRUMENT
	jz short @@E1
		mov eax,cs:[si+CI_REST]
		mov cs:[si+CI_OLD_REST],eax
		movzx ebx,gs:[CDMI_Sample_Rate]
		mul ebx
		shrd eax,edx,16
		mov cs:[si+CI_FREQ],eax

		mov eax,cs:[si+CI_SIZE]
		mov cs:[si+CI_OLD_SIZE],eax

		mov eax,cs:[si+CI_LOOP_START]
		mov cs:[si+CI_OLD_LOOP_START],eax

		Process_Panning
		mov cs:[si+CI_GUS_PANNING],cl
		jmp @@E5

@@E1:   Process_Panning
	cmp cl,cs:[si+CI_GUS_PANNING]
	je short @@E2
		mov cs:[si+CI_GUS_PANNING],cl
		or cs:[si+CI_FLAGS],CF_NEW_PANNING

@@E2:	mov eax,cs:[si+CI_REST]
	cmp eax,cs:[si+CI_OLD_REST]
	je short @@E3
		mov cs:[si+CI_OLD_REST],eax
		movzx ebx,gs:[CDMI_Sample_Rate]
		mul ebx
		shrd eax,edx,16
		mov cs:[si+CI_FREQ],eax
		or cs:[si+CI_FLAGS],CF_NEW_FREQ

@@E3:	mov eax,cs:[si+CI_SIZE]
	cmp eax,cs:[si+CI_OLD_SIZE]
	je short @@E4
		mov cs:[si+CI_OLD_SIZE],eax
		or cs:[si+CI_FLAGS],CF_NEW_SIZE

@@E4:	mov eax,cs:[si+CI_LOOP_START]
	cmp eax,cs:[si+CI_OLD_LOOP_START]
	je short @@E5
		mov cs:[si+CI_OLD_LOOP_START],eax
		or cs:[si+CI_FLAGS],CF_NEW_LOOP

@@E5:  	mov ax,si
	add ax,4
	call cs:[Wave_Play_Sample] C,cs:[Current_Channel],ax,cs
	and dword ptr cs:[si+CI_FLAGS],NOT (CF_NEW_INSTRUMENT or CF_NEW_START or CF_NEW_SIZE or CF_NEW_PANNING or CF_NEW_FREQ or CF_NEW_LOOP)
	mov bx,SEG CDMI_Pattern_No
	mov gs,bx			;GS zeigt auf Datensegment

	pop eax				;Restore volume
	retn
Add_Voice_Wave ENDP




Add_Voice_Wave_and_Mono PROC NEAR
	call Add_Voice_Wave

	Normal_Mixing_Chunk1 WAVE
	xor ebx,ebx
	add edi,ecx
	add edi,ecx
	neg ecx
@@loop1:
		mov bl,ds:[esi]		;Load sample value
	   @@V1:mov ax,ds:[2*ebx+12345678h]
		add ds:[edi+2*ecx],ax  	;Add to DMA-Buffer
		add bp,dx		;Add fractional part
	   @@C1:adc esi,1234h        	;Add integer part
		inc ecx			;Decrease buffer-counter...
jnz short @@loop1			; ...and to the next sample
	Normal_Mixing_Chunk2
Add_Voice_Wave_and_Mono ENDP






;[]------------------------------------------------------------------------[]
;|
;| This is the reverberate-engine. If you want to use it, do not forget
;| to set the flag CDMI_USE_REVERB !
;|
;| The information where to reverb what is stored in the CDMI_Reverb
;| structure in the data segment. Not that you can only use 8 reverbs as
;| a maximum. Higher values will crash your computer (probably)
;|
;|
FILL_REVERB_BUFFER MACRO
	ifndef SHAREWARE
	GET_BUFFER_SIZE
	mov esi,gs:[CDMI_DMA_Address]
	mov edi,cs:[Reverb_Ptr]
	movzx eax,cs:[Reverb_Count]
	mul ecx
	add edi,eax
	shr ecx,2
	rep movs dword ptr es:[edi],ds:[esi]
	endif
	ENDM



Reverb_Engine PROC NEAR
	ifdef SHAREWARE
	retn
	else
	mov bl,byte ptr gs:[CDMI_Reverb.RVB_Count]
	test bl,bl
	jz short @@E
	mov bp,OFFSET CDMI_Reverb.RVB1.FEEDBACK
@@L1:   mov ax,gs:[bp+2]
	mov byte ptr cs:[@@C1-1],al
	mov ax,cs:[Reverb_Count]
	sub ax,gs:[bp]			;Subtract feedback value
	and eax,3fh			;Elign it into buffer
	movzx ecx,gs:[CDMI_DMA_Size]	;Get size of ONE buffer
	testflag gs:[CDMI_Flags],CDMI_USE_STEREO
	jz short @@1
	shl ecx,1			;ECX holds sample-count
@@1:	mul ecx
	mov esi,cs:[Reverb_Ptr]
	shl eax,1
	add esi,eax			;ESI holds start eddress
	mov edi,gs:[CDMI_DMA_Address]	;EDI holds buffer address

	dec ecx
@@L2:	movsx eax,word ptr ds:[esi+2*ecx]
	imul eax,12h
  @@C1:	sar eax,7
	add word ptr ds:[edi+2*ecx],ax
	dec ecx
	jns short @@L2


	add bp,4
	dec bl
	jnz short @@L1


@@E:	mov ax,cs:[Reverb_Count]
	inc ax
	and ax,3fh
	mov cs:[Reverb_Count],ax
	retn
	endif
Reverb_Engine ENDP





;[]------------------------------------------------------------------------[]
;|
;| Here are the pattern- and instrument decoders for the various formats
;| The decoder is split up in various subroutines for better performance
;| and a transparent structure.
;|
;|
;|
PeriodTable dw 27392,25855,24403,23034,21741,20521,19369,18282,17256,16287,15373,14510
	    dw 13696,12927,12202,11517,10871,10260,9685 ,9141 ,8628 ,8144 ,7687 ,7255
	    dw 6848 ,6464 ,6101 ,5758 ,5435 ,5130 ,4842 ,4570 ,4314 ,4072 ,3843 ,3628
	    dw 3424 ,3232 ,3050 ,2879 ,2717 ,2565 ,2421 ,2285 ,2157 ,2036 ,1921 ,1813
	    dw 1712 ,1616 ,1525 ,1440 ,1359 ,1283 ,1211 ,1143 ,1078 ,1018 ,961  ,907
	    dw 856  ,808  , 762 , 720 , 678 , 640 , 604 , 570 , 538 , 508 , 480 , 453
	    dw 428  ,404  , 381 , 360 , 339 , 320 , 302 , 285 , 269 , 254 , 240 , 226
	    dw 214  ,202  , 190 , 180 , 170 , 160 , 151 , 143 , 135 , 127 , 120 , 113
	    dw 107  ,101  ,  95 ,  90 ,  85 ,  80 ,  76 ,  72 ,  68 ,  64 ,  60 ,  57
	    dw 54   ,51   ,  48 ,  45 ,  43 ,  40 ,  38 ,  36 ,  34 ,  32 ,  30 ,  28
	    dw 27   ,25   ,  24 ,  23 ,  21 ,  20 ,  19 ,  18 ,  17 ,  16 ,  15 ,  14
;Arpeggiotable has 12 bits fudge
	      dw 9742,9195,8679,8192
	      dw 7732,7298,6889,6502,6137,5793,5467,5161,4871,4598,4340
ArpeggioTable dw 4096,3866,3649,3444,3251,3069,2896,2733,2580,2435,2299
	      dw 2170,2048,1933,1824,1722
VibratoTable  db   0, 24, 49, 74, 97,120,141,161,180,197,212,224,235,244
	      db 250,253,255,253,250,244,235,224,212,197,180,161,141,120
	      db  97, 74, 49, 24


;This little MACRO is very helpful for effects that change the playing pitch
;It recalculates the MAX_CX and INCREMENT values of the Channel-Info.
;EBX must hold new Period and cs:[di] must point to the current
;Channel-Info-entry
AdjustDI_MAX_CX MACRO
	LOCAL DivError
	test ebx,ebx
	jz short DivError
	mov eax,cs:[di+CI_RESAMPLE]
	mul cs:[Period_Factor]		;EAX holds period-factor
	div ebx                         ;Divide by current period
	mov cs:[di+CI_REST],eax		;Save fractional part
	mov ebx,eax
	mov eax,cs:[di+CI_SIZE]
	sub eax,cs:[di+CI_POSITION]
	js short DivError
	xor edx,edx
	mov cs:[di+CI_OVERFLOW],dx
	shld edx,eax,16
	shl eax,16			;Fudge for division
	div ebx                      	;divide by Rest & Increment
	mov cs:[di+CI_MAX_CX],eax	;Save for later
      DivError:
      ENDM


PATCommandTable dw OFFSET PAT_Nothing
		dw OFFSET PAT_Slide_up
		dw OFFSET PAT_Slide_Down
		dw OFFSET PAT_Portamento
		dw OFFSET PAT_Vibrato
		dw OFFSET PAT_Porta_n_Slide
		dw OFFSET PAT_Vibrato_n_Slide
		dw OFFSET PAT_Tremolo
		dw OFFSET PAT_Panning
		dw OFFSET PAT_Sample_Offset
		dw OFFSET PAT_Volume_Slide
		dw OFFSET PAT_Jump
		dw OFFSET PAT_Set_Volume
		dw OFFSET PAT_Break
		dw OFFSET PAT_Arpeggio
		dw OFFSET PAT_Set_Speed
		dw OFFSET PAT_Set_Filter
		dw OFFSET PAT_Fine_Slide_Up
		dw OFFSET PAT_Fine_Slide_Down
		dw OFFSET PAT_Set_Glissando
		dw OFFSET PAT_Set_Vibrato
		dw OFFSET PAT_Set_Finetune
		dw OFFSET PAT_Loop_Jump
		dw OFFSET PAT_Set_Tremolo
		dw OFFSET PAT_Retrigger_Note
		dw OFFSET PAT_Fine_Vol_Slide_Up
		dw OFFSET PAT_Fine_Vol_Slide_Down
		dw OFFSET PAT_Note_Cut
		dw OFFSET PAT_Note_Delay
		dw OFFSET PAT_Pattern_Delay
		dw OFFSET PAT_Funk_Invert
		dw OFFSET PAT_Arpeggio2
		dw OFFSET PAT_Set_Tempo
		dw OFFSET PAT_Tremor
		dw OFFSET PAT_Set_Global_Volume
		dw OFFSET PAT_Inverse_Sample
		dw OFFSET PAT_Traeller
		dw OFFSET PAT_MultiRetrigger_Note
		dw OFFSET PAT_ExtraFine_Slide_Up
		dw OFFSET PAT_ExtraFine_Slide_Down
		dw OFFSET PAT_Fine_Vibrato
		dw OFFSET PAT_Big_Panning
		dw OFFSET PAT_Panning_Slide
		dw OFFSET PAT_Set_Envelope_Position
		dw OFFSET PAT_Key_Off
		dw OFFSET PAT_Global_Volume_Slide
		dw OFFSET PAT_Set_Envelope_Position
		dw 256-MAX_EFFECTS DUP (OFFSET PAT_Nothing)
PAT_Nothing PROC NEAR
	retn
PAT_Nothing ENDP



PAT_Arpeggio PROC NEAR
	movzx bx,ds:[esi+5]
	mov byte ptr cs:[di+CI_COMMAND],5
	mov byte ptr cs:[di+CI_COM_VALUE],0
	push bx
	and bx,0fh			;Lower 4 bits
	shl bx,1
	mov ax,cs:[bx+OFFSET ArpeggioTable]
	mul word ptr cs:[di+CI_PERIOD]
	shrd ax,dx,12
	mov cs:[di+CI_ARP_2],ax
	pop bx
	shr bx,4			;Upper 4 bits
	shl bx,1
	mov ax,cs:[bx+OFFSET ArpeggioTable]
	mov bx,cs:[di+CI_PERIOD]
	mov cs:[di+CI_ARP_1],bx
	mul bx
	shrd ax,dx,12
	mov cs:[di+CI_ARP_3],ax
	retn
PAT_Arpeggio ENDP




PAT_Arpeggio2 PROC NEAR
	movzx bx,ds:[esi+5]
	mov byte ptr cs:[di+CI_COMMAND],5
	mov byte ptr cs:[di+CI_COM_VALUE],0
	push bx
	and bx,0fh			;Lower 4 bits
	shl bx,1
	mov ax,cs:[bx+OFFSET ArpeggioTable]
	mul word ptr cs:[di+CI_PERIOD]
	shrd ax,dx,12
	mov cs:[di+CI_ARP_2],ax
	pop bx
	shr bx,4			;Upper 4 bits
	shl bx,1
	mov ax,cs:[OFFSET ArpeggioTable-bx]
	mov bx,cs:[di+CI_PERIOD]
	mov cs:[di+CI_ARP_1],bx
	mul bx
	shrd ax,dx,12
	mov cs:[di+CI_ARP_3],ax
	retn
PAT_Arpeggio2 ENDP




PAT_Slide_Up PROC NEAR
	movzx bx,ds:[esi+5]
	mov byte ptr cs:[di+CI_COMMAND],1	;Slide up/down
	shl bx,2
	jz short @@1
	mov cs:[di+CI_COM_VALUE],bx
	add cs:[di+CI_PERIOD],bx
	retn
@@1:    mov bx,cs:[di+CI_COM_VALUE]
	add cs:[di+CI_PERIOD],bx
	retn
PAT_Slide_Up ENDP




PAT_Slide_Down PROC NEAR
	movzx bx,ds:[esi+5]
	mov byte ptr cs:[di+CI_COMMAND],2	;Slide up/down
	shl bx,2
	jz short @@1
	mov cs:[di+CI_COM_VALUE],bx
	sub cs:[di+CI_PERIOD],bx
	retn
@@1:	mov bx,cs:[di+CI_COM_VALUE]
	sub cs:[di+CI_PERIOD],bx
	retn
PAT_Slide_Down ENDP




PAT_Portamento PROC NEAR
	mov ax,cs:[di+CI_DESTINATION]
	test ax,ax
	jnz short @@3
	mov cs:[di+CI_PERIOD],ax
	movzx ebx,ax
	AdjustDI_MAX_CX
	retn
  @@3:	movzx bx,ds:[esi+5]
	shl bx,2
	jz short @@1
	mov word ptr cs:[di+CI_COM_VALUE],bx	;Slide up/down
  @@1:  cmp ax,cs:[di+CI_PERIOD]		;Destination
	je short @@2
	jb short @@Up
	mov byte ptr cs:[di+CI_COMMAND],4 	;Slide down
	retn
  @@Up:	mov byte ptr cs:[di+CI_COMMAND],3 	;Slide up
  @@2:	retn
PAT_Portamento ENDP




PAT_Vibrato PROC NEAR
	cmp word ptr cs:[di+CI_PERIOD],0
	je short @@2
	mov bl,ds:[esi+5]
	mov byte ptr cs:[di+CI_COMMAND],6 	;Vibrato
	mov al,bl
	shr al,4  				;Speed in AL
	shl al,2
	jz short @@1
	mov cs:[di+CI_VIB_SPEED],al
  @@1:  and bl,0fh				;Depth in AH
	jz short @@2
	mov cs:[di+CI_VIB_DEPTH],bl
  @@2:	retn
PAT_Vibrato ENDP





PAT_Fine_Vibrato PROC NEAR
	cmp word ptr cs:[di+CI_PERIOD],0
	je short @@2
	mov bl,ds:[esi+5]
	mov byte ptr cs:[di+CI_COMMAND],19 	;Vibrato
	mov al,bl
	shr al,4  				;Speed in AL
	shl al,2
	jz short @@1
	mov cs:[di+CI_VIB_SPEED],al
  @@1:  and bl,0fh				;Depth in AH
	jz short @@2
	mov cs:[di+CI_VIB_DEPTH],bl
  @@2:	retn
PAT_Fine_Vibrato ENDP




PAT_Porta_n_Slide PROC NEAR
	mov ax,cs:[di+CI_PERIOD]		;Source
	cmp ax,cs:[di+CI_DESTINATION]		;Destination
	je short @@1
	ja short @@2
	mov byte ptr cs:[di+CI_COMMAND],15 	;Slide down
	jmp short @@1
  @@2:  mov byte ptr cs:[di+CI_COMMAND],16 	;Slide up
  @@1:  mov bl,ds:[esi+5]
	test bl,1111b
	jnz short @@3
	shr bl,4
	jz short @@4
	mov cs:[di+CI_VOL_SLIDE],bl
	retn
  @@3:  neg bl
	jz short @@4
	mov cs:[di+CI_VOL_SLIDE],bl
  @@4:	retn
PAT_Porta_n_Slide ENDP




PAT_Vibrato_n_Slide PROC NEAR
	mov bl,ds:[esi+5]
	mov byte ptr cs:[di+CI_COMMAND],14 	;Vibrato & volslide
	test bl,1111b
	jnz short @@1
	shr bl,4
	jz short @@2
	mov cs:[di+CI_VOL_SLIDE],bl
	retn
  @@1:	neg bl
	jz short @@2
	mov cs:[di+CI_VOL_SLIDE],bl
  @@2:	retn
PAT_Vibrato_n_Slide ENDP




PAT_Tremolo PROC NEAR
	mov bl,ds:[esi+5]
	mov byte ptr cs:[di+CI_COMMAND],7 	;Tremolo
	mov al,bl
	and al,0f0h
	shr al,2
	jz short @@1
	mov cs:[di+CI_TRM_SPEED],al
  @@1:  and bl,0fh				;Depth in AH
	jz short @@2
	mov cs:[di+CI_TRM_DEPTH],bl
  @@2:	retn
PAT_Tremolo ENDP




PAT_Panning PROC NEAR
	mov bl,byte ptr ds:[esi+5]
	mov cs:[di+CI_PANNING],bl
	retn
PAT_Panning ENDP




PAT_Big_Panning PROC NEAR
	mov bl,byte ptr ds:[esi+5]
	shl bl,4
	mov cs:[di+CI_PANNING],bl
	retn
PAT_Big_Panning ENDP




PAT_Sample_Offset PROC NEAR
	or dword ptr cs:[di+CI_FLAGS],CF_NEW_POSITION	;This one is needed for GUS
	movzx ebx,byte ptr ds:[esi+5]
	shl ebx,8
	cmp ebx,cs:[di+CI_SIZE]
	jae short @@1
	mov cs:[di+CI_POSITION],ebx	;Add Value<<8
	mov cs:[di+CI_GUS_POSITION],ebx

	mov eax,cs:[di+CI_SIZE]
	sub eax,ebx
	js short @@1
	mov ebx,dword ptr cs:[di+CI_REST]
	test ebx,ebx
	je short @@1           		;Make it safe from 0-division
	xor edx,edx
	mov cs:[di+CI_OVERFLOW],dx
	shld edx,eax,16
	shl eax,16			;Fudge for division
	div ebx  			;divide by Rest & Increment
	mov cs:[di+CI_MAX_CX],eax	;Save for later

 @@1:	retn
PAT_Sample_Offset ENDP




PAT_Volume_Slide PROC NEAR
	mov byte ptr cs:[di+CI_COMMAND],13
	mov bl,ds:[esi+5]
	test bl,1111b
	jnz short @@2
	shr bl,4
	jz short @@1
	mov cs:[di+CI_VOL_SLIDE],bl
	retn
 @@2:   neg bl
	jz short @@1
	mov cs:[di+CI_VOL_SLIDE],bl
 @@1:	retn
PAT_Volume_Slide ENDP




PAT_Jump PROC NEAR
	movzx bx,ds:[esi+5]
	or gs:[CDMI_Flags],CDMI_BREAK_FLAG
	dec bx
	mov gs:[CDMI_Entry_No],bx
	START_PATTERN
	retn
PAT_Jump ENDP




PAT_Set_Volume PROC NEAR
	mov al,ds:[esi+5]
	mov ah,al
	mov cs:[di+CI_VOLUME],ax
	retn
PAT_Set_Volume ENDP




PAT_Break PROC NEAR
	movzx ax,ds:[esi+5]
	or gs:[CDMI_Flags],CDMI_BREAK_FLAG
	mov gs:[CDMI_Beat_No],ax
	retn
PAT_Break ENDP



PAT_Fine_Slide_Up PROC NEAR
	movzx eax,byte ptr ds:[esi+5]
	shl eax,2
	movzx ebx,word ptr cs:[di+CI_PERIOD]
	sub ebx,eax
	mov cs:[di+CI_PERIOD],bx
	AdjustDI_MAX_CX
	retn
PAT_Fine_Slide_Up ENDP



PAT_Fine_Slide_Down PROC NEAR
	movzx eax,byte ptr ds:[esi+5]
	shl eax,2				;*4
	movzx ebx,word ptr cs:[di+CI_PERIOD]
	add ebx,eax
	mov cs:[di+CI_PERIOD],bx
	AdjustDI_MAX_CX
	retn
PAT_Fine_Slide_Down ENDP



PAT_ExtraFine_Slide_Up PROC NEAR
	movzx eax,byte ptr ds:[esi+5]
	movzx ebx,word ptr cs:[di+CI_PERIOD]
	sub ebx,eax
	mov cs:[di+CI_PERIOD],bx
	AdjustDI_MAX_CX
	retn
PAT_ExtraFine_Slide_Up ENDP



PAT_ExtraFine_Slide_Down PROC NEAR
	movzx eax,byte ptr ds:[esi+5]
	movzx ebx,word ptr cs:[di+CI_PERIOD]
	add ebx,eax
	mov cs:[di+CI_PERIOD],bx
	AdjustDI_MAX_CX
	retn
PAT_ExtraFine_Slide_Down ENDP



PAT_Retrigger_Note PROC NEAR
	mov al,byte ptr ds:[esi+5]
	mov byte ptr cs:[di+CI_COMMAND],8
	and al,0fh
	jz short @@1
	mov cs:[di+CI_COM_VALUE],al
	mov cs:[di+CI_TRG_POS],al
@@1:	retn
PAT_Retrigger_Note ENDP



PAT_Fine_Vol_Slide_Up PROC NEAR
	mov al,byte ptr ds:[esi+5]
	add al,cs:[di+CI_VOLUME]
	cmp al,64
	jb short @@1
	mov al,64
 @@1:	mov ah,al
	mov cs:[di+CI_VOLUME],ax
	retn
PAT_Fine_Vol_Slide_Up ENDP



PAT_Fine_Vol_Slide_Down PROC NEAR
	mov al,cs:[di+CI_VOLUME]
	sub al,byte ptr ds:[esi+5]
	jns short @@1
	mov word ptr cs:[di+CI_VOLUME],0
	retn
 @@1:   mov ah,al
	mov word ptr cs:[di+CI_VOLUME],ax
	retn
PAT_Fine_Vol_Slide_Down ENDP



PAT_Note_Cut PROC NEAR
	mov al,byte ptr ds:[esi+5]
	mov byte ptr cs:[di+CI_COMMAND],9
	mov cs:[di+CI_COM_VALUE],al
	retn
PAT_Note_Cut ENDP



PAT_Note_Delay PROC NEAR
	mov al,byte ptr ds:[esi+5]
	mov byte ptr cs:[di+CI_COMMAND],10
	mov cs:[di+CI_COM_VALUE],al
	retn
PAT_Note_Delay ENDP



PAT_Set_Speed PROC NEAR
	movzx bx,ds:[esi+5]
	test bx,bx
	jz short @@1
	cmp bx,20h			;if greater than 20h then
	jae short PAT_BPM		;it is BPM else it is ticks
	mov gs:[CDMI_Speed],bx		;per beat
	mov cs:[Ticks_Left],bx
	retn
PAT_BPM:mov gs:[CDMI_Tempo],bx
@@1:	retn
PAT_Set_Speed ENDP



PAT_Funk_Invert PROC NEAR
	retn
PAT_Funk_Invert ENDP



PAT_Pattern_Delay PROC NEAR
	movzx ax,ds:[esi+5]
	mul gs:[CDMI_Speed]
	add cs:[Ticks_Left],ax
	retn
PAT_Pattern_Delay ENDP



PAT_Set_Filter PROC NEAR
	retn
PAT_Set_Filter ENDP



PAT_Set_Glissando PROC NEAR
	mov al,ds:[esi+5]
	test al,al
	jz short @@1
	or cs:[COMMAND_Flags],COM_GLISSANDO_CTRL
	retn
@@1:	and cs:[COMMAND_Flags],NOT COM_GLISSANDO_CTRL
	retn
PAT_Set_Glissando ENDP



PAT_Set_Tremolo PROC NEAR
	mov al,ds:[esi+5]
	and al,03
	mov cs:[di+CI_TRM_FORM],al
	retn
PAT_Set_Tremolo ENDP



PAT_Set_Vibrato PROC NEAR
	mov al,ds:[esi+5]
	and al,03
	mov cs:[di+CI_VIB_FORM],al
	retn
PAT_Set_Vibrato ENDP



PAT_Set_Finetune PROC NEAR
	retn
PAT_Set_Finetune ENDP



PAT_Loop_Jump PROC NEAR
	movzx bx,ds:[esi+5]
	test bx,bx
	jz short @@1
	dec cs:[LOOP_Count]
	jz short @@3			;Zero means last pass
	jns short @@2			;Sign means first pass

	mov cs:[LOOP_Count],bx
@@2:	mov ax,cs:[LOOP_Entry_No]
	mov gs:[CDMI_Entry_No],ax
	mov ax,cs:[LOOP_Pattern_No]
	mov gs:[CDMI_Pattern_No],ax
	mov ax,cs:[LOOP_Beat_No]
	mov gs:[CDMI_Beat_No],ax
	mov eax,cs:[LOOP_Pattern]
	mov cs:[Current_Pattern],eax
	mov ax,cs:[LOOP_Len]
	mov cs:[Current_Len],ax
@@3:	retn

@@1:    mov ax,gs:[CDMI_Entry_No]
	mov cs:[LOOP_Entry_No],ax
	mov ax,gs:[CDMI_Pattern_No]
	mov cs:[LOOP_Pattern_No],ax
	mov ax,gs:[CDMI_Beat_No]
	mov cs:[LOOP_Beat_No],ax
	mov eax,cs:[Current_Pattern]
	mov cs:[LOOP_Pattern],eax
	mov ax,cs:[Current_Len]
	mov cs:[LOOP_Len],ax
	retn
PAT_Loop_Jump ENDP



PAT_Set_Tempo PROC NEAR
	movzx bx,ds:[esi+5]
	test bx,bx
	jz short @@1
	mov gs:[CDMI_Tempo],bx
@@1:	retn
PAT_Set_Tempo ENDP



PAT_Tremor PROC NEAR
	mov bl,ds:[esi+5]
	mov byte ptr cs:[di+CI_COMMAND],11 	;Tremor
	test bl,bl
	jz short @@2
	mov al,bl
	shr al,4
	mov cs:[di+CI_TRM_ON],al
	and bl,0fh				;Depth in AH
	add bl,al
	mov cs:[di+CI_TRM_OFF],bl
	xor al,al
	mov cs:[si+CI_TRM_POS],al
@@2:	retn
PAT_Tremor ENDP



PAT_Set_Global_Volume PROC NEAR
	retn
PAT_Set_Global_Volume ENDP




PAT_Global_Volume_Slide PROC NEAR
	retn
PAT_Global_Volume_Slide ENDP



PAT_Inverse_Sample PROC NEAR
	mov bl,ds:[esi+5]
	mov byte ptr cs:[di+CI_COMMAND],12 	;Reverse sample
	and ebx,0fh
	jz short @@1
	mov cs:[di+CI_REV_SPEED],bl
	mov cs:[di+CI_REV_POS],bl
	movzx eax,gs:[CDMI_DMA_Size]
	mul ebx
	mov cs:[di+CI_MAX_CX],eax
	mul dword ptr cs:[di+CI_REST]
	shrd eax,edx,16
	mov ebx,cs:[di+CI_SIZE]
	sub ebx,eax
	mov cs:[di+CI_POSITION],ebx
	mov cs:[di+CI_GUS_POSITION],ebx
	shl ax,1
	mov cs:[di+CI_REV_SIZE],ax
	mov dword ptr cs:[di+CI_LOOP_START],0ffffffffh
@@1:	retn
PAT_Inverse_Sample ENDP




PAT_Traeller PROC NEAR
	movzx bx,ds:[esi+5]
	mov byte ptr cs:[di+CI_COMMAND],17
	and bx,0fh			;Lower 4 bits
	shl bx,1
	jz short @@1
	mov ax,cs:[di+CI_PERIOD]
	mov cs:[di+CI_ARP_1],ax
	mul word ptr cs:[bx+OFFSET ArpeggioTable]
	shrd ax,dx,12
	mov cs:[di+CI_ARP_2],ax

@@1:	mov bl,ds:[esi+5]
	shr bl,4			;Upper 4 bits
	jz short @@2
	mov bh,bl
	mov cs:[di+CI_COM_VALUE],bx
@@2:	retn
PAT_Traeller ENDP



PAT_MultiRetrigger_Note PROC NEAR
	mov al,byte ptr ds:[esi+5]
	mov byte ptr cs:[di+CI_COMMAND],18
	test al,al
	jz short @@1
	mov ah,al
	shr ah,4
	and al,0fh
	mov cs:[di+CI_COM_VALUE],ax
	mov cs:[di+CI_TRG_POS],al
@@1:	retn
PAT_MultiRetrigger_Note ENDP




PAT_Panning_Slide PROC NEAR
	mov bl,ds:[esi+5]
	test bl,bl
	jnz short @@2
	mov bl,cs:[di+CI_COM_VALUE+1]
@@2:	mov cs:[di+CI_COM_VALUE+1],bl
	test bl,0f0h
	jz short @@1
	shr bl,4
	mov bh,20
	mov cs:[di+CI_COMMAND],bx 	;Panning_Slide right (+)
	retn
@@1:	mov bh,21
	mov cs:[di+CI_COMMAND],bx 	;Panning_Slide left (-)
	retn
PAT_Panning_Slide ENDP



PAT_Key_Off PROC NEAR
	mov dword ptr cs:[di+CI_LOOP_START],0ffffffffh
	mov dword ptr cs:[di+CI_MAX_CX],0
	retn
PAT_Key_Off ENDP



PAT_Set_Envelope_Position PROC NEAR
	movzx ax,ds:[esi+5]
	shl eax,16
	movzx ax,ds:[esi+5]
	mov cs:[di+CI_VENVELOPE_POS],eax
	retn
PAT_Set_Envelope_Position ENDP



;[]-------------------------------------------------------------------------[]
;|
;| These effects are for the volume coloumn byte...
;| When the routines are called, the old fx-value is in AL
;|
VOLCommandTable dw OFFSET VOL_Nothing
		dw OFFSET VOL_Volume_Slide_Down
		dw OFFSET VOL_Volume_Slide_Up
		dw OFFSET VOL_Volume_Fine_Slide_Down
		dw OFFSET VOL_Volume_Fine_Slide_Up
		dw OFFSET VOL_Set_Vibrato_Speed
		dw OFFSET VOL_Vibrato
		dw OFFSET VOL_Set_Panning
		dw OFFSET VOL_Panning_Slide_Left
		dw OFFSET VOL_Panning_Slide_Right
		dw OFFSET VOL_Tone_Portamento

VOL_Nothing PROC NEAR
	retn
VOL_Nothing ENDP



VOL_Volume_Slide_Down PROC NEAR
	sub al,60h
	jz short @@1
	neg al
	mov cs:[di+CI_VOL_SLIDE],al
@@1:	mov byte ptr cs:[di+CI_COMMAND],13
	retn
VOL_Volume_Slide_Down ENDP



VOL_Volume_Slide_Up PROC NEAR
	sub al,70h
	jz short @@1
	mov cs:[di+CI_VOL_SLIDE],al
@@1:	mov byte ptr cs:[di+CI_COMMAND],13
	retn
VOL_Volume_Slide_Up ENDP



VOL_Volume_Fine_Slide_Down PROC NEAR
	sub al,80h
	mov ah,cs:[di+CI_VOLUME]
	sub ah,al
	jns short @@1
	mov word ptr cs:[di+CI_VOLUME],0
	retn
@@1:    mov al,ah
	mov word ptr cs:[di+CI_VOLUME],ax
	retn
VOL_Volume_Fine_Slide_Down ENDP



VOL_Volume_Fine_Slide_Up PROC NEAR
	sub al,90h
	add al,byte ptr cs:[di+CI_VOLUME]
	cmp al,64
	jb short @@1
	mov al,64
@@1:	mov ah,al
	mov word ptr cs:[di+CI_VOLUME],ax
	retn
VOL_Volume_Fine_Slide_Up ENDP



VOL_Set_Vibrato_Speed PROC NEAR
	sub al,0a0h
	shl al,2
	mov cs:[di+CI_VIB_SPEED],al
	retn
VOL_Set_Vibrato_Speed ENDP



VOL_Vibrato PROC NEAR
	sub al,0b0h
	jz short @@1
	mov cs:[di+CI_VIB_DEPTH],al
@@1:	mov byte ptr cs:[di+CI_COMMAND],6
	retn
VOL_Vibrato ENDP



VOL_Set_Panning PROC NEAR
	sub al,0c0h
	shl al,4
	mov cs:[di+CI_PANNING],al
	retn
VOL_Set_Panning ENDP



VOL_Panning_Slide_Left PROC NEAR
	sub al,0d0h
	mov ah,21
	mov cs:[di+CI_COMMAND],ax 	;Panning_Slide left (-)
	retn
VOL_Panning_Slide_Left ENDP



VOL_Panning_Slide_Right PROC NEAR
	sub al,0e0h
	mov ah,20
	mov cs:[di+CI_COMMAND],ax 	;Panning_Slide right (+)
	retn
VOL_Panning_Slide_Right ENDP



VOL_Tone_Portamento PROC NEAR
	mov ax,cs:[di+CI_DESTINATION]
	test ax,ax
	jnz short @@3
	mov cs:[di+CI_PERIOD],ax
	movzx ebx,ax
	AdjustDI_MAX_CX
	retn
  @@3:	mov bl,ds:[esi+3]
	and bx,0fh				;Mask out effect
	shl bx,2				;Make it 4 times faster
	jz short @@1
	mov word ptr cs:[di+CI_COM_VALUE],bx	;Slide up/down
  @@1:  cmp ax,cs:[di+CI_PERIOD]		;Destination
	je short @@2
	jb short @@Up
	mov byte ptr cs:[di+CI_COMMAND],4 	;Slide down
	retn
  @@Up:	mov byte ptr cs:[di+CI_COMMAND],3 	;Slide up
  @@2:	retn
VOL_Tone_Portamento ENDP





;[]-------------------------------------------------------------------------[]
;|
;| A note of the internal pattern format consists out of 6 bytes:
;|
;| BYTE[0]  BYTE[1]  BYTE[2]  BYTE[3]  BYTE[4]  BYTE[5]
;| aaaaaaaa bbbbbbbb cccccccc dddddddd eeeeeeee ffffffff
;|     
;|                                         
;|  		     	              	Command parameter
;|                                 
;|                                 Command value (See CDMI.INC)
;|                         
;|                         Volume coloumn byte: (Same like XM)
;|                           0        Nothing
;|                           01 - 0f  Reserved - do not use !
;|                           10 - 50  Set Volume
;|                 		51 - 5f  Reserved - do not use !
;|  		               60 - 6f  Volume Slide down
;|  		               70 - 7f  Volume Slide up
;|                           80 - 8f  Fine Volume Slide down
;|                           90 - 9f  Fine Volume Slide up
;|                           a0 - af  Set Vibrato Speed
;|                           b0 - bf  Vibrato
;|                           c0 - cf  Set Panning
;|                           d0 - df  Panning Slide left
;|                           e0 - ef  Panning Slide right
;|                           f0 - ff  Tone Portamento
;|                 
;|                 
;|                 This is the instrument number (0 means no change)
;| 
;| This is the period/pitch to play using the MOD-convention
;| (0 means no change)
;| 
;| 
;| 
;| This is the key-off bit (when it is set, the sample will be stopped)
;|
;|
;| GS should contain the DATA-Segment
;| DS should contain zero
;|

Next_Beat PROC NEAR
	cld

	and gs:[CDMI_Flags],NOT CDMI_BREAK_FLAG
	mov ebp,gs:[CDMI_Song]				;DS:EBP points to song_header
	mov esi,cs:[Current_Pattern]
	movzx eax,gs:[CDMI_Beat_No]
	movzx ebx,word ptr ds:[ebp+SH_ROW_SIZE]		;Bytes per row
	mul ebx
	add esi,eax
	mov di,OFFSET Channel_Info			;In CS:DI is Channel_Info
	mov cx,gs:[CDMI_Channels]			;Number of channels used

 Decode_Loop:
	mov byte ptr cs:[di+CI_COMMAND],0
	mov ax,word ptr ds:[esi]
	test al,80h				;Test for key-off
	jnz Do_Key_Off
	and ax,0ff7fh
	jz Check_Volume				;JZ => No Note/Instrument
	rol ax,8				;Change MSB/LSB order
	mov cs:[di+CI_DESTINATION],ax  		;Save the period
	cmp byte ptr ds:[esi+4],TONE_PORTAMENTO
	je Check_Volume
	cmp byte ptr ds:[esi+3],0f0h
	jae Check_Volume
	mov cs:[di+CI_PERIOD],ax        	;Save the period

	movzx ebx,byte ptr ds:[esi+2]		;Get instrument
	dec bx
	js @@NoI				;BX<0 => No instrument !
	mov cs:[di+CI_INSTRUMENT],bl		;Save instrument number
	shl ebx,8				;*256 bytes/instrument
	add ebx,ebp
	lea eax,[ebx+IH_VENVELOPE]		;Get address of volume envelope
	mov cs:[di+CI_ENVELOPE_ADDRESS],eax
	mov eax,ds:[ebx+IH_FLAGS]
	or eax,CF_NEW_INSTRUMENT or CF_NEW_POSITION
	mov cs:[di+CI_FLAGS],eax
	testflag eax,IF_USE_PANNING
	jz short @@NoPn
	mov al,ds:[ebx+IH_PANNING]		;Get volume of this sample
	mov cs:[di+CI_PANNING],al		;...and save it !
@@NoPn:	mov ax,ds:[ebx+IH_FADE_OUT]		;Get fade-out speed
	mov cs:[di+CI_FADE_OUT],ax
	mov eax,ds:[ebx+IH_GUS_HANDLE]		;Get GUS-Handle
	mov cs:[di+CI_GUS_HANDLE],eax
	mov eax,ds:[ebx+IH_RESAMPLE]		;Get resampling/finetune
	mov cs:[di+CI_RESAMPLE],eax
	mov eax,ds:[ebx+IH_ADDRESS]		;EAX holds Address
	mov cs:[di+CI_ADDRESS],eax
	mov al,ds:[ebx+IH_VOLUME]		;Get volume of this sample
	mov ah,al
	mov cs:[di+CI_VOLUME],ax		;...and save it !
	mov eax,ds:[ebx+IH_SIZE]		;EAX holds samplesize
	mov edx,ds:[ebx+IH_LOOP_START]		;EDX holds Loop_start
	mov cs:[di+CI_LOOP_START],edx
	cmp edx,0fffffffh               	;Has the instrument a loop ?
	jae short @@NoLp		   	;JAE : Nope
	mov eax,ds:[ebx+IH_LOOP_END]		;EAX holds loopend
@@NoLp:	mov cs:[di+CI_SIZE],eax			;Update SampleSize

@@NoI: 	mov ebx,cs:[di+CI_ENVELOPE_ADDRESS]
	mov al,ds:[ebx+IH_VENVELOPE_POINTS-IH_VENVELOPE+2]
	mov cs:[di+CI_ENVELOPE_VOLUME],al
	mov al,ds:[ebx+IH_PENVELOPE_POINTS-IH_VENVELOPE+2]
	mov cs:[di+CI_ENVELOPE_PANNING],al

	mov eax,cs:[di+CI_RESAMPLE]
	mul cs:[Period_Factor]			;EDX:EAX holds period-factor
	movzx ebx,word ptr cs:[di+CI_PERIOD]
	test ebx,ebx
	jz @@VolCol
	div ebx                         	;Divide by current period
	test eax,eax
	jz @@VolCol
	mov cs:[di+CI_REST],eax			;Save fractional part
	mov ebx,eax                  		;Save increment for next div
	xor edx,edx				;Clear EDX for div
	mov cs:[di+CI_FADE_POS],dx		; ... and for clearing
	mov cs:[di+CI_POSITION],edx		;some other useful things
	mov cs:[di+CI_GUS_POSITION],edx
	mov cs:[di+CI_VENVELOPE_POS],edx
	mov cs:[di+CI_OVERFLOW],dx
	mov eax,cs:[di+CI_SIZE]
	shld edx,eax,16
	shl eax,16				;Fudge for division
	div ebx                      		;divide by Rest & Increment
	mov cs:[di+CI_MAX_CX],eax		;Save for later
	or cs:[di+CI_FLAGS],CF_NEW_POSITION
	jmp short @@VolCol

   Check_Volume:			;The famous volume coloumn (yuck !)
	movzx ebx,byte ptr ds:[esi+2]	;Get instrument
	dec bx
	js short @@VolCol
	shl ebx,8
	mov al,ds:[ebx+ebp+IH_VOLUME]	;Get volume of this sample
	mov ah,al
	mov cs:[di+CI_VOLUME],ax	;...and save it !
	mov dword ptr cs:[di+CI_VENVELOPE_POS],0
	mov word ptr cs:[di+CI_FADE_POS],0
	testflag dword ptr cs:[di+CI_FLAGS],IF_USE_PANNING
	jz short @@VolCol
	mov al,ds:[ebx+IH_PANNING]		;Get volume of this sample
	mov cs:[di+CI_PANNING],al		;...and save it !

   @@VolCol:
	mov bl,ds:[esi+3]		;Get volume column byte
	mov al,bl
	sub bl,10h
	jc short No_Volume
	cmp bl,40h
	ja short @@V1			;Is it simply volume or a complex effect ?
		mov bh,bl
		mov cs:[di+CI_VOLUME],bx
		jmp short No_Volume	;And OUT !
@@V1:	sub bl,40h			;Ok it is a complex effect
	shr bl,3
	and bx,1eh
	call word ptr cs:[OFFSET VOLCommandTable+bx]

   No_Volume:
	movzx bx,ds:[esi+4]		;Get effect number
	shl bx,1
	call word ptr cs:[OFFSET PATCommandTable+bx]
	add esi,6			;Next pattern-note
	add di,CI_ENTRY_SIZE		;Next channel - info
dec cx
jnz Decode_Loop



     End_Prepare:
	testflag gs:[CDMI_Flags],CDMI_BREAK_FLAG	;Break_Marker ???
	jnz short Next_Pattern
	inc gs:[CDMI_Beat_No]
	mov ax,cs:[Current_Len]
	cmp gs:[CDMI_Beat_No],ax
	jbe No_New_Pattern
		START_PATTERN
     Next_Pattern:
		mov ax,ds:[ebp+SH_ENTRY_COUNT]	;Entry_Count
		inc gs:[CDMI_Entry_No]
		cmp gs:[CDMI_Entry_No],ax	;Songende ???
		jae End_Song			;JE: Songende
		SETUP_PATTERN

    No_New_Pattern:
	mov ax,TRUE
	retn

 End_Song:					;Song-Ende wurde erreicht
	testflag gs:[CDMI_Flags],CDMI_LOOP_FLAG
	jz Really_End_of_Song
	mov gs:[CDMI_Entry_No],0
	mov gs:[CDMI_Beat_No],0
	SETUP_PATTERN
	mov ax,TRUE
	retn

 Really_End_Of_Song:
	mov ax,FALSE
	retn



 Do_Key_Off:
	testflag dword ptr cs:[di+CI_FLAGS],IF_VOLUME_ENVELOPE
	jnz short @@2
	mov dword ptr cs:[di+CI_MAX_CX],0
	mov dword ptr cs:[di+CI_REST],0
	jmp Check_Volume
@@2:	mov word ptr cs:[di+CI_FADE_POS],0ffffh
	jmp Check_Volume
Next_Beat ENDP






;[]-------------------------------------------------------------------------[]
;|
;| Well, here are the real effect routines called 32 to 50 times per second
;| How often they are actually called depends on the pattern format. MOD
;| uses 50 ticks per second , 669 something about 32
;| Again a effect table is used for maximum performance
;|

CommandTable 	dw OFFSET DoNothing
		dw OFFSET DoSlideUp
		dw OFFSET DoSlideDown
		dw OFFSET DoPortaUp
		dw OFFSET DoPortaDown
		dw OFFSET DoArpeggio
		dw OFFSET DoVibrato
		dw OFFSET DoTremolo
		dw OFFSET DoRetrigger
		dw OFFSET DoNoteCut
		dw OFFSET DoNoteDelay
		dw OFFSET DoTremor
		dw OFFSET DoInverse
		dw OFFSET DoVolumeSlide
		dw OFFSET DoVolumeSlide_n_Vibrato
		dw OFFSET DoVolumeSlide_n_PortaDown
		dw OFFSET DoVolumeSlide_n_PortaUp
		dw OFFSET DoTraeller
		dw OFFSET DoMultiRetrigger
		dw OFFSET DoFineVibrato
		dw OFFSET DoPanningSlideRight
		dw OFFSET DoPanningSlideLeft

Volume_SlideM MACRO normal
	LOCAL VSlide_Down_Neg,VSlide_Ok,VEnd
	mov al,cs:[si+CI_VOLUME]
	add al,cs:[si+CI_VOL_SLIDE]
	js short VSlide_Down_Neg
	cmp al,64
	jb short VSlide_Ok
	mov word ptr cs:[si+CI_VOLUME],64+100h*64
	mov byte ptr cs:[si+CI_COMMAND],normal
	jmp short VEnd
     VSlide_Down_Neg:
	xor ax,ax
	mov byte ptr cs:[si+CI_COMMAND],normal
     VSlide_Ok:
	mov ah,al
	mov word ptr cs:[si+CI_VOLUME],ax
     VEnd:
	ENDM

;This little MACRO is very helpful for effects that change the playing pitch
;It recalculates the MAX_CX and INCREMENT values of the Channel-Info.
;EBX must hold new Period and cs:[si] must point to the current
;Channel-Info-entry

AdjustSI_MAX_CX MACRO
	LOCAL DivError
	test ebx,ebx
	jz short DivError
	mov eax,cs:[si+CI_RESAMPLE]
	mul cs:[Period_Factor]		;EDX:EAX holds period-factor
	div ebx                         ;Divide by current period
	mov cs:[si+CI_REST],eax		;Save fractional part
	mov ebx,eax
	mov eax,cs:[si+CI_SIZE]
	sub eax,cs:[si+CI_POSITION]
	js short DivError
	xor edx,edx
	mov cs:[si+CI_OVERFLOW],dx
	shld edx,eax,16
	shl eax,16			;Fudge for division
	div ebx                      	;divide by Rest & Increment
	mov cs:[si+CI_MAX_CX],eax	;Save for later
      DivError:
      ENDM

;The following macro is used for tremolo/vibrato etc. It decides which wave-form
;to use and retuens the apropriate value.
;
;AH contains wave-form
;DH contains wave-width
;DL contains wave-position
;The parameter contains the fudge-value
;
;Returns value in EAX

GET_WAVE MACRO a
	LOCAL nosn,set,notr,mas
	MOV     AL,DL
	TEST    AH,AH
	JNZ     short nosn
	 SHR    AL,2
	 AND    AL,1Fh
	 MOV    BX,OFFSET VibratoTable
	 XLAT	cs:[bx]
	 MUL    DH
	 SHL    AX,a
	 MOVZX  EAX,AH
	 TEST   DL,80h
	 JZ     short mas
	 NEG    EAX
	 JMP    short mas

nosn: 	DEC     AH
	JNZ     short notr
	 SHL    AL,1
	 JNC    short set
	  NOT   AL
set:     MUL    DH
	 SHL    AX,a
	 MOVZX  EAX,AH
	 TEST   DL,80h
	 JZ     short mas
	 NEG    EAX
	JMP     short mas

notr:    if (a-1)
	 SHL 	dh,a-1
	 endif
	 MOVZX  EAX,DH
	 TEST   DL,80h
	 JZ     short mas
	  NEG   EAX
mas:
	ENDM



;Now the effect processing starts here:
;

DoNothing PROC NEAR
	retn
DoNothing ENDP



DoSlideUp PROC NEAR
	mov ax,cs:[si+CI_COM_VALUE]
	sub cs:[si+CI_PERIOD],ax
	js short @@1
	movzx ebx,word ptr cs:[si+CI_PERIOD]
	AdjustSI_MAX_CX
	retn
 @@1:	xor eax,eax
	mov cs:[si+CI_PERIOD],ax
	mov cs:[si+CI_MAX_CX],eax
	mov cs:[si+CI_REST],eax
	mov byte ptr cs:[si+CI_COMMAND],0
	retn
DoSlideUp ENDP




DoSlideDown PROC NEAR
	mov ax,cs:[si+CI_COM_VALUE]
	add cs:[si+CI_PERIOD],ax
	movzx ebx,word ptr cs:[si+CI_PERIOD]
	AdjustSI_MAX_CX
	retn
DoSlideDown ENDP




DoPortaUp PROC NEAR
	mov ax,cs:[si+CI_COM_VALUE]
	sub cs:[si+CI_PERIOD],ax
	mov ax,cs:[si+CI_DESTINATION]	;AX=Destination
	cmp cs:[si+CI_PERIOD],ax	;Has it reached its destination ?
	jg short @@1                	;JB: No, continue effect
	mov cs:[si+CI_PERIOD],ax	;Yes, stop effect
	mov byte ptr cs:[si+CI_COMMAND],0
  @@1:  movzx ebx,word ptr cs:[si+CI_PERIOD]
	AdjustSI_MAX_CX
	retn
DoPortaUp ENDP




DoPortaDown PROC NEAR
	mov ax,cs:[si+CI_COM_VALUE]
	add cs:[si+CI_PERIOD],ax
	mov ax,cs:[si+CI_DESTINATION]	;AX=Destination
	cmp cs:[si+CI_PERIOD],ax	;Has it reached its destination ?
	jb short @@1			;JB: No, continue effect
	mov cs:[si+CI_PERIOD],ax	;Yes, stop effect
	mov byte ptr cs:[si+CI_COMMAND],0
  @@1:  movzx ebx,word ptr cs:[si+CI_PERIOD]
	AdjustSI_MAX_CX
	retn
DoPortaDown ENDP




DoArpeggio PROC NEAR
	mov al,cs:[si+CI_COM_VALUE]
	test al,al			;First period
	jnz short Arp1
	  mov byte ptr cs:[si+CI_COM_VALUE],1
	  movzx ebx,word ptr cs:[si+CI_ARP_2]
	  jmp short Do_Arpeggio
      Arp1:
	cmp al,1			;First period
	jne short Arp2
	  mov byte ptr cs:[si+CI_COM_VALUE],2
	  movzx ebx,word ptr cs:[si+CI_ARP_3]
	  jmp short Do_Arpeggio
      Arp2:
	  mov byte ptr cs:[si+CI_COM_VALUE],0
	  movzx ebx,word ptr cs:[si+CI_ARP_1]
      Do_Arpeggio:
	AdjustSI_MAX_CX
	retn
DoArpeggio ENDP




DoVibrato PROC NEAR
	mov ah,cs:[si+CI_VIB_FORM]
	mov dx,cs:[si+CI_VIB_POS]

	GET_WAVE 4
	movzx ebx,word ptr cs:[si+CI_PERIOD]	;EBX holds period
	add ebx,eax			;Add sine to period
	add dl,cs:[si+CI_VIB_SPEED]	;Get sine-increment
	mov cs:[si+CI_VIB_POS],dl	;Save Vibrato-position
	AdjustSI_MAX_CX
	retn
DoVibrato ENDP





DoFineVibrato PROC NEAR
	mov ah,cs:[si+CI_VIB_FORM]
	mov dx,cs:[si+CI_VIB_POS]

	GET_WAVE 2
	movzx ebx,word ptr cs:[si+CI_PERIOD]	;EBX holds period
	add ebx,eax			;Add sine to period
	add dl,cs:[si+CI_VIB_SPEED]	;Get sine-increment
	mov cs:[si+CI_VIB_POS],dl	;Save Vibrato-position
	AdjustSI_MAX_CX
	retn
DoFineVibrato ENDP




DoTremolo PROC NEAR
	mov ah,cs:[si+CI_TRM_FORM]
	mov dx,cs:[si+CI_TRM_POS]

	GET_WAVE 1
	add al,cs:[si+CI_VOLUME]	;Add sine to period
	jns short @@2
	xor al,al
	jmp short @@3
 @@2:   cmp al,64
	jb short @@3
	mov al,64
 @@3:	add dl,cs:[si+CI_TRM_SPEED]	;Get sine-increment
	mov cs:[si+CI_TRM_POS],dl	;Save Vibrato-position

	mov cs:[si+CI_REAL_VOLUME],bl
	retn
DoTremolo ENDP




DoRetrigger PROC NEAR
	dec byte ptr cs:[si+CI_TRG_POS]
	jz short @@1
	retn
 @@1:   or cs:[si+CI_FLAGS],CF_NEW_POSITION
	mov al,byte ptr cs:[si+CI_COM_VALUE]
	mov byte ptr cs:[si+CI_TRG_POS],al
	mov dword ptr cs:[si+CI_POSITION],0
	mov dword ptr cs:[si+CI_GUS_POSITION],0
	movzx ebx,word ptr cs:[si+CI_PERIOD]
	AdjustSI_MAX_CX
	retn
DoRetrigger ENDP




DoNoteCut PROC NEAR
	dec byte ptr cs:[si+CI_COM_VALUE]
	jnz short @@1
	xor ax,ax
	mov word ptr cs:[si+CI_VOLUME],ax
	mov byte ptr cs:[si+CI_COMMAND],al
 @@1:	retn
DoNoteCut ENDP




DoNoteDelay PROC NEAR
	retn
DoNoteDelay ENDP



DoTremor PROC NEAR
	mov al,cs:[si+CI_TRM_POS]
	inc al
	cmp al,cs:[si+CI_TRM_OFF]
	ja short @@1
	cmp al,cs:[si+CI_TRM_ON]
	ja short @@2
	mov cs:[si+CI_TRM_POS],al
	retn

 @@1:   xor al,al
	mov cs:[si+CI_TRM_POS],al
	mov al,cs:[si+CI_VOLUME]
	mov cs:[si+CI_REAL_VOLUME],al
	retn
 @@2:   mov cs:[si+CI_TRM_POS],al
	xor ax,ax
	mov word ptr cs:[si+CI_VOLUME],ax
	retn
DoTremor ENDP




DoVolumeSlide PROC NEAR
	Volume_SlideM 0
	retn
DoVolumeSlide ENDP



DoVolumeSlide_n_Vibrato PROC NEAR
	Volume_SlideM 5
	mov ah,cs:[si+CI_VIB_FORM]
	mov dx,cs:[si+CI_VIB_POS]

	GET_WAVE 4
	movzx ebx,word ptr cs:[si+CI_PERIOD]	;EBX holds period
	add ebx,eax			;Add sine to period
	add dl,cs:[si+CI_VIB_SPEED]	;Get sine-increment
	mov cs:[si+CI_VIB_POS],dl	;Save Vibrato-position
	AdjustSI_MAX_CX
	retn
DoVolumeSlide_n_Vibrato ENDP




DoVolumeSlide_n_PortaDown PROC NEAR
	Volume_SlideM 4
	movzx ax,cs:[si+CI_COM_VALUE]
	add cs:[si+CI_PERIOD],ax
	mov ax,cs:[si+CI_DESTINATION]	;AX=Destination
	cmp cs:[si+CI_PERIOD],ax	;Has it reached its destination ?
	jb short @@1			;JB: No, continue effect
	mov cs:[si+CI_PERIOD],ax	;Yes, stop effect
	mov byte ptr cs:[si+CI_COMMAND],13
  @@1:  movzx ebx,word ptr cs:[si+CI_PERIOD]
	AdjustSI_MAX_CX
	retn
DoVolumeSlide_n_PortaDown ENDP




DoVolumeSlide_n_PortaUp PROC NEAR
	Volume_SlideM 3
	movzx ax,cs:[si+CI_COM_VALUE]
	sub cs:[si+CI_PERIOD],ax
	mov ax,cs:[si+CI_DESTINATION]	;AX=Destination
	cmp cs:[si+CI_PERIOD],ax	;Has it reached its destination ?
	ja short @@1                	;JB: No, continue effect
	mov cs:[si+CI_PERIOD],ax	;Yes, stop effect
	mov byte ptr cs:[si+CI_COMMAND],13
  @@1:  movzx ebx,word ptr cs:[si+CI_PERIOD]
	AdjustSI_MAX_CX
	retn
DoVolumeSlide_n_PortaUp ENDP




DoInverse PROC NEAR
;	or cs:[si+CI_FLAGS],CF_NEW_OFFSET	;This one is needed for GUS
	dec byte ptr cs:[si+CI_REV_POS]
	jnz short @@1
	movzx ebx,byte ptr cs:[si+CI_REV_SPEED]
	movzx eax,gs:[CDMI_DMA_Size]
	mul ebx
	mov cs:[si+CI_MAX_CX],eax
	mov cs:[si+CI_REV_POS],bl
	movzx eax,word ptr cs:[si+CI_REV_SIZE]
	sub cs:[si+CI_POSITION],eax
	jns short @@1
	mov dword ptr cs:[si+CI_REST],0
@@1:	retn
DoInverse ENDP




DoTraeller PROC NEAR
	dec byte ptr cs:[si+CI_COM_VALUE+1]
	jz short @@3
	retn
  @@3:  mov al,cs:[si+CI_COM_VALUE]
	mov cs:[si+CI_COM_VALUE+1],al
	mov al,cs:[si+CI_TRL_POS]
	test al,al			;First period
	jnz short @@1
	  mov byte ptr cs:[si+CI_TRL_POS],1
	  movzx ebx,word ptr cs:[si+CI_ARP_1]
	  jmp short @@2
  @@1:    mov byte ptr cs:[si+CI_TRL_POS],0
	  movzx ebx,word ptr cs:[si+CI_ARP_2]
  @@2:  AdjustSI_MAX_CX
	retn
DoTraeller ENDP





DoMultiRetrigger PROC NEAR
	dec byte ptr cs:[si+CI_TRG_POS]
	jz short @@1
	retn
 @@1:	mov ax,cs:[si+CI_COM_VALUE]
	mov byte ptr cs:[si+CI_TRG_POS],al
	mov al,cs:[si+CI_VOLUME]
	cmp ah,5
	jb short @@2
	ja short @@V1
	mov cl,ah
	dec cl
	mov ah,1
	shl ah,cl
	sub al,ah
	jmp short @@E

 @@V1:	cmp ah,6
	jne short @@V2
	mov ah,al
	shr ah,2		;3/4 of original volume
	sub al,ah
	jmp short @@E

 @@V2:	cmp ah,7
	jne short @@V3
	shr al,1		;1/2 of original volume
	jmp short @@E

 @@V3:  cmp ah,8		;Not defined !
	je short @@2
	cmp ah,0dh
	ja short @@V4
	sub ah,0dh
	mov cl,ah
	mov ah,1
	shl ah,cl
	add al,ah
	jmp short @@E

 @@V4:  cmp ah,0eh
	ja short @@V5
	mov ah,al
	shl al,1
	add al,ah
	shr al,1		;*3/2
	jmp short @@E

 @@V5:  shl al,1


 @@E:   cmp al,64
	jbe short @@Ok
	mov al,64
	jg short @@Ok
	xor al,al
 @@Ok:	mov ah,al
	mov cs:[si+CI_VOLUME],ax
 @@2:	mov dword ptr cs:[si+CI_POSITION],0
	mov dword ptr cs:[si+CI_GUS_POSITION],0
	or cs:[si+CI_FLAGS],CF_NEW_POSITION
	movzx ebx,word ptr cs:[si+CI_PERIOD]
	AdjustSI_MAX_CX
	retn
DoMultiRetrigger ENDP





DoPanningSlideRight PROC NEAR
	mov al,cs:[si+CI_COM_VALUE]
	add cs:[si+CI_BALANCE],al
	jc short @@1
	retn
@@1:	mov byte ptr cs:[si+CI_BALANCE],255
	mov byte ptr cs:[si+CI_COMMAND],0
	retn
DoPanningSlideRight ENDP




DoPanningSlideLeft PROC NEAR
	mov al,cs:[si+CI_COM_VALUE]
	sub cs:[si+CI_BALANCE],al
	jc short @@1
	retn
@@1:	mov byte ptr cs:[si+CI_BALANCE],0
	mov byte ptr cs:[si+CI_COMMAND],0
	retn
DoPanningSlideLeft ENDP





;[]-------------------------------------------------------------------------[]
;|
;| This MACRO processes an envelope of the instrument and saves the result
;| in the appropriate field of the Channel_Info
;|
;| envtype can be: IF_VOLUME_ENVELOPE
;|             or  IF_PANNING_ENVELOPE
;|
Process_Envelope MACRO envtype
	LOCAL ENDE,L1,L2,NORM,OK,J1,J2

	testflag dword ptr cs:[si+CI_FLAGS],envtype
	jz ENDE

	mov ebx,cs:[si+CI_ENVELOPE_ADDRESS]
	if envtype eq IF_VOLUME_ENVELOPE
		envsus 		equ	IF_VOLUME_ENVELOPE_SUSTAIN
		envloop		equ	IF_VOLUME_ENVELOPE_LOOP
		envpos		equ	CI_VENVELOPE_POS
		envdest		equ	CI_ENVELOPE_VOLUME
	else
		envsus 		equ	IF_PANNING_ENVELOPE_SUSTAIN
		envloop		equ	IF_PANNING_ENVELOPE_LOOP
		envpos		equ	CI_PENVELOPE_POS
		envdest		equ	CI_ENVELOPE_PANNING

		add ebx,IH_PENVELOPE-IH_VENVELOPE
	endif

	mov ax,cs:[si+envpos]
	inc ax

	testflag dword ptr cs:[si+CI_FLAGS],envsus
	jz short L1
	cmp word ptr cs:[si+CI_FADE_POS],0
	jne short L1
	movzx ecx,word ptr ds:[ebx+2]
	mov cx,ds:[ebx+4*ecx+8]		;Get sustain point
	cmp ax,cx
	jbe short L1
	mov ax,cx
	jmp short Ok

L1:	testflag dword ptr cs:[si+CI_FLAGS],envloop
	jz short Norm
	movzx ecx,word ptr ds:[ebx+6]
	mov cx,ds:[ebx+4*ecx+8]		;Get loop end point
	cmp ax,cx
	jbe short Ok
	movzx ecx,word ptr ds:[ebx+4]	;Get loop start point
	mov ax,ds:[ebx+4*ecx+8]		;
	jmp short Ok

Norm:	movzx ecx,word ptr ds:[ebx]
	mov cx,ds:[ebx+4*ecx+8]		;Get last point
	cmp ax,cx
	jb short Ok
	mov ax,cx
Ok:	mov cs:[si+envpos],ax

	;
	;Now the volume will be calulate within the envelope
	;
L2:  	add ebx,4			;Get the current position
	cmp ax,ds:[ebx+4]
	ja short L2
	jne short J2

J1:	mov ax,ds:[ebx+6]		;Get volume
	mov cs:[si+envdest],al
	jmp short ENDE

J2:	mov cx,ds:[ebx+6]	    	;CX = Y2
	sub cx,ds:[ebx+2]               ;CX = Y2-Y1
	sub ax,ds:[ebx]			;AX = X-X1
	imul cx				;DX:AX contains delta
	mov cx,ds:[ebx+4]		;CX = X2
	sub cx,ds:[ebx]			;CX = X2-X1
	idiv cx                         ;AX = (Y2-Y1)/(X2-X1)*(X-X1)
	add ax,ds:[ebx+2]		;AX = Y(X)+Y1
	mov cs:[si+envdest],al
ENDE:
       ENDM




;[]-------------------------------------------------------------------------[]
;|
;| The follwoing routine will be called once every tick. This routine then
;| calls the mixing routines and the effect routines (DoXxxxxx).
;|
Calc_Buffer PROC NEAR
	mov edi,gs:[CDMI_DMA_Address]
	test edi,edi
	jz short @@3
	GET_BUFFER_SIZE
	xor eax,eax
	shr ecx,2
	rep stos dword ptr es:[edi]			;Clear DMA-Buffer

@@3:	mov cx,gs:[CDMI_Channels]
	mov cs:[Current_Channel],0
	mov si,OFFSET Channel_Info
   Channel_Loop:
		push cx
		mov ax,cs:[Current_Channel]
		bt word ptr gs:[CDMI_Channel_Flags],ax
		jnc short @@1
		call cs:[Mixing]


		;
		;Now the volume envelope position will be calculated
		;
	@@1:    Process_Envelope IF_VOLUME_ENVELOPE
		Process_Envelope IF_PANNING_ENVELOPE


		;
		;Last but not least, the effect will be applied
		;
		movzx bx,cs:[si+CI_COMMAND]	;Get number
		shl bx,1			;Make index
		jz short @@5			;Zero (no effect) ???
		call word ptr cs:[OFFSET CommandTable+bx]

		;
		;The second part of the loop
		;
	@@5:	pop cx				;Next entry
		add si,CI_ENTRY_SIZE
		inc cs:[Current_Channel]
		dec cx
   jnz Channel_Loop

	;
	;Now the one (or two) effect channels will be mixed in
	;
	ifndef SHAREWARE
	mov si,OFFSET Channel_Info+FX_CHANNELS*CI_ENTRY_SIZE
	call cs:[Mixing]
;	inc cs:[Current_Channel]
;	add si,CI_ENTRY_SIZE
;	call cs:[Mixing]

	testflag gs:[CDMI_Flags],CDMI_USE_REVERB
	jz short @@2
	FILL_REVERB_BUFFER
	call Reverb_Engine
	endif

@@2:	call cs:[Filters]
	call cs:[Postprocessing]
	retn
Calc_Buffer ENDP






;[]-------------------------------------------------------------------------[]
;|
;| This macro increments the Tick-count and decides, whether a new note has
;| to be processed. It also calls the buffer-mixing routines.
;| Use this MACRO if you want to advance one tick.
;| DS must contain zero before you use this macro !!!
;|

Next_Tick MACRO
	LOCAL @1
	mov ax,cs:[BPM_Count]
	add ax,gs:[CDMI_Tempo]
	xor dx,dx
	div cs:[BPM_Divider]
	mov cs:[BPM_Count],dx
	sub cs:[Ticks_Left],ax
	jnbe short @1
	mov ax,gs:[CDMI_Speed]
	add cs:[Ticks_left],ax
	call Next_Beat
 @1:
	ENDM





;[]-------------------------------------------------------------------------[]
;|
;| The next two routines are used in DMA-Mode only. In DMA-Mode a bigger
;| block consisting out of more than one Tick is transfered by the soundcard
;| at once. But instead of calculating the music when the DMA-Interrupt
;| is called, a new Interrupt will be activated about 50-60 times per second.
;| This is the CDMI_Timer_Interrupt. In this inetrrupt, the next buffer will
;| be calculated. When the DMA-Buffer is ready, the flag BUFFER_READY_FLAG in
;| the CDMI_Flags will be set.
;| But there will be still a DMA-Interrupt, which changes the buffer-pointer
;| for the Music-Interrupt and which tells the CDMI that a new buffer is
;| played and that the old buffer must get filled again. It also clears the
;| BUFFER_READY_FLAG.
;|

CDMI_Timer_Interrupt PROC NEAR
	pushad
	mov al,20h
	out 20h,al
	cmp cs:[Busy],1
	je @@1
	mov cs:[Busy],1
	push ds
	push es
	push fs
	push gs
	cld
	sti

	xor ax,ax
	mov ds,ax
	mov es,ax
	mov ax,SEG CDMI_Pattern_No
	mov gs,ax				;GS points to DATA-Segment
	inc gs:[CDMI_Tick]
	testflag gs:[CDMI_Flags],CDMI_USE_POLLING
	jnz @@Poll
	testflag gs:[CDMI_Flags],CDMI_BUFFER_READY_FLAG
	jz short @@2
	cmp cs:[Buffer_Tick_No],4
	ja short @@4

  @@2:	movzx eax,cs:[DMA_Increment]
	add gs:[CDMI_DMA_Address],eax
	inc cs:[Buffer_Tick_No]
	mov ax,cs:[Buffer_Tick_No]
	cmp ax,cs:[Buffer_Ticks]
	jb short @@3
	mov cs:[Buffer_Tick_No],0
	mov eax,cs:[Buffer_One]
	add eax,10h
	mov gs:[CDMI_DMA_Address],eax
	or gs:[CDMI_Flags],CDMI_BUFFER_READY_FLAG

  @@3:	call Calc_Buffer
	Next_Tick

  @@4:  testflag gs:[CDMI_Flags],CDMI_SUPPORT_INT8
	jz short @@5
	mov ax,cs:[Timer_Inc]
	add cs:[Timer_Pos],ax
	jnc short @@5
		pop gs
		pop fs
		pop es
		pop ds
		mov cs:[Busy],0
		popad
		jmp cs:[Old_Timer]
  @@5:	pop gs
	pop fs
	pop es
	pop ds
	mov cs:[Busy],0
  @@1:  popad
	iret


  @@Poll:
	inc gs:[CDMI_Poll_Counter]
	jmp short @@4
CDMI_Timer_Interrupt ENDP





CDMI_DMA_Interrupt PROC FAR
	mov ax,SEG CDMI_Pattern_No
	mov ds,ax

	call cs:[Sound_Continue] C,dword ptr cs:[Buffer_One]
	and ds:[CDMI_Flags],NOT CDMI_BUFFER_READY_FLAG

	retf
CDMI_DMA_Interrupt ENDP






;[]-------------------------------------------------------------------------[]
;|
;| This interrupt-routine is used for sound-devices that already use the
;| timer-interrupt. Here this routine will be called, when the sound-driver
;| is ready with a block and begins to play the next block. The block size
;| corresponds exactly to one Tick. That makes it very different from the
;| DMA-Mode where more ticks are played in one block.
;|
;| Note that this handler has to end with a retf-command instead of a iret
;| command, because it is called from inside the driver-interrupt.
;|

CDMI_Song_Interrupt PROC FAR
	push gs
	cld

	mov ax,SEG CDMI_Pattern_No
	mov gs,ax				;GS points to DATA-Segment
	xor ax,ax
	mov ds,ax				;DS is set up for linear addressing

	inc gs:[CDMI_Tick]
	sub gs:[CDMI_DMA_Address],16
	mov eax,cs:[Buffer_One]
	cmp eax,gs:[CDMI_DMA_Address]
	jne short NowBufferOne
		mov eax,cs:[Buffer_Two]
    NowBufferOne:
	add eax,16
	mov gs:[CDMI_DMA_Address],eax
	sub eax,16
	call cs:[Sound_Continue] C,eax		;Set_Next_Block
	xor ax,ax
	mov es,ax
	call Calc_Buffer
	Next_Tick

	testflag gs:[CDMI_Flags],CDMI_SUPPORT_INT8
	jz short @@5
	mov ax,cs:[Timer_Inc]
	add cs:[Timer_Pos],ax
	jnc short @@5
		pushf
		call cs:[Old_Timer]

@@5:	pop gs
	retf
CDMI_Song_Interrupt ENDP





;[]-------------------------------------------------------------------------[]
;|
;| The following interrupt is for wavetable cards like the GUS
;|

CDMI_Wave_Interrupt PROC FAR
	pushad
	mov al,20h
	out 20h,al
	push ds
	push es
	push fs
	push gs
	cld
	sti

	mov ax,SEG CDMI_Flags
	mov gs,ax
	inc gs:[CDMI_Tick]

	xor ax,ax
	mov ds,ax
	mov es,ax

	call Calc_Buffer
	Next_Tick

	testflag gs:[CDMI_Flags],CDMI_SUPPORT_INT8
	jz short @@5
	mov ax,cs:[Timer_Inc]
	add cs:[Timer_Pos],ax
	jnc short @@5
		pop gs
		pop fs
		pop es
		pop ds
		mov cs:[Busy],0
		popad
		jmp cs:[Old_Timer]
  @@5:	pop gs
	pop fs
	pop es
	pop ds
	popad
	iret
CDMI_Wave_Interrupt ENDP





;[]------------------------------------------------------------------------[]
;|
;| The routines that follow now, are the front-end routines for use in your
;| program. YOu should only call these routines and NOT any other routine
;| above.
;|
TBLOCK SOUND_BLOCK <0,0,0,0>

PUBLIC C CDMI_Play_Song
CDMI_Play_Song PROC
	ARG freq:word,options:word,SndDrv:dword
	push bp
	mov bp,sp
	push ds
	push esi
	push edi
	push ebp

	;
	; First lets free some buffers that may still be allocated....
	;
	cmp cs:[Buffer_One],0		;Wenn nicht 0,dann ist dies ein Speicherblock
	je short Is_free1
	call EXT_Free C,cs:[Buffer_One]	;Freigeben...
	mov cs:[Buffer_One],0		;0 setzen
     Is_free1:
	cmp cs:[Buffer_Two],0
	je short Is_free2
	call EXT_Free C,cs:[Buffer_Two]
	mov cs:[Buffer_Two],0
     Is_free2:
	cmp cs:[Boost_Table],0
	je short Is_free3
	call EXT_Free C,cs:[Boost_Table]
	mov cs:[Boost_Table],0
     Is_free3:
	cmp cs:[Volume_Table],0
	je short Is_free4
	call EXT_Free C,cs:[Volume_Table]
	mov cs:[Volume_Table],0
     Is_free4:
	cmp cs:[Reverb_Ptr],0
	je short Is_free5
	call EXT_Free C,cs:[Reverb_Ptr]
	mov cs:[Reverb_Ptr],0
     Is_free5:
	cmp cs:[Empty_Pattern],0
	je short Is_free6
	call EXT_Free C,cs:[Empty_Pattern]
	mov cs:[Empty_Pattern],0
     Is_free6:

	mov ax,SEG CDMI_Song
	mov gs,ax
	mov esi,gs:[CDMI_Song]
	xor ax,ax
	mov es,ax

	movzx eax,word ptr es:[esi+SH_PATTERN_SIZE]
	call EXT_Malloc C,eax
	test eax,eax
	jz short @@E1
	mov cs:[Empty_Pattern],eax
	mov edi,eax
	movzx ecx,word ptr es:[esi+SH_PATTERN_SIZE]
	xor eax,eax
	shr ecx,2
	rep stos dword ptr es:[edi]

	call Get_Flat_Interrupt C,8
	mov cs:[Old_Timer],eax


	;
	;Now lets get the device-header information
	;
	lds si,[SndDrv]
	cmp dword ptr ds:[si+DRV_TYPE],"NUOS"
	je short @@Is_Sound
	cmp dword ptr ds:[si+DRV_TYPE],"EVAW"
	je @@Is_Wave

@@E1:	mov ax,FALSE
	pop ebp
	pop edi
	pop esi
	pop ds
	pop bp
	retf				;Error: Strange device !



	;
	;Now the initialisation routines for normal sound cards
	;begin here
	;
@@Is_Sound:
	mov eax,ds:[si+DRV_START]	;Get all driver functions needed...
	mov cs:[Sound_Start],eax
	mov eax,ds:[si+DRV_CONTINUE]
	mov cs:[Sound_Continue],eax
	mov eax,ds:[si+DRV_STOP]
	mov cs:[Sound_End],eax
	mov eax,ds:[si+DRV_SET_INTERRUPT]
	mov cs:[Sound_Interrupt],eax
	mov eax,ds:[si+DRV_CAPABILITIES]
	mov cs:[Sound_Flags],eax
	testflag eax,SOUND_USES_TIMER	;Does the device use already the timer
	jnz short @@Ok8
	or [options],CDMI_TIMER_MODE
@@Ok8:

	;
	;Now lets setup a test block for the sound-device
	;
	mov cs:[TBLOCK.SND_SIZE],0
	mov ax,[freq]			;playing frequency
	mov cs:[TBLOCK.SND_FREQUENCY],ax
	mov al,1
	testflag [options],CDMI_USE_STEREO
	jz short @@7
	inc al
@@7:	mov cs:[TBLOCK.SND_CHANNELS],al
	mov al,8
	testflag [options],CDMI_USE_16_BIT
	jz short @@8
	mov al,16
@@8:	mov cs:[TBLOCK.SND_RESOLUTION],al

	xor eax,eax
	xor ebx,ebx
	mov ax,cs
	mov bx,OFFSET TBLOCK
	shl eax,4
	add eax,ebx
	call cs:[Sound_Start] C,eax
	and [options],NOT (CDMI_USE_STEREO or CDMI_USE_16_BIT)
	cmp cs:[TBLOCK.SND_CHANNELS],2
	jb short @@9
	or [options],CDMI_USE_STEREO
@@9:	cmp cs:[TBLOCK.SND_RESOLUTION],16
	jb short @@A
	or [options],CDMI_USE_16_BIT
@@A:

	cli
	cld
	mov bx,SEG CDMI_Pattern_No
	mov gs,bx			;GS zeigt auf Datensegment
	mov ax,cs:[TBLOCK.SND_FREQUENCY]
	mov gs:[CDMI_Sample_Rate],ax

	xor ax,ax
	mov ds,ax
	mov esi,gs:[CDMI_Song]
	mov cx,ds:[esi+SH_START_SPEED]	;Song-Speed
	mov gs:[CDMI_Speed],cx		;Number of ticks per beat
	mov cs:[Ticks_Left],cx		;Number of ticks left
	mov ax,ds:[esi+SH_SAMPLE_FREQ]	;Sample frequency
	mov cs:[Sample_Freq],ax
	mov ax,ds:[esi+SH_START_TEMPO]	;BPM
	mov gs:[CDMI_Tempo],ax
	mov dx,18
	xor ax,ax
	mov bx,ds:[esi+SH_TICKS_PER_SECOND]
	mov gs:[CDMI_Tick_Speed],bx
	div bx
	mov cs:[Timer_Inc],ax
	mov cs:[Timer_Pos],0
	mov ax,ds:[esi+SH_START_VOLUME]
	mov gs:[CDMI_Volume],ax
	mov ax,ds:[esi+SH_CHANNELS]
	mov gs:[CDMI_Channels],ax

	SETUP_CHANNELS
	mov edx,0d8h                     ;
	mov eax,7c3a6664h		;3546894,6 shl 18
	movzx ecx,gs:[CDMI_Sample_Rate]
	div ecx
	xor edx,edx
	movzx ecx,word ptr ds:[esi+SH_SAMPLE_FREQ]
	div ecx
	mov cs:[Period_Factor],eax
	mov cs:[BPM_Divider],125
	mov cs:[BPM_Count],0

	mov ax,gs:[CDMI_Sample_Rate]
	xor dx,dx
	div gs:[CDMI_Tick_Speed]	;Play_freq/Ticks_per_second
	and al,11111110b		;Make it aligned for dword-mode
	xor edx,edx
	mov gs:[CDMI_DMA_Size],ax	;Save the size for ONE tick
	mov cs:[DMA_Increment],ax
	mov gs:[CDMI_Entry_No],dx 	;Entry 0 will be played
	mov gs:[CDMI_Tick],dx
	mov gs:[CDMI_Sample_Volume],dx
	mov gs:[CDMI_Poll_Counter],dx
	mov gs:[CDMI_Reverb.RVB_Count],dx
	movzx ebx,[options]             ;Get options
	mov gs:[CDMI_Flags],ebx         ;Set options
	mov gs:[CDMI_Channel_Flags],0ffffffffh	;Turn on all channels
	mov cs:[Busy],dl
	mov cs:[COMMAND_Flags],dx
	mov cs:[REVERB_Count],dx
	mov cs:[LOOP_Count],dx


	mov cs:[Mixing],OFFSET Add_Voice_Mono
	mov cs:[Postprocessing],OFFSET Postprocess_10bit
	mov cs:[Filters],OFFSET Apply_Filters_Mono


;The following lines will be excluded in the shareware version. They include
;handling for linear interpolation, stereo and maybe (in some time) 16bit
;
	ifndef SHAREWARE
  @@1:	test bx,CDMI_QUALITY_MODE
	jz short @@3
	mov cs:[Mixing],OFFSET Add_Voice_Mono_Interpolated
	test bx,CDMI_USE_STEREO
	jz short @@4
	mov cs:[Mixing],OFFSET Add_Voice_Stereo_Interpolated
	mov cs:[Filters],OFFSET Apply_Filters_Stereo
	shl cs:[DMA_Increment],1
	test bx,CDMI_USE_FAST_PANNING
	jz short @@4
	mov cs:[Mixing],OFFSET Add_Voice_FastStereo_Interpolated
	jmp short @@4

  @@3:  test bx,CDMI_STEREO_MODE
	jz short @@4
	mov cs:[Mixing],OFFSET Add_Voice_Stereo
	mov cs:[Filters],OFFSET Apply_Filters_Stereo
	shl cs:[DMA_Increment],1
	test bx,CDMI_USE_FAST_PANNING
	jz short @@4
	mov cs:[Mixing],OFFSET Add_Voice_FastStereo

  @@4:	test bx,CDMI_USE_16_BIT
	jz short @@5
	mov cs:[Postprocessing],OFFSET Postprocess_16bit
	jmp short @@NoBoost
  @@5:
	endif


	;
	;And now lets save the old timer and lets allocate the buffers
	;again...
	;
	mov eax,1000h
	call EXT_Malloc C,eax
	mov cs:[Boost_Table],eax

  @@NoBoost:
	mov eax,8400h
	call EXT_Malloc C,eax
	mov cs:[Volume_Table],eax


	;
	;Now lets clear the reverb-buffers
	;
	ifndef SHAREWARE

	mov ax,SEG CDMI_Flags
	mov gs,ax
	testflag gs:[CDMI_Flags],CDMI_USE_REVERB	;Reverb-engine enabled ?
	jz short @@A8
	GET_BUFFER_SIZE
	fastimul ebx,ecx,64			;Memory for 64 ticks...
	push ebx
	call EXT_Malloc C,ebx
	mov cs:[Reverb_Ptr],eax
	mov edi,eax
	pop ecx
	shr ecx,2
	xor eax,eax
	mov es,ax
	rep stos dword ptr es:[edi]		;Clear reverb-buffer

	endif


  @@A8:	mov ax,SEG CDMI_DMA_Address
	mov gs,ax
	testflag gs:[CDMI_Flags],CDMI_TIMER_MODE
	jnz @@Setup_Timer_Mode


;These setup-procedures are for drivers, which already occupy the timer-
;interrupt. Here we use a double-buffer system.
	and gs:[CDMI_Flags],NOT CDMI_USE_POLLING
	mov ax,cs:[DMA_Increment]
	add ax,32
	shl ax,1
	push ax
	call EXT_DMA_Malloc C,ax              	;Puffer anfordern
	mov cs:[Buffer_One],eax        		;Adresse abspeichern
	add eax,10h
	mov dx,SEG CDMI_DMA_Address
	mov gs,dx
	mov gs:[CDMI_DMA_Address],eax		;Auch hier Adresse sichern

	pop ax
	call EXT_DMA_Malloc C,ax
	mov cs:[Buffer_Two],eax
	mov ax,SEG CDMI_DMA_Address
	mov gs,ax

	mov cl,cs:[TBLOCK.SND_RESOLUTION]
	mov ch,cs:[TBLOCK.SND_CHANNELS]
	mov edi,cs:[Buffer_One]
	mov ax,gs:[CDMI_Sample_Rate]
	mov bx,gs:[CDMI_DMA_Size]
	mov ds:[edi],ax
	mov ds:[edi+2],bx
	mov ds:[edi+4],cx
	mov edi,cs:[Buffer_Two]
	mov ds:[edi],ax
	mov ds:[edi+2],bx
	mov ds:[edi+4],cx

	call cs:[Sound_Interrupt] C,OFFSET CDMI_Song_Interrupt,cs
	jmp @@End_Setup


;This timer-mode links in to the timer interrupt the buffer-calc routines
;and uses the DMA-interrupt for transfer. Bigger blocks are transfered
;at a time for etter output quality
@@Setup_Timer_Mode:
	xor dx,dx
	mov ax,0f000h
	div cs:[DMA_Increment]
	dec ax
	mov cs:[Buffer_Ticks],ax
	mov cs:[Buffer_Tick_No],0
	and gs:[CDMI_Flags],NOT CDMI_BUFFER_READY_FLAG

	call EXT_DMA_Malloc C,0f020h           	;Puffer anfordern
	test eax,eax
	jz PlayEnde
	mov cs:[Buffer_One],eax        		;Adresse abspeichern
	add eax,10h
	mov dx,SEG CDMI_DMA_Address
	mov gs,dx
	mov gs:[CDMI_DMA_Address],eax		;Auch hier Adresse sichern

	mov cl,cs:[TBLOCK.SND_RESOLUTION]
	mov ch,cs:[TBLOCK.SND_CHANNELS]
	mov edi,cs:[Buffer_One]
	mov bx,gs:[CDMI_Sample_Rate]
	mov ax,gs:[CDMI_DMA_Size]
	mul cs:[Buffer_Ticks]
	mov ds:[edi],bx
	mov ds:[edi+2],ax
	mov ds:[edi+4],cx

	mov al,36h			;Select timer
	out 43h,al
	mov bx,gs:[CDMI_Tick_Speed]
	inc bx
	mov dx,12h
	mov ax,3333h                    ;Calculate timer constant
	div bx
	out 40h,al
	shr ax,8
	out 40h,al                      ;Set new timer speed

	call Set_Flat_Interrupt C,8,OFFSET CDMI_Timer_Interrupt,cs
	call cs:[Sound_Interrupt] C,OFFSET CDMI_DMA_Interrupt,cs



@@End_Setup:
	mov ax,SEG CDMI_DMA_Address
	mov gs,ax
	SETUP_VOLUME_TABLE
	SETUP_BOOST_TABLE
	START_PATTERN
	SETUP_PATTERN
	SETUP_BALANCE
	call Next_Beat
	call Calc_Buffer
	Next_Tick

	testflag gs:[CDMI_Flags],CDMI_TIMER_MODE
	jnz short @@6
	mov eax,cs:[Buffer_Two]
	add eax,16
	mov gs:[CDMI_DMA_Address],eax         	;Neue DMA-Adresse setzen
	call Calc_Buffer			;Nchstes Muster
	Next_Tick
	call cs:[Sound_Start] C,cs:[Buffer_One]
	call cs:[Sound_Continue] C,cs:[Buffer_Two]
	jmp PlayEnde

 @@6:	movzx eax,cs:[DMA_Increment]
	add gs:[CDMI_DMA_Address],eax         	;Neue DMA-Adresse setzen
	add cs:[Buffer_Tick_No],2
	call Calc_Buffer			;Nchstes Muster
	Next_Tick
	movzx eax,cs:[DMA_Increment]
	add gs:[CDMI_DMA_Address],eax         	;Neue DMA-Adresse setzen
	call Calc_Buffer			;Nchstes Muster
	Next_Tick
	call cs:[Sound_Start] C,cs:[Buffer_One]
	call cs:[Sound_Continue] C,cs:[Buffer_One]


 PlayEnde:
	pop ebp
	pop edi
	pop esi
	pop ds
	pop bp
	or cs:[COMMAND_Flags],COM_IS_PLAYING
	mov ax,TRUE
	sti
	retf



	;
	;These are the initialisation routines for wavetable-cards like GUS
	;
@@Is_Wave:
	cli
	cld
	mov eax,ds:[si+WAV_INIT_MEMORY]
	mov cs:[Wave_Init],eax
	mov eax,ds:[si+WAV_PLAY_SAMPLE]
	mov cs:[Wave_Play_Sample],eax
	mov eax,ds:[si+WAV_STOP_SAMPLE]
	mov cs:[Wave_Stop_Sample],eax
	mov eax,ds:[si+WAV_LOAD_SAMPLE]
	mov cs:[Wave_Load_Sample],eax
	mov eax,ds:[si+WAV_SET_INTERRUPT]
	mov cs:[Wave_Interrupt],eax
	mov eax,ds:[si+WAV_STOP_ALL]
	mov cs:[Wave_Stop_All],eax
	mov bx,SEG CDMI_Pattern_No
	mov gs,bx			;GS zeigt auf Datensegment

	xor ax,ax
	mov ds,ax
	mov esi,gs:[CDMI_Song]
	mov cx,ds:[esi+SH_START_SPEED]	;Song-Speed
	mov gs:[CDMI_Speed],cx		;Number of ticks per beat
	mov cs:[Ticks_Left],cx		;Number of ticks left
	mov ax,ds:[esi+SH_SAMPLE_FREQ]	;Sample frequency
	mov cs:[Sample_Freq],ax
	mov ax,ds:[esi+SH_START_TEMPO]	;BPM
	mov gs:[CDMI_Tempo],ax
	mov dx,18
	xor ax,ax
	mov bx,ds:[esi+SH_TICKS_PER_SECOND]
	mov gs:[CDMI_Tick_Speed],bx
	div bx
	mov cs:[Timer_Inc],ax
	mov cs:[Timer_Pos],0
	mov ax,ds:[esi+SH_START_VOLUME]
	mov gs:[CDMI_Volume],ax
	mov ax,ds:[esi+SH_CHANNELS]
	mov gs:[CDMI_Channels],ax

	SETUP_CHANNELS
	mov edx,0d8h                     ;
	mov eax,7c3a6664h		;3546894,6 shl 18
	mov ecx,12000
	div ecx
	xor edx,edx
	movzx ecx,word ptr ds:[esi+SH_SAMPLE_FREQ]
	div ecx
	mov cs:[Period_Factor],eax
	mov cs:[BPM_Divider],125
	mov cs:[BPM_Count],0

	xor edx,edx
	mov gs:[CDMI_Sample_Rate],12000	;Save the size for ONE tick
	mov gs:[CDMI_DMA_Address],edx	;Save the size for ONE tick
	mov gs:[CDMI_DMA_Size],dx	;Save the size for ONE tick
	mov cs:[DMA_Increment],dx
	mov gs:[CDMI_Entry_No],dx 	;Entry 0 will be played
	mov gs:[CDMI_Tick],dx
	mov gs:[CDMI_Sample_Volume],dx
	mov gs:[CDMI_Poll_Counter],dx
	mov gs:[CDMI_Reverb.RVB_Count],dx
	movzx ebx,[options]             ;Get options
	and ebx,(NOT CDMI_USE_STEREO) and (NOT CDMI_USE_16BIT) and (NOT CDMI_USE_REVERB) and (NOT CDMI_USE_POLLING)
	or ebx,CDMI_WAVE_TABLE or CDMI_TIMER_MODE
	mov gs:[CDMI_Flags],ebx         ;Set options
	mov gs:[CDMI_Channel_Flags],0ffffffffh	;Turn on all channels
	mov cs:[Busy],dl
	mov cs:[COMMAND_Flags],dx
	mov cs:[REVERB_Count],dx
	mov cs:[LOOP_Count],dx

	mov cs:[Mixing],OFFSET Add_Voice_Wave
	mov cs:[Postprocessing],OFFSET Postprocess_Nothing
	mov cs:[Filters],OFFSET Apply_No_Filters


	;
	;Now lets start loading all samples into the WaveTable-Memory
	;
	mov esi,gs:[CDMI_Song]
	mov ax,word ptr ds:[esi+SH_CHANNELS]
	inc ax
	call cs:[Wave_Init] C,ax
	mov cx,MAX_SAMPLES
@@LoadSamples:
	mov eax,ds:[esi+IH_SIZE]
	test eax,eax
	jz short @@Nothing

	push cx
	call cs:[Wave_Load_Sample] C,dword ptr ds:[esi+IH_ADDRESS],dword ptr ds:[esi+IH_SIZE],0
	pop cx
	cmp eax,0ffffffffh
	je @@Error
	mov ds:[esi+IH_GUS_HANDLE],eax

@@Nothing:
	add esi,INSTRUMENT_HEADER_SIZE
	dec cx
	jnz short @@LoadSamples

	mov ax,SEG CDMI_DMA_Address
	mov gs,ax
	mov esi,gs:[CDMI_Song]


	;
	;Now lets test if normal mixing should be supported
	;
	testflag gs:[CDMI_Flags],CDMI_MIX_ALWAYS
	jz @@N1

	mov cs:[Mixing],OFFSET Add_Voice_Wave_and_Mono
	mov cs:[Postprocessing],OFFSET Postprocess_10bit
	mov ax,12000
	xor dx,dx
	div gs:[CDMI_Tick_Speed]	;Play_freq/Ticks_per_second
	and al,11111110b		;Make it aligned for dword-mode
	mov gs:[CDMI_DMA_Size],ax	;Save the size for ONE tick
	mov cs:[DMA_Increment],ax

	mov eax,8400h
	call EXT_Malloc C,eax
	mov cs:[Volume_Table],eax

	mov eax,1000h
	call EXT_Malloc C,eax
	mov cs:[Boost_Table],eax

	movzx eax,cs:[DMA_Increment]
	add eax,32
	shl eax,1
	call EXT_Malloc C,eax              	;Puffer anfordern
	mov cs:[Buffer_One],eax        		;Adresse abspeichern
	mov dx,SEG CDMI_DMA_Address
	mov gs,dx
	mov gs:[CDMI_DMA_Address],eax		;Auch hier Adresse sichern
	SETUP_VOLUME_TABLE
	SETUP_BOOST_TABLE


	;
	;Here we install the new timer interrupt for the GUS
	;
@@N1:   mov ax,SEG CDMI_DMA_Address
	mov gs,ax
	mov al,36h			;Select timer
	out 43h,al
	mov bx,gs:[CDMI_Tick_Speed]
	mov dx,12h
	mov ax,3333h                    ;Calculate timer constant
	div bx
	out 40h,al
	shr ax,8
	out 40h,al                      ;Set new timer speed
	call Set_Flat_Interrupt C,8,OFFSET CDMI_Wave_Interrupt,cs


	;
	;Now lets initialize some patterns etc...
	;
	mov ax,SEG CDMI_DMA_Address
	mov gs,ax
	START_PATTERN
	SETUP_PATTERN
	SETUP_BALANCE

	call Next_Beat
	call Calc_Buffer
	Next_Tick

	pop ebp
	pop edi
	pop esi
	pop ds
	pop bp
	or cs:[COMMAND_Flags],COM_IS_PLAYING
	mov ax,TRUE
	sti
	retf

@@Error:
	pop ebp
	pop edi
	pop esi
	pop ds
	pop bp
	mov ax,FALSE
	sti
	retf
CDMI_Play_Song ENDP






PUBLIC C CDMI_Stop_Song
CDMI_Stop_Song PROC
	testflag cs:[COMMAND_FLAGS],COM_IS_PLAYING
	jz @@Ende

	push ds
	cli

	mov ax,seg CDMI_Flags
	mov gs,ax
	testflag gs:[CDMI_Flags],CDMI_WAVE_TABLE
	jnz short @@Wave
	;
	;This is the SB,AdLib etc. specific end
	;
	call cs:[Sound_End]
	call cs:[Sound_Interrupt] C,0,0
	jmp @@Cont


@@Wave: ;
	;This is the wavetable specific end (like GUS)
	;
	call cs:[Wave_Stop_All]
	call cs:[Wave_Interrupt] C,0,0


@@Cont:	call Set_Flat_Interrupt C,8,cs:[Old_Timer]
	mov al,36h			;Select timer
	out 43h,al
	mov al,0ffh
	out 40h,al
	out 40h,al                      ;Set new timer speed

	cmp cs:[Buffer_One],0
	je short @@1
	call EXT_Free C,cs:[Buffer_One]
	mov cs:[Buffer_One],0
     @@1:
	cmp cs:[Buffer_Two],0
	je short @@2
	call EXT_Free C,cs:[Buffer_Two]
	mov cs:[Buffer_Two],0
     @@2:
	cmp cs:[Boost_Table],0
	je short @@3
	call EXT_Free C,cs:[Boost_Table]
	mov cs:[Boost_Table],0
     @@3:
	cmp cs:[Volume_Table],0
	je short @@4
	call EXT_Free C,cs:[Volume_Table]
	mov cs:[Volume_Table],0
     @@4:
	cmp cs:[Reverb_Ptr],0
	je short @@5
	call EXT_Free C,cs:[Reverb_Ptr]
	mov cs:[Reverb_Ptr],0
     @@5:
	cmp cs:[Empty_Pattern],0
	je short @@6
	call EXT_Free C,cs:[Empty_Pattern]
	mov cs:[Empty_Pattern],0
     @@6:

	pop ds
@@Ende: mov ax,seg CDMI_Flags
	mov gs,ax
	mov gs:[CDMI_FLags],0
	mov gs:[CDMI_DMA_Address],0
	mov gs:[CDMI_DMA_Size],0
	mov gs:[CDMI_Volume],0
	mov gs:[CDMI_Pattern_No],0
	mov gs:[CDMI_Beat_No],0
	mov gs:[CDMI_Entry_No],0

	and cs:[COMMAND_Flags],NOT COM_IS_PLAYING
	mov ax,TRUE
	retf
CDMI_Stop_Song ENDP






PUBLIC C CDMI_Play_Sample
CDMI_Play_Sample PROC
	ifdef SHAREWARE
	retf
	else
	ARG SAMPLE:WORD,Note:word
	push bp
	mov bp,sp
	push esi
	push edi

	mov di,OFFSET Channel_Info+FX_CHANNELS*CI_ENTRY_SIZE
	mov ax,SEG CDMI_Song
	mov gs,ax
	xor ax,ax
	mov fs,ax
	mov esi,gs:[CDMI_Song]

	movzx ecx,[Note]
	mov cs:[di+CI_PERIOD],cx
	test cx,cx
	jnz short @@1
		mov cs:[di+CI_REST],ecx
		mov cs:[di+CI_MAX_CX],ecx
		jmp  @@End

@@1:	movzx ebx,[SAMPLE]
	mov cs:[di+CI_INSTRUMENT],bx
	shl ebx,8				;*64 bytes
	mov eax,fs:[esi+ebx+IH_FLAGS]
	or eax,CF_NEW_INSTRUMENT or CF_NEW_POSITION
	and eax,NOT (IF_VOLUME_ENVELOPE or IF_PANNING_ENVELOPE)
	mov cs:[di+CI_FLAGS],eax
	mov eax,fs:[esi+ebx+IH_RESAMPLE]
	mov cs:[di+CI_RESAMPLE],eax
	mov eax,fs:[esi+ebx+IH_ADDRESS]
	mov cs:[di+CI_ADDRESS],eax
	mov eax,fs:[esi+ebx+IH_GUS_HANDLE]		;Get GUS-Handle
	mov cs:[di+CI_GUS_HANDLE],eax
	mov eax,fs:[esi+ebx+IH_SIZE]
	mov edx,fs:[esi+ebx+IH_LOOP_START]
	mov cs:[di+CI_LOOP_START],edx
	cmp edx,0fffffffh               	;Has the instrument a loop ?
	jae short @@NoLp		   	;JAE : Nope
	mov eax,fs:[esi+ebx+IH_LOOP_END]	;EAX holds loopend
@@NoLp:	mov cs:[di+CI_SIZE],eax			;Update SampleSize
	mov word ptr cs:[di+CI_VOLUME],64+100h*64
	xor eax,eax
	mov cs:[di+CI_POSITION],eax
	mov cs:[di+CI_GUS_POSITION],eax
	mov byte ptr cs:[di+CI_COMMAND],al
	mov byte ptr cs:[di+CI_VOL_SLIDE],al
	mov word ptr cs:[di+CI_FADE_POS],ax
	movzx ebx,word ptr cs:[di+CI_PERIOD]

	AdjustDI_MAX_CX


@@End:	pop edi
	pop esi
	pop bp
	retf
	endif
CDMI_Play_Sample ENDP





PUBLIC C CDMI_Set_Volume
CDMI_Set_Volume PROC
	arg volume:word
	push bp
	mov bp,sp

	mov bx,SEG CDMI_Volume
	mov gs,bx
	cmp gs:[CDMI_Song],0
	je @@Ende


	testflag gs:[CDMI_Flags],CDMI_WAVE_TABLE
	jnz @@Wave
	mov bx,[volume]
	cmp bx,512
	jb short @@1
	mov bx,512
@@1:	mov gs:[CDMI_Volume],bx
	testflag gs:[CDMI_Flags],CDMI_USE_16BIT
	jnz short @@2
	SETUP_BOOST_TABLE

@@2:	mov ax,gs:[CDMI_Volume]
	pop bp
	retf

@@Wave: mov ax,64
	pop bp
	retf

@@Ende:	xor ax,ax
	pop bp
	retf
CDMI_Set_Volume ENDP







PUBLIC C CDMI_Jump
CDMI_Jump PROC
	arg dest:word
	push bp
	mov bp,sp
	push edi
	push esi
        push ds

        mov ax,SEG CDMI_Entry_No
	mov gs,ax
	xor ax,ax
	mov ds,ax
	mov edi,gs:[CDMI_Song]
	test edi,edi
	jz short @@1
	mov ax,ds:[edi+SH_ENTRY_COUNT]		;Entry_Count
	mov bx,[dest]
	cmp bx,ax
	jae short @@1
	mov gs:[CDMI_Entry_No],bx
	SETUP_PATTERN
	START_PATTERN

  @@1:  pop ds
	pop esi
	pop edi
	pop bp
	retf
CDMI_Jump ENDP





PUBLIC C CDMI_Free_Song
CDMI_Free_Song PROC FAR
	push ebp
	push esi
	push edi
	push ds
	xor ax,ax
	mov ds,ax
	mov ax,SEG CDMI_Song
	mov gs,ax

	mov esi,gs:[CDMI_Song]
	test esi,esi
	jz short @@Ende
	push esi

	mov edi,esi
	mov bp,255
 @@3:   mov eax,dword ptr ds:[edi+SH_PATTERN_PTR]
	test eax,eax
	jz short @@4
	call EXT_Free C,eax
 @@4:	add edi,4
	dec bp
	jnz short @@3

	mov cx,MAX_INSTRUMENTS
 @@1:	push cx
	cmp dword ptr ds:[esi+IH_SIZE],0
	je short @@2
	call EXT_Free C,dword ptr ds:[esi+IH_ADDRESS]
 @@2:   add esi,INSTRUMENT_HEADER_SIZE
	pop cx
	dec cx
	jnz short @@1

	pop esi
	call EXT_Free C,esi

@@Ende:	pop ds
	pop edi
	pop esi
	pop ebp
	mov ax,TRUE
	retf
CDMI_Free_Song ENDP







PUBLIC C CDMI_Poll_Music
CDMI_Poll_Music PROC FAR
	push esi
	push edi
	push ebp
	push ds
	cld

	mov ax,SEG CDMI_Pattern_No
	mov gs,ax				;GS points to DATA-Segment
	xor ax,ax
	mov ds,ax
	mov es,ax
	testflag gs:[CDMI_Flags],CDMI_TIMER_MODE	;Not possible when not in timer-mode
	jz @@4
	testflag gs:[CDMI_Flags],CDMI_WAVE_TABLE
	jnz @@4
	cmp gs:[CDMI_Poll_Counter],ax		;Nothing to do ?
	je @@4

  @@L:	testflag gs:[CDMI_Flags],CDMI_BUFFER_READY_FLAG
	jz short @@2
	cmp cs:[Buffer_Tick_No],4
	ja short @@4

  @@2:	movzx eax,cs:[DMA_Increment]
	add gs:[CDMI_DMA_Address],eax
	inc cs:[Buffer_Tick_No]
	mov ax,cs:[Buffer_Tick_No]
	cmp ax,cs:[Buffer_Ticks]
	jb short @@3
	mov cs:[Buffer_Tick_No],0
	mov eax,cs:[Buffer_One]
	add eax,10h
	mov gs:[CDMI_DMA_Address],eax
	or gs:[CDMI_Flags],CDMI_BUFFER_READY_FLAG

  @@3:	call Calc_Buffer
	Next_Tick

	dec gs:[CDMI_Poll_Counter]		;Anything left to do ???
	jnz short @@L

  @@4:  mov gs:[CDMI_Poll_Counter],0
	pop ds
	pop ebp
	pop edi
	pop esi
	retf
CDMI_Poll_Music ENDP









PUBLIC C CDMI_Load_Song
CDMI_Load_Song PROC FAR
	ARG fname:dword
	push bp
	mov bp,sp
	push ds
	push esi
	push edi

	xor ax,ax
	mov ds,ax
	call Open C,[fname],O_RDONLY
	mov cs:[IO_Handle],ax
	cmp ax,1
	jl @@Error

	xor edi,edi
	xor ebx,ebx
	mov di,cs
	shl edi,4
	mov bx,OFFSET IO_Buf
	add edi,ebx
	call Read C,ax,edi,4,0

	call Seek C,cs:[IO_Handle],1080,0,SEEK_SET
	add edi,4
	call Read C,cs:[IO_Handle],edi,4,0

	call Seek C,cs:[IO_Handle],2ch,0,SEEK_SET
	add edi,4
	call Read C,cs:[IO_Handle],edi,4,0

	call Close C,cs:[IO_Handle]

	;
	;Now we will check what type of module this seems to be
	;
	cmp dword ptr cs:[IO_Buf+4],'.K.M'
	je @@MOD
	cmp dword ptr cs:[IO_Buf+4],'4TLF'
	je @@MOD
	cmp dword ptr cs:[IO_Buf+4],'6TLF'
	je @@MOD
	cmp dword ptr cs:[IO_Buf+4],'8TLF'
	je @@MOD
	cmp dword ptr cs:[IO_Buf+4],'!K&M'
	je @@MOD


	cmp dword ptr cs:[IO_Buf],'etxE'
	jne short @@1
		call far ptr CDMI_Load_XM C,[fname]
		jmp @@E

@@1:	cmp dword ptr cs:[IO_Buf],'RAF'
	jne short @@2
		call far ptr CDMI_Load_FAR C,[fname]
		jmp @@E

@@2:	cmp word ptr cs:[IO_Buf],'TM'
	jne short @@3
	cmp byte ptr cs:[IO_Buf+2],'M'
	jne short @@3
		call far ptr CDMI_Load_MTM C,[fname]
		jmp @@E

@@3:	cmp word ptr cs:[IO_Buf],06669h
	jne short @@4
		call far ptr CDMI_Load_669 C,[fname]
		jmp @@E

@@4:	cmp dword ptr cs:[IO_Buf+8],'MRCS'
	jne short @@5
		call far ptr CDMI_Load_S3M C,[fname]
		jmp @@E

	;
	;Now we check again for MOD, but only words...
	;
@@5:	cmp word ptr cs:[IO_Buf+5],'HC'
	je @@MOD
	cmp word ptr cs:[IO_Buf+6],'HC'
	je @@MOD


	;
	;Last we check the extension...
	;
	lgs bx,[fname]
	mov cx,128
 @@NAM: mov edx,gs:[bx]
	and edx,NOT 20202000h
	cmp edx,'DOM.'
	je short @@MOD
	cmp edx,'WOW.'
	je short @@MOD
	cmp edx,'MTS.'
	je short @@STM
	inc bx
	cmp dl,0
	je short @@Error
	cmp dh,0
	je short @@Error
	rol edx,16
	cmp dl,0
	je short @@Error
	cmp dh,0
	je short @@Error
	dec cx
	jnz short @@NAM
	jmp short @@Error

@@MOD:		call far ptr CDMI_Load_MOD C,[fname]
		jmp short @@E

@@STM:		call far ptr CDMI_Load_MOD C,[fname]
		jmp short @@E


@@E:	pop edi
	pop esi
	pop ds
	pop bp
	retf

@@Error:mov ax,FALSE
	pop edi
	pop esi
	pop ds
	pop bp
	retf
CDMI_Load_Song ENDP










;[]-------------------------------------------------------------------------[]
;|
;| The routines that follow now are called by the loaders at the end of this
;| file. They are used to improve quality, find bugs etc. And there are some
;| macros for clearing and resetting information in the song-header
;|
;[]-------------------------------------------------------------------------[]
;|
;| The following routine is a very special qualitiy-improver. It filters
;| the end of all instrument with no loop and reduces the volume to zero to
;| avoid nasty cracks. Second it processes instruments with loops by smoothing
;| the loop start and the loop end.
;|

Process_Instruments PROC NEAR
	push ds
	push ebp
	push esi
	push edi

	mov ax,SEG CDMI_Song
	mov gs,ax
	xor ax,ax
	mov ds,ax
	mov ebp,gs:[CDMI_Song]			;DS:EBP pointss to header
	movzx edx,word ptr ds:[ebp+SH_SAMPLE_FREQ]	;DX holds sample-freq
	mov cx,MAX_INSTRUMENTS
@@1:	push cx

	cmp byte ptr ds:[ebp+IH_VOLUME],64	;Check volume
	jbe short @@2
	mov byte ptr ds:[ebp+IH_VOLUME],64

	;
	;Here we examine the volume envelope for max volume (40h)
	;
@@2:	mov cx,12
	lea ebx,[ebp+IH_VENVELOPE_POINTS+2]
@@L2:	cmp word ptr ds:[ebx],40h		;Check volume envelope
	jb short @@3
	mov word ptr ds:[ebx],40h
@@3:	add ebx,4
	dec cx
	jnz short @@L2

	;
	;Is resampling all right ?
	;
	cmp dword ptr ds:[ebp+IH_RESAMPLE],2000
	ja short @@4
	mov ds:[ebp+IH_RESAMPLE],edx


	;
	;Here we check if it is a 16bit instrument. If so, we will convert it
	;down to 8bit
	;
@@4:	testflag dword ptr ds:[ebp+IH_FLAGS],IF_16BIT
	jz short @@5
	and dword ptr ds:[ebp+IH_FLAGS],NOT IF_16BIT
	xor ax,ax
	mov es,ax
	mov esi,ds:[ebp+IH_ADDRESS]
	mov edi,esi
	inc esi
	mov ecx,ds:[ebp+IH_SIZE]
	jecxz @@5
@@L3:	lods word ptr ds:[esi]
	stos byte ptr es:[edi]
	dec ecx
	jnz short @@L3

	;
	;Now we will check the loop-area (if it is really in range etc...)
	;
@@5:    cmp dword ptr ds:[ebp+IH_LOOP_START],0fffffffh
	jae short @@9
	mov eax,ds:[ebp+IH_SIZE]
	cmp eax,ds:[ebp+IH_LOOP_START]
	ja short @@6				;Is start bigger than size ?
	mov dword ptr ds:[ebp+IH_LOOP_START],0ffffffffh
	jmp @@9
@@6:    cmp eax,ds:[ebp+IH_LOOP_END]		;Is loop in range ???
	jae short @@7
	mov ds:[ebp+IH_LOOP_END],eax
@@7:	mov esi,ds:[ebp+IH_LOOP_START]		;Is start smaller than end ?
	cmp esi,ds:[ebp+IH_LOOP_END]
	jb short @@9
	mov dword ptr ds:[ebp+IH_LOOP_START],0ffffffffh

@@9:	pop cx
	add ebp,INSTRUMENT_HEADER_SIZE
	dec cx
	jnz @@1

	pop edi
	pop esi
	pop ebp
	pop ds
	retn
Process_Instruments ENDP




;[]-------------------------------------------------------------------------[]
;|
;| Now follow the loading-procedures for MOD,669,STM and S3M:
;| int CDMI_Load_MOD(char *fname);
;| int CDMI_Load_STM(char *fname);
;| int CDMI_Load_669(char *fname);
;| int CDMI_Load_S3M(char *fname);
;| int CDMI_Load_MTM(char *fname);
;| int CDMI_Load_XM (char *fname);
;|
;[]-------------------------------------------------------------------------[]
;|
;| These macros are very helpful for converting MOTOROLA numbers like in the
;| MOD-files to INTEL numbers. (DSWAP and WSWAP) The source is (E)DX and
;| the destination is (E)AX !
;|
Clear_Header MACRO
	push edi
	mov edi,esi
	xor eax,eax
	mov ecx,SONG_HEADER_SIZE/4
	mov es,ax
	rep stos dword ptr es:[edi]

	mov cx,MAX_INSTRUMENTS
	mov edi,esi
	mov ebx,0ffffffffh
	mov edx,8900
	mov al,80h
  @@1: 	mov dword ptr es:[edi+IH_LOOP_START],ebx
	mov dword ptr es:[edi+IH_RESAMPLE],edx
	mov  byte ptr es:[edi+IH_BALANCE],al
	add edi,INSTRUMENT_HEADER_SIZE
	dec cx
	jnz short @@1
	pop edi
	ENDM
DSWAP MACRO
	mov al,dl
	shl eax,8
	ror edx,8
	mov al,dl
	shl eax,8
	ror edx,8
	mov al,dl
	shl eax,8
	ror edx,8
	mov al,dl
	ENDM
WSWAP MACRO
	mov ax,dx
	rol ax,8
	ENDM
Test_Effect MACRO a,b
	LOCAL n
	cmp al,a
	jne short n
		mov byte ptr ds:[edi+4],b
		mov byte ptr ds:[edi+5],bl
		jmp @@Nothing
n:
	ENDM

;[]-------------------------------------------------------------------------[]
;|
;| Here are some constants and a IO_buffer for disk access. This buffer is
;| used for temporary datas that are not needed long.
;|

IO_Handle		dw	?
IO_Buf			db 	256 dup (0)
I_Pos			dd	?
I_Flags			dw	?
P_Pos			dd	?
I_Count			db	?
P_Count			dw	?
T_Count			dw      ?
C_Size			dw	?
Temp_Ptr		dd	?
Fuck_Ptr		dd	?

;[]-------------------------------------------------------------------------[]
;|
;| Now follows the MOD decoder.
;| A MOD-note is build up like that:
;|
;| Contents for each note:
;|
;|  _____byte 1_____   byte2_    _____byte 3_____       byte4_
;| /                \ /      \  /                \     /      \
;| 0000          0000-00000000  0000          0000  -  00000000
;|
;| Upper four    12 bits for    Lower four    Effect   Effect
;| bits of sam-  note pitch.    bits of sam-  code.    parameter.
;| ple number.                  ple number.
;|
;| The pitch for the note actually determines the time between outputting samples.
;| For the Amiga, the value of the pitch is the number of clock ticks that a 3.5
;| MHz timer must count down between outputting two samples.
;| The exact formulas are:
;|
;| 	         3546894.6
;| SampleRate = -----------        (For a PAL machine)
;| 		  Pitch
;|
;| 	         3579545.3
;| SampleRate = -----------        (For a NTSC machine)
;| 	          Pitch
;|
;| Thus, the pitch 214 (for note C-3) corresponds to 16,574 Hz, using the PAL
;| formula. Each second 16,574 sampled data bytes for the instrument are pushed
;| through the D/A convertor. (Actually, with most samplers the D/A conversion
;| frequency is fixed and real-time resampling takes place.)
;|
;| If finetuning is supported, the pitch stored in the note is always one of the
;| values in the "pitch table for tuning 0" above. The correct pitch for the note
;| comes from one of 15 other tables, according to the finetune value of the
;| instrument.
;|
;| This is an extract of a MOD-description written by:
;|	Thiadmer Riemersma
;| 	ITB CompuPhase, The Netherlands
;|	CIS: 100115,2074
;|
;[]-------------------------------------------------------------------------[]
;|
;| Now follows the MOD commands. The offsets are stored in a table for fast
;| indexing.
;|
;| Protracker V2.3A/3.01 Effect Commands
;| ------------------------------------------------------------------------------
;| 0 + Normal play or arpeggio             0xy : x-first halfnote add, y-second
;| 1 - Slide up                            1xx : up speed
;| 2 - Slide down                          2xx : down speed
;| 3 + Tone portamento (slide to note)     3xx : up/down speed
;| 4 - Vibrato (frequency trembles)        4xy : x-speed,   y-depth
;| 5 - Continue effect 3 + volume slide    5xy : x-upspeed, y-downspeed
;| 6 - Continue effect 4 + volume slide    6xy : x-upspeed, y-downspeed
;| 7 - Tremolo (volume trembles)           7xy : x-speed,   y-depth
;| 8 - not used
;| 9 - Set sample offset                   9xx : offset (23 -> 2300)
;| A - Volume slide                        Axy : x-upspeed, y-downspeed
;| B - Position jump                       Bxx : song position
;| C - Set volume                          Cxx : volume, 00-40
;| D - Pattern break                       Dxx : break position in next pattern
;| E - Extended commands
;|   E0- Set filter                        E0x : 0=filter on, 1=filter off
;|   E1- Fine slide up                     E1x : value
;|   E2- Fine slide down                   E2x : value
;|   E3+ Glissando control                 E3x : 0=off, 1=on (use with effect 3)
;|   E4- Set vibrato waveform              E4x : 0=sine, 1=ramp down, 2=square
;|   E5- Set finetune value                E5x : value (0..15)
;|   E6- Jump to loop                      E6x : 0=set loop start, >0 play x times
;|   E7- Set Tremolo Waveform              E7x : 0=sine, 1=ramp down. 2=square
;|   E8- not used
;|   E9- Retrig note                       E9x : retrig from note + x vblanks
;|   EA- Fine volume slide up              EAx : add x to volume
;|   EB- Fine volume slide down            EBx : subtract x from volume
;|   EC- Note cut                          ECx : cut from note + x vblanks
;|   ED- Note delay                        EDx : delay note x vblanks
;|   EE- Pattern delay                     EEx : delay pattern x notes
;|   EF- Invert loop                       EFx : speed
;| F - Set speed or tempo                  Fxx : speed (00-1F) / tempo (20-FF)
;|
;|
;| This is an extract of a MOD-description written by:
;|	Thiadmer Riemersma
;| 	ITB CompuPhase, The Netherlands
;|	CIS: 100115,2074
;|

MOD_I_Name		equ	0
MOD_I_Size		equ	22
MOD_I_FineTune		equ	24
MOD_I_Volume		equ	25
MOD_I_Loop_Start	equ	26
MOD_I_Loop_Size		equ	28

MOD4_MAGIC_1		equ	2e4b2e4dh
MOD4_MAGIC_2		equ	214b264dh
MOD4_MAGIC_3		equ	34544c46h
MOD8_MAGIC_1		equ	38544c46h
MOD_MAGIC_CH		equ     4843h
MOD_MAGIC_HN		equ     4e48h
;Fintune		  0    1    2    3    4    5    6    7
MOD_Adjust_Frequencies dw 8196,8255,8315,8375,8436,8497,8558,8621
		       dw 7736,7792,7848,7905,7962,8020,8078,8137

Convert_MOD PROC NEAR
	ARG src:dword,dest:dword,beats:word,channels:word,song:dword
	push bp
	mov bp,sp
	push ebp
	push esi
	push edi

	mov esi,[src]			;DS:ESI points to MOD-source
	mov edi,[dest]			;DS:EDI points to PAT-destination

	push edi
	mov ax,[beats]
	mul [channels]
	fastimul cx,ax,3
	shr cx,1
	movzx ecx,cx
	xor eax,eax
	mov es,ax
	rep stos dword ptr es:[edi]
	pop edi

	mov edx,[song]			;DS:EDX points to song-header

@@1:	mov cx,[channels]
@@2:	mov bx,ds:[esi]
	and bx,0ff0fh			;EBX=Period / Clear high-word
	rol bx,8
	shl bx,2
	ror bx,8
	mov ds:[edi],bx

	mov bl,ds:[esi]			;Get upper 4 bits
	and bl,0f0h			;Mask out lower 4 period-bits
	mov bh,ds:[esi+2]		;Get lower four bits of instrument
	shr bh,4			;Shift away effect bits
	add bl,bh			;BL finally has instrument
	mov ds:[edi+2],bl

@@3:	mov al,ds:[esi+2]		;AL has command-value
	mov bl,ds:[esi+3]		;BL has parameter
	and al,0fh
	jnz short @@01
		test bl,bl
		jz @@Nothing
		mov byte ptr ds:[edi+4],ARPEGGIO
		mov byte ptr ds:[edi+5],bl
		jmp @@Nothing
@@01:   cmp al,12			;Set volume
	jne short @@02
		cmp bl,40h
		jb @@5
		mov bl,40h
	  @@5:	add bl,10h
		mov ds:[edi+3],bl
		jmp @@Nothing
@@02:	Test_Effect 1,SLIDE_UP
	Test_Effect 2,SLIDE_DOWN
	Test_Effect 3,TONE_PORTAMENTO
	Test_Effect 4,VIBRATO
	Test_Effect 5,TONE_AND_VOLSLIDE
	Test_Effect 6,VIB_AND_VOLSLIDE
	Test_Effect 7,TREMOLO
;	Test_Effect 8,PANNING
	Test_Effect 9,SAMPLE_OFFSET
	Test_Effect 10,VOLUME_SLIDE
	Test_Effect 11,POSITION_JUMP
	Test_Effect 13,PATTERN_BREAK
	Test_Effect 15,SET_SPEED
	mov al,ds:[esi+3]
	shr al,4
	and bl,0fh
	Test_Effect 0,SET_FILTER
	Test_Effect 1,FINE_SLIDE_UP
	Test_Effect 2,FINE_SLIDE_DOWN
	Test_Effect 3,GLISSANDO_CONTROL
	Test_Effect 4,SET_VIBWAVE_FORM
	Test_Effect 5,SET_FINETUNE
	Test_Effect 6,LOOP_JUMP
	Test_Effect 7,SET_TREMWAVE_FORM
	Test_Effect 8,BIG_PANNING
	Test_Effect 9,RETRIGGER_NOTE
	Test_Effect 10,FINE_VOL_SLIDE_UP
	Test_Effect 11,FINE_VOL_SLIDE_DOWN
	Test_Effect 12,NOTE_CUT
	Test_Effect 13,NOTE_DELAY
	Test_Effect 14,PATTERN_DELAY
	Test_Effect 15,FUNK_INVERT

@@Nothing:
	add esi,4			;Next pattern-note
	add edi,6            		;Next channel - info
dec cx
jnz @@2
dec [beats]
jnz @@1

	pop edi
	pop esi
	pop ebp
	pop bp
	retn
Convert_MOD ENDP




PUBLIC C CDMI_Load_MOD
CDMI_Load_MOD PROC FAR
	ARG fname:dword
	push bp
	mov bp,sp
	push ds
	push esi
	push edi
	push ebp

        xor ax,ax
	mov ds,ax
	call Open C,[fname],O_RDONLY
	mov cs:[IO_Handle],ax
        cmp ax,2
	jl @@Error

        mov eax,SONG_HEADER_SIZE
	call EXT_Malloc C,eax
	shl edx,16
	mov dx,ax
        mov ax,SEG CDMI_Song
	mov gs,ax
	mov gs:[CDMI_Song],edx
	mov esi,edx				;DS:ESI points to Song_Header

	Clear_Header
	mov  word ptr ds:[esi+SH_SAMPLE_FREQ],8196
	mov  word ptr ds:[esi+SH_START_SPEED],6
	mov  word ptr ds:[esi+SH_START_TEMPO],125
	mov  word ptr ds:[esi+SH_TICKS_PER_SECOND],50

	mov edi,esi
	mov ax,ds
	mov es,ax
	add edi,SH_PATTERN_LEN
	mov eax,3f3f3f3fh
	mov ecx,256/4
	rep stos dword ptr es:[edi]		;Set break-points to 63

	mov eax,1080
	call Seek C,cs:[IO_Handle],eax,SEEK_SET
	xor eax,eax
	xor edi,edi
	mov di,cs
	shl edi,4
	mov ax,OFFSET IO_Buf
	add edi,eax				;DS:EDI points to read-buffer
        mov eax,4
	call Read C,cs:[IO_Handle],edi,eax
	mov eax,dword ptr cs:[IO_Buf]

	lgs bx,[fname]
	mov cx,128
  @@WOW:mov edx,gs:[bx]
	and edx,NOT 20202000h
	cmp edx,574f572eh
	jne short @@11
	mov eax,MOD8_MAGIC_1
	jmp short @@8_1
  @@11: inc bx
	cmp dl,0
	je short @@10
	cmp dh,0
	je short @@10
	rol edx,16
	cmp dl,0
	je short @@10
	cmp dh,0
	je short @@10
	dec cx
	jnz short @@WOW

  @@10: cmp eax,MOD8_MAGIC_1
	jne short @@4_T
  @@8_1:mov cx,31				;Number of instruments
	mov word ptr ds:[esi+SH_CHANNELS],8	;Channels
	mov word ptr ds:[esi+SH_ROW_SIZE],8*6
	mov word ptr ds:[esi+SH_PATTERN_SIZE],8*6*64
	mov word ptr ds:[esi+SH_START_VOLUME],128
	jmp @@Ready

  @@4_T:cmp eax,MOD4_MAGIC_1
	je short @@4_1
	cmp eax,MOD4_MAGIC_2
	je short @@4_1
	cmp eax,MOD4_MAGIC_3
	jne short @@CH_T
  @@4_1:mov cx,31				;Number of instruments
	mov word ptr ds:[esi+SH_CHANNELS],4	;Channels
	mov word ptr ds:[esi+SH_ROW_SIZE],4*6
	mov word ptr ds:[esi+SH_PATTERN_SIZE],4*6*64
	mov word ptr ds:[esi+SH_START_VOLUME],64
	jmp @@Ready

 @@CH_T:ror eax,16				;Get high-bytes
	cmp ax,MOD_MAGIC_CH
	jne short @@HN_T
	rol eax,16
	movzx bx,al
	sub bl,'0'
	fastimul dx,bx,10
	add dl,ah
	sub dl,'0'
	mov cx,31				;Number of instruments
	shl dx,4
	mov word ptr ds:[esi+SH_START_VOLUME],dx
	shr dx,4
	mov word ptr ds:[esi+SH_CHANNELS],dx	;Channels
	fastimul ax,dx,6
	mov word ptr ds:[esi+SH_ROW_SIZE],ax
	shl ax,6
	mov word ptr ds:[esi+SH_PATTERN_SIZE],ax
	jmp short @@Ready

 @@HN_T:cmp ax,MOD_MAGIC_HN
	jne short @@15
	rol eax,16
	movzx dx,al
	sub dl,'0'
	mov cx,31				;Number of instruments
	shl dx,4
	mov word ptr ds:[esi+SH_START_VOLUME],dx
	shr dx,4
	mov word ptr ds:[esi+SH_CHANNELS],dx	;Channels
	fastimul ax,dx,6
	mov word ptr ds:[esi+SH_ROW_SIZE],ax
	shl ax,6
	mov word ptr ds:[esi+SH_PATTERN_SIZE],ax
	jmp short @@Ready


  @@15:	mov cx,15				;Number of instruments
	mov word ptr ds:[esi+SH_CHANNELS],4	;Channels
	mov word ptr ds:[esi+SH_ROW_SIZE],4*6
	mov word ptr ds:[esi+SH_PATTERN_SIZE],4*6*64
	mov word ptr ds:[esi+SH_START_VOLUME],64

  @@Ready:
	push edi				;Save IO_Buffer pointer
	push cx					;Save instrument count
	mov cs:[I_Count],cl			;Save for later...

	xor eax,eax
	call Seek C,cs:[IO_Handle],eax,SEEK_SET
	mov edi,esi
	add edi,SH_NAME
	mov eax,20
	call Read C,cs:[IO_Handle],edi,eax
	mov byte ptr ds:[esi+SH_NAME+20],0

	pop cx					;Get instrument count
	pop edi					;Get IO_Buffer ptr
	mov cs:[I_Pos],0
	mov ebp,esi

	;now follows a loop to read in all instrument headers
  @@2:	push cx
	mov eax,30
	call Read C,cs:[IO_Handle],edi,eax

	xor ebx,ebx				;This is a stupid
  @@N:  mov ax,word ptr cs:[OFFSET IO_Buf+bx]	;copyroutine for the
	mov ds:[ebp+IH_NAME+ebx],ax		;instrument's name
	add bx,2
	cmp bx,22
	jne short @@N
	mov word ptr ds:[ebp+IH_NAME+ebx],0

	movzx eax,word ptr cs:[OFFSET IO_Buf+MOD_I_SIZE]
	rol ax,8
	shl eax,1
	add cs:[I_Pos],eax
	mov ds:[ebp+IH_SIZE],eax
	movzx eax,word ptr cs:[OFFSET IO_Buf+MOD_I_LOOP_SIZE]
	rol ax,8
	shl eax,1
	cmp eax,4
	jb short @@NoLoop
	cmp eax,01fffdh
	jae short @@NoLoop
		movzx eax,word ptr cs:[OFFSET IO_Buf+MOD_I_LOOP_START]
		rol ax,8
		shl eax,1
		mov ds:[ebp+IH_LOOP_START],eax
		movzx ebx,word ptr cs:[OFFSET IO_Buf+MOD_I_LOOP_SIZE]
		rol bx,8
		shl ebx,1
		add eax,ebx
;		dec eax
		mov ds:[ebp+IH_LOOP_END],eax
		jmp short  @@3
	@@NoLoop:
		mov dword ptr ds:[ebp+IH_LOOP_START],0ffffffffh

 @@3:   mov bl,byte ptr cs:[OFFSET IO_Buf+MOD_I_FineTune]
	and bx,0fh
	shl bx,1
	movzx eax,word ptr cs:[OFFSET MOD_Adjust_Frequencies+bx]
	mov ds:[ebp+IH_RESAMPLE],eax
	mov al,cs:[OFFSET IO_Buf+MOD_I_Volume]
	mov ds:[ebp+IH_VOLUME],al
	add ebp,INSTRUMENT_HEADER_SIZE
	pop cx			;Get instrument-counter
	dec cx
	jnz  @@2

	mov edi,esi
	add edi,SH_LIST_COUNT
	mov eax,2
	call Read C,cs:[IO_Handle],edi,eax
        and word ptr ds:[edi],0ffh
	add edi,SH_PATTERN_LIST-SH_LIST_COUNT
	mov eax,128
	call Read C,cs:[IO_Handle],edi,eax
	cmp cs:[I_Count],31				;Do we need to skip
	jb short @@4					;JB => No
	mov eax,4
	call Seek C,cs:[IO_Handle],eax,SEEK_CUR		;Skip signature

   @@4: xor eax,eax
	mov ebx,127				;Here we examine the
   @@5: mov dl,ds:[esi+ebx+SH_PATTERN_LIST-1]	;sequence in order to find
	cmp dl,127				;out how many patterns
	jae short @@6				;there are to load
	cmp dl,al
	jb short @@6
	mov al,dl
   @@6: dec bx
	jnz short @@5
	inc eax					;Add one pattern
        mov ds:[esi+SH_PATTERN_COUNT],ax	;Save them here

	shl eax,8				;*4 bytes Note *64 beats
	movzx ebx,word ptr ds:[esi+SH_CHANNELS]
	mul ebx					;EAX holds size to read
	push eax   				;Save pattern sizes
	call EXT_Malloc C,eax			;Allocate memory for patterns
	mov edi,eax				;EDX contains linear address
	pop eax   				;Restore bytes to read
	test edi,edi
	jz @@Error
	mov cs:[Temp_Ptr],edi			;Save ptr there
	call Read C,cs:[IO_Handle],edi,eax	;Read patterns

	mov cx,ds:[esi+SH_PATTERN_COUNT]
	xor ebp,ebp
  @@L2: push cx
	movzx eax,word ptr ds:[esi+SH_PATTERN_SIZE]
	call EXT_Malloc C,eax
	mov ds:[esi+SH_PATTERN_PTR+ebp],eax
	call Convert_MOD C,edi,eax,64,word ptr ds:[esi+SH_CHANNELS],esi
	movzx eax,word ptr ds:[esi+SH_CHANNELS]
	shl eax,8
	add edi,eax
	add ebp,4
	pop cx
	dec cx
	jnz short @@L2
	call EXT_Free C,dword ptr cs:[Temp_Ptr]

	mov cl,cs:[I_Count]			;and load them !
	mov edi,esi
   @@8:	push cx
	cmp dword ptr ds:[edi+IH_SIZE],0
	je short @@9
	mov eax,dword ptr ds:[edi+IH_SIZE]
	add eax,4
	call EXT_Malloc C,eax
	mov ds:[edi+IH_ADDRESS],eax
	call Read C,cs:[IO_Handle],eax,dword ptr ds:[edi+IH_SIZE]
   @@9: add edi,INSTRUMENT_HEADER_SIZE
	pop cx
	dec cl
	jnz short @@8

	call Close C,cs:[IO_Handle]

	call Process_Instruments
	pop ebp
	pop edi
	pop esi
	pop ds
	pop bp
	mov ax,TRUE
	retf

@@Error:
	call Close C,cs:[IO_Handle]
	pop ebp
	pop edi
	pop esi
	pop ds
	pop bp
	mov ax,FALSE
	retf
CDMI_Load_MOD ENDP







;[]-------------------------------------------------------------------------[]
;|
;| This is the real 669-loader
;|
;[]-------------------------------------------------------------------------[]
;|
;| The 669-format decoder follows now:
;| A 669 note is build like that:
;|
;|
;| bits:
;|   BYTE[0]:             BYTE[1]:            BYTE[2]:
;|  aaaaaaaa             bbbbbbbb            cccccccc
;|              
;|                                           
;|                         4 bit volume       command value
;|                                         
;|       aabbbb = 6 bit instrument number   command:
;|                                           0 = a
;|  note value = (12*oct)+note                1 = b
;|                                            2 = c
;|  special values for byte 0:                3 = d
;|    0xfe = no note, only volume change      4 = e
;|    0xff = no note or volume change         5 = f
;|
;|                                           special value for byte 2:
;|                                             0xff = no command
;| Commands:
;| 0 - Portamento up
;| 1 - Portamento down
;| 2 - Port to note
;| 3 - Frequency adjust
;| 4 - Frequency vibrato
;| 5 - Set tempo
;|
;|
;| This is an extract from the 669-format description from Renessaince
;|
;[]-------------------------------------------------------------------------[]
;|
;| This is the real Pattern-decoder for 669- and MOD-format. Before this
;| routine is called, make sure that GS contains the DATA-Segment
;|

MAGIC_669		equ	0
NAME_669		equ	2
NOS_669			equ	110
NOP_669			equ	111
LOOP_669		equ	112

I_669_NAME		equ	0
I_669_SIZE		equ	13
I_669_LOOP_START	equ	17
I_669_LOOP_END		equ	21



Convert_669 PROC NEAR
	ARG src:dword,dest:dword,beats:word,channels:word
	push bp
	mov bp,sp
	push ebp
	push esi
	push edi

	mov esi,[src]			;DS:ESI points to MOD-source
	mov edi,[dest]			;DS:EDI points to PAT-destination

	push edi
	mov ax,[beats]
	mul [channels]
	fastimul cx,ax,3
	shr cx,1
	movzx ecx,cx
	xor eax,eax
	mov es,ax
	rep stos dword ptr es:[edi]
	pop edi

@@1:	mov cx,[channels]
@@2:	mov bx,ds:[esi]
	cmp bl,0feh
	ja short @@Check_FX
	je short @@Check_Volume
	and bx,0fch			;BX=note
	shr bx,1
	mov ax,cs:[OFFSET PeriodTable+bx+4*12]
	rol ax,8			;Swap lo-high bytes !!!
	mov ds:[edi],ax			;AX=pitch

	mov bl,ds:[esi]			;Get upper 2 bits
	and bl,11b
	shl bl,4
	mov bh,ds:[esi+1]		;Get lower four bits of instrument
	shr bh,4			;Shift away effect bits
	add bl,bh			;BL finally has instrument
	inc bl
	mov ds:[edi+2],bl
@@Check_Volume:
	mov al,ds:[esi+1]
	and al,0fh
	shl al,2
	add al,10h
	mov ds:[edi+3],al		;Save volume

@@Check_FX:
	mov al,ds:[esi+2]		;AL has command-value
	cmp al,0ffh
	je short @@Nothing
	shr al,4
	mov bx,ds:[esi+2]		;BL has parameter
	and bx,0fh
	cmp al,3
	jne short @@7
		shl bx,12
		sar bx,12
		mov ax,ds:[edi]
		rol ax,8
		add ax,bx
		rol ax,8
		mov ds:[edi],ax
		jmp short @@Nothing
@@7:	Test_Effect 0,SLIDE_UP
	Test_Effect 1,SLIDE_DOWN
	Test_Effect 2,TONE_PORTAMENTO
	Test_Effect 4,VIBRATO
	Test_Effect 5,SET_SPEED

@@Nothing:
	add esi,3			;Next pattern-note
	add edi,6            		;Next channel - info
dec cx
jnz @@2
dec [beats]
jnz @@1

	pop edi
	pop esi
	pop ebp
	pop bp
	retn
Convert_669 ENDP




PUBLIC C CDMI_Load_669
CDMI_Load_669 PROC FAR
	ARG fname:dword
	push bp
	mov bp,sp
	push ds
	push esi
	push edi
	push ebp

	xor ax,ax
	mov ds,ax
	call Open C,[fname],O_RDONLY
	mov cs:[IO_Handle],ax
	cmp ax,2
	jl @@Error

	mov eax,SONG_HEADER_SIZE
	call EXT_Malloc C,eax
	test eax,eax
	jz @@Error
	mov dx,SEG CDMI_Song
	mov gs,dx
	mov gs:[CDMI_Song],eax
	mov esi,eax				;DS:ESI points to Song_Header
	Clear_Header

	mov  word ptr ds:[esi+SH_SAMPLE_FREQ],8960
	mov  word ptr ds:[esi+SH_START_SPEED],6
	mov  word ptr ds:[esi+SH_START_TEMPO],125
	mov  word ptr ds:[esi+SH_START_VOLUME],128
	mov  word ptr ds:[esi+SH_TICKS_PER_SECOND],32
	mov  word ptr ds:[esi+SH_PATTERN_SIZE],6*8*64
	mov  word ptr ds:[esi+SH_ROW_SIZE],6*8
	mov  word ptr ds:[esi+SH_CHANNELS],8

	xor eax,eax
	xor edi,edi
	mov di,cs
	shl edi,4
	mov ax,OFFSET IO_Buf
	add edi,eax				;DS:EDI points to read-buffer
	mov eax,113
	call Read C,cs:[IO_Handle],edi,eax

	mov ebp,esi
	add ebp,SH_NAME				;DS:EBP points to name
	xor ebx,ebx
 @@c:	mov eax,dword ptr ds:[edi+NAME_669+ebx]
	mov ds:[esi+ebx+SH_NAME],eax
	add bx,4
	cmp bx,32
	jne short @@c
	mov byte ptr ds:[esi+SH_NAME+31],0

	mov cl,cs:[IO_Buf+NOS_669]
	mov cs:[I_Count],cl
	movzx ecx,byte ptr cs:[IO_Buf+NOP_669]
	mov ds:[esi+SH_PATTERN_COUNT],cx

	mov ebp,esi
	add ebp,SH_PATTERN_LIST
	mov eax,128
	call Read C,cs:[IO_Handle],ebp,eax	;Get order list
	xor ebx,ebx
 @@P:	cmp byte ptr ds:[ebp+ebx],127
	jae short @@EP
	inc bx
	cmp bx,128
	jb short @@P
 @@EP:  mov ds:[esi+SH_ENTRY_COUNT],bx

	mov eax,128
	call Seek C,cs:[IO_Handle],eax,SEEK_CUR	;Skip tempo list
	add ebp,SH_PATTERN_LEN-SH_PATTERN_LIST
	mov eax,128
	call Read C,cs:[IO_Handle],ebp,eax	;Get break list

	mov cl,cs:[I_Count]
	mov ebp,esi
 @@3:   push cx
	mov eax,25				;I_Header size
	call Read C,cs:[IO_Handle],edi,eax	;Read in header
	mov byte ptr ds:[ebp+IH_VOLUME],64
	mov dword ptr ds:[ebp+IH_RESAMPLE],8960
	mov eax,dword ptr cs:[IO_Buf+I_669_SIZE]
	mov ds:[ebp+IH_SIZE],eax
	mov eax,dword ptr cs:[IO_Buf+I_669_LOOP_END]
	mov ds:[ebp+IH_LOOP_END],eax
	cmp eax,0ffff0h
	jae short @@NoLoop
	mov eax,dword ptr cs:[IO_Buf+I_669_LOOP_START]
	cmp eax,0ffff0h
	jae short @@NoLoop
		mov ds:[ebp+IH_LOOP_START],eax
		jmp short @@4
	@@NoLoop:
		mov dword ptr ds:[ebp+IH_LOOP_START],0ffffffffh
 @@4:   xor ebx,ebx
 @@5:	mov eax,dword ptr cs:[IO_Buf+I_669_Name+bx]
	mov ds:[ebp+ebx+IH_NAME],eax
	add ebx,4
	cmp ebx,12
	jne short @@5
	mov byte ptr ds:[ebp+ebx+IH_NAME],0
	add ebp,INSTRUMENT_HEADER_SIZE
	pop cx
	dec cl
	jnz @@3

	movzx eax,word ptr ds:[esi+SH_PATTERN_COUNT]
	fastimul ebx,eax,0600h
	push ebx				;Save size for later
	call EXT_Malloc C,ebx
	mov edi,eax
	test edi,edi
	jz @@Error
	mov cs:[Temp_Ptr],edi
	pop ebx
	call Read C,cs:[IO_Handle],edi,ebx

	mov cx,ds:[esi+SH_PATTERN_COUNT]
	xor ebp,ebp
  @@L2: push cx
	movzx eax,word ptr ds:[esi+SH_PATTERN_SIZE]
	call EXT_Malloc C,eax
	mov ds:[esi+SH_PATTERN_PTR+ebp],eax
	call Convert_669 C,edi,eax,64,8
	add edi,64*8*3
	add ebp,4
	pop cx
	dec cx
	jnz short @@L2
	call EXT_Free C,dword ptr cs:[Temp_Ptr]


	mov cl,cs:[I_Count]
	mov ebp,esi
   @@8:	push cx
	cmp dword ptr ds:[ebp+IH_SIZE],0
	je short @@9
	mov eax,dword ptr ds:[ebp+IH_SIZE]
	add eax,4
	call EXT_Malloc C,eax
	mov edx,eax
	mov ds:[ebp+IH_ADDRESS],edx
	mov eax,ds:[ebp+IH_SIZE]
	push edx
	push eax
	call Read C,cs:[IO_Handle],edx,eax
	pop eax
	pop edx
   @@D:	add byte ptr ds:[edx],80h
	inc edx
	dec eax
	jnz short @@D
   @@9: add ebp,INSTRUMENT_HEADER_SIZE
	pop cx
	dec cl
	jnz short @@8

	xor edi,edi
	xor eax,eax
	mov di,cs
	shl edi,4
	mov ax,OFFSET IO_Buf
	add edi,eax				;DS:EDI points to read-buffer
	mov eax,241
	call Seek C,cs:[IO_Handle],eax,SEEK_SET	;Seek to tempo list
	mov eax,128
	call Read C,cs:[IO_Handle],edi,eax
	call Close C,cs:[IO_Handle]

	mov cx,word ptr ds:[esi+SH_PATTERN_COUNT]
	xor edi,edi
	xor bx,bx
	mov dl,SET_SPEED
 @@TempoLoop:
		mov dh,cs:[IO_Buf+bx]		;load tempo
		mov ebp,ds:[esi+edi+SH_PATTERN_PTR]
		mov ds:[ebp+4],dx		;Set command
		add edi,4
		inc bx
 dec cx
 jnz short @@TempoLoop

	call Process_Instruments
	pop ebp
	pop edi
	pop esi
	pop ds
	pop bp
	mov ax,TRUE
	retf

@@Error:
	call Close C,cs:[IO_Handle]
	pop ebp
	pop edi
	pop esi
	pop ds
	pop bp
	mov ax,FALSE
	retf
CDMI_Load_669 ENDP





;[]-------------------------------------------------------------------------[]
;|
;| Now follows the S3M loader for Cream-tracker 3.0 modules. Note that S3m
;| theoretically also supports FM-Voices. But these modules will not be
;| loaded correct !!! (See S3M.DOC for format description)
;|
;| Unpacked pattern is always 32 channels by 64 rows. Below
;| is the unpacked format st uses for reference:
;|     byte 0 - Note; hi=oct, lo=note, 255=empty note,
;|		  254=key off (used with adlib, with samples stops smp)
;|     byte 1 - Instrument      ;0=..
;|     byte 2 - Volume          ;255=..
;|     byte 3 - Special command ;255=..
;|     byte 4 - Command info    ;
;|
;| Packed data consits of following entries:
;|   BYTE:what  0=end of row
;|	      &31=channel
;|	      &32=follows;  BYTE:note, BYTE:instrument
;|	      &64=follows;  BYTE:volume
;|	     &128=follows;  BYTE:command, BYTE:info
;|
S3M_ORDER_COUNT		equ	20h
S3M_INSTRUMENT_COUNT	equ	22h
S3M_PATTERN_COUNT	equ	24h
S3M_FLAGS		equ	26h
S3M_TRACKER_VERSION	equ	28h
S3M_SAMPLE_FORMAT	equ	2ah
S3M_MAGIC_ADRESS	equ	2ch
S3M_GLOBAL_VOLUME	equ	30h
S3M_START_SPEED		equ	31h
S3M_START_TEMPO		equ	32h
S3M_MASTER_VOLUME	equ	33h
S3M_CHANNEL_MAP		equ	40h
S3M_MAGIC		equ	'MRCS'
S3M_INST_TYPE		equ	0
S3M_INST_ADRESS		equ	0dh
S3M_INST_SIZE		equ	10h
S3M_INST_LOOP_START	equ	14h
S3M_INST_LOOP_END	equ	18h
S3M_INST_VOLUME		equ	1ch
S3M_INST_PACK_TYPE	equ	1dh
S3M_INST_FLAGS 		equ	1fh
S3M_INST_RESAMPLE	equ	20h
S3M_INST_NAME		equ	30h
S3M_INST_MAGIC		equ	4ch

S3M_Last_VSlides	db	32 dup (?)
S3M_Last_PSlides	db	32 dup (?)
S3M_This_Channel	dw	?

Convert_S3M PROC NEAR
	ARG src:dword,dest:dword,song:dword
	push bp
	mov bp,sp
	push esi
	push edi
	push ebp

	mov esi,[src]			;DS:ESI points to S3M-source
	mov edi,[dest]			;DS:EDI points to PAT-destination
	mov ebp,[song]			;DS:EBP points to song
	push edi
	movzx eax,word ptr ds:[ebp+SH_CHANNELS]
	fastimul ecx,eax,64*6/4
	xor eax,eax
	mov es,ax
	rep stos dword ptr es:[edi]
	pop edi
	mov cx,64

@@1:	mov dl,ds:[esi]
	inc esi
	test dl,dl
	jnz short @@3
	movzx eax,word ptr ds:[ebp+SH_ROW_SIZE]
	add edi,eax
	dec cx
	jnz short @@1
	pop ebp
	pop edi
	pop esi
	pop bp
	retn

@@3:    mov bl,dl
	and ebx,31
	cmp bl,ds:[ebp+SH_CHANNELS]
	jb short @@OK7
	test dl,32
	jz short @@G1
	add esi,2
  @@G1: test dl,64
	jz short @@G2
	inc esi
  @@G2: test dl,128
	jz short @@1
	add esi,2
  @@G3: jmp short @@1

@@OK7:	mov cs:[S3M_This_Channel],bx
	fastimul eax,ebx,6
	push edi
	add edi,eax

	;
	;First we test if there is a note and / or instrument
	;
	test dl,32			;32 : Note and instrument
	jz @@4
	mov al,ds:[esi]
	cmp al,0feh			;FE = Key-off , FF = No Note
	ja short @@2
	jne short @@7
	mov word ptr ds:[edi],80h	;Key-off
	jmp short @@2

@@7:	push ax
	movzx bx,al
	shr bx,4
	fastimul ax,bx,12
	pop bx
	and bx,0fh
	add bx,ax
	shl bx,1
	mov ax,word ptr cs:[OFFSET PeriodTable+bx]
	rol ax,8			;Swap lo-high bytes !!!
	mov ds:[edi],ax			;AX=pitch

@@2:	mov bl,ds:[esi+1]		;Get instrument
	cmp bl,0ffh
	je short @@D
	mov ds:[edi+2],bl		;Save instrument
@@D:	add esi,2

	;
	;Now we test if there is a volume
	;
@@4:    test dl,64
	jz short @@5
	mov al,ds:[esi]
	inc esi
	cmp al,0ffh
	je short @@5
	cmp al,64
	jb short @@Ok1
	mov al,64
@@Ok1:	add al,10h
	mov ds:[edi+3],al		;Save volume

	;
	;Last we test for special effects
	;
@@5:	test dl,128
	jz @@6
	mov ax,ds:[esi]
	add esi,2
	cmp al,0ffh
	je @@Nothing
@@Ok3:	mov bl,ah
	cmp al,4 			;Volume slide
	jne short @@F
		mov bx,cs:[S3M_This_Channel]
		test ah,ah
		jnz short @@V1
		mov ah,cs:[OFFSET S3M_Last_Vslides+BX]
	@@V1:	mov cs:[OFFSET S3M_Last_Vslides+BX],ah
		mov bl,ah
		and ah,0fh
		cmp ah,0fh
		jne short @@E
		shr bl,4
		jz short @@V2
		mov byte ptr ds:[edi+4],FINE_VOL_SLIDE_UP
		mov byte ptr ds:[edi+5],bl
		jmp @@Nothing
	@@V2:	mov byte ptr ds:[edi+4],VOLUME_SLIDE
		mov byte ptr ds:[edi+5],ah
		jmp @@Nothing
	@@E:	mov ah,bl
		cmp ah,0f0h
		jb short @@8
		and bl,0fh
		mov byte ptr ds:[edi+4],FINE_VOL_SLIDE_DOWN
		mov byte ptr ds:[edi+5],bl
		jmp @@Nothing
	@@8:	mov byte ptr ds:[edi+4],VOLUME_SLIDE
		mov byte ptr ds:[edi+5],bl
		jmp @@Nothing
@@F:    cmp al,5 			;Slide down
	jne short @@A
		mov bx,cs:[S3M_This_Channel]
		test ah,ah
		jnz short @@P1
		mov ah,cs:[OFFSET S3M_Last_PSlides+BX]
	@@P1:	mov cs:[OFFSET S3M_Last_PSlides+BX],ah
		mov bl,ah
		shr ah,4
		cmp ah,0eh
		jb short @@9
		je short @@EFD
		and bl,0fh
		mov byte ptr ds:[edi+4],FINE_SLIDE_DOWN
		mov byte ptr ds:[edi+5],bl
		jmp @@Nothing
	@@9:    mov byte ptr ds:[edi+4],SLIDE_DOWN
		mov byte ptr ds:[edi+5],bl
		jmp @@Nothing
	@@EFD:	and bl,0fh
		mov byte ptr ds:[edi+4],EXTRA_FINE_SLIDE_DOWN
		mov byte ptr ds:[edi+5],bl
		jmp @@Nothing

@@A:	cmp al,6 			;Slide up
	jne short @@B
		mov bx,cs:[S3M_This_Channel]
		test ah,ah
		jnz short @@P2
		mov ah,cs:[OFFSET S3M_Last_PSlides+BX]
	@@P2:	mov cs:[OFFSET S3M_Last_PSlides+BX],ah
		mov bl,ah
		shr ah,4
		cmp ah,0eh
		jb short @@C
		je short @@EFU
		and bl,0fh
		mov byte ptr ds:[edi+4],FINE_SLIDE_UP
		mov byte ptr ds:[edi+5],bl
		jmp @@Nothing
	@@C:    mov byte ptr ds:[edi+4],SLIDE_UP
		mov byte ptr ds:[edi+5],bl
		jmp @@Nothing
	@@EFU:	and bl,0fh
		mov byte ptr ds:[edi+4],EXTRA_FINE_SLIDE_UP
		mov byte ptr ds:[edi+5],bl
		jmp @@Nothing

@@B:	Test_Effect 1,SET_SPEED
	Test_Effect 2,POSITION_JUMP
	Test_Effect 3,PATTERN_BREAK
	Test_Effect 7,TONE_PORTAMENTO
	Test_Effect 8,VIBRATO
	Test_Effect 9,TREMOR
	Test_Effect 10,ARPEGGIO
	Test_Effect 11,VIB_AND_VOLSLIDE
	Test_Effect 12,TONE_AND_VOLSLIDE
	Test_Effect 15,SAMPLE_OFFSET
	Test_Effect 17,MULTIRETRIGGER_NOTE
	Test_Effect 18,TREMOLO
	Test_Effect 20,SET_SPEED
	Test_Effect 21,FINE_VIBRATO
	Test_Effect 22,SET_GLOBAL_VOLUME
;	Test_Effect 24,PANNING
	Test_Effect 25,TRAELLER
	Test_Effect 26,REVERSE_SAMPLE

	cmp al,19
	jne @@Nothing
	mov al,bl
	shr al,4
	and bl,0fh
	Test_Effect 0,SET_FILTER
	Test_Effect 1,GLISSANDO_CONTROL
	Test_Effect 2,SET_FINETUNE
	Test_Effect 3,SET_VIBWAVE_FORM
	Test_Effect 4,SET_TREMWAVE_FORM
	Test_Effect 8,BIG_PANNING
	Test_Effect 11,LOOP_JUMP
	Test_Effect 12,NOTE_CUT
	Test_Effect 13,NOTE_DELAY
	Test_Effect 14,PATTERN_DELAY
	Test_Effect 15,FUNK_INVERT

@@Nothing:

@@6:	pop edi
	jmp @@1
Convert_S3M ENDP





PUBLIC C CDMI_Load_S3M
CDMI_Load_S3M PROC FAR
	ARG fname:dword
	push bp
	mov bp,sp
	push ds
	push esi
	push edi
	push ebp

	xor ax,ax
	mov ds,ax
	call Open C,[fname],O_RDONLY
	mov cs:[IO_Handle],ax
	cmp ax,2
	jl @@Error

	mov eax,SONG_HEADER_SIZE
	call EXT_Malloc C,eax
	shl edx,16
	mov dx,ax
	test edx,edx
	jz @@Error
	mov ax,SEG CDMI_Song
	mov gs,ax
	mov gs:[CDMI_Song],edx
	mov esi,edx				;DS:ESI points to Song_Header
	Clear_Header

	mov  word ptr ds:[esi+SH_SAMPLE_FREQ],8363
	mov  word ptr ds:[esi+SH_TICKS_PER_SECOND],50

	mov edi,esi
	mov ax,ds
	mov es,ax
	add edi,SH_PATTERN_LEN
	mov eax,3f3f3f3fh
	mov ecx,256/4
	rep stos dword ptr es:[edi]		;Set break-points to 63

	xor eax,eax
	xor edi,edi
	mov di,cs
	shl edi,4
	mov ax,OFFSET IO_Buf
	add edi,eax				;DS:EDI points to read-buffer
	mov eax,60h
	call Read C,cs:[IO_Handle],edi,eax

	xor ebx,ebx				;Copy the song name...
 @@c:	mov eax,dword ptr ds:[edi+ebx]
	mov ds:[esi+ebx+SH_NAME],eax
	add bx,4
	cmp bx,28
	jne short @@c
	mov byte ptr ds:[esi+SH_NAME+28],0
	mov ax,word ptr ds:[edi+S3M_ORDER_COUNT]
	mov word ptr ds:[esi+SH_ENTRY_COUNT],ax
	mov ax,word ptr ds:[edi+S3M_PATTERN_COUNT]
	mov word ptr ds:[esi+SH_PATTERN_COUNT],ax
	mov al,byte ptr ds:[edi+S3M_MASTER_VOLUME]
	and ax,07fh
	mov word ptr ds:[esi+SH_START_VOLUME],ax
;	mov al,byte ptr ds:[edi+S3M_GLOBAL_VOLUME]
;	mov word ptr ds:[esi+SH_START_VOLUME],ax
	mov al,byte ptr ds:[edi+S3M_START_TEMPO]
	mov word ptr ds:[esi+SH_START_TEMPO],ax
	mov al,byte ptr ds:[edi+S3M_START_SPEED]
	mov word ptr ds:[esi+SH_START_SPEED],ax
	mov ax,word ptr ds:[edi+S3M_SAMPLE_FORMAT]
	mov cs:[I_Flags],ax
	mov ax,word ptr cs:[IO_Buf+S3M_INSTRUMENT_COUNT]
	mov cs:[I_Count],al

	cmp dword ptr ds:[edi+S3M_MAGIC_ADRESS],S3M_MAGIC
	jne @@Error

	mov bx,31
	xor dx,dx
 @@L1:	mov al,cs:[IO_Buf+bx+S3M_CHANNEL_MAP]
	cmp al,32
	ja short @@2
	inc dx
 @@2:   dec bx
	jns short @@L1
	mov word ptr ds:[esi+SH_CHANNELS],dx		;NOC
	mov ax,64/4
	mul dx
	mov word ptr ds:[esi+SH_START_VOLUME],ax

	movzx eax,word ptr ds:[esi+SH_ENTRY_COUNT]
	mov ebx,esi
	add ebx,SH_ORDER_LIST
	call Read C,cs:[IO_Handle],ebx,eax		;Get orders


	;The S3M format has so called para-pointers which are used to
	;address the samples and patterns inside the file. Here we read in
	;all para-pointers of the instrument-headers. These will be saved
	;temporarily in the instrument-header under IH_ADDRESS
	mov cl,cs:[I_Count]
	mov ebp,esi
 @@3:	push cx
	mov eax,2
	call Read C,cs:[IO_Handle],edi,eax		;Get inst-para-pointer
	movzx eax,word ptr cs:[IO_Buf]
	shl eax,4
	mov ds:[ebp+IH_ADDRESS],eax
	add ebp,INSTRUMENT_HEADER_SIZE
	pop cx
	dec cl
	jnz short @@3

	movzx ecx,word ptr ds:[esi+SH_PATTERN_COUNT]
	movzx ebx,word ptr ds:[esi+SH_CHANNELS]
	fastimul eax,ebx,6
	mov ds:[esi+SH_ROW_SIZE],ax
	shl eax,6
	mov ds:[esi+SH_PATTERN_SIZE],ax
	mov eax,4000h                           ;Get some temporary memory
	call EXT_Malloc C,eax			;for loading in the compressed
	test eax,eax				;S3M patterns
	jz @@Error
	mov cs:[Temp_Ptr],eax			;Save pointer


	;Now the instrument headers will be processed...
	mov ebp,esi
	mov cl,cs:[I_Count]
 @@5:	push cx
	call Seek C,cs:[IO_Handle],dword ptr ds:[ebp+IH_ADDRESS],SEEK_SET
	mov eax,50h
	call Read C,cs:[IO_Handle],edi,eax

	cmp byte ptr cs:[IO_Buf+S3M_INST_TYPE],1
	ja @@9
	cmp dword ptr cs:[IO_Buf+S3M_INST_MAGIC],'SRCS'
	jne @@9
	movzx eax,byte ptr cs:[IO_Buf+S3M_INST_ADRESS]
	shl eax,16
	mov ax,word ptr cs:[IO_Buf+S3M_INST_ADRESS+1]
	shl eax,4
	mov ds:[ebp+IH_ADDRESS],eax
	mov eax,dword ptr cs:[IO_Buf+S3M_INST_SIZE]
	mov ds:[ebp+IH_SIZE],eax
	movzx eax,word ptr cs:[IO_Buf+S3M_INST_RESAMPLE]
	mov ds:[ebp+IH_RESAMPLE],eax
	mov al,byte ptr cs:[IO_Buf+S3M_INST_VOLUME]
	cmp al,64
	jb short @@7
	mov al,64
 @@7:	mov ds:[ebp+IH_VOLUME],al
	test byte ptr cs:[IO_Buf+S3M_INST_FLAGS],1
	jnz short @@8
	mov dword ptr ds:[ebp+IH_LOOP_START],0ffffffffh
	mov dword ptr ds:[ebp+IH_LOOP_END],0h
	jmp short @@9
 @@8:   mov eax,dword ptr cs:[IO_Buf+S3M_INST_LOOP_START]
	mov ds:[ebp+IH_LOOP_START],eax
	mov eax,dword ptr cs:[IO_Buf+S3M_INST_LOOP_END]
	mov ds:[ebp+IH_LOOP_END],eax
 @@9:	xor ebx,ebx
 @@L2:	mov eax,dword ptr cs:[IO_Buf+S3M_INST_NAME+bx]
	mov ds:[ebp+ebx+IH_NAME],eax
	add bx,4
	cmp bx,28
	jne short @@L2
	mov ds:[ebp+IH_NAME+28],bh

	add ebp,INSTRUMENT_HEADER_SIZE
	pop cx
	dec cl
	jnz @@5

	;Now the patterns will be processed and unpacked...
	movzx edx,word ptr ds:[esi+SH_ENTRY_COUNT]
	add dx,60h
	movzx cx,cs:[I_Count]
	shl cx,1
	add dx,cx
	mov cs:[P_Pos],edx			;Save position...
	mov cx,ds:[esi+SH_PATTERN_COUNT]
	xor ebp,ebp
 @@4:	push cx					;CX still contains number of
	call Seek C,cs:[IO_Handle],cs:[P_Pos],SEEK_SET
	mov eax,2				;   Patterns
	call Read C,cs:[IO_Handle],edi,eax	;Get para-pointer to pattern
	movzx eax,word ptr cs:[IO_Buf]
	shl eax,4
	call Seek C,cs:[IO_Handle],eax,SEEK_SET
	mov eax,2				;
	call Read C,cs:[IO_Handle],edi,eax	;Get size of packed data
	call Read C,cs:[IO_Handle],cs:[Temp_Ptr],word ptr cs:[IO_Buf],0
	movzx eax,word ptr ds:[esi+SH_PATTERN_SIZE]
	call EXT_Malloc C,eax
	mov ds:[esi+ebp+SH_PATTERN_PTR],eax
	call Convert_S3M C,cs:[Temp_Ptr],eax,esi
	add ebp,4
	add cs:[P_Pos],2
	pop cx
	dec cx
	jnz @@4

	call EXT_Free C,cs:[Temp_Ptr]

	;Now the instruments will be loaded
	mov ebp,esi
	mov cl,cs:[I_Count]
 @@B:	push cx
	cmp dword ptr ds:[ebp+IH_SIZE],0
	je short @@A
	call Seek C,cs:[IO_Handle],dword ptr ds:[ebp+IH_ADDRESS],SEEK_SET
	mov eax,dword ptr ds:[ebp+IH_SIZE]
	add eax,4
	call EXT_Malloc C,eax
	mov ds:[ebp+IH_ADDRESS],eax
	call Read C,cs:[IO_Handle],eax,dword ptr ds:[ebp+IH_SIZE]
	cmp cs:[I_Flags],2
	jne short @@A
	mov ecx,ds:[ebp+IH_SIZE]
	mov ebx,ds:[ebp+IH_ADDRESS]
	dec ebx
 @@L3:	add byte ptr ds:[ebx+ecx],80h
	dec ecx
	jnz short @@L3
 @@A:	add ebp,INSTRUMENT_HEADER_SIZE
	pop cx
	dec cl
	jnz @@B


	;This routine will throw out strange sequence-entries, which can
	;occur in S3M-files
	xor ebx,ebx
	mov ebp,esi
	mov cx,word ptr ds:[esi+SH_ENTRY_COUNT]
 @@L4:  mov al,ds:[ebp+SH_ORDER_LIST+ebx]
	cmp al,128
	jb short @@Ok5
	inc bx
	dec word ptr ds:[esi+SH_ENTRY_COUNT]
	dec cx
	jz short @@E1
	jmp short @@L4
 @@Ok5: mov ds:[ebp+SH_ORDER_LIST],al
	inc ebp
	dec cx
	jnz short @@L4
 @@E1:

	call Close C,cs:[IO_Handle]
	call Process_Instruments

	pop ebp
	pop edi
	pop esi
	pop ds
	pop bp
	mov ax,TRUE
	retf

@@Error:
	call Close C,cs:[IO_Handle]
	pop ebp
	pop edi
	pop esi
	pop ds
	pop bp
	mov ax,FALSE
	retf
CDMI_Load_S3M ENDP





;[]-------------------------------------------------------------------------[]
;|
;| In order to complete Scream-Tracker support, here is the STM loader for
;| scream-tracker 2.0 files !!!
;|
;| A scream-tracker note is constructed like the following:
;|
;|   BYTE[0]   BYTE[1]   BYTE[2]   BYTE[3]
;|   aaaaaaaa  bbbbbbbb  cccccccc  dddddddd
;|       
;|                            8 bit effect value
;|                       4 bit effect
;|               7 bit volume (ccccbbb)
;|           5 bit instrument
;|      note
;|  octave
;|
;|
STM_NAME		equ	0
STM_TRACKER_NAME	equ	20
STM_VERSION		equ	28
STM_TYPE		equ	29
STM_SPEED		equ	32
STM_PATTERN_COUNT	equ	33
STM_GLOBAL_VOLUME	equ	34
STM_INST_NAME		equ	0	;13 bytes
STM_INST_SIZE		equ	16
STM_INST_LOOP_START	equ	18
STM_INST_LOOP_END	equ	20
STM_INST_VOLUME		equ	22
STM_INST_RESAMPLE	equ	24



Convert_STM PROC NEAR
	ARG src:dword,dest:dword,song:dword
	push bp
	mov bp,sp
	push esi
	push edi
	push ebp

	mov esi,[src]
	mov edi,[dest]

	push edi
	mov ecx,6*64*4/4
	xor eax,eax
	mov es,ax
	rep stos dword ptr es:[edi]
	pop edi

	mov cx,64*4
	mov ebp,[song]
@@L1:   mov al,ds:[esi]
	cmp al,0ffh
	je short @@D
	mov bl,al
	and bx,0fh
	and ax,0f0h
	shr ax,4
	fastimul dx,ax,12
	add bx,dx
	shl bx,1
	mov ax,word ptr cs:[OFFSET PeriodTable+bx+4*12]
	rol ax,8			;Swap lo-high bytes !!!
	mov ds:[edi],ax			;AX=pitch

@@1:	mov bl,ds:[esi+1]
	shr bl,3
	jz short @@D
	mov ds:[edi+2],bl

@@D:    mov al,ds:[esi+2]
	and al,0f0h
	shr al,1
	mov bl,ds:[esi+1]
	and bl,7
	add al,bl
	cmp al,64
	jbe short @@2
;	or byte ptr ds:[edi],80h
	jmp @@4
@@2:    jb short @@3
	mov al,64
@@3:	add al,10h
	mov ds:[edi+3],al

@@4:	mov al,ds:[esi+2]		;AL has command-value
	and al,0fh
	je @@Nothing
	mov bl,ds:[esi+3]		;BL has parameter
	cmp al,1
	jne short @@7
		shr bl,4
		mov bh,SET_SPEED
		ror bx,8
		mov ds:[edi+4],bx
		jmp @@Nothing
@@7:	Test_Effect 2,POSITION_JUMP
	Test_Effect 3,PATTERN_BREAK
	Test_Effect 4,VOLUME_SLIDE
	Test_Effect 5,SLIDE_DOWN
	Test_Effect 6,SLIDE_UP
	Test_Effect 7,TONE_PORTAMENTO
	Test_Effect 8,VIBRATO
	Test_Effect 10,ARPEGGIO

@@Nothing:
	add esi,4
	add edi,6
	dec cx
	jnz @@L1

	pop ebp
	pop edi
	pop esi
	pop bp
	retn
Convert_STM ENDP




PUBLIC C CDMI_Load_STM
CDMI_Load_STM PROC FAR
	ARG fname:dword
	push bp
	mov bp,sp
	push ds
	push esi
	push edi
	push ebp

	xor ax,ax
	mov ds,ax
	call Open C,[fname],O_RDONLY
	mov cs:[IO_Handle],ax
	cmp ax,2
	jl @@Error

	mov eax,SONG_HEADER_SIZE
	call EXT_Malloc C,eax
	test eax,eax
	jz @@Error
	mov dx,SEG CDMI_Song
	mov gs,dx
	mov gs:[CDMI_Song],eax
	mov esi,eax				;DS:ESI points to Song_Header

	Clear_Header
	mov  word ptr ds:[esi+SH_SAMPLE_FREQ],8363
	mov  word ptr ds:[esi+SH_TICKS_PER_SECOND],50
	mov  word ptr ds:[esi+SH_START_VOLUME],64
	mov  word ptr ds:[esi+SH_CHANNELS],4
	mov  word ptr ds:[esi+SH_ROW_SIZE],4*6
	mov  word ptr ds:[esi+SH_PATTERN_SIZE],4*6*64
	mov  word ptr ds:[esi+SH_START_TEMPO],125

	mov edi,esi
	mov ax,ds
	mov es,ax
	add edi,SH_PATTERN_LEN
	mov eax,3f3f3f3fh
	mov ecx,256/4
	rep stos dword ptr es:[edi]		;Set break-points to 63

	xor eax,eax
	xor edi,edi
	mov di,cs
	shl edi,4
	mov ax,OFFSET IO_Buf
	add edi,eax				;DS:EDI points to read-buffer
	mov eax,48
	call Read C,cs:[IO_Handle],edi,eax

	xor ebx,ebx
 @@c:	mov eax,dword ptr ds:[edi+ebx]
	mov ds:[esi+ebx+SH_NAME],eax
	add bx,4
	cmp bx,12
	jne short @@c
	mov byte ptr ds:[esi+SH_NAME+12],0
	xor ah,ah
	mov al,byte ptr cs:[OFFSET IO_Buf+STM_PATTERN_COUNT]
	mov word ptr ds:[esi+SH_PATTERN_COUNT],ax
	mov al,byte ptr cs:[OFFSET IO_Buf+STM_SPEED]
	mov word ptr ds:[esi+SH_START_SPEED],6

	mov cx,31
	mov ebp,esi
 @@L1:	push cx
	mov eax,32
	call Read C,cs:[IO_Handle],edi,eax
	xor ebx,ebx
 @@d:	mov eax,dword ptr cs:[OFFSET IO_Buf+bx]
	mov ds:[ebp+ebx+IH_NAME],eax
	add bx,4
	cmp bx,12
	jne short @@d
	mov byte ptr ds:[ebp+IH_NAME+12],0
	movzx eax,word ptr cs:[OFFSET IO_Buf+STM_INST_SIZE]
	mov ds:[ebp+IH_SIZE],eax
	cmp word ptr cs:[OFFSET IO_Buf+STM_INST_LOOP_END],0ffffh
	jne short @@4
	cmp word ptr cs:[OFFSET IO_Buf+STM_INST_LOOP_START],0h
	je short @@2
 @@4:	mov ax,word ptr cs:[OFFSET IO_Buf+STM_INST_LOOP_START]
	mov ds:[ebp+IH_LOOP_START],eax
	mov ax,word ptr cs:[OFFSET IO_Buf+STM_INST_LOOP_END]
	mov ds:[ebp+IH_LOOP_END],eax
	jmp short @@3
 @@2:	mov dword ptr ds:[ebp+IH_LOOP_START],0ffffffffh
	mov dword ptr ds:[ebp+IH_LOOP_END],0h
 @@3:	mov al,byte ptr cs:[OFFSET IO_Buf+STM_INST_VOLUME]
	mov ds:[ebp+IH_VOLUME],al
	movzx eax,word ptr cs:[OFFSET IO_Buf+STM_INST_RESAMPLE]
	mov ds:[ebp+IH_RESAMPLE],eax
	add ebp,INSTRUMENT_HEADER_SIZE
	pop cx
	dec cx
	jnz @@L1

	mov ebp,esi
	add ebp,SH_PATTERN_LIST
	mov eax,128
	call Read C,cs:[IO_Handle],ebp,eax	;Get order list
	xor ebx,ebx
 @@P:	cmp byte ptr ds:[ebp+ebx],99
	jae short @@EP
	inc bx
	cmp bx,128
	jb short @@P
 @@EP:  mov ds:[esi+SH_ENTRY_COUNT],bx

	movzx eax,word ptr ds:[esi+SH_PATTERN_COUNT]
	fastimul ebx,eax,4*64*4
	push ebx
	call EXT_Malloc C,ebx
	test eax,eax
	jz @@Error
	mov cs:[Temp_Ptr],eax
	mov edi,eax
	pop ebx
	call Read C,cs:[IO_Handle],eax,ebx

	mov cx,ds:[esi+SH_PATTERN_COUNT]
	xor ebp,ebp
  @@L2: push cx
	movzx eax,word ptr ds:[esi+SH_PATTERN_SIZE]
	call EXT_Malloc C,eax
	mov ds:[esi+SH_PATTERN_PTR+ebp],eax
	call Convert_STM C,edi,eax,esi
	add edi,64*4*4
	add ebp,4
	pop cx
	dec cx
	jnz short @@L2
	call EXT_Free C,dword ptr cs:[Temp_Ptr]


	;Now the instruments will be loaded
	mov ebp,esi
	mov cl,31
 @@B:	push cx
	cmp dword ptr ds:[ebp+IH_SIZE],0
	je short @@A
	mov eax,dword ptr ds:[ebp+IH_SIZE]
	add eax,4
	call EXT_Malloc C,eax
	mov ds:[ebp+IH_ADDRESS],eax
	call Read C,cs:[IO_Handle],eax,dword ptr ds:[ebp+IH_SIZE]
 @@A:	add ebp,INSTRUMENT_HEADER_SIZE
	pop cx
	dec cl
	jnz @@B

	call Close C,cs:[IO_Handle]
	call Process_Instruments
	pop ebp
	pop edi
	pop esi
	pop ds
	pop bp
	mov ax,TRUE
	retf

@@Error:
	call Close C,cs:[IO_Handle]
	pop ebp
	pop edi
	pop esi
	pop ds
	pop bp
	mov ax,FALSE
	retf
CDMI_Load_STM ENDP




;[]-------------------------------------------------------------------------[]
;|
;| This is the MTM_loader ,which will load Renaissance's new MTM-modules
;| Note that the tracks are stored individually in order to save space. But
;| when loading a MTM-song, we will have to remix all tracks.
;|
;| A MTM-Note looks like this:
;|      BYTE 0   BYTE 1   BYTE 2
;|	ppppppii iiiieeee aaaaaaaa
;|
;|	 p = pitch value (0=no pitch stated)
;|	 i = instrument number (0=no instrument number)
;|	 e = effect number
;|	 a = effect argument
;|
;| The effects are just the same like the standard MOD-effects.
;|
MTM_NAME		equ     4           ;
MTM_MAGIC_POS		equ	0           ;
MTM_MAGIC		equ	'TM'        ;
MTM_TRACK_COUNT		equ	24          ;
MTM_PATTERN_COUNT       equ	26          ;
MTM_ORDER_COUNT		equ	27          ;
MTM_COMMENT_SIZE	equ	28
MTM_SAMPLE_COUNT	equ	30          ;
MTM_ATTRIBUTE		equ	31
MTM_BEATS_PER_TRACK	equ	32
MTM_TRACKS_PLAYED	equ	33
MTM_VOICE_PANNING	equ	34
MTM_HEADER_SIZE		equ	66

MTM_I_NAME		equ	0
MTM_I_SIZE		equ	22
MTM_I_LOOP_START	equ	26
MTM_I_LOOP_END		equ	30
MTM_I_FINETUNE		equ	34
MTM_I_VOLUME		equ	35
MTM_I_FLAGS		equ	36
MTM_I_HEADER_SIZE	equ	37

MTM_TRACK_SIZE		equ	192

Convert_MTM PROC NEAR
	ARG src:dword,trackmap:dword,song:dword
	push bp
	mov bp,sp
	push esi
	push edi
	push ebp

	mov esi,[src]
	mov ebx,[trackmap]
	mov ebp,[song]
	xor edi,edi

	mov cx,ds:[ebp+SH_PATTERN_COUNT]
@@L1:   push edi
	push cx
	push ebx
	movzx eax,word ptr ds:[ebp+SH_PATTERN_SIZE]
	call EXT_Malloc C,eax
	mov ds:[ebp+edi+SH_PATTERN_PTR],eax
	mov edi,eax

	push edi
	movzx ecx,word ptr ds:[ebp+SH_PATTERN_SIZE]
	shr cx,2
	xor eax,eax
	mov es,ax
	rep stos dword ptr es:[edi]
	pop edi
	pop ebx

	mov cx,32

@@L2:	push cx
	push ebx
	movzx eax,word ptr ds:[ebx]
	dec eax
	js @@N1

	push edi
	push esi
	fastimul edx,eax,MTM_TRACK_SIZE
	add esi,edx			;DS:[ESI] points to source-track
	mov cx,64

@@2:	movzx bx,ds:[esi]
	shr bx,2
	jz short @@Check_Inst
	shl bx,1
	mov ax,cs:[OFFSET PeriodTable+bx+4*12-2]
	rol ax,8			;Swap lo-high bytes !!!
	mov ds:[edi],ax			;AX=pitch
@@Check_Inst:
	mov bl,ds:[esi]			;Get upper 2 bits
	and bl,11b
	shl bl,4
	mov bh,ds:[esi+1]		;Get lower four bits of instrument
	shr bh,4			;Shift away effect bits
	add bl,bh			;BL finally has instrument
	mov ds:[edi+2],bl
	mov al,ds:[esi+1]		;AL has command-value
	mov bl,ds:[esi+2]		;BL has parameter
	and al,0fh
	jnz short @@01
		test bl,bl
		jz @@Nothing
		mov byte ptr ds:[edi+4],ARPEGGIO
		mov byte ptr ds:[edi+5],bl
		jmp @@Nothing
@@01:   cmp al,12			;Set volume
	jne short @@02
		cmp bl,40h
		jb short @@5
		mov bl,40h
	  @@5:	add bl,10h
		mov ds:[edi+3],bl
		jmp @@Nothing
@@02:	Test_Effect 1,SLIDE_UP
	Test_Effect 2,SLIDE_DOWN
	Test_Effect 3,TONE_PORTAMENTO
	Test_Effect 4,VIBRATO
	Test_Effect 5,TONE_AND_VOLSLIDE
	Test_Effect 6,VIB_AND_VOLSLIDE
	Test_Effect 7,TREMOLO
;	Test_Effect 8,PANNING
	Test_Effect 9,SAMPLE_OFFSET
	Test_Effect 10,VOLUME_SLIDE
	Test_Effect 11,POSITION_JUMP
	Test_Effect 13,PATTERN_BREAK
	Test_Effect 15,SET_SPEED

	cmp al,14
	jne @@Nothing
	mov al,ds:[esi+2]
	shr al,4
	and bl,0fh
	Test_Effect 0,SET_FILTER
	Test_Effect 1,FINE_SLIDE_UP
	Test_Effect 2,FINE_SLIDE_DOWN
	Test_Effect 3,GLISSANDO_CONTROL
	Test_Effect 4,SET_VIBWAVE_FORM
	Test_Effect 5,SET_FINETUNE
	Test_Effect 6,LOOP_JUMP
	Test_Effect 7,SET_TREMWAVE_FORM
	Test_Effect 8,BIG_PANNING
	Test_Effect 9,RETRIGGER_NOTE
	Test_Effect 10,FINE_VOL_SLIDE_UP
	Test_Effect 11,FINE_VOL_SLIDE_DOWN
	Test_Effect 12,NOTE_CUT
	Test_Effect 13,NOTE_DELAY
	Test_Effect 14,PATTERN_DELAY
	Test_Effect 15,FUNK_INVERT
@@Nothing:
	add esi,3			;Next pattern-note
	movzx eax,word ptr ds:[ebp+SH_ROW_SIZE]
	add edi,eax			;Next channel - info
	dec cx
	jnz @@2


	pop esi
	pop edi
	add edi,6			;Next row

@@N1:	pop ebx
	pop cx
	add ebx,2
	dec cx
	jnz @@L2

	pop cx
	pop edi
	add edi,4
	dec cx
	jnz @@L1



	pop ebp
	pop edi
	pop esi
	pop bp
	retn
Convert_MTM ENDP




PUBLIC C CDMI_Load_MTM
CDMI_Load_MTM PROC FAR
	ARG fname:dword
	push bp
	mov bp,sp
	push ds
	push esi
	push edi
	push ebp

	xor ax,ax
	mov ds,ax
	call Open C,[fname],O_RDONLY
	mov cs:[IO_Handle],ax
	cmp ax,2
	jl @@Error

	mov eax,SONG_HEADER_SIZE
	call EXT_Malloc C,eax
	shl edx,16
	mov dx,ax
	test edx,edx
	jz @@Error
	mov ax,SEG CDMI_Song
	mov gs,ax
	mov gs:[CDMI_Song],edx
	mov esi,edx				;DS:ESI points to Song_Header

	Clear_Header
	mov  word ptr ds:[esi+SH_SAMPLE_FREQ],8196
	mov  word ptr ds:[esi+SH_START_SPEED],6
	mov  word ptr ds:[esi+SH_START_TEMPO],125
	mov  word ptr ds:[esi+SH_TICKS_PER_SECOND],50

	mov edi,esi
	mov ax,ds
	mov es,ax
	add edi,SH_PATTERN_LEN
	mov eax,3f3f3f3fh
	mov ecx,256/4
	rep stos dword ptr es:[edi]		;Set break-points to 63

	xor eax,eax
	xor edi,edi
	mov di,cs
	shl edi,4
	mov ax,OFFSET IO_Buf
	add edi,eax				;DS:EDI points to read-buffer
	mov eax,MTM_HEADER_SIZE
	call Read C,cs:[IO_Handle],edi,eax

	mov ebp,esi
	add ebp,SH_NAME				;DS:EBP points to name
	xor ebx,ebx
 @@c:	mov eax,dword ptr ds:[edi+MTM_NAME+ebx]
	mov ds:[esi+ebx+SH_NAME],eax
	add bx,4
	cmp bx,20
	jne short @@c
	mov byte ptr ds:[esi+SH_NAME+20],0

	mov al,cs:[OFFSET IO_Buf+MTM_SAMPLE_COUNT]
	mov cs:[I_COUNT],al
	movzx ax,cs:[OFFSET IO_Buf+MTM_PATTERN_COUNT]
	inc ax
	mov cs:[P_COUNT],ax
	mov ds:[esi+SH_PATTERN_COUNT],ax
	mov ax,word ptr cs:[OFFSET IO_Buf+MTM_TRACK_COUNT]
	mov cs:[T_COUNT],ax
	movzx ax,cs:[OFFSET IO_Buf+MTM_ORDER_COUNT]
	mov ds:[esi+SH_ENTRY_COUNT],ax

	mov eax,194
	movzx ebx,cs:[I_Count]
	fastimul edx,ebx,MTM_I_HEADER_SIZE
	add eax,edx
	movzx ebx,cs:[T_Count]
	fastimul edx,ebx,MTM_TRACK_SIZE
	add eax,edx
	movzx ebx,cs:[P_Count]
	fastimul edx,ebx,64
	add eax,edx
	movzx ebx,word ptr cs:[IO_Buf+MTM_COMMENT_SIZE]
	add eax,ebx
	mov cs:[I_Pos],eax			;Where to find the samples



	;Now the instrument headers will be read in
	mov cl,cs:[I_Count]
	mov ebp,esi

  @@2:	push cx
	mov eax,MTM_I_HEADER_SIZE
	call Read C,cs:[IO_Handle],edi,eax
	xor ebx,ebx				;This is a stupid
  @@N:  mov ax,word ptr cs:[OFFSET IO_Buf+bx]	;copyroutine for the
	mov ds:[ebp+IH_NAME+ebx],ax		;instrument's name
	add bx,2
	cmp bx,22
	jne short @@N

	mov eax,dword ptr cs:[OFFSET IO_Buf+MTM_I_SIZE]
	mov ds:[ebp+IH_SIZE],eax
	mov eax,dword ptr cs:[OFFSET IO_Buf+MTM_I_LOOP_START]
	cmp eax,dword ptr cs:[OFFSET IO_Buf+MTM_I_LOOP_END]
	jae short @@NoLoop
	cmp dword ptr cs:[OFFSET IO_Buf+MTM_I_LOOP_END],02h
	jbe short @@NoLoop
		mov ds:[ebp+IH_LOOP_START],eax
		mov eax,dword ptr cs:[OFFSET IO_Buf+MTM_I_LOOP_END]
		mov ds:[ebp+IH_LOOP_END],eax
		jmp short  @@3
	@@NoLoop:
		mov dword ptr ds:[ebp+IH_LOOP_START],0ffffffffh
 @@3:   mov bl,byte ptr cs:[OFFSET IO_Buf+MTM_I_FineTune]
	and bx,0fh
	shl bx,1
	movzx eax,word ptr cs:[OFFSET MOD_Adjust_Frequencies+bx]
	mov ds:[ebp+IH_RESAMPLE],eax
	mov al,cs:[OFFSET IO_Buf+MTM_I_Volume]
	mov ds:[ebp+IH_VOLUME],al
	add ebp,INSTRUMENT_HEADER_SIZE
	pop cx			;Get instrument-counter
	dec cl
	jnz  @@2



	;Now the pattern-order data will be read in
	mov eax,esi
	add eax,SH_ORDER_LIST
	mov ebx,128
	call Read C,cs:[IO_Handle],eax,ebx



	;Well, now comes the track data. It will NOT be processed directly,
	;but saved for later
	movzx eax,cs:[T_Count]
	fastimul ebx,eax,MTM_TRACK_SIZE
	push ebx			;Save size
	call EXT_Malloc C,ebx
	test eax,eax
	jz @@Error
	mov cs:[Temp_Ptr],eax
	pop ebx
	call Read C,cs:[IO_Handle],eax,ebx


	;Now comes the "track sequencing data" This data will decide how many
	;tracks are actually needed in order to play this file
	movzx eax,cs:[P_COUNT]
	shl eax,6			;*64
	push eax
	call EXT_Malloc C,eax
	test eax,eax
	jz @@Error
	mov cs:[FUck_Ptr],eax
	mov ebp,eax			;EBP points to sequencing data
	pop ebx
	call Read C,cs:[IO_Handle],eax,ebx

	xor bx,bx			;BX will hold number of channels
	mov cx,cs:[P_COUNT]

@@L2:	mov ch,32
	xor dx,dx
@@L3:	cmp word ptr ds:[ebp],0
	je short @@4
	inc dx
@@4:    add ebp,2
	dec ch
	jnz short @@L3
	cmp bx,dx
	ja short @@5
	mov bx,dx
@@5:	dec cl
	jnz short @@L2
					;BX now holds the number of channels
	mov ax,bx
	shl ax,4
	mov ds:[esi+SH_START_VOLUME],ax
	mov ds:[esi+SH_CHANNELS],bx
	fastimul ax,bx,6
	mov ds:[esi+SH_ROW_SIZE],ax
	shl ax,6
	mov ds:[esi+SH_PATTERN_SIZE],ax

	call Convert_MTM C,cs:[Temp_Ptr],cs:[Fuck_Ptr],esi
	call EXT_Free C,cs:[Fuck_Ptr]
	call EXT_Free C,cs:[Temp_Ptr]


	call Seek C,cs:[IO_Handle],cs:[I_Pos],SEEK_SET
	mov cl,cs:[I_Count]			;and load them !
	mov edi,esi
   @@8:	push cx
	cmp dword ptr ds:[edi+IH_SIZE],0
	je short @@9
	mov eax,dword ptr ds:[edi+IH_SIZE]
	add eax,4
	call EXT_Malloc C,eax
	mov ds:[edi+IH_ADDRESS],eax
	push eax
	call Read C,cs:[IO_Handle],eax,dword ptr ds:[edi+IH_SIZE]
	pop eax
	mov ecx,ds:[edi+IH_SIZE]
	dec ecx
  @@L4: add byte ptr ds:[eax+ecx],80h
	dec ecx
	jns short @@L4
   @@9: add edi,INSTRUMENT_HEADER_SIZE
	pop cx
	dec cl
	jnz short @@8


	call Close C,cs:[IO_Handle]
	call Process_Instruments

	pop ebp
	pop edi
	pop esi
	pop ds
	pop bp
	mov ax,TRUE
	retf

@@Error:
	call Close C,cs:[IO_Handle]
	pop ebp
	pop edi
	pop esi
	pop ds
	pop bp
	mov ax,FALSE
	retf
CDMI_Load_MTM ENDP





;[]-------------------------------------------------------------------------[]
;|
;| The following routines are for the XM-loader. Note that this powerful
;| format is not implemented completely yet as there have to be done lots
;| of changes in the other loaders, too.
;|
;| The patterns are stored as ordinary MOD patterns, except that each
;| note is stored as 5 bytes:
;|
;|    ?      1   (byte) Note (0-71, 0 = C-0)
;|   +1      1   (byte) Instrument (0-128)
;|   +2      1   (byte) Volume column byte (see below)
;|   +3      1   (byte) Effect type
;|   +4      1   (byte) Effect parameter
;|
;| A simle packing scheme is also adopted, so that the patterns not become
;| TOO large: Since the MSB in the note value is never used, if is used for
;| the compression. If the bit is set, then the other bits are interpreted
;| as follows:
;|
;| bit 0 set: Note follows
;|	1 set: Instrument follows
;| 	2 set: Volume column byte follows
;| 	3 set: Effect follows
;| 	4 set: Guess what!
;|
XM_MAGIC		equ	0
XM_MAIN_HEADER_SIZE	equ	80
XM_NAME			equ	17

XM_ENTRY_COUNT		equ	64
XM_RESTART_POSITION	equ	66
XM_CHANNEL_COUNT        equ	68
XM_PATTERN_COUNT	equ	70
XM_INST_COUNT		equ	72
XM_MAIN_FLAGS		equ	74
XM_START_SPEED		equ	76
XM_START_TEMPO		equ	78

Convert_XM PROC NEAR
	ARG src:dword,dest:dword,beats:word,song:dword
	push bp
	mov bp,sp
	push ebp
	push esi
	push edi

	mov esi,[src]
	mov edi,[dest]

	push edi
	mov ax,[beats]
	mov ebx,[song]
	mul word ptr ds:[ebx+SH_ROW_SIZE]
	movzx ecx,ax
	shr ecx,2
	xor eax,eax
	mov es,ax
	rep stos dword ptr es:[edi]	;Clear this pattern...
	pop edi

	mov ax,[beats]
	mov ebp,[song]
	mul word ptr ds:[ebp+SH_CHANNELS]
	mov cx,ax
@@L1:	mov dl,ds:[esi]
	inc esi
	test dl,80h
	jnz short @@D
	dec esi
	mov dl,0ffh

@@D:	test dl,1
	jz short @@NoPitch
	movzx bx,ds:[esi]
	inc esi
	cmp bl,61h
	jne short @@2
	mov byte ptr ds:[edi],80h	;key-off
	jmp short @@NoPitch
@@2:	shl bx,1
	mov ax,word ptr cs:[OFFSET PeriodTable+bx]
	rol ax,8			;Swap lo-high bytes !!!
	mov ds:[edi],ax			;AX=pitch

@@NoPitch:
	test dl,2
	jz short @@NoInst
	mov bl,ds:[esi]
	inc esi
	mov ds:[edi+2],bl		;Save instrument

@@NoInst:
	test dl,4
	jz short @@NoVol
	mov al,ds:[esi]			;Volume coloumn byte
	inc esi
	test al,al
	jz short @@NoVol
	mov es:[edi+3],al

@@NoVol:
	test dl,8
	jz @@NoFX
	mov al,ds:[esi]			;Get effect
	inc esi
	xor bl,bl			;Clear parameter value

	Test_Effect 1,SLIDE_UP
	Test_Effect 2,SLIDE_DOWN
	Test_Effect 3,TONE_PORTAMENTO
	Test_Effect 4,VIBRATO
	Test_Effect 5,TONE_AND_VOLSLIDE
	Test_Effect 6,VIB_AND_VOLSLIDE
	Test_Effect 7,TREMOLO
	Test_Effect 8,PANNING
	Test_Effect 9,SAMPLE_OFFSET
	Test_Effect 10,VOLUME_SLIDE
	Test_Effect 11,POSITION_JUMP
	Test_EFfect 12,SET_VOLUME
	Test_Effect 13,PATTERN_BREAK
	Test_Effect 15,SET_SPEED
	Test_Effect 16,SET_GLOBAL_VOLUME
	Test_Effect 17,GLOBAL_VOLUME_SLIDE
	Test_Effect 21,SET_ENVELOPE_POSITION
	Test_Effect 25,PANNING_SLIDE
	Test_Effect 27,MULTI_RETRIGGER_NOTE
	Test_Effect 29,TREMOR

	cmp al,20			;Key-off
	jne short @@3
	mov word ptr ds:[edi],80h
	jmp @@Nothing

@@3:	cmp al,14			;Extended effects
	jne @@Nothing
	xor al,al
	xor bl,bl
	test dl,16
	jz short @@4
	mov al,ds:[esi]
	mov bl,al
	inc esi
	and dl,NOT 16
@@4:	shr al,4
	and bl,0fh
	Test_Effect 0,SET_FILTER
	Test_Effect 1,FINE_SLIDE_UP
	Test_Effect 2,FINE_SLIDE_DOWN
	Test_Effect 3,GLISSANDO_CONTROL
	Test_Effect 4,SET_VIBWAVE_FORM
	Test_Effect 5,SET_FINETUNE
	Test_Effect 6,LOOP_JUMP
	Test_Effect 7,SET_TREMWAVE_FORM
	Test_Effect 8,BIG_PANNING
	Test_Effect 9,RETRIGGER_NOTE
	Test_Effect 10,FINE_VOL_SLIDE_UP
	Test_Effect 11,FINE_VOL_SLIDE_DOWN
	Test_Effect 12,NOTE_CUT
	Test_Effect 13,NOTE_DELAY
	Test_Effect 14,PATTERN_DELAY
	Test_Effect 15,FUNK_INVERT

@@Nothing:
@@NoFX:	test dl,16
	jz short @@NoParam
	mov al,ds:[esi]
	mov byte ptr ds:[edi+5],al
	inc esi
	cmp byte ptr ds:[edi+4],0 		;Was it an arpeggio ?
	jne short @@1
	mov byte ptr ds:[edi+4],ARPEGGIO
@@1:
@@NoParam:
	add edi,6
	dec cx
	jnz @@L1

	pop edi
	pop esi
	pop ebp
	pop bp
	retn
Convert_XM ENDP






PUBLIC C CDMI_Load_XM
CDMI_Load_XM PROC FAR
	ARG fname:dword
	push bp
	mov bp,sp
	push ds
	push esi
	push edi
	push ebp

	xor ax,ax
	mov ds,ax
	call Open C,[fname],O_RDONLY
	mov cs:[IO_Handle],ax
	cmp ax,1
	jl @@Error

	mov eax,SONG_HEADER_SIZE
	call EXT_Malloc C,eax
	test eax,eax
	jz @@Error
	mov dx,SEG CDMI_Song
	mov gs,dx
	mov gs:[CDMI_Song],eax
	mov esi,eax				;DS:ESI points to Song_Header

	Clear_Header
	mov word ptr ds:[esi+SH_SAMPLE_FREQ],8569
	mov word ptr ds:[esi+SH_TICKS_PER_SECOND],50

	xor eax,eax
	xor edi,edi
	mov di,cs
	shl edi,4
	mov ax,OFFSET IO_Buf
	add edi,eax				;DS:EDI points to read-buffer
	mov eax,XM_MAIN_HEADER_SIZE
	call Read C,cs:[IO_Handle],edi,eax

	cmp dword ptr cs:[IO_Buf],'etxE'
	jne @@Error
	mov ebp,esi
	add ebp,SH_NAME				;DS:EBP points to name
	xor ebx,ebx
 @@c:	mov eax,dword ptr ds:[edi+XM_NAME+ebx]
	mov ds:[esi+ebx+SH_NAME],eax
	add bx,4
	cmp bx,20
	jne short @@c
	mov byte ptr ds:[esi+SH_NAME+20],0

	mov ax,word ptr cs:[IO_Buf+XM_START_TEMPO]
	mov ds:[esi+SH_START_TEMPO],ax
	mov ax,word ptr cs:[IO_Buf+XM_START_SPEED]
	mov ds:[esi+SH_START_SPEED],ax
	mov ax,word ptr cs:[IO_Buf+XM_ENTRY_COUNT]
	mov ds:[esi+SH_ENTRY_COUNT],ax
	mov ax,word ptr cs:[IO_Buf+XM_PATTERN_COUNT]
	mov ds:[esi+SH_PATTERN_COUNT],ax
	mov ax,word ptr cs:[IO_Buf+XM_INST_COUNT]
	mov cs:[I_Count],al
	mov ax,word ptr cs:[IO_Buf+XM_CHANNEL_COUNT]
	mov ds:[esi+SH_CHANNELS],ax
	mov bx,ax
	shl bx,4
	mov ds:[esi+SH_START_VOLUME],bx
	fastimul bx,ax,6
	mov ds:[esi+SH_ROW_SIZE],bx
	shl ax,6			;Assuming 64 rows/pattern
	mov ds:[esi+SH_PATTERN_SIZE],ax


	mov eax,esi
	add eax,SH_PATTERN_LIST
	mov ebx,256
	call Read C,cs:[IO_Handle],eax,ebx	;Get order list

	mov eax,66000
	call EXT_Malloc C,eax
	test eax,eax
	jz @@Error
	mov cs:[Temp_Ptr],eax

	mov cx,ds:[esi+SH_PATTERN_COUNT]
	xor ebp,ebp
@@L1:	push cx
	push ebp
	mov ebx,9				;Size of pattern-header
	call Read C,cs:[IO_Handle],edi,ebx	;Read in header...
	mov ax,word ptr cs:[IO_Buf+5]
	dec ax
	mov ds:[esi+ebp+SH_PATTERN_LEN],al
	inc ax
	mul word ptr ds:[esi+SH_ROW_SIZE]
	and eax,0ffffh
	call EXT_Malloc C,eax
	mov ds:[esi+4*ebp+SH_PATTERN_PTR],eax
	mov ebp,eax
	movzx eax,word ptr cs:[IO_Buf+7]		;Packed ptn-size
	call Read C,cs:[IO_Handle],cs:[Temp_Ptr],eax	;Read in this pattern...
	call Convert_XM C,cs:[Temp_Ptr],ebp,word ptr cs:[IO_Buf+5],esi

	pop ebp
	pop cx
	inc ebp
	dec cx
	jnz @@L1

	call EXT_Free C,cs:[Temp_Ptr]


	;
	;Now the instruments will be processed
	;
	mov cl,cs:[I_Count]
	mov ebp,esi
@@L2:	push cx
	mov ebx,4+22+1+2+4			;Size of instrument header
	call Read C,cs:[IO_Handle],edi,ebx	;Read in header...
	xor ebx,ebx				;This is a stupid
  @@N:  mov ax,word ptr cs:[OFFSET IO_Buf+bx+4]	;copyroutine for the
	mov ds:[ebp+IH_NAME+ebx],ax		;instrument's name
	add bx,2
	cmp bx,22
	jne short @@N

	mov ax,word ptr cs:[IO_Buf+27]		;Number of samples...
	test ax,ax
	jz @@5					;No sample
	push ax
	mov ebx,96+48+48+18+20
	call Read C,cs:[IO_Handle],edi,ebx	;Read in header...
	mov al,cs:[IO_Buf+235-33]
	mov ds:[ebp+IH_AVIB_FORM],al
	mov al,cs:[IO_Buf+236-33]
	mov ds:[ebp+IH_AVIB_SWEEP],al
	mov al,cs:[IO_Buf+237-33]
	mov ds:[ebp+IH_AVIB_DEPTH],al
	mov al,cs:[IO_Buf+238-33]
	mov ds:[ebp+IH_AVIB_SPEED],al
	mov ax,word ptr cs:[IO_Buf+239-33]
	mov ds:[ebp+IH_FADE_OUT],ax
	movzx ax,byte ptr cs:[IO_Buf+225-33]
	mov ds:[ebp+IH_VENVELOPE_SIZE],ax
	mov al,byte ptr cs:[IO_Buf+227-33]
	mov ds:[ebp+IH_VENVELOPE_SUSTAIN],ax
	mov al,byte ptr cs:[IO_Buf+228-33]
	mov ds:[ebp+IH_VENVELOPE_LOOP_START],ax
	mov al,byte ptr cs:[IO_Buf+229-33]
	mov ds:[ebp+IH_VENVELOPE_LOOP_END],ax
	mov al,byte ptr cs:[IO_Buf+226-33]
	mov ds:[ebp+IH_PENVELOPE_SIZE],ax
	mov al,byte ptr cs:[IO_Buf+230-33]
	mov ds:[ebp+IH_PENVELOPE_SUSTAIN],ax
	mov al,byte ptr cs:[IO_Buf+231-33]
	mov ds:[ebp+IH_PENVELOPE_LOOP_START],ax
	mov al,byte ptr cs:[IO_Buf+232-33]
	mov ds:[ebp+IH_PENVELOPE_LOOP_END],ax
	or dword ptr ds:[ebp+IH_FLAGS],IF_USE_PANNING


	;
	;Here we copy the volume and panning envelopes
	;
	push esi
	push edi
	xor ax,ax
	mov es,ax

	mov edi,ebp
	add edi,IH_VENVELOPE_POINTS		;Now lets cope the envelope
	xor esi,esi
	mov si,OFFSET IO_Buf+129-33
	mov ecx,48/4
	rep movs dword ptr es:[edi],cs:[esi]

	mov edi,ebp
	add edi,IH_PENVELOPE_POINTS
	mov si,OFFSET IO_Buf+177-33
	mov ecx,48/4
	rep movs dword ptr es:[edi],cs:[esi]

	pop edi
	pop esi


	;
	;Now test the volume envelope flags...
	;
	test byte ptr cs:[IO_Buf+233-33],1
	jz short @@V0
	or dword ptr ds:[ebp+IH_FLAGS],IF_VOLUME_ENVELOPE
@@V0:	test byte ptr cs:[IO_Buf+233-33],2
	jz short @@V1
	or dword ptr ds:[ebp+IH_FLAGS],IF_VOLUME_ENVELOPE_SUSTAIN
@@V1:	test byte ptr cs:[IO_Buf+233-33],4
	jz short @@V2
	or dword ptr ds:[ebp+IH_FLAGS],IF_VOLUME_ENVELOPE_LOOP
@@V2:

	;
	;Now test the panning envelope flags...
	;
	test byte ptr cs:[IO_Buf+234-33],1
	jz short @@P0
	or dword ptr ds:[ebp+IH_FLAGS],IF_PANNING_ENVELOPE
@@P0:	test byte ptr cs:[IO_Buf+234-33],2
	jz short @@P1
	or dword ptr ds:[ebp+IH_FLAGS],IF_PANNING_ENVELOPE_SUSTAIN
@@P1:	test byte ptr cs:[IO_Buf+234-33],4
	jz short @@P2
	or dword ptr ds:[ebp+IH_FLAGS],IF_PANNING_ENVELOPE_LOOP
@@P2:

	;
	;Now lets start and read in all sample headers...
	;
	mov ebx,40				;Now follow the sample-headers
	call Read C,cs:[IO_Handle],edi,ebx

	mov al,cs:[IO_Buf+12]
	mov ds:[ebp+IH_VOLUME],al
	mov al,cs:[IO_Buf+15]
	mov ds:[ebp+IH_BALANCE],al
	movsx eax,byte ptr cs:[IO_Buf+16]	;Get relative note
	cdq
	mov ebx,12
	idiv ebx
	mov cx,ax
	movsx eax,byte ptr cs:[IO_Buf+13]
	add eax,8363
	shl eax,cl
	mov ebx,edx				;Get rest (halftone)
	neg bx
	shl bx,1
	movzx ebx,cs:[ArpeggioTable+bx]
	mul ebx
	shrd eax,edx,12
	mov ds:[ebp+IH_RESAMPLE],eax

	mov bl,cs:[IO_Buf+14]			;Flags...
	mov eax,dword ptr cs:[IO_Buf]		;Size of sample (in bytes)
	mov ecx,dword ptr cs:[IO_Buf+4]
	mov edx,dword ptr cs:[IO_Buf+8]
	dec edx
	test bl,16				;Is it 16bit ?
	jz short @@3
	shr eax,1                               ;16bit: shift all values
	shr ecx,1
	shr edx,1
	or dword ptr ds:[ebp+IH_FLAGS],IF_16BIT
  @@3:	add edx,ecx
	test bl,2				;Ping-pong loop
	jz short @@NP
	or dword ptr ds:[ebp+IH_FLAGS],IF_PINGPONG_LOOP
  @@NP:	test bl,3				;Loop
	jnz short @@4
	mov ecx,0ffffffffh
  @@4:	mov ds:[ebp+IH_SIZE],eax
	mov ds:[ebp+IH_LOOP_START],ecx
	mov ds:[ebp+IH_LOOP_END],edx

	;
	;Now lets skip all other samples in this instrument
	;
	pop cx
	mov cs:[I_Pos],0			;Will be used for samplesize
	push dword ptr cs:[IO_Buf]		;Save current sample-size
	dec cx					;Get sample-count
	jz short @@8

  @@9:  push cx
	mov ebx,40				;Now follow the sample-headers
	call Read C,cs:[IO_Handle],edi,ebx
	mov eax,dword ptr cs:[IO_Buf]
	add cs:[I_Pos],eax
	pop cx
	dec cx
	jnz short @@9


	;
	;Ok, now lets read in the real sample data
	;
  @@8:  pop eax					;Sample-size (in bytes)
	push eax
	add eax,16
	call EXT_Malloc C,eax
	mov ds:[ebp+IH_ADDRESS],eax
	pop ebx					;Again sample-size
	call Read C,cs:[IO_Handle],eax,ebx

	;
	;Now we have to convert the sample data from deltas to signed
	;
	push esi
	push edi
	mov ecx,ds:[ebp+IH_SIZE]		;Number of samples to be processed
	jecxz @@7
	mov edi,ds:[ebp+IH_ADDRESS]
	xor ax,ax
	mov es,ax
	test dword ptr ds:[ebp+IH_FLAGS],IF_16BIT ;16 bit ?
	jnz short @@C16
  @@C8:	add al,ds:[edi]
	stos byte ptr es:[edi]
	dec ecx
	jnz short @@C8
	jmp short @@7

 @@C16:	add ax,ds:[edi]
	stos word ptr es:[edi]
	dec ecx
	jnz short @@C16
  @@7:  pop edi
	pop esi

	mov ecx,cs:[I_Pos]		;Skip other samples
	jecxz @@5
	call Seek C,cs:[IO_Handle],ecx,SEEK_CUR

	;
	;Now lets go over to the next instrument
	;
  @@5:  add ebp,INSTRUMENT_HEADER_SIZE
	pop cx				;Next instrument
	dec cl
	jnz @@L2


	call Close C,cs:[IO_Handle]
	call Process_Instruments

	pop ebp
	pop edi
	pop esi
	pop ds
	pop bp
	mov ax,TRUE
	retf


@@Error:
	call Close C,cs:[IO_Handle]
	pop ebp
	pop edi
	pop esi
	pop ds
	pop bp
	mov ax,FALSE
	retf
CDMI_Load_XM ENDP






;[]-------------------------------------------------------------------------[]
;|
;| This is the DMF-loader
;|
CDMI_Load_DMF PROC FAR
	mov ax,FALSE
	retf
CDMI_Load_DMF ENDP





;[]-------------------------------------------------------------------------[]
;|
;| This is the FAR-loader
;|
CDMI_Load_FAR PROC FAR
	mov ax,FALSE
	retf
CDMI_Load_FAR ENDP




;[]-------------------------------------------------------------------------[]
;|
;| The OKTALYZER-format decoder follows now:
;| An OKTALYZER note is build like that:
;|
;| BYTE[0] - Period using notes		0 means no change
;| BYTE[1] - Instrument number
;| BYTE[3] - Special effect
;| BYTE[4] - Effect parameter
;|
;[]-------------------------------------------------------------------------[]
;|
;| Now follows just the same thing only for OKT-files. Again a effect-table
;| is used for better performance and readability.
;|
;| Commands:
;| 0  - Nothing
;| 1  - Portamento down
;| 2  - Portamento up
;| 10 - Arpeggio
;| 11 - Arpeggio2
;| 13 - rs_slided-p ????
;| 15 - Filter
;| 17 - p-rs_slideu ????
;| 21 - p-rs_slided ????
;| 25 - Position jump       Parameter := (Parameter AND $F) + (Parameter SHR 4)*10 + 1;
;| 27 - Rertigger Note
;| 28 - Set tempo
;| 30 - rs_slideu-p ????
;| 31 - Volume      	parameter<64   -> Set_Volume
;|                      parameter<50h  -> Slide_Volume_Down   p-=40h
;|			parameter<60h  -> Slide_Vol_Fine_Down p-=50h
;|			parameter<70h  -> Slide_Volume_Up
;|			parameter<80h  -> Slide_Vol_Fine_Up
;|
;|
END