/***************************************************************************
 **
 ** (c) 1993,1994,1995 by Marc van Shaney , aka Kaya Memisoglu
 **
 ** This Source-Code was written by and is copyrighted by Kaya Memisoglu
 ** You may use the whole code or only parts of it in your own programs
 ** whether they are commercial or not. BUT you must give credits for these
 ** parts to me (Kaya Memisoglu  or  Marc van Shaney).
 ** I am not responsible for any damage or loss caused by this program, so
 ** if you success in erasing your harddisk with this code, then it is your
 ** own fault and you should not claim me to be responsible...
 ** I would be very pleased if you also sent me a postcard or even a letter
 ** if you can use this code. My address:
 **
 **        Kaya Memisoglu
 **        Reichenberger Ring 50
 **        63512 Hainburg
 **        Germany
 **
 ** You can also leave a message for Marc van Shaney on the Nirvana BBS:
 **
 **              Nirvana BBS     ++49-(0)6245-3056      Sysop:Raytrayza
 **
 **
 **/

#ifndef __CDMILIB_H
#define __CDMILIB_H

#include "sounddrv.h"
#include "ext386.h"

#ifndef __SOUND_BLOCK
#define __SOUND_BLOCK
typedef struct {
		unsigned int Speed;
		unsigned int Size;
		unsigned char Bits_per_Sample;
		unsigned char Channels;
		char Reserved[10];
	       } Sound_Block;
#endif

typedef struct {
		int FEEDBACK;
		int GAIN;
	       } REVERB_ECHO;
typedef struct {
		int RVB_COUNT;
		REVERB_ECHO RVB1;
		REVERB_ECHO RVB2;
		REVERB_ECHO RVB3;
		REVERB_ECHO RVB4;
		REVERB_ECHO RVB5;
		REVERB_ECHO RVB6;
		REVERB_ECHO RVB7;
		REVERB_ECHO RVB8;
	       } REVERB_INFO;



extern volatile unsigned int  CDMI_Pattern_No;
extern volatile unsigned int  CDMI_Beat_No;
extern volatile unsigned int  CDMI_Entry_No;
extern volatile unsigned int  CDMI_Volume;
extern          unsigned int  CDMI_Channels;
extern volatile unsigned int  CDMI_Tick;
extern volatile l_ptr         CDMI_DMA_Address;
extern volatile unsigned int  CDMI_DMA_Size;
extern volatile unsigned int  CDMI_Flags;
extern volatile unsigned long CDMI_Channel_Flags;
extern volatile unsigned int  CDMI_Speed;
extern volatile unsigned int  CDMI_Tempo;
extern          unsigned int  CDMI_Tick_Speed;
extern          l_ptr         CDMI_Song;
extern          unsigned int  CDMI_Version;
extern          unsigned int  CDMI_Sample_Rate;
extern   	unsigned int  CDMI_Sample_Volume;
extern          unsigned int  CDMI_Poll_Counter;
extern          REVERB_INFO   CDMI_Reverb;

#ifndef __SONG_FLAGS
#define __SONG_FLAGS
	#define CDMI_WAVE_TABLE		0x10000
	#define CDMI_MIX_ALWAYS		0x8000
	#define CDMI_USE_REVERB		0x4000
	#define CDMI_USE_POLLING	0x2000
	#define CDMI_NO_FX_FLAG		0x1000
	#define CDMI_SUPPORT_INT8    	0x800
	#define CDMI_TIMER_MODE		0x400
	#define CDMI_USE_16BIT		0x200
	#define CDMI_USE_16_BIT		CDMI_USE_16BIT
	#define CDMI_USE_STEREO		0x100
	#define CDMI_STEREO_MODE	CDMI_USE_STEREO
	#define CDMI_QUALITIY_MODE	64
	#define	CDMI_BREAK_FLAG		16
	#define CDMI_LOOP_FLAG		1
	#define CDMI_HIGH_PASS		2
	#define CDMI_MID_PASS		4
	#define CDMI_LOW_PASS		8
#endif

extern int CDMI_Play_Sample (int,int);
extern int CDMI_Play_Song (int freq,int attr,SoundDrv *);
extern int CDMI_Stop_Song (void);
extern int CDMI_Set_Volume(int);
extern int CDMI_Jump(int);
extern int CDMI_Free_Song(void);
extern int CDMI_Load_Song(char *);
extern int CDMI_Load_MOD(char *);
extern int CDMI_Load_669(char *);
extern int CDMI_Load_S3M(char *);
extern int CDMI_Load_STM(char *);
extern int CDMI_Load_MTM(char *);
extern int CDMI_Load_DMF(char *);
extern int CDMI_Load_FAR(char *);
extern int CDMI_Load_XM(char *);
extern int CDMI_Poll_Music(void);


#endif
