;[]------------------------------------------------------------------------[]
;|                                                                          |
;| (c) 1993,1994,1995 by Marc van Shaney , aka Kaya Memisoglu               |
;|                                                                          |
;| This Source-Code was written by and is copyrighted by Kaya Memisoglu	    |
;| You may use the whole code or only parts of it in your own programs      |
;| whether they are commercial or not. BUT you must give credits for these  |
;| parts to me (Kaya Memisoglu  or  Marc van Shaney).                       |
;| I am not responsible for any damage or loss caused by this program, so   |
;| if you success in erasing your harddisk with this code, then it is your  |
;| own fault and you should not claim me to be responsible...               |
;| I would be very pleased if you also sent me a postcard or even a letter  |
;| if you can use this code. My address:                                    |
;|                                                                          |
;|        Kaya Memisoglu                                                    |
;|        Reichenberger Ring 50                                             |
;|        63512 Hainburg                                                    |
;|        Germany                                                           |
;|                                                                          |
;| You can also leave a message for Marc van Shaney on the Nirvana BBS:     |
;|                                                                          |
;|              Nirvana BBS     ++49-(0)6245-3056      Sysop:Raytrayza      |
;|                                                                          |
;|                                                                          |
;[]------------------------------------------------------------------------[]
;
;
; !!! ATTENTION !!! ATTENTION !!! ATTENTION !!! ATTENTION !!! ATTENTION !!!
;
; ALL THESE CONSTANTS ARE USED INTERNALLY !  DO NOT CHANGE THEM UNLESS
; YOU ARE REALLY SURE WHAT YOU DO !
;
; !!! ATTENTION !!! ATTENTION !!! ATTENTION !!! ATTENTION !!! ATTENTION !!!



TRUE        		equ   1
FALSE       		equ   -1

INSTRUMENT_HEADER_SIZE	equ	256
MAX_INSTRUMENTS		equ	128
MAX_SAMPLES		equ	MAX_INSTRUMENTS
MAX_PERIOD		equ	6848
MIN_PERIOD		equ	3
MAX_CHANNELS		equ	34

;These constants are the relative offset in the Song-Header
;All things beginning with SH_ are offsets in the song-header
;
SH_ROW_SIZE		equ     2       	;Size of one row
SH_PATTERN_SIZE		equ     4               ;Size of one pattern
SH_SAMPLE_FREQ		equ	6		;C frequency
SH_PATTERN_COUNT	equ	8		;Number of patterns
SH_LIST_COUNT		equ	10		;Number of list entries
SH_START_SPEED		equ	12
SH_START_TEMPO		equ     14
SH_START_VOLUME		equ	16
SH_TICKS_PER_SECOND	equ	18
SH_CHANNELS  		equ	20
SH_CHANNEL_MAP		equ	22		;32 entriess
SH_NAME			equ	54		;74 bytes
SH_PATTERN_LIST		equ	128		;256 byte entries
SH_PATTERN_LEN		equ	384		;256 byte entries
SH_PATTERN_PTR		equ	640		;256 dword entries
SH_INSTRUMENTS		equ	2048
SONG_HEADER_SIZE	equ	2048+MAX_INSTRUMENTS*INSTRUMENT_HEADER_SIZE

SH_ENTRY_COUNT		equ	SH_LIST_COUNT
SH_ORDER_LIST		equ	SH_PATTERN_LIST

;These are the instrument-header offsests inside the instrument header
;They all begins with IH_
;
IH_SIZE			equ	SH_INSTRUMENTS
IH_LOOP_START		equ	SH_INSTRUMENTS+4
IH_LOOP_END		equ	SH_INSTRUMENTS+8
IH_VOLUME  		equ	SH_INSTRUMENTS+12
IH_BALANCE		equ	SH_INSTRUMENTS+13
IH_RESAMPLE		equ	SH_INSTRUMENTS+14
IH_ADDRESS 		equ	SH_INSTRUMENTS+18
IH_FLAGS		equ	SH_INSTRUMENTS+22
IH_AVIB_SWEEP		equ	SH_INSTRUMENTS+26
IH_AVIB_FORM 		equ	SH_INSTRUMENTS+27
IH_AVIB_SPEED		equ	SH_INSTRUMENTS+28
IH_AVIB_DEPTH		equ	SH_INSTRUMENTS+29
IH_FADE_OUT  		equ	SH_INSTRUMENTS+30
IH_GUS_HANDLE		equ	SH_INSTRUMENTS+32
IH_VENVELOPE		equ	SH_INSTRUMENTS+50
IH_VENVELOPE_SIZE	equ	SH_INSTRUMENTS+50
IH_VENVELOPE_SUSTAIN	equ	SH_INSTRUMENTS+52
IH_VENVELOPE_LOOP_START	equ     SH_INSTRUMENTS+54
IH_VENVELOPE_LOOP_END	equ     SH_INSTRUMENTS+56
IH_VENVELOPE_POINTS	equ     SH_INSTRUMENTS+58
IH_PENVELOPE		equ	SH_INSTRUMENTS+106
IH_PENVELOPE_SIZE	equ	SH_INSTRUMENTS+106
IH_PENVELOPE_SUSTAIN	equ	SH_INSTRUMENTS+108
IH_PENVELOPE_LOOP_START	equ     SH_INSTRUMENTS+110
IH_PENVELOPE_LOOP_END	equ     SH_INSTRUMENTS+112
IH_PENVELOPE_POINTS	equ     SH_INSTRUMENTS+114
IH_NAME			equ	SH_INSTRUMENTS+162

IH_PANNING		equ	IH_BALANCE

;These are instrument flags
;
IF_16BIT			equ	1
IF_VOLUME_ENVELOPE		equ	2
IF_VOLUME_ENVELOPE_SUSTAIN      equ	4
IF_VOLUME_ENVELOPE_LOOP      	equ	8
IF_PANNING_ENVELOPE		equ	10h
IF_PANNING_ENVELOPE_SUSTAIN  	equ	20h
IF_PANNING_ENVELOPE_LOOP      	equ	40h
IF_PINGPONG_LOOP		equ	80h
IF_USE_PANNING			equ	100h


ENTRY_COUNT		equ     12
MEM_HANDLE		equ	32

FX_CHANNELS		equ	MAX_CHANNELS-2

;These are the flags, that can be set when calling CDMI_Play_Song
;These are just indetically with those in CDMI_Flags
CDMI_WAVE_TABLE		equ	10000h
CDMI_MIX_ALWAYS		equ	8000h
CDMI_USE_REVERB		equ	4000h
CDMI_USE_POLLING	equ	2000h
CDMI_NO_FX_FLAG		equ	1000h
CDMI_SUPPORT_INT8	equ	800h
CDMI_TIMER_MODE		equ	400h
CDMI_USE_16_BIT		equ	200h
CDMI_USE_16BIT		equ	CDMI_USE_16_BIT
CDMI_USE_STEREO		equ	100h
CDMI_USE_FAST_PANNING	equ	80h
CDMI_STEREO_MODE	equ	CDMI_USE_STEREO
CDMI_QUALITY_MODE	equ	40h
CDMI_BUFFER_READY_FLAG	equ	20h
CDMI_BREAK_FLAG		equ	10h
CDMI_LOW_PASS		equ	8
CDMI_MID_PASS		equ	4
CDMI_HIGH_PASS		equ	2
CDMI_LOOP_FLAG		equ	1

;The following are the offsets in the channel-info table
CI_ADDRESS		equ	0
CI_FLAGS		equ	4
CI_GUS_HANDLE           equ	8
CI_GUS_POSITION		equ	12
CI_SIZE			equ	16
CI_LOOP_START		equ	20
CI_FREQ			equ	24
CI_GUS_VOLUME		equ	28
CI_GUS_BALANCE		equ	29

CI_BALANCE		equ	32
CI_VOLUME		equ	34
CI_REAL_VOLUME		equ	35
CI_PERIOD		equ	36
CI_DESTINATION		equ	38

CI_MAX_CX   		equ	40
CI_REST			equ	44
CI_INCREMENT		equ	46
CI_OVERFLOW		equ	48
CI_RESAMPLE		equ	50
CI_POSITION		equ	54

CI_ENVELOPE_VOLUME	equ	58
CI_ENVELOPE_PANNING	equ	59
CI_VOL_SLIDE		equ	60
CI_COMMAND		equ	61
CI_COM_VALUE		equ	62
CI_INSTRUMENT		equ	64
CI_ARP_1		equ	66
CI_ARP_2		equ	68
CI_ARP_3		equ	70
CI_VIB_POS  		equ	72
CI_VIB_DEPTH		equ	73
CI_VIB_SPEED		equ	74
CI_VIB_FORM		equ	75
CI_TRM_FORM		equ	76
CI_AVIB_SPEED		equ	77	;These are the values for auto-
CI_AVIB_FORM		equ	78	;vibrato used in XM
CI_AVIB_POS		equ	79
CI_AVIB_DPETH		equ	80
CI_AVIB_SWEEP		equ	82
CI_AVIB_SWEEP_LEFT	equ	84
CI_FADE_OUT		equ	86
CI_FADE_POS		equ	88
CI_OLD_REST		equ	92
CI_OLD_SIZE		equ	96
CI_OLD_LOOP_START	equ	100
CI_ENVELOPE_ADDRESS	equ	104
CI_VENVELOPE_POS	equ	108
CI_PENVELOPE_POS	equ	110

CI_TRM_SPEED		equ	CI_VIB_SPEED
CI_TRM_DEPTH		equ	CI_VIB_DEPTH
CI_TRM_POS  		equ	CI_VIB_POS
CI_TRM_ON		equ	CI_VIB_SPEED
CI_TRM_OFF		equ	CI_VIB_DEPTH
CI_TRG_POS		equ	CI_VIB_POS
CI_REV_SPEED		equ	CI_VIB_SPEED
CI_REV_POS		equ	CI_VIB_DEPTH
CI_REV_SIZE		equ	CI_VIB_POS
CI_TRL_POS		equ	CI_VIB_POS
CI_PANNING		equ	CI_BALANCE
CI_GUS_PANNING		equ	CI_GUS_BALANCE
CI_ENVELOPE_BALANCE	equ	CI_ENVELOPE_PANNING
CI_ENTRY_SIZE		equ	112



;These flags are for internal use only. Do not change them !
COM_GLISSANDO_CTRL	equ	1
COM_IS_PLAYING		equ	2

;These are the flags for the CI_FLAGS field.
;Note that there are also the instrument flags in this field !
CF_NEW_INSTRUMENT	equ	1000000h
CF_NEW_POSITION		equ	2000000h
CF_NEW_FREQ		equ	4000000h
CF_NEW_PANNING		equ	8000000h
CF_NEW_SIZE		equ	10000000h
CF_NEW_LOOP		equ	20000000h
CF_NEW_HANDLE		equ	CF_NEW_INSTRUMENT
CF_NEW_START		equ	CF_NEW_POSITION


;This is a valid list of all special effects and their command-values
;!!! DO NOT CHANGE THESE BECAUSE THEY ARE INDICES OF A COMMAND TABLE !!!

SLIDE_UP		equ	1
SLIDE_DOWN		equ	2
TONE_PORTAMENTO		equ	3
VIBRATO			equ	4
TONE_AND_VOLSLIDE	equ	5
VIB_AND_VOLSLIDE	equ	6
TREMOLO			equ	7
PANNING			equ	8
SAMPLE_OFFSET		equ	9
VOLUME_SLIDE		equ	10
POSITION_JUMP		equ	11
SET_VOLUME		equ	12
PATTERN_BREAK		equ	13
ARPEGGIO		equ	14
SET_SPEED		equ	15
SET_FILTER		equ	16
FINE_SLIDE_UP		equ	17
FINE_SLIDE_DOWN		equ	18
GLISSANDO_CONTROL	equ	19
SET_VIBWAVE_FORM	equ	20
SET_FINETUNE		equ	21
LOOP_JUMP		equ	22
PATTERN_LOOP		equ	LOOP_JUMP
SET_TREMWAVE_FORM	equ	23
RETRIGGER_NOTE		equ	24
FINE_VOL_SLIDE_UP	equ	25
FINE_VOL_SLIDE_DOWN	equ	26
NOTE_CUT		equ	27
NOTE_DELAY		equ	28
PATTERN_DELAY		equ	29
FUNK_INVERT		equ	30
OKT_ARPEGGIO		equ	31
SET_TEMPO		equ	32
TREMOR			equ	33
SET_GLOBAL_VOLUME	equ	34
REVERSE_SAMPLE		equ	35
TRAELLER		equ	36
MULTIRETRIGGER_NOTE	equ	37
MULTI_RETRIGGER_NOTE	equ	MULTIRETRIGGER_NOTE
EXTRA_FINE_SLIDE_UP	equ	38
EXTRA_FINE_SLIDE_DOWN	equ	39
FINE_VIBRATO		equ	40
BIG_PANNING		equ	41
PANNING_SLIDE		equ	42
SET_ENVELOPE_POSITION	equ	43
KEY_OFF			equ	44
GLOBAL_VOLUME_SLIDE	equ	45
MAX_EFFECTS		equ	45



REVERB_ECHO STRUC
	FEEDBACK	DW	?
	GAIN		DW	?
REVERB_ECHO ENDS


REVERB_INFO STRUC
	RVB_COUNT	DW	?
	RVB1	REVERB_ECHO	<?,?>
	RVB2	REVERB_ECHO	<?,?>
	RVB3	REVERB_ECHO	<?,?>
	RVB4	REVERB_ECHO	<?,?>
	RVB5	REVERB_ECHO	<?,?>
	RVB6	REVERB_ECHO	<?,?>
	RVB7	REVERB_ECHO	<?,?>
	RVB8	REVERB_ECHO	<?,?>
REVERB_INFO ENDS



ifndef CDMI_SYSTEM_FILE

EXTRN C CDMI_Pattern_No:WORD
EXTRN C CDMI_Beat_No:WORD
EXTRN C CDMI_Entry_No:WORD
EXTRN C CDMI_DMA_Address:DWORD
EXTRN C CDMI_DMA_Size:WORD
EXTRN C CDMI_Flags:DWORD
EXTRN C CDMI_Channel_Flags:DWORD
EXTRN C CDMI_Volume:WORD
EXTRN C CDMI_Channels:WORD
EXTRN C CDMI_Tick:WORD
EXTRN C CDMI_Speed:WORD
EXTRN C CDMI_Tempo:WORD
EXTRN C CDMI_Song:DWORD
EXTRN C CDMI_Tick_Speed:WORD
EXTRN C CDMI_Version:WORD
EXTRN C CDMI_Sample_Rate:WORD
EXTRN C CDMI_Sample_Volume:WORD
EXTRN C CDMI_Poll_Counter:WORD
EXTRN C CDMI_Reverb:REVERB_INFO


EXTRN C CDMI_Load_669:PROC
EXTRN C CDMI_Load_MOD:PROC
EXTRN C CDMI_Load_S3M:PROC
EXTRN C CDMI_Load_STM:PROC
EXTRN C CDMI_Load_MTM:PROC
EXTRN C CDMI_Load_FAR:PROC
EXTRN C CDMI_Load_DMF:PROC
EXTRN C CDMI_Load_XM:PROC
EXTRN C CDMI_Free_Song:PROC
EXTRN C CDMI_Play_Song:PROC
EXTRN C CDMI_Stop_Song:PROC
EXTRN C CDMI_Load_Song:PROC
EXTRN C CDMI_Jump:PROC
EXTRN C CDMI_Set_Volume:PROC
EXTRN C CDMI_Play_Sample:PROC
EXTRN C CDMI_Poll_Music:PROC

endif