;[]------------------------------------------------------------------------[]
;|                                                                          |
;| (c) 1993,1994,1995 by Marc van Shaney , aka Kaya Memisoglu               |
;|                                                                          |
;| This Source-Code was written by and is copyrighted by Kaya Memisoglu	    |
;| You may use the whole code or only parts of it in your own programs      |
;| whether they are commercial or not. BUT you must give credits for these  |
;| parts to me (Kaya Memisoglu  or  Marc van Shaney).                       |
;| I am not responsible for any damage or loss caused by this program, so   |
;| if you success in erasing your harddisk with this code, then it is your  |
;| own fault and you should not claim me to be responsible...               |
;| I would be very pleased if you also sent me a postcard or even a letter  |
;| if you can use this code. My address:                                    |
;|                                                                          |
;|        Kaya Memisoglu                                                    |
;|        Reichenberger Ring 50                                             |
;|        63512 Hainburg                                                    |
;|        Germany                                                           |
;|                                                                          |
;| You can also leave a message for Marc van Shaney on the Nirvana BBS:     |
;|                                                                          |
;|              Nirvana BBS     ++49-(0)6245-3056      Sysop:Raytrayza      |
;|                                                                          |
;|                                                                          |
;[]------------------------------------------------------------------------[]
;
; This DOS-Extender works in the 386-FLAT model, a memory model, where you
; can access the whole 4GB in real mode with the 32-bit registers.
; The extender also gives you some basic I/O funcions for disk-operations
; beyoond 1MB.
; Note that this DOS-Extender is only useful when you write in Assembler,
; because you CANNOT access the 4GB with a normal programming language.
; But if you still want to use the memory with Borland C++, then I have
; also written some memory-transfer routines (Memcpy etc.).
;
;


P386
MODEL USE16 LARGE
LOCALS
JUMPS
DOSSEG

EXT386_SYSTEM_FILE      equ     1
REGISTERED              equ     1
include ext386.inc
include keys.inc




CODESEG
PUBLIC C DMA_Malloc
PUBLIC C Coreleft
PUBLIC C Free
PUBLIC C Malloc

PUBLIC C Init_EXT386
PUBLIC C Exit_EXT386

PUBLIC C EXT_Malloc
PUBLIC C EXT_Free
PUBLIC C EXT_Coreleft
PUBLIC C EXT_DMA_Malloc
PUBLIC C Memcpy
PUBLIC C Memcmp
PUBLIC C Memset
PUBLIC C Memchr

PUBLIC C Open
PUBLIC C Creat
PUBLIC C Close
PUBLIC C Write
PUBLIC C Read
PUBLIC C Tell
PUBLIC C Seek
PUBLIC C Chsize

PUBLIC C Get_PSP

XMS_Control             dd      ?
XMS_Handle              dw      ?
XMS_Address             dd      ?
XMS_Size                dd      ?

IO_Buffer               dd      ?
IO_Buffer_Size          dd      ?


EXT386_Flags            dd      ?
EXT386_Method           dw      0
EXT386_PSP		dw	?


GEMMIS_Startup_Info	dd	?
GEMMIS_Mode_Switch	dd	?
GEMMIS_Import_Buffer	df	1

PAGE_Table		dd	?


METHOD_XMS              equ     1
METHOD_RAW              equ     2
METHOD_GEMMIS		equ	3


GDT_ADR LABEL FWORD                     ; Address and size of GDT
DW 24                                   ; Size of GDT
DD ?                                    ; Startaddress of GDT

GDT_START LABEL DWORD                   ; Hier beginnt die GDT
D0 DESCRIPTOR <0,0,0,0,0,0>             ; Offset 0 - Dummy-Descriptor
D1 DESCRIPTOR <0FFFFh,0,0,92h,8Fh,0>    ; Offset 8 - Des.for DS,ES,FS,GS

Text_Buf  db 16 dup (0)
INT_Table  	dd      ?
VINT_Table	dd	?

OLD_INT0        dd      ?
OLD_INT4        dd      ?
OLD_INT9        dd      ?
OLD_DIRECTORY	db	'\'
		db      70 dup (?)
OLD_DRIVE	db	?

DEV_EMMXXXX0	db	"EMMXXXX0",0

EXT_VERSION	equ	120h
Copyright db 10,"EXT386 - REAL-Mode DOS-EXTENDER v1.3            (C) 1994,1995 by Kaya Memisoglu",10,13,'$'
Text1     db " EXT386-mode successfully started",10,13,'$'
Text2     db " Free XMS       :",'$'
Text3     db " Free low memory:",'$'
Text4     db " Detected CPU   :",'$'
Text5     db " I/O buffer size:",'$'
Text6     db " 386-Method     :",'$'
Text9     db " UMB usage enabled.",10,13,'$'
Text10    db " Ctrl-Alt-Del will terminate.",10,13,'$'
Text11    db " Ctrl-Alt-Del deactivated.",10,13,'$'
Text12    db " Interrupt table saved",10,13,'$'
Text13    db " XMS allocated",10,13,'$'
Text14    db " Pause-key deactivated",10,13,'$'
Text15    db " GEMMIS protocol supported",10,13,'$'
Text30    db "EXT386:Program terminated on user request.",10,13,'$'
Text31    db "EXT386:Division by 0 - program terminated.",10,13,'$'
Text32    db "EXT386:Unhandled overflow in division - program terminated.",10,13,'$'
Text33    db "EXT386:Segment overrun - program terminated.",10,13,'$'
Text34    db "EXT386:Memory is corrupted - program terminated.",10,13,'$'
Text35    db "EXT386:Not enoguh free XMS.",10,13,'$'
Text36    db "EXT386:Not enoguh free low memory.",10,13,'$'
Text40    db "Unknown or NO-METHOD !!!",10,13,'$'
Text41    db "XMS / HIMEM.SYS",10,13,'$'
Text42    db "RAW-Start / INT15",10,13,'$'
Text43    db "GEMMIS  (Next time unload EMM386 etc...)",10,13,'$'



;[]-------------------------------------------------------------------------[]
;|
;| This macro is used to display a $-terminated string on the screen using
;| the DOS-interrupt 21h function 9.
;|

PRINT MACRO a
	push ds
	mov ax,cs
	mov ds,ax
	mov dx,OFFSET a
	mov ah,9
	int 21h
	pop ds
      ENDM
PRINT_INFO MACRO a
	LOCAL G
	test cs:[EXT386_Flags],DISPLAY_INFO
	jz short G
	PRINT a
G:
	ENDM
LONG2HEX MACRO
	LOCAL @1,@2,@3
	mov ax,cs
	mov es,ax
	mov ds,ax
	mov di,OFFSET Text_Buf
	mov cx,8
@1:     rol edx,4
	mov al,dl
	and al,0fh
	add al,'0'
	cmp al,'9'
	jbe short @2
	add al,'A'-'0'
@2:     stosb
	dec cx
	jnz short @1
	mov byte ptr es:[di],24h
	ENDM


PRINT_NUMBER PROC NEAR
	push ds

	mov ax,cs
	mov es,ax
	mov ds,ax
	mov di,OFFSET Text_Buf

	mov ebx,edx
	mov ecx,1000000000
@@1:    xor edx,edx
	mov eax,ebx
	div ecx
	cmp di,OFFSET Text_Buf
	jne short @@4
	test al,al
	jz short @@2
@@4:    add al,'0'
	stosb
@@2:    mov ebx,edx
	xor edx,edx
	mov eax,ecx
	mov ecx,10
	div ecx
	test eax,eax
	jz short @@3
	mov ecx,eax
	jmp short @@1

@@3:    mov dword ptr es:[di],240d0ah
	mov dx,OFFSET Text_Buf
	mov ah,9
	int 21h
	pop ds
	retn
PRINT_NUMBER ENDP





;[]-------------------------------------------------------------------------[]
;|
;| This is a macro for exiting immediatly after displayiing a messy
;| It is used for errors...
;|
DISPLAY_AND_EXIT MACRO a
	mov al,20h
	out 20h,al
	mov ax,3
	int 10h                         ;Switch to text-mode
	call far ptr Exit_EXT386
	PRINT a
	mov ah,4ch
	int 21h                         ;Exit program
	ENDM



;[]-------------------------------------------------------------------------[]
;|
;| Now come four routines for low-memory allocations. They use the DOS-
;| function 48h:
;|      void far *Malloc    (size_l );
;|      int       Free      (void far *);
;|      size_l    Coreleft  (void);
;|      void far *DMA_Malloc(size_t);
;| You should use these functions instead of any other allocation routine.
;| Note that they return the old SEG:OFF pointers and NOT linear addresses !
;| But you can smply convert them to a linear address:
;| (DX holds segment, AX offset):
;| and edx,0ffffh
;| and eax,0ffffh
;| shl edx,4
;| add eax,edx          ;Now the linear address is in EAX
;|

Malloc PROC FAR
	ARG len:dword
	push bp
	mov bp,sp

	mov ebx,len
	cmp ebx,0fffe0h			;About 1 MB ????
	jae short @@1
	shr ebx,4                       ;Paragraphs
	inc ebx
	mov ax,4800h                    ;Allocate memory
	int 21h
	jc short @@1
	mov dx,ax
	shl eax,16
	pop bp
	retf

 @@1:   test cs:[EXT386_Flags],STARTUP_HANDLERS
	jnz short @@2
	test cs:[EXT386_Flags],EXIT_ON_LOWMEM
	jz short @@2
	DISPLAY_AND_EXIT Text36
 @@2:   xor dx,dx
	xor eax,eax
	pop bp
	retf
Malloc ENDP




Free PROC FAR
	ARG mem:dword
	push bp
	mov bp,sp

	mov ax,word ptr [mem]           ;Offset
	mov dx,word ptr [mem+2]         ;Segment
	mov bx,ax                       ;Save offset
	shr ax,4
	add dx,ax
	and bx,0fh
	jnz short @@1                   ;Must be zero
	mov es,dx
	mov ax,4900h
	int 21h
	jc short @@1

	mov ax,TRUE
	pop bp
	retf
@@1:    mov ax,FALSE
	pop bp
	retf
Free ENDP




Coreleft PROC FAR
	push bp

	mov bx,0ffffh                   ;Paragraphs
	mov ax,4800h                    ;Allocate memory
	int 21h
	xor dx,dx
	movzx eax,bx
	shld dx,ax,4
	shl eax,4

	pop bp
	retf
Coreleft ENDP




DMA_Malloc PROC FAR
	ARG len:word
	LOCAL mblock:word
	push bp
	mov bp,sp
	sub sp,2

	mov bx,[len]
	shr bx,4
	inc bx                          ;BX holds size in paragraphs
	push bx
	mov ax,4800h
	int 21h
	pop bx
	jc short @@1
	mov cx,ax                       ;AX contains memory segment
	mov dx,ax
	add cx,bx
	shr cx,12                       ;End segment in CX
	shr dx,12                       ;Start segment in DX
	cmp cx,dx
	je short @@2                    ;Equal => Success !

	push ax                         ;Save old segment address
	mov es,ax
	mov ax,4900h                    ;Free memory block
	int 21h
	pop ax

	mov bx,0ffffh
	sub bx,ax
	and bx,00fffh                   ;Paragraphs to next segment
	mov ax,4800h
	int 21h
	jc short @@1
	mov [mblock],ax                 ;Save allocated address

	call DMA_Malloc C,[len]         ;Try again
	push dx                         ;Save result
	push ax

	mov es,[mblock]
	mov ax,4900h
	int 21h

	pop ax
	pop dx
	ror eax,16
	mov ax,dx
	ror eax,16

	add sp,2
	pop bp
	retf

 @@2:   mov dx,ax
	shl eax,16
	add sp,2
	pop bp
	retf

 @@1:   test cs:[EXT386_Flags],EXIT_ON_LOWMEM
	jz short @@3
	DISPLAY_AND_EXIT Text36
 @@3:   xor eax,eax
	xor dx,dx
	add sp,2
	pop bp
	retf
DMA_Malloc ENDP




;[]-------------------------------------------------------------------------[]
;|
;|  CPU-detection
;|  This MACRO returns the CPU in your computer in AX. See constants below
;|  for exact return-code
;|

Cpu8086         equ     0
Cpu80186        equ     1
Cpu80286        equ     2
Cpu80386        equ     3
Cpu80486        equ     4

Detect_CPU PROC NEAR
	mov dx,Cpu8086
	push sp
	pop ax
	cmp sp,ax
	jne short @OUT
	mov dx,Cpu80286
	pushf
	pop ax
	or ax,4000h
	push ax
	popf
	pushf
	pop ax
	test ax,4000h
	je short @OUT
	mov dx, Cpu80386
	mov ebx,esp
	and esp, 0FFFCh
	pushfd
	pop eax
	mov ecx,eax
	xor eax,00040000h
	push eax
	popfd
	pushfd
	pop eax
	and eax,00040000h
	and ecx,00040000h
	cmp eax,ecx
	je short @Not486
	mov dx,Cpu80486
@Not486:
	push ecx
	popfd
	mov esp,ebx
@Out:
	mov ax,dx
	retn
Detect_CPU ENDP



;[]-------------------------------------------------------------------------[]
;|
;| These two macros are used to control the NMI, which cannot be turned of
;| with the cli-command.
;|
NO_NMI MACRO
	in al,07fh
	or al,80h
	out 07fh,al
	ENDM
YES_NMI MACRO
	in al,07fh
	and al,07fh
	out 07fh,al
	ENDM


;[]-------------------------------------------------------------------------[]
;|
;| This macro activates/deactivates the UMB by calling int 21h function 58h
;|
Set_UMB_Link  MACRO a
	if a eq OFF
		mov ax,5803h
		mov bx,1
		int 21h
		mov ax,5801
		mov bx,0
		int 21h
	else
		mov ax,5803h
		mov bx,0
		int 21h
		mov ax,5801
		mov bx,0
		int 21h
	endif
	 ENDM


;[]-------------------------------------------------------------------------[]
;|
;| This routine checks, if there is already a multitasker or memory-manager
;| active which switched the machine in V86 mode
;| Returns 1 if in V86 else 0
;|
Check_V86 MACRO
	mov eax,cr0
	and eax,1
	ENDM




;[]-------------------------------------------------------------------------[]
;|
;| This MACRO is the main thing of this extender. It switches to flat mode
;| by initializing the internal cache-segment registers.
;|

INIT_FLAT MACRO
	lgdt GDT_ADR
	push ds
	mov eax,CR0             ;Set up protected mode
	or eax,1
	mov CR0,eax
	jmp short @@NEXT_BYTE   ;Clear prefetch-buffer
 @@NEXT_BYTE:
	mov bx,8                ;Load first descriptor
	mov ds,bx               ; ...in DS
	mov es,bx               ; ...in ES
	mov fs,bx               ; ...in FS
	mov gs,bx               ; ...and in GS
	and al,0feh             ;Go back in real-mode
	mov CR0,eax
	jmp short @@REAL_MODE
 @@REAL_MODE:
	pop ds
	ENDM




;[]-------------------------------------------------------------------------[]
;|
;| The routines that follow now are for the XMS initialisation. This means
;| that only HIMEM.SYS must be present in order to activate the FLAT-mode
;| These routines switch into PM and then load DS,ES,FS and GS with a 4GB
;| selector and switch back to RMode. The cache-registers still are loaded
;| with the $GB limits. Note that also the A20 is enabled using HIMEM.SYS.
;|
;[]-------------------------------------------------------------------------[]
;|
;| This routine checks for a XMS-memory manager and returns 1 if there is
;| a HIMEM.SYS or something compatible. Else it returns NO_HIMEM
;|
Check_XMS PROC NEAR
	mov ax,4300h
	int 2fh
	cmp al,80h                              ;Check for XMS
	jne short @@No_XMS
	mov ax,4310h
	int 2fh                                 ;Get XMS-Handler
	mov word ptr cs:[XMS_Control],bx
	mov word ptr cs:[XMS_Control+2],es
	xor ax,ax                               ;Get Version
	call dword ptr cs:[XMS_Control]
	cmp ax,200h
	jb short @@No_XMS
	mov ax,TRUE
	retn
 @@No_XMS:
	mov ax,NO_HIMEM
	retn
Check_XMS ENDP



;[]-------------------------------------------------------------------------[]
;|
;| This macro returns the amount of free XMS in EAX (in bytes)
;|
XMS_Left MACRO
	mov ax,0800h                    ;Get free XMS in kBytes
	call dword ptr cs:[XMS_Control]
	movzx eax,ax
	shl eax,10                      ;*1024
	ENDM


;[]-------------------------------------------------------------------------[]
;|
;| This macro allocates EDX bytes of XMS and returns its physical address
;| in EDX and the handle in BX. AX holds the error-code.
;|
XMS_Alloc MACRO
	LOCAL @@1,@@2
	mov ax,0900h                            ;Alloctae XMS
	shr edx,10
	call dword ptr cs:[XMS_Control]         ;Returns handle in DX
	test ax,ax
	jz short @@1
	push dx                                 ;Save handle
	mov ax,0c00h                            ;Lock XMS
	call dword ptr cs:[XMS_Control]         ;DX:BX holds linear Address
	shl edx,16
	mov dx,bx
	pop bx
	test ax,ax
	jz short @@1
	mov ax,TRUE
	jmp short @@2
 @@1:   mov ax,NOT_ENOUGH_XMS
 @@2:
	ENDM



;[]-------------------------------------------------------------------------[]
;|
;| This macro unlocks and frees a XMS-Block. The Handle must be in DX.
;|
XMS_Free MACRO
	mov ax,0d00h                    ;Unlock XMS
	push dx                         ;Save handle
	call dword ptr cs:[XMS_Control]
	pop dx
	mov ax,0a00h                    ;Free XMS
	call dword ptr cs:[XMS_Control]
	ENDM




;[]-------------------------------------------------------------------------[]
;|
;| This macro activates/deactivates the A20 by calling HIMEM.SYS
;|
Set_A20  MACRO a
	if a eq OFF
		mov ah,04h
	else
		mov ah,03h
	endif
	call cs:[XMS_Control]
	 ENDM



Use_XMS PROC NEAR
	call Check_XMS
	cmp ax,0
	jl @@E

	XMS_Left
	mov edx,eax                     ;Allocate all free XMS
	mov cs:[XMS_Size],eax
	test eax,eax
	jz @@E1
	XMS_Alloc
	mov cs:[XMS_Handle],bx
	mov cs:[XMS_Address],edx
	cmp ax,TRUE
	jl @@E1
	PRINT_INFO Text13

	;
	;Now lets turn of all interrupts and switch to flat mode
	;
	cli
	NO_NMI
	SET_A20 ON
	cmp ax,1
	jne @@E2
	INIT_FLAT

	;
	;O.k. we are in flat mode. Now we have to initialize our memory
	;manager
	;
	xor ax,ax
	mov es,ax               ;ES now has a 4GB address space !!!
	mov eax,cs:[XMS_Size]
	sub eax,8               ;Free size
	mov ebx,cs:[XMS_Address]
	mov word ptr es:[ebx],BLOCK_MAGIC
	mov word ptr es:[ebx+2],FREE_BLOCK or LAST_BLOCK
	mov dword ptr es:[ebx+4],eax
	YES_NMI
	sti
	mov cs:[EXT386_Method],METHOD_XMS
	mov ax,TRUE
	retn

 @@E1:  mov ax,NOT_ENOUGH_XMS
	retn
 @@E2:  YES_NMI
	mov ax,HIMEM_PROBLEM
 @@E:	retn
Use_XMS ENDP






;[]-------------------------------------------------------------------------[]
;|
;| These routines use the AT-Interrupt 15h , function 88h
;| Note that this technique may be incompatible and should not be used in
;| every case. I headr that especially VDISK does not work with this method !
;|
;[]-------------------------------------------------------------------------[]
;|
;| This function Initializes the RAW-mode
;|
Use_RAW PROC NEAR
	push ds
	call enableA20                  ; enable that stupid A20 thingy
	cmp ax,0
	jl @@E3

	mov ah,88h                      ; chek and get extended mem
	int 15h
	movzx eax,ax
	shl eax,10
	jz @@E1
	mov cs:[XMS_Size],eax
	mov ebx,100000h
	mov cs:[XMS_Address],ebx
	PRINT_INFO Text13

	;
	;Now lets turn of all interrupts and switch to flat mode
	;
	cli
	NO_NMI
	INIT_FLAT
	YES_NMI
	sti


	;
	;O.k. we are in flat mode. Now we have to initialize our memory
	;manager
	;
	xor cx,cx
	mov es,cx               ;ES now has a 4GB address space !!!
	mov ebx,cs:[XMS_Address]
	mov eax,cs:[XMS_Size]
	sub eax,8               ;Free size
	mov word ptr es:[ebx],BLOCK_MAGIC
	mov word ptr es:[ebx+2],FREE_BLOCK or LAST_BLOCK
	mov dword ptr es:[ebx+4],eax
	mov cs:[EXT386_Method],METHOD_RAW
	mov ax,TRUE
	pop ds
	retn

 @@E1:  mov ax,NOT_ENOUGH_XMS
 @@E3:  pop ds
	retn
Use_RAW ENDP



;[]-------------------------------------------------------------------------[]
;|
;| These are some stupid A20 hardware-routines
;|
enableA20 PROC NEAR                     ; hardware enable gate A20
	xor ax,ax
	mov fs,ax
	dec ax
	mov gs,ax
	call testA20
	je short enableA20done

	in al,92h                       ; PS/2 A20 enable
	or al,2
	jmp short $+2
	jmp short $+2
	jmp short $+2
	out 92h,al
	call testA20
	je short enableA20done

	call enableA20o1                ; AT A20 enable
	jnz short enableA20wait
	mov al,0d1h
	out 64h,al
	call enableA20o1
	jnz short enableA20wait
	mov al,0dfh
	out 60h,al
	push offset enableA20wait
enableA20o1:
	mov ecx,20000h
enableA20o1l:
	jmp short $+2
	jmp short $+2
	jmp short $+2
	in al,64h
	test al,2
	loopnz enableA20o1l
enableA20done:
	mov ax,TRUE
	retn


enableA20wait:                          ; wait for A20
	mov al,36h
	out 43h,al
	xor al,al
	out 40h,al
	out 40h,al
	mov cx,800h
enableA20waitl0:
	call testA20
	je enableA20done
	in al,40h
	in al,40h
	mov ah,al
enableA20waitl1:
	in al,40h
	in al,40h
	cmp al,ah
	je enableA20waitl1
	loop enableA20waitl0

	mov ax,A20_PROBLEM
	retn
enableA20 ENDP



;[]-------------------------------------------------------------------------[]
;|
;| This little function simply tests if the A20 is/is not enabled
;|
TestA20 PROC NEAR
	mov al,fs:[0]
	mov ah,al
	not al
	mov gs:[10h],al
	cmp ah,fs:[0]
	mov fs:[0],ah
	retn
TestA20 ENDP





;[]-------------------------------------------------------------------------[]
;|
;| These are the GEMMIS routines. They are a bit complex and slow. Note
;| that they might not work together with all memory-managers, because
;| they use undocumented functions.
;|
;[]-------------------------------------------------------------------------[]
;|
;| First comes the GEMMIS interrupt system
;|
IDT_Virtual label fword
	dw 3ffh,0,0
IDT_Native label fword
	dw 3ffh,0,0

num=0						;flat real mode interrupt handlers
irpc hex,<0123456789abcdef>
irpc unit,<0123456789abcdef>
it&hex&&unit:
	mov byte ptr cs:[automodif_int+1],num
	jmp it
num=num+1
endm
endm

GEMMIS_Switch2Prot MACRO
	mov ax,1
	call dword ptr cs:[GEMMIS_Mode_Switch]
	ENDM

GEMMIS_Switch2Real MACRO
	xor ax,ax
	call dword ptr cs:[GEMMIS_Mode_Switch]
	ENDM


it:     pushad
	push ds
	push es
	push fs
	push gs

	lidt cs:[IDT_Native]
	GEMMIS_Switch2Prot

	mov ax,1606h
	xor dx,dx
	int 2fh			;restore device name

	pop gs
	pop fs
	pop es
	pop ds
	popad
	movzx esp,sp
	push word ptr ss:[esp+4]		;flags, tricky !
	popf
automodif_int db 0cdh,0		;call the old interrupt handler
	pushf
	pop word ptr ss:[esp+4]		;flags, tricky !
	cli
	pushad
	push ds
	push es
	push fs
	push gs

	mov ax,1605h
	xor bx,bx
	mov cx,bx
	mov dx,bx
	mov si,bx
	mov di,30bh		;version number 3.11
	mov ds,bx
	mov es,bx
	int 2fh

	mov ax,1608h
	int 2fh

	GEMMIS_Switch2Real
	lidt cs:[IDT_Virtual]
	INIT_FLAT
	pop gs
	pop fs
	pop es
	pop ds
	popad
	iret






;[]-------------------------------------------------------------------------[]
;|
;| This routine checks the multiplex interrupt for GEMMIS-support
;|
GEMText0	db	"   You are running this system under a memory manager like EMM386,QEMM,etc...",10,13
		db	"   Due the fact that all interrupts must be emulated, the system will be VERY",10,13
		db	"   slow and unstable. So we recommend you to reboot your computer without",10,13
		db	"   loading these memory managers.",10,13
		db	"   Do you still want to continue [Y/N] ?",'$'
GEMText1	db	10,13
GEMText2	db	10,13,'$'

Check_GEMMIS PROC NEAR
	push ds
	push esi
	push edi
	push ebp
	mov ax,1605h
	xor ebx,ebx
	xor ecx,ecx
	xor edx,edx
	xor esi,esi
	mov ds,dx
	mov es,dx
	mov di,30bh		;Windows 3.11
	int 2fh
	test cx,cx
	jnz short @@Error

	mov word ptr cs:[GEMMIS_Startup_Info],bx
	mov word ptr cs:[GEMMIS_Startup_Info+2],es

	mov word ptr cs:[GEMMIS_Mode_Switch],si
	mov word ptr cs:[GEMMIS_Mode_Switch+2],ds

	shl esi,16
	mov si,ds
	test esi,esi
	jz short @@Error

	mov ax,1606h		;Exit windows mode
	xor dx,dx
	int 2fh

	PRINT_INFO Text15	;Display message

	mov ax,TRUE
	pop ebp
	pop edi
	pop esi
	pop ds
	retn

@@Error:
	mov ax,FALSE
	pop ebp
	pop edi
	pop esi
	pop ds
	retn
Check_GEMMIS ENDP




Use_GEMMIS PROC NEAR
	push ds
	PRINT GEMText0
@@K:    GETKEY
	cmp al,'y'
	je short @@Cont
	cmp al,'Y'
	je short @@Cont
	cmp al,'n'
	je short @@Abort
	cmp al,'N'
	je short @@Abort
	jmp short @@K

@@Abort:PRINT GEMText1
	mov ax,4c00h
	int 21h				;Exit program



	;* test EMS version >= 4.0
@@Cont: PRINT GEMText2
	mov ah,46h
	int 67h				;get EMM version
	cmp al,40h                      ;Is it V4.0 ar later ???
	jb @@E4

	;
	;First lets get some EMM386 and GEMMIS information...
	;
	push cs
	pop ds
	mov ax,3d00h
	mov dx,OFFSET DEV_EMMXXXX0
	int 21h				;open handle
	jc @@E3
	mov bx,ax
	mov ax,4400h
	int 21h				;get device information
	jc @@E3
	not dx
	test dx,4080h
	jnz @@E3
	mov ax,4407h
	int 21h				;get output status
	jc @@E3
	inc al
	jnz @@E3
	mov ax,4402h
	mov cx,6
	mov dx,offset GEMMIS_import_buffer
	int 21h				;IOCTL read
	jc @@E3				;cannot read device
	cmp ax,cx
	jne @@E3			;cannot read device
	mov ah,3eh
	int 21h				;close handle


	;
	;Now we will allocate all memory (XMS)
	;
	call Check_XMS			;Is there a XMS driver ?
	cmp ax,0
	jl @@E

	XMS_Left
	mov edx,eax                     ;Allocate all free XMS
	mov cs:[XMS_Size],eax
	test eax,eax
	jz @@E1
	XMS_Alloc			;Allocate it !
	mov cs:[XMS_Handle],bx
	mov cs:[XMS_Address],edx
	cmp ax,TRUE
	jl @@E1
	PRINT_INFO Text13		;Print messy that XMS is allocated


	;
	;Lets get the address of the page-table
	;
	mov eax,cr3
	mov cs:[PAGE_Table],eax


	;
	;Now the protected mode thing will start
	;
	mov eax,1605h			;GET GEMMIS-SARTUP-DATA
	xor edx,edx
	xor ebx,ebx
	xor ecx,ecx
	xor edx,edx
	xor esi,esi
	mov ds,bx
	mov es,bx
	mov di,30bh			;Windows 3.11
	int 2fh                         ;Start GEMMIS procedure

	cli
	NO_NMI                          ;make it safer
	SET_A20 ON
	cmp ax,1
	jne @@E2


	push ds
	GEMMIS_Switch2Real
	pop ds


	;
	;Now the standard procedure for setting up the flat real mode
	;start here
	;

	INIT_FLAT
;	mov eax,cs:[PAGE_Table]
;	mov cr3,eax
;	mov eax,cr0
;	or eax,80000000h
;	mov cr0,eax

	;
	;Now we have to initialize the extended memory for our own
	;memory management
	;
	xor ax,ax
	mov es,ax               ;ES now has a 4GB address space !!!
	mov eax,cs:[XMS_Size]
	sub eax,8               ;Free size
	mov ebx,cs:[XMS_Address]
	mov word ptr es:[ebx],BLOCK_MAGIC
	mov word ptr es:[ebx+2],FREE_BLOCK or LAST_BLOCK
	mov dword ptr es:[ebx+4],eax

;	jmp @@TEST0
	;
	;Now we HAVE to install new interrupts...
	;
	mov cx,256
	les di,cs:[VINT_Table]
	mov si,cs
	shl esi,16
	mov si,OFFSET it00
@@L1:	mov es:[di],esi				;Set new INT-Handler
	add di,4
	add si,OFFSET it01-OFFSET it00
	dec cx
	jnz short @@L1

	lidt cs:[IDT_Virtual]

@@TEST0:
	pop ds
	YES_NMI
	sti
	or cs:[EXT386_Flags],VIRTUAL_INTERRUPTS
	mov cs:[EXT386_Method],METHOD_GEMMIS
	mov ax,TRUE
	retn

	;
	;Here are some error-return codes
	;
 @@E1:  mov ax,NOT_ENOUGH_XMS
	pop ds
	retn
 @@E2:  YES_NMI
	mov ax,HIMEM_PROBLEM
	pop ds
	retn
 @@E3:	mov ax,EMM_PROBLEM
	pop ds
	retn
 @@E4:	mov ax,OLD_EMM386
	pop ds
	retn
 @@E:   pop ds
	retn
Use_GEMMIS ENDP




;[]-------------------------------------------------------------------------[]
;|
;| Now the type-specific stuff ends here. The following rountines are mostly
;| front-end routines callabel by your software.
;|
;[]-------------------------------------------------------------------------[]
;|
;| This function displays an error message and terminates the program.
;|
e0      db      "ERROR:Unknown error occured in 386 Extender.",10,13,'$'
e1      db      "ERROR:Processor is already in V86 mode. Unload EMM386, QEMM etc.",10,13,'$'
e2      db      "ERROR:No HIMEM.SYS loaded or wrong version.",10,13,'$'
e3      db      "ERROR:No 80386 or compatible CPU found in your machine.",10,13,'$'
e4      db      "ERROR:Not enough free XMS to run this program.",10,13,'$'
e5      db      "ERROR:There was a problem with your HIMEM.SYS driver.",10,13,'$'
e6      db      "ERROR:Not enough base memory to allocate I/O buffers.",10,13,'$'
e7      db      "ERROR:EXT386 was modified. Will not start program !",10,13,'$'
e8      db      "ERROR:Could not enable A20. Load HIMEM.SYS ans try again !",10,13,'$'
e9	db	"ERROR:There were some problems while queriing the EMM386-driver !",10,13,'$'
eA	db	"ERROR:Your EMM386 driver does not support LIM4.0 !",10,13,'$'


Error_EXT386 PROC NEAR
	push ax
	push ds
	mov dx,OFFSET e0

	cmp ax,ALREADY_IN_V86
	jne short @@1
	mov dx,OFFSET e1
 @@1:   cmp ax,NO_HIMEM
	jne short @@2
	mov dx,OFFSET e2
 @@2:   cmp ax,NO_386
	jne short @@3
	mov dx,OFFSET e3
 @@3:   cmp ax,NOT_ENOUGH_XMS
	jne short @@4
	mov dx,OFFSET e4
 @@4:   cmp ax,HIMEM_PROBLEM
	jne short @@5
	mov dx,OFFSET e5
 @@5:   cmp ax,NOT_ENOUGH_RAM
	jne short @@6
	mov dx,OFFSET e6
 @@6:   cmp ax,EXT386_MODIFIED
	jne short @@7
	mov dx,OFFSET e7
 @@7:   cmp ax,A20_PROBLEM
	jne short @@8
	mov dx,OFFSET e8
 @@8:	cmp ax,EMM_PROBLEM
	jne short @@9
	mov dx,OFFSET e9
 @@9:   cmp ax,OLD_EMM386
	jne short @@A
	mov dx,OFFSET eA
 @@A:
	mov ax,cs
	mov ds,ax
	mov ah,9
	int 21h
	pop ds
	pop ax
	mov ax,4c00h
	int 21h
	retn
Error_EXT386 ENDP






;[]-------------------------------------------------------------------------[]
;|
;| This function initializes the FLAT-Mode of the 386
;| int Init_EXT386(size_t IO_Buffer_Size,long flags);
;| int Exit_EXT386(void);
;|

Init_EXT386 PROC FAR
	ARG bsize:word,flags:dword
	push bp
	mov bp,sp
	push ds
	push esi
	push edi

	cld
	mov cs:[EXT386_METHOD],0
	PRINT Copyright


	;
	;First, lets save the old drive and directory
	;
	mov ah,19h
	int 21h
	mov cs:[OLD_DRIVE],al

	mov ah,47h
	push cs
	pop ds
	xor dl,dl
	mov si,OFFSET OLD_DIRECTORY+1
	int 21h

	mov eax,[Flags]
	or eax,STARTUP_HANDLERS
	and eax,NOT VIRTUAL_INTERRUPTS
	mov cs:[EXT386_Flags],eax

	call Detect_CPU
	cmp ax,Cpu80386
	jb CPU_No_386


	;
	;Now we get the PSP
	;
	mov ah,62h
	int 21h
	mov cs:[EXT386_PSP],bx


	;
	;Here we allocate some meory for the I/O buffer and for the
	;interrupt-table
	;
	movzx eax,[bsize]
	mov cs:[IO_Buffer_Size],eax
	call Malloc C,eax
	test eax,eax
	jz Low_RAM
	mov cs:[IO_Buffer],eax


	;
	;Now a new interrupt table will be allocated
	;
	mov eax,1024
	call Malloc C,eax
	test eax,eax
	jz Low_RAM
	mov cs:[INT_Table],eax
	xor si,si
	mov ds,si
	les di,cs:[INT_Table]		;Lets save the old int-table
	mov cx,256
	rep movsd


	mov eax,1024			;This 2nd copy is for a virtual
	call Malloc C,eax		;interrupt table
	test eax,eax
	jz Low_RAM
	mov cs:[VINT_Table],eax
	xor si,si
	mov ds,si
	les di,cs:[VINT_Table]		;Lets save the old int-table
	mov cx,256
	rep movsd
	PRINT_INFO Text12


	;
	;Now we set various addresses
	;
	xor eax,eax
	xor ebx,ebx
	mov ax,cs
	shl eax,4
	mov bx,OFFSET GDT_Start
	add eax,ebx
	mov dword ptr cs:[GDT_ADR+2],eax


	movzx eax,word ptr cs:[VINT_Table]
	movzx ebx,word ptr cs:[VINT_Table+2]
	shl ebx,4
	add eax,ebx
	mov dword ptr cs:[IDT_Virtual+2],eax


	;
	;Here the various routines will be called unless one works.
	;
	Check_V86
	jnz short @@2			;Already in virtual mode ?


	;
	;Here we can do with our CPU what we like to do, because we are at
	;CPL0. Yeah !
	;
	call Check_XMS			;No -> Check for XMS
	cmp ax,0
	jl short @@1

	call Use_XMS			;Use it !
	cmp ax,0
	jl General_Problem
	jmp Now_in_FLAT_Mode

@@1:    call Use_RAW			;USe RAW-start
	cmp ax,0
	jl General_Problem
	jmp short Now_In_FLAT_Mode


@@2:    ;
	;When we are here, then the processor is already in V86 mode,
	;so we have to use other methods, becuase we are just not CPL0
	;
	call Check_GEMMIS
	cmp ax,FALSE
	jl short @@3
	call Use_GEMMIS
	cmp ax,0
	jl General_Problem
	jmp short Now_In_FLAT_Mode

@@3:	mov ax,ALREADY_IN_V86
	jmp General_Problem





Now_in_FLAT_Mode:
	test cs:[EXT386_Flags],USE_UMB
	jz short @@6
	Set_UMB_Link ON


@@6:	;
	;Here we install some new interrupt handlers....
	;
	call FAR PTR Get_Flat_Interrupt C,0
	mov cs:[OLD_INT0],eax
	call FAR PTR Get_Flat_Interrupt C,4
	mov cs:[OLD_INT4],eax
	call FAR PTR Get_Flat_Interrupt C,9
	mov cs:[OLD_INT9],eax

	call FAR PTR Set_Flat_Interrupt C,0,OFFSET INT00_Handler,cs
	call FAR PTR Set_Flat_Interrupt C,4,OFFSET INT04_Handler,cs
	call FAR PTR Set_Flat_Interrupt C,9,OFFSET INT09_Handler,cs
	call FAR PTR Set_Flat_Interrupt C,31h,OFFSET INT31_Handler,cs


	;
	;Now we display some information, if needed
	;
	test cs:[EXT386_Flags],DISPLAY_INFO
	jz @@No_Info
	PRINT Text1
	PRINT Text2
	call FAR PTR EXT_Coreleft
	shl edx,16
	mov dx,ax
	call PRINT_NUMBER
	PRINT Text3
	call Coreleft
	shl edx,16
	mov dx,ax
	call PRINT_NUMBER
	PRINT Text4
	call Detect_CPU
	movzx eax,ax
	fastimul edx,eax,100
	add edx,80086
	call PRINT_NUMBER
	PRINT Text5
	mov edx,cs:[IO_Buffer_Size]
	call PRINT_NUMBER
	PRINT Text6
	cmp cs:[EXT386_Method],0
	jne short @@N0
	PRINT Text40
 @@N0:  cmp cs:[EXT386_Method],1		;XMS
	jne short @@N1
	PRINT Text41
 @@N1:  cmp cs:[EXT386_Method],2		;INT15
	jne short @@N2
	PRINT Text42
 @@N2:  cmp cs:[EXT386_Method],3		;GEMMIS
	jne short @@N3
	PRINT Text43
 @@N3:

	test cs:[EXT386_Flags],USE_UMB
	jz short @@T1
	PRINT Text9
 @@T1:  test cs:[EXT386_Flags],EXIT_ON_RESET
	jz short @@T7
	PRINT Text10
 @@T7:  test cs:[EXT386_Flags],VERBOSE_RESET
	jz short @@T8
	PRINT Text11
 @@T8:	test cs:[EXT386_Flags],VERBOSE_PAUSE
	jz short @@T9
	PRINT Text14
 @@T9:


@@No_Info:
	;
	;Here we are ready initializing the system
	;
	and cs:[EXT386_Flags],NOT STARTUP_HANDLERS
	mov ax,TRUE
	pop edi
	pop esi
	pop ds
	pop bp
	retf

General_Problem:
	call Error_EXT386
Cpu_No_386:
	mov ax,NO_386
	call Error_EXT386
CPU_NO_XMS:
	mov ax,NO_HIMEM
	call Error_EXT386
Low_RAM:
	mov ax,NOT_ENOUGH_RAM
	call Error_EXT386
Init_EXT386 ENDP






Exit_EXT386 PROC FAR
	push ds
	push edi
	push esi
	push ebp
	cld
	cli  		; interrupts off
			; set default timer interval into PIT0
	mov ax,36h 	; PIT channel 0, square wave,binary, send LSB & MSB
	out 43h,al 	; send command
	mov al,0
	out 40h,al 	; maximum timer count (freq. = 18.2 Hz)
	out 40h,al 	;
	mov ax,0B6h 	; PIT channel 2, square wave,binary, send LSB & MSB
	out 43h,al  	; send command
	mov al,0
	out 42h,al 	; maximum timer count (freq. = 18.2 Hz)
	out 42h,al 	;
	cli
	in al,61h     	; disable sound
	and al,011111100b
	out 61h,al


	;
	;First lets restore the old INT-Table
	;
	xor di,di
	mov es,di
	lfs si,cs:[INT_Table]
	mov cx,256
	rep movs dword ptr es:[di],fs:[si]


	test cs:[EXT386_FLAGS],VIRTUAL_INTERRUPTS
	jz short @@G2
	lidt cs:[IDT_Native]			;Activate normal interrupts


@@G2:	cmp cs:[EXT386_METHOD],METHOD_GEMMIS
	jne short @@G1
	push ds
	pushad
	GEMMIS_Switch2PROT
	popad
	pop ds


@@G1:   sti
	call Free C,cs:[INT_Table]	;Release memory
	call Free C,cs:[IO_Buffer]
	call Free C,cs:[VINT_Table]


	test cs:[EXT386_Flags],SAVE_DIRECTORY
	jz short @@5
	push ds
	mov ah,0eh
	mov dl,cs:[OLD_DRIVE]
	int 21h

	mov ax,cs
	mov ds,ax
	mov ah,3bh
	mov dx,OFFSET OLD_DIRECTORY
	int 21h
	pop ds


@@5:	test cs:[EXT386_Flags],USE_UMB
	jz short @@6
	Set_UMB_Link OFF


	;
	;Now say goodbye to XMS-system
	;
@@6:    cmp cs:[EXT386_METHOD],METHOD_XMS
	jne short @@1
	mov dx,cs:[XMS_Handle]
	XMS_Free
	SET_A20 OFF
	mov ax,TRUE
	jmp @@E


	;
	;Here we exit from the RAW / INT15 system
	;
@@1:    cmp cs:[EXT386_METHOD],METHOD_RAW
	jne short @@2
	mov ax,TRUE
	jmp @@E


	;
	;Last we exit from GEMMIS
	;
@@2:	cmp cs:[EXT386_METHOD],METHOD_GEMMIS
	jne short @@3
	push ds
	mov ax,1606h
	xor dx,dx
	int 2fh
	pop ds
	mov dx,cs:[XMS_Handle]
	XMS_Free
	SET_A20 OFF
	mov ax,TRUE
	jmp @@E


	;
	;Well, there seems to be a bug...
	;
@@3:	mov ax,FALSE
@@E:	pop ebp
	pop esi
	pop edi
	pop ds
	retf
Exit_EXT386 ENDP





;[]-------------------------------------------------------------------------[]
;|
;| The following routine is a keyboard handler to prevent Ctrl-Alt Del !!!
;| Here are also some interrupt-handlers which terminate the program due
;| an error (divisin by zero etc...) plus a handler for memory errors.
;|

INT09_Handler PROC FAR
	push ax
	push bx
	push es
	mov bx,40h
	mov es,bx
	mov ah,es:[17h]

	in al,60h
	test ah,4                       ;Is 'Ctrl' pressed ???
	jz short @@4
	cmp al,0e0h                     ;Is it 'Pause' ???
	je short @@2
	cmp al,02eh                     ;Is it 'C' ???
	je short @@2
	cmp al,53h                      ;is it 'Del' ???
	jne short @@1
	test ah,8                       ;is Alt pressed ???
	jz short @@1

	test cs:[EXT386_Flags],EXIT_ON_RESET
	jnz short @@3
	test cs:[EXT386_Flags],VERBOSE_RESET
	jnz short @@2
	jmp short @@1

@@3:    and byte ptr es:[17h],NOT 4
	mov al,20h
	out 20h,al
	mov ax,3
	int 10h                         ;Switch to text-mode
	call Exit_EXT386
	PRINT Text30
	mov ah,4ch
	int 21h                         ;Exit program

@@4:    test byte ptr es:[18h],8        ;Is it 'Pause' only ???
	jz short @@1
	test cs:[EXT386_Flags],VERBOSE_PAUSE
	jz short @@1
	and byte ptr es:[18h],0f7h      ;Clear pause flag
	mov al,20h
	out 20h,al
	pop es
	pop bx
	pop ax
	iret

@@1:    pop es
	pop bx
	pop ax
	jmp dword ptr cs:[OLD_INT9]
@@2:    and byte ptr es:[17h],NOT 4
	mov al,20h
	out 20h,al
	pop es
	pop bx
	pop ax
	iret
INT09_Handler ENDP



INT00_Handler PROC FAR                  ;Division by zero
	mov al,20h
	out 20h,al
	mov ax,3
	int 10h                         ;Switch to text-mode
	call Exit_EXT386
	PRINT Text31
	mov ah,4ch
	int 21h                         ;Exit program
	iret
INT00_Handler ENDP




INT04_Handler PROC FAR                  ;Overflow
	mov al,20h
	out 20h,al
	mov ax,3
	int 10h                         ;Switch to text-mode
	call Exit_EXT386
	PRINT Text32
	mov ah,4ch
	int 21h                         ;Exit program
	iret
INT04_Handler ENDP





MEMERR_Handler PROC NEAR
	mov al,20h
	out 20h,al
	mov ax,3
	int 10h                         ;Switch to text-mode
	call Exit_EXT386
	PRINT Text34
	mov ah,4ch
	int 21h                         ;Exit program
MEMERR_Handler ENDP


;[]-------------------------------------------------------------------------[]
;|
;| The following routines are used to allocate some of the new memory.
;|
;| The functions are:
;| size_l EXT_alloc    (size_l size);
;| int    EXT_free     (size_l address);
;| size_l EXT_coreleft (void);
;|
;| EXT_Alloc allocates a memory block with a specific size and returns the
;| linear address. EXT_Free frees this memoryblock again, when you pass
;| the address as a parameter. So they work exactly like malloc() and free()
;|
;| Our new memory is organzied like a single linked list,and each allocated
;| memory block is described by a header:
;|      word Magic      -       'KM'
;|      word Flags      -       Some flags (See below)
;|      dword Size      -       Size WITHOUT header
;| The following flags are defined:
;|      FREE_BLOCK      -       This block is available
;|      LAST_BLOCK      -       This is the very last block in the list
;| The first block is located at the very beginning of the allocated XMS.
;| The next blocks can be found by adding the block-size plus 8 bytes for
;| header information to the current address:
;|
;| Main Header
;|   Magic
;|   Flags
;|   Size ------------->  Second Header
;|   Data                   Magic
;|                          Flags
;|                          Size ----------(....)---> Last Header
;|                          Data                        Magic
;|                                                      Flags with LAST_BOCK
;|                                                            set
;|                                                      Size
;|                                                      Data
;|


EXT_Malloc PROC FAR
	ARG len:dword
	push bp
	mov bp,sp

	xor ax,ax
	mov es,ax                       ;ES is your magic 4GB segment
	mov ebx,cs:[XMS_Address]        ;EBX points to first XMS-entry
	mov ecx,[len]                   ;ECX holds requested len

  @@Look_for_free:
	cmp word ptr es:[ebx],BLOCK_MAGIC
	jne @@Error                     ;NO => XMS is corrupted !!!
	test word ptr es:[ebx+2],FREE_BLOCK
	jz short @@Block_not_free
	cmp es:[ebx+4],ecx              ;Is free block large enough ?
	jb short @@Block_Not_Free       ;JB: Sorry,no !
	mov eax,es:[ebx+4]              ;Save old size here
	and word ptr es:[ebx+2],NOT FREE_BLOCK
	sub eax,ecx                     ;Calculate remaining block size
	cmp eax,16                      ;When smaller than 16 bytes, do not
	jae short @@1                   ;create a new block !!!

	add ebx,8                       ;Skip header for return address
	mov eax,ebx
	shr ebx,16
	mov dx,bx                       ;Block address in DX:AX
	pop bp
	retf

  @@1:  mov es:[ebx+4],ecx              ;Save new size
	mov edx,ebx                     ;Save for return value
	add ebx,8                       ;Skip over header
	add ebx,ecx                     ;New header will be placed here
	mov word ptr es:[ebx],BLOCK_MAGIC
	sub eax,8                       ;Subtract header-size from remaining size
	mov es:[ebx+4],eax              ;Save new block size
	mov ax,FREE_BLOCK               ;Flag
	test word ptr es:[edx+2],LAST_BLOCK
	jz short @@2                    ;JZ: It was NOT the last block
	or ax,LAST_BLOCK
  @@2:  mov es:[ebx+2],ax               ;Save flags in new header
	and word ptr es:[edx+2],NOT LAST_BLOCK
	add edx,8
	mov eax,edx
	shr edx,16                      ;Block address in DX:AX
	pop bp
	retf

  @@Block_Not_Free:
	test word ptr es:[ebx+2],LAST_BLOCK
	jnz short @@NoMem
	add ebx,es:[ebx+4]
	add ebx,8
  jmp  @@Look_for_free


 @@Error:
	call MEMERR_Handler
 @@NoMem:
	test cs:[EXT386_Flags],EXIT_ON_LOWMEM
	jz short @@3
	DISPLAY_AND_EXIT Text35
 @@3:   xor dx,dx
	xor eax,eax
	pop bp
	retf
EXT_Malloc ENDP






EXT_DMA_Malloc PROC FAR
	ARG len:word
	push bp
	mov bp,sp

	xor ax,ax
	mov es,ax                       ;ES is your magic 4GB segment
	mov ebx,cs:[XMS_Address]        ;EBX points to first XMS-entry
	movzx ecx,[len]                 ;ECX holds requested len

  @@Look_for_free:
	cmp word ptr es:[ebx],BLOCK_MAGIC
	jne @@Error                     ;NO => XMS is corrupted !!!
	test word ptr es:[ebx+2],FREE_BLOCK
	jz @@Block_not_free
	cmp es:[ebx+4],ecx              ;Is free block large enough ?
	jb @@Block_Not_Free             ;JB: Sorry,no !
	;Now we have to est if there is a sub-block of memory in ONE page
	mov edx,ebx
	add edx,8
	mov eax,edx
	shr eax,16                      ;Page
	add edx,ecx                     ;Requested size
	shr edx,16
	cmp ax,dx                       ;Is it still same page
	jne @@Next_page                 ;JNE: No test next page

	;This is case 1:
	;  The first subblock is in one page
  @@Allocate:
	mov eax,es:[ebx+4]              ;Save old size here
	and word ptr es:[ebx+2],NOT FREE_BLOCK
	sub eax,ecx                     ;Calculate remaining block size
	cmp eax,16                      ;When smaller than 16 bytes, do not
	jae short @@1                   ;create a new block !!!

	;This is case 1a:
	;  The resulting second free block is smaller than 16 bytes and will
	;  be added to the allocated block
	add ebx,8                       ;Skip header for return address
	mov eax,ebx
	shr ebx,16
	mov dx,bx                       ;Block address in DX:AX
	pop bp
	retf

	;This is case 1b:
	;  The resulting block is larger than 16 bytes and a second free
	;  will be created
  @@1:  mov es:[ebx+4],ecx              ;Save new size
	mov edx,ebx                     ;Save for return value
	add ebx,8                       ;Skip over header
	add ebx,ecx                     ;New header will be placed here
	mov word ptr es:[ebx],BLOCK_MAGIC
	sub eax,8                       ;Subtract header-size from remaining size
	mov es:[ebx+4],eax              ;Save new block size
	mov ax,FREE_BLOCK               ;Flag
	test word ptr es:[edx+2],LAST_BLOCK
	jz short @@2                    ;JZ: It was NOT the last block
	or ax,LAST_BLOCK
  @@2:  mov es:[ebx+2],ax               ;Save flags in new header
	and word ptr es:[edx+2],NOT LAST_BLOCK
	add edx,8
	mov eax,edx
	shr edx,16                      ;Block address in DX:AX
	pop bp
	retf



	;Now we come to case 2:
	;  Here we check if the next page in the block can hold the requested
	;  memory-block
	;  EBX - current MCB
	;  ECX - requested size
  @@Next_Page:
	mov edx,ebx
	xor dx,dx               ;EDX points to next possible MCB
	add edx,10000h
	mov eax,es:[ebx+4]
	sub eax,edx
	add eax,ebx             ;EAX= size of new block
	cmp eax,ecx
	jb short @@Block_Not_Free
	mov  word ptr es:[edx],BLOCK_MAGIC
	mov dword ptr es:[edx+4],eax    ;Set new size
	mov ax,es:[ebx+2]               ;Get flags
	and  word ptr es:[ebx+2],NOT LAST_BLOCK
	mov  word ptr es:[edx+2],ax     ;Set flags
	mov eax,edx
	sub eax,ebx
	sub eax,8
	mov dword ptr es:[ebx+4],eax    ;Set new size
	mov ebx,edx
	jmp @@Allocate


  @@Block_Not_Free:
	test word ptr es:[ebx+2],LAST_BLOCK
	jnz short @@NoMem
	add ebx,es:[ebx+4]
	add ebx,8
  jmp  @@Look_for_free


 @@Error:
	call MEMERR_Handler
 @@NoMem:
	test cs:[EXT386_Flags],EXIT_ON_LOWMEM
	jz short @@3
	DISPLAY_AND_EXIT Text35
 @@3:   xor dx,dx
	xor eax,eax
	pop bp
	retf
EXT_DMA_Malloc ENDP






EXT_Free PROC
	ARG adr:dword
	push bp
	mov bp,sp

	xor ax,ax
	mov es,ax
	mov ebx,cs:[XMS_Address]
	mov ecx,[adr]
	sub ecx,8                       ;Jump back to header
	xor edx,edx                     ;EDX will hold last-block
 @@Search_Block:
		cmp word ptr es:[ebx],BLOCK_MAGIC
		jne @@Error
		cmp ebx,ecx
		je short @@Block_Found
		mov edx,ebx             ;Save last-block for collecting
		test word ptr es:[ebx+2],LAST_BLOCK
		jnz short @@4
		add ebx,es:[ebx+4]
		add ebx,8               ;Jump to next header
 jmp short @@Search_Block
 @@4:   mov ax,FALSE
	pop bp
	retf

@@Block_Found:
	test edx,edx                    ;Is Last_Block=Zero ?
	jz short @@No_Previous_Block
	test word ptr es:[edx+2],FREE_BLOCK
	jz short @@No_Previous_Block
	test word ptr es:[ebx+2],LAST_BLOCK
	pushf
	mov eax,es:[ebx+4]
	add eax,8                       ;EAX has block-size inclusive header
	mov ebx,edx                     ;EBX points to previous block
	add es:[ebx+4],eax              ;Adjust size
	mov ax,FREE_BLOCK
	popf
	jz short @@1                    ;Was it the last block ?
	or ax,LAST_BLOCK                ;Yes,then this is the last block,too
   @@1: mov es:[ebx+2],ax               ;Save flags

@@No_Previous_Block:
	test word ptr es:[ebx+2],LAST_BLOCK
	jnz short @@One_Block
	mov edx,ebx
	add edx,es:[ebx+4]
	add edx,8                       ;EDX points to next block-header
	test word ptr es:[edx+2],FREE_BLOCK
	jz short @@One_Block
	test word ptr es:[edx+2],LAST_BLOCK
	pushf
	mov eax,es:[edx+4]              ;Get block-size
	add eax,8                       ;Add header-size
	add es:[ebx+4],eax              ;Add block-size to current block
	mov ax,FREE_BLOCK
	popf
	jz short @@2
	or ax,LAST_BLOCK
   @@2: mov es:[ebx+2],ax               ;Save flags

	mov ax,TRUE
	pop bp
	retf

@@One_Block:
	or word ptr es:[ebx+2],FREE_BLOCK
	mov ax,TRUE
	pop bp
	retf

@@Error:
	call MEMERR_Handler
EXT_Free ENDP





EXT_Coreleft PROC FAR
	xor ax,ax
	mov es,ax

	mov ebx,cs:[XMS_Address]
	xor edx,edx
 @@Loop:
		cmp word ptr es:[ebx],BLOCK_MAGIC
		jne short @@Error
		test word ptr es:[ebx+2],FREE_BLOCK
		jz short @@1
		add edx,es:[ebx+4]
	  @@1:  test word ptr es:[ebx+2],LAST_BLOCK
		jnz short @@End
		add ebx,es:[ebx+4]
		add ebx,8
 jmp short @@Loop

@@End:  mov eax,edx
	shr edx,16
	retf
@@Error:
	call MEMERR_Handler
EXT_Coreleft ENDP





;[]-------------------------------------------------------------------------[]
;|
;| Here come some memory-routines like memcpy,memcmp etc... They all use
;| linear addresses. If you want to convert a SEG:OFF address to a linear
;| address, then use the macro PTR2LONG in EXT386.H If you use assembler,
;| an equivalent would look like:
;|
;|      (Address in DX:AX, returns linear address in EAX)
;| PTR2LONG MACRO
;|      and edx,0ffffh
;|      and eax,0ffffh          ;Clear high-words
;|      shl edx,4               ;*16 bytes (one paragraph)
;|      add eax,edx
;|      ENDM
;|
;| The functions are:
;|      size_l Memcpy(size_l dest,size_l source,size_l len);
;|      int    Memcmp(size_l dest,size_l source,size_l len);
;|      size_l Memset(size_l dest,char c,size_l len);
;|      size_l Memchr(size_l src ,char c,size_l len);
;|
;| Note in the implementation of these routines:
;|  If you use STOS,LODS,CMPS,SCAS or MOVS in your program and you want
;|  to access the extended memory, then you MUST write explicite:
;|  lods byte ptr ds:[ESI] and
;|  stos byte ptr es:[EDI] etc...
;| So do not forget to use 32-bit indices. You must also consider that if
;| you use the REP prefix with a 32-bit command, that the counter will
;| be ECX and NOT CX !!!
;|
;| P.S.: There are rather a lot of people telling you, that you cannot
;| access the linear address-space with these string commands - they
;| just don't know how to use TASM - Here is the proof it works ;-)
;|




Memcpy PROC FAR
	ARG dest:dword,src:dword,len:dword
	push bp
	mov bp,sp
	push edi
	push esi

	cld
	xor ax,ax
	mov es,ax
	mov fs,ax
	mov esi,[src]
	mov edi,[dest]
	mov ecx,[len]
	rep movs byte ptr es:[edi],fs:[esi]

	mov edx,[dest]
	mov eax,edx
	shr edx,16

	pop esi
	pop edi
	pop bp
	retf
Memcpy ENDP





Memcmp PROC FAR
	ARG dest:dword,src:dword,len:dword
	push bp
	mov bp,sp
	push esi
	push edi

	cld
	xor ax,ax
	mov es,ax
	mov fs,ax
	mov esi,[src]
	mov edi,[dest]
	mov ecx,[len]
	repe cmps byte ptr fs:[esi],es:[edi]
	setne al
	xor ah,ah

	pop edi
	pop esi
	pop bp
	retf
Memcmp ENDP






Memset PROC FAR
	ARG dest:dword,val:byte,len:dword
	push bp
	mov bp,sp
	push edi

	cld
	xor ax,ax
	mov es,ax
	mov edi,[dest]
	mov ecx,[len]
	mov al,[val]
	rep stos byte ptr es:[edi]

	mov edx,[dest]
	mov eax,edx
	shr edx,16

	pop edi
	pop bp
	retf
Memset ENDP






Memchr PROC FAR
	ARG dest:dword,val:byte,len:dword
	push bp
	mov bp,sp
	push edi

	cld
	xor ax,ax
	mov es,ax
	mov edi,[dest]
	mov ecx,[len]
	mov al,[val]
	repne scas byte ptr es:[edi]
	cmp es:[edi],al
	je short @@1
	xor edi,edi
  @@1:  mov eax,edi
	shr edi,16
	mov dx,di

	pop edi
	pop bp
	retf
Memchr ENDP



;[]-------------------------------------------------------------------------[]
;|
;| Now follow some I/O routines for disk-access in FLAT-Mode
;| Basically they use normal DOS-interrupts and copy 1024-byte chunks from
;| Base-memory to XMS.
;|
;| The functions are:
;| int    Open  (char *fname,int mode);
;| int    Creat (char *fname,int attribute);
;| size_l Read  (int handle,long address,long size);
;| size_l Write (int handle,long address,long size);
;| int    Close (int handle);
;| size_l Seek  (int handle,long pos,int where);
;| size_l Tell  (int handle);
;|
;| These functions only work in the binary file mode, but are compatible with
;| the equivalents in Borland C++, which use DOS-calls. The syntax is just
;| the same like _open,_read,_write etc. You can even use the read and
;| write commands together with handles open by _open !!!
;|

O_RDONLY                equ     1
O_WRONLY                equ     2
O_RDWR                  equ     4




Open PROC FAR
	ARG fname:dword,mode:word
	push bp
	mov bp,sp
	push ds

	mov al,1
	mov cx,[mode]
	test cx,O_WRONLY
	jnz short @@1
	mov al,2
	test cx,O_RDWR
	jnz short @@1
	mov al,0
@@1:    lds dx,[fname]
	mov cl,0f0h
	and cl,byte ptr [mode]
	or al,cl
	mov ah,3dh
	int 21h                                 ;AX contains new handle
	jc short @@Error

	pop ds
	pop bp
	retf
@@Error:
	xor ax,ax
	pop ds
	pop bp
	retf
Open ENDP






Creat PROC FAR
	ARG fname:dword,mode:word
	push bp
	mov bp,sp
	push ds

	mov ah,03ch
	mov cx,[mode]
	lds dx,[fname]
	int 21h
	jc short @@Error

	pop ds
	pop bp
	retf
@@Error:
	xor ax,ax
	pop ds
	pop bp
	retf
Creat ENDP






Close PROC FAR
	ARG handle:word
	push bp
	mov bp,sp

	mov ah,3eh
	mov bx,[handle]
	int 21h
	mov ax,0

	pop bp
	retf
Close ENDP







Seek PROC FAR
	ARG handle:word,pos:dword,mode:word
	push bp
	mov bp,sp

	mov ah,42h
	mov al,byte ptr [mode]
	mov bx,[handle]
	mov cx,word ptr [pos+2]
	mov dx,word ptr [pos]
	int 21h

	mov bx,dx
	shl ebx,16
	mov bx,ax
	mov eax,ebx

	pop bp
	retf
Seek ENDP







Tell PROC FAR
	ARG handle:word
	push bp
	mov bp,sp

	mov ax,4201h
	mov bx,[handle]
	xor cx,cx
	xor dx,dx
	int 21h

	mov bx,dx
	shl ebx,16
	mov bx,ax
	mov eax,ebx

	pop bp
	retf
Tell ENDP








Read PROC FAR
	ARG handle:word,adr:dword,len:dword
	push bp
	mov bp,sp
	push ds
	push esi
	push edi
	push ebp

	cld
	xor ax,ax
	mov es,ax               ;ES is used for RMEM
	mov bx,[handle]         ;BX holds filehandle
	mov esi,[len]           ;ESI holds len
	mov edi,[adr]           ;EDI holds destination in RMEM
	xor ebp,ebp             ;EBP holds bytes read
	push edi
	add edi,esi
	cmp edi,100000h
	pop edi
	jb short Read_Low_Mem

     @@Loop:
	test esi,esi
	jz @@End

	mov ecx,esi                     ;CX holds lower word of size
	cmp esi,cs:[IO_Buffer_Size]     ;Is ESI bigger than buffer ?
	jb short @@1                    ;JB => No,leave SI in cx
	mov ecx,cs:[IO_Buffer_Size]
   @@1: push bx                         ;Save handle
	push cx
	mov ah,3fh                      ;Read block
	lds dx,cs:[IO_Buffer]
	int 21h
	pop dx
	pop bx                          ;Restore handle
	pushf                           ;Save Carry-bit
	movzx ecx,ax                    ;ECX will be used as a counter
	sub esi,ecx                     ;Subtract bytes_read from bytes_to_read
	add ebp,ecx                     ;Add bytes_read to

	push esi
	xor esi,esi                     ;Clear high-bytes
	lds si,cs:[IO_Buffer]           ;DS:SI points to Buffer
	rep movs byte ptr es:[edi],ds:[esi]
	pop esi

	popf                            ;Restore carry-bit
	jc short @@End
	cmp dx,ax
	jne short @@End
	jmp short @@Loop


   Read_Low_Mem:
   @@Loop2:
	test esi,esi
	jz short @@End

	mov ecx,esi                     ;CX holds lower word of size
	cmp esi,0fff0h                  ;Is ESI bigger than buffer ?
	jb short @@5                    ;JB => No,leave SI in cx
	mov ecx,0fff0h
   @@5: push bx                         ;Save handle
	push cx
	ror edi,4
	mov ds,di
	rol edi,4
	mov dx,di
	and dx,0fh
	mov ah,3fh                      ;Read block
	int 21h
	pop dx
	pop bx                          ;Restore handle
	pushf                           ;Save Carry-bit
	movzx ecx,ax                    ;ECX will be used as a counter
	sub esi,ecx                     ;Subtract bytes_read from bytes_to_read
	add ebp,ecx                     ;Add bytes_read to
	add edi,ecx
	popf                            ;Restore carry-bit
	jc short @@End
	cmp dx,ax
	jne short @@End
	jmp short @@Loop2

     @@End:
	mov eax,ebp
	shr ebp,16
	mov dx,bp               ;Bytes read in DX:AX
	pop ebp
	pop edi
	pop esi
	pop ds
	pop bp
	retf
Read ENDP






Write PROC FAR
	ARG handle:word,adr:dword,len:dword
	push bp
	mov bp,sp
	push ds
	push esi
	push edi
	push ebp

	cld
	xor ax,ax
	mov fs,ax                       ;DS is used for RMEM
	mov bx,[handle]                 ;BX holds filehandle
	mov edi,[len]                   ;EDI holds len
	mov esi,[adr]                   ;ESI holds source in RMEM
	xor ebp,ebp                     ;EBP holds bytes read

     @@Loop:
	test edi,edi
	jz short @@End

	mov ecx,edi                     ;CX holds lower word of size
	cmp edi,cs:[IO_Buffer_Size]     ;Is ESI bigger than buffer ?
	jb short @@1                    ;JB => No,leave SI in cx
	mov ecx,cs:[IO_Buffer_Size]
   @@1: push edi
	push ecx                        ;Save counter
	xor edi,edi                     ;Clear high-bytes
	les di,cs:[IO_Buffer]           ;ES:EDI points to Buffer
	rep movs byte ptr es:[edi],fs:[esi]
	pop ecx
	pop edi
	push bx                         ;Save handle
	push cx
	mov ah,40h                      ;Write block
	lds dx,cs:[IO_Buffer]
	int 21h
	pop dx
	pop bx                          ;Restore handle
	pushf                           ;Save Carry-bit
	movzx ecx,ax                    ;ECX will be used as a counter
	sub edi,ecx                     ;Subtract bytes_read from bytes_to_read
	add ebp,ecx                     ;Add bytes_read to
	popf                            ;Restore carry-bit
	jc short @@End
	cmp dx,ax
	jne short @@End
	jmp short @@Loop

     @@End:
	mov eax,ebp
	shr ebp,16
	mov dx,bp               ;Bytes read in DX:AX
	pop ebp
	pop edi
	pop esi
	pop ds
	pop bp
	retf
Write ENDP





PUBLIC C Chsize
Chsize PROC FAR
	ARG handle:word,newsize:dword
	LOCAL Posn:dword
	push	bp
	mov	bp,sp
	sub	sp,4

	mov     ax, 4201h               ;Seek to current position
	mov     bx, [handle]
	sub     cx, cx
	mov     dx, cx
	int     21h
	jc      @@E

	mov     word ptr [Posn], ax
	mov     word ptr [Posn+2], dx   ;Save this position

	mov     ax, 4202h		;Seek to end of file
	sub     cx, cx
	mov     dx, cx
	int     21h
	jc      @@E

	cmp     dx, word ptr [newSize+2]
	ja      chsizeTruncate
	jb      chsizePad
	cmp     ax, word ptr [newSize]
	jae     chsizeTruncate


	;
	;Here we expand the file
	;
chsizePad:
	shl	edx,16
	mov	dx,ax			;EDX contains actual address
	push	ds
	push	esi
	push	edi

	les	di,cs:[IO_Buffer]
	mov     ecx,cs:[IO_Buffer_Size]
	shr	cx,2
	xor	eax,eax
	cld
	rep  	stosd

	mov 	edi,[newSize]          	;EDI holds len
	sub     edi,edx                 ;EDI holds total bytes to write
chsizeWriteLoop:
	mov	ecx,cs:[IO_Buffer_Size]
	cmp	edi,ecx
	jae	short @@1		;A full buffer ???
	mov	ecx,edi
@@1:	mov 	ah,40h           	;Write block
	lds 	dx,cs:[IO_Buffer]
	int 	21h
	jc	@@E2
	movzx 	ecx,ax                  ;ECX will be used as a counter
	sub 	edi,ecx                 ;Subtract bytes_read from bytes_to_read
	jnz 	short chsizeWriteLoop

	pop	edi
	pop	esi
	pop	ds
	add	sp,4
	pop	bp
	xor 	ax,ax
	retf

@@E2:	pop	edi
	pop	esi
	pop	ds
	add	sp,4
	pop	bp
	mov 	ax,FALSE
	retf



	;
	;Here we truncate the file
	;
chsizeTruncate:
	mov     ax, 4200h               ;seek to new end-of-file
	mov     bx, [handle]
	mov     dx, word ptr [newSize]
	mov     cx, word ptr [newSize+2]
	int     21h
	jc      @@E

	mov     ah, 40h                 ;truncate at desired position
	sub     cx, cx
	int     21h
	jc      @@E

chsizeSeekback:
	mov     dx, word ptr [Posn]
	mov     cx, word ptr [Posn+2]
	mov     ax, 4200h               ; seek to original place
	int     21h
	jc      @@E

	xor	ax,ax
	add	sp,4
	pop	bp
	retf

@@E:	mov	ax,FALSE
	add	sp,4
	pop	bp
	retf
Chsize ENDP




PUBLIC C Getchar
Getchar PROC FAR
	ARG handle:word
	push 	bp
	mov	bp,sp



	pop	bp
	retf
Getchar ENDP



;[]-------------------------------------------------------------------------[]
;|
;| This command will execute C:\COMMAND.COM. This routine also manages the
;| revectoring of various routines (INT9,INT0,etc...)
;|
DOS_Command     db      "C:\COMMAND.COM",0
DOS_Switches    db      0
DOS_Parameter   dw      0
		dw      OFFSET DOS_Switches
		dw      SEG DOS_Switches
		dw      5ch
DOS_FCB1        dw      ?
		dw      6ch
DOS_FCB2        dw      ?
PUBLIC C System
System PROC FAR
	push ds
	push esi
	push edi
	push ebp

	call FAR PTR Set_Flat_Interrupt C,0,cs:[OLD_INT0]
	call FAR PTR Set_Flat_Interrupt C,4,cs:[OLD_INT4]
	call FAR PTR Set_Flat_Interrupt C,9,cs:[OLD_INT9]

	mov bx,cs:[EXT386_PSP]                 ;Get PSP
	mov cs:[DOS_FCB1],bx
	mov cs:[DOS_FCB2],bx

	mov ax,cs
	mov ds,ax
	mov es,ax
	mov dx,OFFSET DOS_Command
	mov bx,OFFSET DOS_Parameter
	mov ax,4b00h
	int 21h

	call FAR PTR Set_Flat_Interrupt C,0,OFFSET INT00_Handler,cs
	call FAR PTR Set_Flat_Interrupt C,4,OFFSET INT04_Handler,cs
	call FAR PTR Set_Flat_Interrupt C,9,OFFSET INT09_Handler,cs

	pop ebp
	pop edi
	pop esi
	pop ds
	retf
System ENDP





;[]-------------------------------------------------------------------------[]
;|
;| Now follow some interrupt-vector routines like GET_INTERRUPT etc.
;| Note that there are two function classes:
;|   Function for Flat-INT and other for Real-INT. When you install a handler
;|   using the Real-INT, it will be written in the normal interrupt table
;|   at 0000:0000 - but they might have to be simulated.
;|   When you use Real-INT, all interrupts are written in the active table
;| Note that not all methods support this difference, but this should be
;| of no interrest. You should just use the Flat-INTS, as long as the specific
;| code is in lower 640KB
;|
PUBLIC C Set_Real_Interrupt
Set_Real_Interrupt PROC FAR
	ARG nr:word,handler:dword
	push bp
	mov bp,sp

	xor ax,ax
	mov es,ax
	mov bx,[nr]
	shl bx,2
	mov eax,es:[bx]
	mov ecx,[handler]
	mov es:[bx],ecx

	mov edx,eax
	shr edx,16

	pop bp
	retf
Set_Real_Interrupt ENDP





PUBLIC C Get_Real_Interrupt
Get_Real_Interrupt PROC FAR
	ARG nr:word
	push bp
	mov bp,sp

	xor ax,ax
	mov es,ax
	mov bx,[nr]
	shl bx,2
	mov eax,es:[bx]

	mov edx,eax
	shr edx,16

	pop bp
	retf
Get_Real_Interrupt ENDP






PUBLIC C Set_Flat_Interrupt
Set_Flat_Interrupt PROC FAR
	ARG nr:word,handler:dword
	push bp
	mov bp,sp
	push si

	test cs:[EXT386_Flags],VIRTUAL_INTERRUPTS
	jz short @@1
	les si,cs:[VINT_Table]
	jmp short @@2
@@1:	xor si,si
	mov es,si
@@2:	mov bx,[nr]
	shl bx,2
	mov eax,es:[bx+si]
	mov ecx,[handler]
	mov es:[bx+si],ecx

	mov edx,eax
	shr edx,16

	pop si
	pop bp
	retf
Set_Flat_Interrupt ENDP





PUBLIC C Get_Flat_Interrupt
Get_Flat_Interrupt PROC FAR
	ARG nr:word
	push bp
	mov bp,sp
	push si

	test cs:[EXT386_Flags],VIRTUAL_INTERRUPTS
	jz short @@1
	les si,cs:[VINT_Table]
	jmp short @@2
@@1:	xor si,si
	mov es,si
@@2:	mov bx,[nr]
	shl bx,2
	mov eax,es:[bx+si]

	mov edx,eax
	shr edx,16

	pop si
	pop bp
	retf
Get_Flat_Interrupt ENDP





PUBLIC C Get_PSP
Get_PSP PROC FAR
	mov ax,cs:[EXT386_PSP]
	mov dx,ax
	shl eax,16
	retf
Get_PSP ENDP


;[]-------------------------------------------------------------------------[]
;|
;| The following code is something like a DPMI interrupt. It handles
;| get/set interrupt requests etc....
;|
INT31_Handler PROC FAR
	push es
	push fs
	push gs
	cmp ax,200h
	jne short @@1
		xor bh,bh
		call Get_Real_Interrupt C,bx
		mov cx,dx
		mov edx,eax
		jmp @@E
@@1:	cmp ax,201h
	jne short @@2
		xor bh,bh
		call Set_Real_Interrupt C,bx,dx,cx
		jmp @@E
@@2:	cmp ax,204h
	jne short @@3
		xor bh,bh
		call Get_Flat_Interrupt C,bx
		mov cx,dx
		mov edx,eax
		jmp @@E
@@3:	cmp ax,205h
	jne short @@4
		xor bh,bh
		call Set_Flat_Interrupt C,bx,dx,cx
		jmp @@E
@@4:	cmp ax,0ffffh
	jne short @@5
		xor ax,ax
		mov bx,EXT_Version
		jmp @@E
@@5:    cmp ax,0100h
	jne short @@6
		movzx ebx,bx
		shl ebx,4
		call Malloc C,ebx
		jmp @@E
@@6:    cmp ax,0101h
	jne short @@7
		movzx edx,dx
		shl edx,4
		call Free C,edx
		jmp @@E
@@7:    cmp ax,0150h
	jne short @@8
		mov ax,cs:[EXT386_PSP]
		mov dx,ax
		shl eax,16
		jmp @@E
@@8:    cmp ax,0501h
	jne short @@9
		call EXT_Malloc C,cx,bx
		mov bx,dx
		mov cx,ax
		jmp @@E
@@9:    cmp ax,0502h
	jne short @@A
		call EXT_Free C,cx,bx
		mov bx,dx
		mov cx,ax
		jmp @@E
@@A:
@@E:	pop gs
	pop fs
	pop es
	iret
INT31_Handler ENDP


END
