;[]------------------------------------------------------------------------[]
;|                                                                          |
;| (c) 1993,1994 by Marc van Shaney , aka Kaya Memisoglu                    |
;|                                                                          |
;| Dieser Assembler-Source-Code unterliegt dem Urheberrecht von Kaya        |
;| Memisoglu und darf auch nur mit seiner schriftlichen Genehmigung         |
;| in kommerziellen Programmen verwendet werden.                            |
;| Ich bernehme keinerlei Verantwortung fr eventuelle Schden,die dieses  |
;| Programm verursacht.                                                     |
;|                                                                          |
;|                                                                          |
;| 18.12.1994 Kaya Memisoglu                                                |
;|                                                                          |
;[]------------------------------------------------------------------------[]


P386
JUMPS

LOCALS
VGA_Width         equ  320
VGA_Height        equ  200
VGA_Segment       equ  0a000h
VGA_Mode          equ  13h
Char_Segment      equ  0f000h
Char_Offset       equ  0fa6eh
Text_Mode         equ  3
Black             equ  240
Background        equ  255
VGA_Adresse       equ  0a0000000h

CRTC_Index        equ 3d4h
CRTC_Data         equ 3d5h
CRTC_Status       equ 3dah
Display_Enable    equ 01
Vertical_Sync     equ 08


.MODEL USE16 LARGE
.Code


PUBLIC C Init_Graphic
Init_Graphic PROC
      push ds
      mov al,VGA_Mode
      mov ah,0
      int 10h
      mov ah,10h
      mov al,01h
      mov bh,0
      int 10h

      pop ds
      retcode
Init_Graphic ENDP





PUBLIC C Exit_Graphic
Exit_Graphic PROC
      push ds

      mov al,Text_Mode
      mov ah,0
      int 10h

      pop ds
      retcode
Exit_Graphic ENDP






PUBLIC C Clear_Screen
Clear_Screen PROC
      ARG farbe:byte
      push bp
      mov bp,sp
      push di
      cld

      mov ax,VGA_Segment
      mov es,ax                 ;In ES ist das VGA-Segment
      mov ah,[farbe]
      mov al,ah                 ;Farbe einladen
      rol eax,16
      mov al,[farbe]
      mov ah,al
      mov di,0
      mov cx,03e80h             ;Bank lschen (DoppelWortweise !!!)
      rep stosd

      pop di
      pop bp
      retcode
Clear_Screen ENDP





PUBLIC C Get_Colour
Get_Colour PROC
      ARG COLOR:DATAPTR,Nummer:Word
      push bp
      mov bp,sp
      cli

      les bx,COLOR              ;In ES:DI Zeiger auf Farbe
      mov dx,03c7h
      mov ax,Nummer             ;In AX die Farbnummer
      out dx,al
      add dx,2                  ;Neue Portadresse
      in al,dx
      shl al,2
      mov [ES:bx],al
      in al,dx
      shl al,2
      mov [ES:bx+1],al
      in al,dx
      shl al,2
      mov [ES:bx+2],al

      sti
      pop bp
      retcode
Get_Colour ENDP






PUBLIC C Set_Colour
Set_Colour PROC
      ARG COLOR:DATAPTR,Nummer:Word
      push bp
      mov bp,sp
      cli

      les bx,COLOR              ;In ES:DI Zeiger auf Farbe
      mov dx,03c8h
      mov ax,Nummer             ;In AX die Farbnummer
      out dx,al
      inc dx                    ;Neue Portadresse
      mov al,byte ptr[es:bx]
      shr al,2                  ;2 Bit nach rechts verschieben
      out dx,al
      mov al,byte ptr[es:bx+1]
      shr al,2                  ;2 Bit nach rechts verschieben
      out dx,al
      mov al,byte ptr[es:bx+2]
      shr al,2                  ;2 Bit nach rechts verschieben
      out dx,al

      sti
      pop bp
      retcode
Set_Colour ENDP






PUBLIC C Set_Palette
Set_Palette PROC
      ARG COLOR:DATAPTR
      push bp
      mov bp,sp

      xor cl,cl
      les bx,COLOR              ;In ES:DI Zeiger auf Farbe
@@1:  mov dx,03c8h
      mov ax,cx             	;In AX die Farbnummer
      out dx,al
      inc dx                    ;Neue Portadresse
      mov al,byte ptr[es:bx]
      shr al,2                  ;2 Bit nach rechts verschieben
      out dx,al
      mov al,byte ptr[es:bx+1]
      shr al,2                  ;2 Bit nach rechts verschieben
      out dx,al
      mov al,byte ptr[es:bx+2]
      shr al,2                  ;2 Bit nach rechts verschieben
      out dx,al
      add bx,4
      inc cl
      jnz short @@1

      pop bp
      retcode
Set_Palette ENDP









PUBLIC C Put_Frame
Put_Frame PROC
      ARG frame:dataptr
      push bp
      mov bp,sp
      push si
      push di
      cld

      mov cx,3e80h
      lfs si,frame
      mov ax,VGA_Segment
      mov es,ax
      xor di,di
      rep movs dword ptr [es:di],[fs:si]

      pop di
      pop si
      pop bp
      retcode
Put_Frame ENDP




PUBLIC C VGA_Wait_Sync
VGA_Wait_Sync PROC
      mov dx,CRTC_Status
  Nope3:
      in al,dx
      test al,Display_Enable
      jnz Nope3
  Nope4:
      in al,dx
      test al,Vertical_Sync
      jz Nope4

      retcode
VGA_Wait_Sync ENDP




PUBLIC C Set_Tween_Palette
Set_Tween_Palette PROC
      ARG src:dword,dest:dword,strength:word
      push bp
      mov bp,sp
      push ds
      push si
      push di

      xor cl,cl
      lds si,[src]              ;In ES:DI Zeiger auf Farbe
      les di,[dest]
      mov bx,[strength]
      shr bx,2
      mov bh,64
      sub bh,bl
@@1:  mov dx,03c8h
      mov al,cl             	;In AX die Farbnummer
      out dx,al
      inc dx                    ;Neue Portadresse
      mov al,ds:[si]
      mul bl
      mov ch,ah
      mov al,es:[di]
      mul bh
      mov al,ah
      add al,ch
      out dx,al
      mov al,ds:[si+1]
      mul bl
      mov ch,ah
      mov al,es:[di+1]
      mul bh
      mov al,ah
      add al,ch
      out dx,al
      mov al,ds:[si+2]
      mul bl
      mov ch,ah
      mov al,es:[di+2]
      mul bh
      mov al,ah
      add al,ch
      out dx,al
      add di,4
      add si,4
      inc cl
      jnz short @@1

      pop di
      pop si
      pop ds
      pop bp
      retcode
Set_Tween_Palette ENDP




Tween_Table db 512 dup (?)

PUBLIC C Put_Tween_Frames
Put_Tween_Frames PROC FAR
	arg src:dword,dest:dword,strength:word
	push bp
	mov bp,sp
	push ds
	push si
	push di


	mov dx,[strength]
	xor bx,bx
@@L1:	mov al,bl
	mul dl
	mov cs:[OFFSET Tween_Table+bx],ah
	mov al,bl
	sub al,ah
	mov cs:[OFFSET Tween_Table+bx+256],al
	inc bl
	jnz short @@L1


	xor esi,esi
	xor edi,edi
	lds si,[src]
	lfs di,[dest]
	mov bp,63998
	mov ax,0a000h
	mov es,ax
	xor bx,bx

@@L2:	mov bl,ds:[si+bp]
	mov al,cs:[OFFSET Tween_Table+bx]
	mov bl,fs:[di+bp]
	add al,cs:[OFFSET Tween_Table+bx+256]
	mov bl,ds:[si+bp+1]
	mov ah,cs:[OFFSET Tween_Table+bx]
	mov bl,fs:[di+bp+1]
	add ah,cs:[OFFSET Tween_Table+bx+256]
	mov es:[bp],ax
	sub bp,2
	jnz short @@L2

	pop di
	pop si
	pop ds
	pop bp
	retf
Put_Tween_Frames ENDP



END