/***************************************************************************
 **
 ** (c) 1993,1994,1995 by Marc van Shaney , aka Kaya Memisoglu
 **
 ** This Source-Code was written by and is copyrighted by Kaya Memisoglu
 ** You may use the whole code or only parts of it in your own programs
 ** whether they are commercial or not. BUT you must give credits for these
 ** parts to me (Kaya Memisoglu  or  Marc van Shaney).
 ** I am not responsible for any damage or loss caused by this program, so
 ** if you success in erasing your harddisk with this code, then it is your
 ** own fault and you should not claim me to be responsible...
 ** I would be very pleased if you also sent me a postcard or even a letter
 ** if you can use this code. My address:
 **
 **        Kaya Memisoglu
 **        Reichenberger Ring 50
 **        63512 Hainburg
 **        Germany
 **
 ** You can also leave a message for Marc van Shaney on the Nirvana BBS:
 **
 **              Nirvana BBS     ++49-(0)6245-3056      Sysop:Raytrayza
 **
 **
 **/

#include <bios.h>
#include <stdio.h>
#include <dos.h>
#include <stdlib.h>
#include <mem.h>
#include <conio.h>
#include <math.h>
#include <string.h>

#include "cdmi.h"
#include "vga.h"
#include "frame.h"

extern far Palette XAOS1_PAL;
extern far Bitmap  XAOS0_PIC;
extern far Bitmap  XAOS1_PIC;
extern far Bitmap  XAOS2_PIC;
extern far Bitmap  XAOS3_PIC;
extern far Palette XAOS3_PAL;
extern far Palette XAOS4_PAL;
extern far Bitmap  XAOS_LENS;
extern far char    XAOS5_PIC;
extern     Palette XAOS5_PAL;
extern far Palette XAOS6_PAL;
extern far Bitmap  XAOS6_PIC;
extern far Bitmap  XAOS7_PIC;
extern far Palette XAOS8_PAL;
extern far Palette XAOS9_PAL;
extern far IFS     XAOS0_IFS;
extern far IFS     XAOS1_IFS;
extern far IFS     XAOS2_IFS;
extern far IFS     XAOS3_IFS;
extern far IFS     XAOS4_IFS;
extern far IFS     XAOS5_IFS;
extern far IFS     XAOS6_IFS;
extern far IFS     XAOS7_IFS;
extern far IFS     XAOS8_IFS;
extern far IFS     XAOS9_IFS;
extern far IFS     XAOSA_IFS;
extern far IFS     XAOSB_IFS;
extern far IFS     XAOSD_IFS;
extern far IFS	   XAOSZ_IFS;
extern far char	   XAOS_ADDY[4000];


/***************************************************************************
 **
 ** These are some driver specific routines...
 **
 **/

extern SoundDrv *SBDMA_Driver;
extern SoundDrv *SPEAKER_Driver;
extern SoundDrv *SBTIMER_Driver;
extern SoundDrv *LPT_Driver;
extern SoundDrv *ADLIB_Driver;

#ifndef __DRIVER_STRUCT
#define __DRIVER_STRUCT

#define CONFIG_MAGIC		0x36bea73f
#define CONFIG_STRING		1
#define CONFIG_INTEGER		2
#define CONFIG_SELECT		3
#define CONFIG_SWITCH		4
#define CONFIG_TEXT		5

typedef struct {
		char Type;
		char Text_Len;
		int Dataptr;
		int Parameter[6];
		char Text[];
	       } Config_Object;
typedef struct {
		long Magic;
		int  Config_Count;
		Config_Object First_Object;
	       } Driver_Setup;

typedef struct {
		char Copyright[28];
		long Size;
		char Type[16];
		char Name[32];
		int Version;
		int Function_Count;
		Driver_Setup *Config;
		int Driver[];
	       } Driver_Header;

#endif

int Config_Driver(Driver_Header *Drv)
{
 Config_Object *Cur_Obj;
 int *dataptr,i;

 if ((Drv->Config->Magic!=CONFIG_MAGIC) || (Drv->Config->Config_Count==0))
	 return TRUE;

 Cur_Obj=&Drv->Config->First_Object;

 for (i=0;i<Drv->Config->Config_Count;i++)
	{
	 dataptr=MK_FP(FP_SEG(Drv),Cur_Obj->Dataptr);
	 switch (Cur_Obj->Type)
		{
		 case CONFIG_TEXT:
                 	printf("%s\n",Cur_Obj->Text);
			break;
		 case CONFIG_INTEGER:
                 	printf("%s (%d - %d):",Cur_Obj->Text,Cur_Obj->Parameter[0],Cur_Obj->Parameter[1]);
                        scanf("%d",dataptr);
			break;
		}
	 Cur_Obj=MK_FP(FP_SEG(Cur_Obj),FP_OFF(Cur_Obj)+16+(int)Cur_Obj->Text_Len);
	}

 return TRUE;
}







/***************************************************************************
 **
 ** Here's a little getkey function. It substitutes the Borland getch()
 ** function,because it also return special codes.
 **
 **/


int getkey(void)
{
 int key, lo, hi;

 key = bioskey(0);
 lo = key & 0X00FF;
 hi = (key & 0XFF00) >> 8;
 return((lo == 0) ? hi + 256 : lo);
}



/***************************************************************************
 **
 **  This little MACRO is used to find out if there is a key in the buffer.
 ** I don't use kbhit(), because there is a conflict between this function
 ** and my interrupt-handler causing a lock-up.
 **
 **/

#ifndef BIOS_kbhit
#define BIOS_kbhit	((*((int *)MK_FP(0x040,0x01c)))-(*((int *)MK_FP(0x040,0x01a))))
#endif


char *Frame;
Bitmap *FrameB;
char *Screen=MK_FP(0x0a000,0000);

#define MP_SCALE		16777216
void Intro(void)
{
 char *Frame2;

 Frame2=Malloc(64000L);

 Set_Palette(&XAOS1_PAL);

 Clear_Frame(Frame,0);
 Clear_Frame(Frame2,0);
 FPut_Image(Frame,50,78,&XAOS1_PIC);
 CDMI_Tick=0;
 while (CDMI_Tick<127)
	 Put_Tween_Frames(Frame2,Frame,255-2*CDMI_Tick);

 CDMI_Tick=0;
 while (CDMI_Tick<40);
 CDMI_Tick=0;
 FPut_Image(Frame2,72,78,&XAOS2_PIC);
 while (CDMI_Tick<127)
	 Put_Tween_Frames(Frame,Frame2,255-2*CDMI_Tick);

 CDMI_Tick=0;
 while (CDMI_Tick<40);
 CDMI_Tick=0;
 Clear_Frame(Frame,0);
 FStretch_Image(Frame,270,66,50,&XAOS0_PIC);
 while (CDMI_Tick<127)
	 Put_Tween_Frames(Frame2,Frame,255-2*CDMI_Tick);

 CDMI_Tick=0;
 while (CDMI_Tick<110)
	{
	 Clear_Frame(Frame,0);
	 FStretch_Image(Frame,270-(CDMI_Tick<<1),66,50+(CDMI_Tick<<1),&XAOS0_PIC);
	 Put_Frame(Frame);
	}

 Free(Frame2);
}





void Mandel (void)
{
 char *Frame2;
 Bitmap *Mandel;

 Mandel=Malloc(16032L);
 Frame2=Malloc(64000L);
 Mandel->Width=160;
 Mandel->Height=100;

 Calc_Mandel(Mandel,-168674656,46332939,-167332464,45325297);
 CDMI_Tick=0;
 Copy_Frame(Frame2,XAOS3_PIC.Data);
 FPut_Image(Frame2,80,50,Mandel);
 while (CDMI_Tick<127)
	 Put_Tween_Frames(Frame,Frame2,255-2*CDMI_Tick);

 Copy_Frame(Frame,XAOS3_PIC.Data);
 FPut_Image(Frame,80,50,Mandel);
 Put_Frame(Frame);

 CDMI_Tick=0;
 while (CDMI_Tick<40);
 CDMI_Tick=0;
 while (CDMI_Tick<63)
	Set_Tween_Palette(&XAOS1_PAL,&XAOS3_PAL,255-CDMI_Tick*4);

 Mandel->Width=80;
 Mandel->Height=50;
 Calc_Mandel(Mandel,-30071736<<3,359682<<3,-29011420<<3,-435559<<3);
 FPut_Image(Frame,0,50,Mandel);
 Put_Frame(Frame);
 Calc_Mandel(Mandel,7747235<<3,-5754311<<3,7915009<<3,-5880141<<3);
 FPut_Image(Frame,240,100,Mandel);
 Put_Frame(Frame);
 Calc_Mandel(Mandel,-2611439<<3,17451961<<3,-2516515<<3,17380775<<3);
 FPut_Image(Frame,0,100,Mandel);
 Put_Frame(Frame);
 Calc_Mandel(Mandel,-21157962<<3,-6336034<<3,-20990188<<3,-6461864<<3);
 FPut_Image(Frame,240,50,Mandel);
 Put_Frame(Frame);
 Calc_Mandel(Mandel,-12338738<<3,-5928792<<3,-12037054<<3,-6155055<<3);
 FPut_Image(Frame,0,0,Mandel);
 Put_Frame(Frame);
 Calc_Mandel(Mandel,44214136,-7826277,46705211,-9694589);
 FPut_Image(Frame,240,150,Mandel);
 Put_Frame(Frame);
 Calc_Mandel(Mandel,-12874674,128732543,-12807592,128682197);
 FPut_Image(Frame,0,150,Mandel);
 Put_Frame(Frame);
 Calc_Mandel(Mandel,-23471994,-88385280,-23135869,-88636885);
 FPut_Image(Frame,240,0,Mandel);
 Put_Frame(Frame);

 CDMI_Tick=0;
 while (CDMI_Tick<40);

 Free(Frame2);
 Free(Mandel);
}





/****************************************************************************
 **
 ** Something
 **
 **/
void Lens(void)
{
 char *Frame2;
 Palette *Pal;
 int x,y,Last_Tick;

 Frame2=Malloc(64000L);
 Pal=Malloc(sizeof(Palette));
 memset(Pal,0,sizeof(Palette));

 CDMI_Tick=0;
 while (CDMI_Tick<127)
	{
	 Clear_Frame(Frame2,0);
	 FZoom_Image(Frame2,CDMI_Tick*160/128,CDMI_Tick*100/128,319-CDMI_Tick*160/128,199-CDMI_Tick*100/128,FrameB);
	 Put_Frame(Frame2);
	 Set_Tween_Palette(Pal,&XAOS3_PAL,CDMI_Tick<<1);
	}

 Free(Pal);
 Free(Frame2);
}





/****************************************************************************
 **
 ** Some fast IFS routines with morphing
 **
 **/
void Do_Tween (IFS *a,IFS *b)
{
 CDMI_Tick=0;
 while (CDMI_Tick<64)
	{
	 Tween_IFS(a,b,&XAOSZ_IFS,CDMI_Tick*4);
	 Prepare_IFS(&XAOSZ_IFS);
	 Copy_Frame(Frame,XAOS3_PIC.Data);
	 FDraw_IFS(Frame,&XAOSZ_IFS,3000);
	 Put_Frame(Frame);
	}
 Copy_Frame(Frame,XAOS3_PIC.Data);
 FDraw_IFS(Frame,b,3000);
 Put_Frame(Frame);
 while (CDMI_Tick<70);
}





void Draw_IFS(void)
{
 Palette *Pal;
 Pal=Malloc(sizeof(Palette));
 memset(Pal,0,sizeof(Palette));


 CDMI_Tick=2;
 while (CDMI_Tick<127)
	{
	 FZoom_Image(Screen,(128-CDMI_Tick)*160/128,(128-CDMI_Tick)*100/128,319-(128-CDMI_Tick)*160/128,199-(128-CDMI_Tick)*100/128,&XAOS3_PIC);
	 Set_Tween_Palette(&XAOS4_PAL,Pal,CDMI_Tick<<1);
	}

 Set_Palette(&XAOS4_PAL);
 Prepare_IFS(&XAOS0_IFS);
 Prepare_IFS(&XAOS1_IFS);
 Prepare_IFS(&XAOS2_IFS);
 Prepare_IFS(&XAOS3_IFS);
 Prepare_IFS(&XAOS4_IFS);
 Prepare_IFS(&XAOS5_IFS);
 Prepare_IFS(&XAOS6_IFS);
 Prepare_IFS(&XAOS7_IFS);
 Prepare_IFS(&XAOS8_IFS);
 Prepare_IFS(&XAOS9_IFS);
 Prepare_IFS(&XAOSA_IFS);
 Do_Tween(&XAOS0_IFS,&XAOS1_IFS);
 Do_Tween(&XAOS1_IFS,&XAOS2_IFS);
 Do_Tween(&XAOS2_IFS,&XAOS3_IFS);
 Do_Tween(&XAOS3_IFS,&XAOS4_IFS);
 Do_Tween(&XAOS4_IFS,&XAOS2_IFS);
 Do_Tween(&XAOS2_IFS,&XAOS5_IFS);
 Do_Tween(&XAOS5_IFS,&XAOS6_IFS);
 Do_Tween(&XAOS6_IFS,&XAOS7_IFS);
 Do_Tween(&XAOS7_IFS,&XAOS3_IFS);
 Do_Tween(&XAOS3_IFS,&XAOS8_IFS);
 Do_Tween(&XAOS8_IFS,&XAOS9_IFS);
 Do_Tween(&XAOS9_IFS,&XAOS6_IFS);
 Do_Tween(&XAOS6_IFS,&XAOSA_IFS);
 Do_Tween(&XAOSA_IFS,&XAOS0_IFS);

 Free(Pal);
}







void Map_Images(void)
{
 char *Frame2;

 Frame2=Malloc(64000L);

 CDMI_Tick=1;
 while (CDMI_Tick<260)
	{
	 Clear_Frame(Frame2,0);
	 FMap_Image(Frame2,(unsigned long)pow(1.05,CDMI_Tick+100),FrameB);
	 Put_Frame(Frame2);
	}

 Clear_Screen(0);
 Set_Palette(&XAOS5_PAL);
 FZoom_Texture(Frame,0,0,319,199,&XAOS5_PIC);
 CDMI_Tick=1;
 while (CDMI_Tick<260)
	 FMap_Image(Screen,pow(1.05,260-CDMI_Tick+100),FrameB);

 Free(Frame2);
}




/****************************************************************************
 **
 ** A nice exploding xaos at the end
 **
 **/

void Explode_XAOS(void)
{

}



/****************************************************************************
 **
 ** Another very fine routine to rotate an image on the screen like in
 ** Second Reality
 **/
void Rotate_Picture(void)
{
 double a,b;
 Palette *Pal,*WPal;


 Set_Palette(&XAOS5_PAL);
 Pal=Malloc(sizeof(Palette));
 memset(Pal,0,sizeof(Palette));
 WPal=Malloc(sizeof(Palette));
 memset(WPal,255,sizeof(Palette));
 CDMI_Tick=0;
 FZoom_Texture(Frame,0,0,319,199,&XAOS5_PIC);
 FDraw_Text(Frame,96,160,"Monty Python and",161);
 FDraw_Text(Frame,32,180,"The castle of Aaaaaarrrggghhh...",161);
 Put_Frame(Frame);
 while(CDMI_Tick<60);

 CDMI_Tick=1;
 while(CDMI_Tick<1000)
	{
	 if (CDMI_Tick<64)
		Set_Tween_Palette(&XAOS5_PAL,WPal,CDMI_Tick<<2);
	 a=(cos((double)CDMI_Tick/60)*CDMI_Tick*3);
	 b=(sin((double)CDMI_Tick/60)*CDMI_Tick*3);
	 FDraw_Texture(Screen,(int)a,(int)b,&XAOS5_PIC);
	 if (BIOS_kbhit)
	       {
		getkey();
		break;
	       }
	 if (CDMI_Tick>875)
		Set_Tween_Palette(Pal,&XAOS5_PAL,(CDMI_Tick-875)<<1);
	}

 Free(WPal);
 Free(Pal);
}





/****************************************************************************
 **
 ** This is a little shit-bob routine
 **
 **/

void Draw_Shade_Bobs(double x,double y)
{
 double Count1=30,Count2=0;
 Palette *Pal;

 Pal=Malloc(sizeof(Palette));
 memset(Pal,0,sizeof(Palette));

 Set_Palette(Pal);
 for (Count1=0;Count1<30;Count1++)
	{
	 FDraw_Bob(Screen,(unsigned int)(160+100*sin(y*Count1)),
			  (unsigned int)(100+80*sin(x*Count1)),&XAOS6_PIC);
	}

 CDMI_Tick=0;
 while (Count1<700)
	{
	 while (!CDMI_Tick);
	 CDMI_Tick=0;
	 FDraw_Bob(Screen,(unsigned int)(160+100*sin(y*Count1)),
			  (unsigned int)(100+80*sin(x*Count1)),&XAOS6_PIC);
	 FDelete_Bob(Screen,(unsigned int)(160+100*sin(y*Count2)),
			    (unsigned int)(100+80*sin(x*Count2)),&XAOS6_PIC);
	 Count1++;
	 Count2++;
	 FDraw_Bob(Screen,(unsigned int)(160+100*sin(y*Count1)),
			  (unsigned int)(100+80*sin(x*Count1)),&XAOS6_PIC);
	 FDelete_Bob(Screen,(unsigned int)(160+100*sin(y*Count2)),
			    (unsigned int)(100+80*sin(x*Count2)),&XAOS6_PIC);
	 Count1++;
	 Count2++;
	 FDraw_Bob(Screen,(unsigned int)(160+100*sin(y*Count1)),
			  (unsigned int)(100+80*sin(x*Count1)),&XAOS6_PIC);
	 FDelete_Bob(Screen,(unsigned int)(160+100*sin(y*Count2)),
			    (unsigned int)(100+80*sin(x*Count2)),&XAOS6_PIC);
	 Count1++;
	 Count2++;
	 if (Count2<64)
		Set_Tween_Palette(&XAOS6_PAL,Pal,(unsigned int)Count2*4);
	 if (Count1>640)
		Set_Tween_Palette(Pal,&XAOS6_PAL,(unsigned int)(Count1-640)*4);
	}

 Free(Pal);
}




void Bobs(void)
{
 int i,j;
 Clear_Frame(Screen,0);
 Draw_Shade_Bobs(0.0714,0.0823);

 Clear_Frame(Screen,0);
 Draw_Shade_Bobs(0.0655,0.0971);

 Clear_Frame(Screen,0);
 for (i=0;i<4;i++)
	for (j=0;j<8;j++)
		FPut_Image(Screen,i*80,j*25,&XAOS7_PIC);
 Draw_Shade_Bobs(0.102,0.0571);
}




/****************************************************************************
 **
 ** This is the wobbler of the texture
 **
 **/
void Wobbler(void)
{
 Palette *SPal,*DPal;

 SPal=Malloc(sizeof(Palette));
 DPal=Malloc(sizeof(Palette));
 memset(SPal,0,sizeof(Palette));
 memset(DPal,255,sizeof(Palette));

 Clear_Screen(0);
 Set_Palette(SPal);
 CDMI_Tick=0;
 while (CDMI_Tick<500)
	{
	 FWobble_Texture(Screen,CDMI_Tick<<1,CDMI_Tick,&XAOS5_PIC+6912);
	 if (CDMI_Tick<64)
		Set_Tween_Palette(&XAOS5_PAL,SPal,CDMI_Tick*4);
	 if (CDMI_Tick>440)
		Set_Tween_Palette(DPal,&XAOS5_PAL,(CDMI_Tick-440)*4);
	}
 Free(DPal);
 Free(SPal);
}



/****************************************************************************
 **
 ** This is the great circle-alogrithm
 **
 **/
void Circles(void)
{
 Palette *Pal;

 Pal=Malloc(sizeof(Palette));
 memset(Pal,0,sizeof(Palette));

 Clear_Screen(0);
 Set_Palette(&XAOS6_PAL);
 CDMI_Tick=0;
 while (CDMI_Tick<350)
	{
	 FDraw_Moire(Screen,((unsigned long)CDMI_Tick)<<9);
	 if (CDMI_Tick>290)
		Set_Tween_Palette(Pal,&XAOS6_PAL,(CDMI_Tick-290)<<2);
	}

 Free(Pal);
}


/****************************************************************************
 **
 ** This plasma routines use four cosine functions in order to draw a
 ** real-time animated plasma on your screen.
 **
 **/
void Plasma(void)
{
 Clear_Screen(0);
 Set_Palette(&XAOS9_PAL);
 CDMI_Tick=250;
 while (CDMI_Tick<500)
	{
	 FDraw_Plasma(Screen,CDMI_Tick*3,-CDMI_Tick,-CDMI_Tick<<1,CDMI_Tick);
	}
}


/****************************************************************************
 **
 ** This is the universal test routine for multiple purpose
 **
 **/
// #define DO_TEST

void Test(void)
{
}



/****************************************************************************
 **
 ** This is the dentro with a nice font-scroller
 ** The first letter in the text specifies the colour:
 **
 **  A  -  dark
 **  B  -  middle
 **  C  -  bright
 **/
static char *Dentro_Text[]={
			    "",
			    "",
			    "",
			    "",
			    "",
			    "",
			    "",
			    "- X - A - O - S -",
			    "",
			    "brought to you by",
			    "C y b e r D y n e",
			    "in 1995",
			    "",
			    "",
			    "",
			    "Code:",
			    "Marc van Shaney",
			    "",
			    "Music:",
			    "Marc van Shaney",
			    "",
			    "Music player:",
			    "Marc van Shaney",
			    "",
			    "Some of the IFSs:",
			    "Adapted from a book called",
			    "The Tricks of the Graphics Gurus",
			    "",
			    "Parts of the rotating picture:",
			    "The Faker of Aardvark",
			    "",
			    "The picture of the castle:",
			    "Don't know",
			    "",
			    "Everything else:",
			    "Marc van Shaney",
			    "",
			    "",
			    "",
			    "Greets go to:",
			    "",
			    "Aardvark",
			    "Future Crew",
			    "Triton",
			    "VangeliSTeam",
			    "Witan",
			    "Xography",
			    "Vision Factory",
			    "Legend Design",
			    "Maral (my sister ;-)",
			    "",
			    "",
			    "",
			    "The music was composed with",
			    "PSI's great Scream Tracker 3",
			    "",
			    "",
			    "",
			    "I especially want to greet",
			    "Boris Bertelsons",
			    "&",
			    "Mathias Rasch",
			    "for writing their great book",
			    "called",
			    "PC Underground",
			    "",
			    "G E T   I T   ! ! !",
			    "",
			    "",
			    "",
			    "",
			    "",
			    "",
			    "",
			    "",
			    "",
			    ""};

void Dentro(void)
{
 int i=0,j,len;
 Palette *Pal;
 Pal=Malloc(sizeof(Palette));
 memset(Pal,255,sizeof(Palette));

 Clear_Screen(0);
 Clear_Frame(Frame,0);
 FMagnify_Frame(Screen,0,Frame);

 CDMI_Tick=0;
 while(CDMI_Tick<64)
	Set_Tween_Palette(&XAOS8_PAL,Pal,CDMI_Tick<<2);

 CDMI_Tick=61;
 while (i<68)
	{
	 if (CDMI_Tick>60)
		{
		 Clear_Frame(Frame,0);
		 for (j=0;j<7;j++)
			{
			 len=strlen(Dentro_Text[j+i]);
			 FDraw_Text(Frame,160-(len<<2),j*15,Dentro_Text[j+i],128);
			}
		 CDMI_Tick-=60;
		 i++;
		}
	 FMagnify_Frame(Screen,CDMI_Tick<<6,Frame);
	 if (BIOS_kbhit)
		{
		 getkey();
		 break;
		}
	}

 memset(Pal,0,sizeof(Palette));
 CDMI_Tick=0;
 while (CDMI_Tick<64)
	{
	 Set_Tween_Palette(Pal,&XAOS8_PAL,CDMI_Tick<<2);
	 CDMI_Set_Volume(128-(CDMI_Tick<<1));
	}

 Free(Pal);
}





/****************************************************************************
 **
 ** This is the main routine with the setup
 ** This routine also initates the graphics mode and calls the other
 ** parts of this demo
 **/

void main (void)
{
 int SONG_Frequency,i,j,k,l;
 SoundDrv *SND;

 if(Init_EXT386(4096,EXT_EXIT_ON_RESET|EXT_VERBOSE_PAUSE|EXT_EXIT_ON_LOWMEM)<0)
	exit(-1);
 printf("\nXAOS - Demo\n");
 printf("(c) 1995 by Marc van Shaney\n");
 printf("         a.k.a. Kaya Memisoglu\n");
 printf("\nPlease select your Sound device:\n");
 printf("  1. PC-Speaker\n");
 printf("  2. AdLib\n");
 printf("  3. DAC at printer-port\n");
 printf("  4. SoundBlaster DMA\n");
 printf("  5. SoundBlaster Timer\n");

 do {
     i=getkey();
     switch (i)
	{
	 case '1':
		SND=SPEAKER_Driver;
		break;
	 case '2':
		SND=ADLIB_Driver;
		break;
	 case '3':
		SND=LPT_Driver;
		break;
	 case '4':
		SND=SBDMA_Driver;
		break;
	 case '5':
		SND=SBTIMER_Driver;
		break;
	}
    }
 while ((i<'1') && (i>'5'));

 Config_Driver((Driver_Header *)SND);

 printf("\nSelect song frequency:\n");
 printf("  1. 8  kHz\n");
 printf("  2. 12 kHz\n");
 printf("  3. 16 kHz\n");
 printf("  4. 22 kHz\n");

 do {
     i=getkey();
     switch (i)
	{
	 case '1':
		SONG_Frequency=8000;
		break;
	 case '2':
		SONG_Frequency=12000;
		break;
	 case '3':
		SONG_Frequency=16000;
		break;
	 case '4':
		SONG_Frequency=22000;
		break;
	}
    }
 while ((i<'1') && (i>'4'));


 Init_Graphic();
 Set_Palette(&XAOS6_PAL);
 FDraw_Text(Screen,108,93,"Loading . . .",70);
 (*SND->Init_Driver)();
 CDMI_Load_S3M("XAOS.S3M");
 CDMI_Play_Song(SONG_Frequency,CDMI_LOOP_FLAG,SND);
 FrameB=Malloc(64032L);
 FrameB->Width=320;
 FrameB->Height=200;
 Frame=FrameB->Data;

 Intro();
 Mandel();
 Lens();
 Draw_IFS();
 Map_Images();
 Rotate_Picture();
 Bobs();
 Plasma();
 Circles();
 Wobbler();
 Dentro();


 Free(FrameB);
 CDMI_Stop_Song();
 CDMI_Free_Song();
 (*SND->Exit_Driver)();
 Exit_Graphic();
 Exit_EXT386();

 gotoxy(1,18);
 memcpy(MK_FP(0x0b800,0),XAOS_ADDY,4000);
}
