
#include <app/Application.h>
#include <InterfaceKit.h>
#include <StorageKit.h>
#include <SupportKit.h>
#include <TranslationKit.h>
#include <errno.h>

#include "Sanity.h"
#include "ScanWindow.h"
#include "MainWindow.h"
#include "BitmapView.h"

#include "BeSANE.h"

// --------------------------------------------------------------
MainWindow::MainWindow(BRect Frame)
	: BWindow(Frame, SOFTWARE_NAME, B_DOCUMENT_WINDOW, B_ASYNCHRONOUS_CONTROLS),
	m_image(NULL) {
	
	BMenuBar *	menu_bar;
	BMenu *		menu;
	BMenuItem *	item;
	BRect		r;
	
	
	m_savePanel = new TranslatorSavePanel("TranslatorSavePanel",
										new BMessenger(this), NULL, 0, false,
										new BMessage(SAVE_FILE_PANEL_MSG)); 

	r = Bounds();
	
	// File Menu
	menu = new BMenu(SOFTWARE_NAME);
	item = new BMenuItem("About", new BMessage(B_ABOUT_REQUESTED));
	item->SetTarget(be_app);
	menu->AddItem(item);
	menu->AddSeparatorItem();
	item = new BMenuItem("New Window", new BMessage(Sanity::NEW_WINDOW_MSG), 'N');
	item->SetTarget(be_app);
	menu->AddItem(item);
	menu->AddSeparatorItem();
	menu->AddItem(new BMenuItem("Save As" B_UTF8_ELLIPSIS, new BMessage(SAVE_AS_MSG)));
	menu->AddSeparatorItem();
	menu->AddItem(new BMenuItem("Close", new BMessage(B_QUIT_REQUESTED), 'W'));
	item = new BMenuItem("Quit", new BMessage(B_QUIT_REQUESTED), 'Q');
	item->SetTarget(be_app);
	menu->AddItem(item);
	
		
	// Okay, add our menu bar
	menu_bar = new BMenuBar(r, "menu_bar");
	menu_bar->AddItem(menu);
	menu_bar->AddItem(new BMenuItem("Scan!",new BMessage(SCAN_MSG)));
	AddChild(menu_bar);

	r = Bounds();
	r.top		= menu_bar->Bounds().bottom+1;
	r.right 	-= B_V_SCROLL_BAR_WIDTH;
	r.bottom 	-= B_H_SCROLL_BAR_HEIGHT;
	
	m_bitmapView 		= new BitmapView(r, NULL);
	BScrollView *	sv 	= new BScrollView("bitmap_scroll", m_bitmapView,
										B_FOLLOW_ALL_SIDES, B_WILL_DRAW, true, true);
	AddChild(sv);
}


// --------------------------------------------------------------
MainWindow::~MainWindow() {
	delete m_savePanel;
	delete m_image;
}


// --------------------------------------------------------------
bool MainWindow::QuitRequested() {
	be_app->PostMessage(Sanity::WINDOW_CLOSED_MSG);
	return true;
}


// --------------------------------------------------------------
void MainWindow::MessageReceived(BMessage *	msg) {
	BBitmap* image = NULL;
	
	switch (msg->what){
		case SAVE_AS_MSG:
			doSaveAs();
			break;
						
		case SAVE_FILE_PANEL_MSG:
			doFilePanel(msg);
			break;
			
		case SCAN_MSG:
			((Sanity *)be_app)->Scan();
			break;
			
		case ScanWindow::SCAN_COMPLETE:
			msg->FindPointer("image",(void **)&image);
			ASSERT(image != NULL);
			m_bitmapView->SetBitmap(image);
			if ( m_image )
				delete m_image;
			m_image = image;
			break;
					
		default:	
			_inherited::MessageReceived(msg);
	}
}



// --------------------------------------------------------------
void MainWindow::doScan(void) {
}



// Save As
void MainWindow::doSaveAs(void) {
	if ( ! m_image ) {
		BAlert *alert = new BAlert(NULL, "No image to save.", "Doh!",
							NULL, NULL, B_WIDTH_AS_USUAL, B_STOP_ALERT);
		alert->Go();
		return;
	}
/*				
	if ( ! m_savePanel )
		m_savePanel = new TranslatorSavePanel("TranslatorSavePanel",
												new BMessenger(this), NULL, 0, false,
												new BMessage(SAVE_FILE_PANEL_MSG)); 
*/
	m_savePanel->Window()->SetWorkspaces(B_CURRENT_WORKSPACE);
	m_savePanel->Show();
}




// Other save stuff???
void MainWindow::doFilePanel(BMessage* msg) {
	// Recover the necessary data from the message
	translator_id * id;
	uint32 			format;
	ssize_t 		length = sizeof(translator_id);

	if ( msg->FindData("translator_id", B_RAW_TYPE, (const void **)&id, &length) != B_OK)
		return;
	if ( msg->FindInt32("translator_format", (int32 *)&format) != B_OK)
		return;

	entry_ref dir;
	if ( msg->FindRef("directory", &dir) != B_OK)
		return;

	BDirectory bdir(&dir);
	const char *name;

	if ( msg->FindString("name", &name) != B_OK)
		return;
	if ( name == NULL )
		return;

	// Clobber any existing file or create a new one if it didn't exist
	BFile file(&bdir, name, B_WRITE_ONLY | B_CREATE_FILE | B_ERASE_FILE);
	if (file.InitCheck() != B_OK) {
		BAlert *alert = new BAlert(NULL, "Could not create file.", "OK");
		alert->Go();
		return;
	}

	BTranslatorRoster * roster = BTranslatorRoster::Default();
	BBitmapStream stream(m_image);

	// If the id is no longer valid or the translator fails for any other
	// reason, catch it here
	if ( roster->Translate(*id, &stream, NULL, &file, format) != B_OK) {
		BAlert * alert = new BAlert(NULL, "Could not save the image.", "OK");
		alert->Go();
	}

	// Reclaim the ownership of the bitmap, otherwise it would be deleted
	// when stream passes out of scope
	stream.DetachBitmap(&m_image);
}
