#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>

#include <Application.h>
#include <Window.h>
#include <Alert.h>

#include "Sanity.h"
#include "MainWindow.h"
#include "ScanWindow.h"

#include "BeSANE.h"

const char * APPLICATION_SIGNATURE = "application/x-vnd." SOFTWARE_EDITOR "-" SOFTWARE_NAME;

const char * STR_ABOUT_TITLE =	"About " SOFTWARE_NAME;
const char * STR_ABOUT_BUTTON =	"Big Deal";	// "Hum?"
const char * STR_ABOUT_TEXT = 	SOFTWARE_NAME " " SOFTWARE_VERSION_LABEL "\n" \
								"A little BeSANE front-end.\n\n" \
								"The " SOFTWARE_NAME " Team:\n\n" \
								"Philippe Houdoin\n" \
								"Cedric Degea\n" \
								"Kaya Memisoglu <k.memisoglu@majix.de>\n" \
								"\n" \
								"This version is based on a rather old version\n" \
								"of Sanity from Philippe Houdoin and it has been\n" \
								"improved by Kaya Memisoglu.";

// --------------------------------------------------------------
int main() {
	// Create an application instance
	Sanity * app;

	app = new Sanity();
	app->Run();
	delete app;
	
	return 0;
}



// --------------------------------------------------------------
Sanity::Sanity()
	: BApplication(APPLICATION_SIGNATURE) {
	m_windowRect.Set(50, 50, 400, 500);
	m_windowCount = 0;

	sane_init(0, NULL);
}



// -------------------------------------------------
Sanity::~Sanity() {
	sane_exit();
}


// -------------------------------------------------
void Sanity::ReadyToRun( void ) {
	// CReate the scan control window!
	m_controlPanel = new ControlPanel();
	m_controlPanel->Show();
	
	// Open at least one window!
	if ( m_windowCount < 1 )
		PostMessage(NEW_WINDOW_MSG);
}


// --------------------------------------------------------------
bool Sanity::QuitRequested() {
	m_controlPanel->Quit();
	return true;
}
	
	
// --------------------------------------------------------------
void Sanity::MessageReceived(BMessage * pMsg) {
	switch( pMsg->what )  {
		case NEW_WINDOW_MSG:
			{
			MainWindow * window = new MainWindow(m_windowRect);
			window->Show();

			m_windowRect.OffsetBy(40, 40);
			m_windowCount++;
			break;
			}
			
		case WINDOW_CLOSED_MSG:
			m_windowCount--;
			if ( m_windowCount < 1 )
				PostMessage(B_QUIT_REQUESTED);
			break;
			
		default:
			_inherited::MessageReceived( pMsg );
			break;
	}
}


// --------------------------------------------------------------
void Sanity::RefsReceived(BMessage *	msg)  {
	switch (msg->what) {
		default:
			_inherited::MessageReceived(msg);
			break;
	}
}


// -------------------------------------------------
void Sanity::Scan(void) {
	ScanWindow* window = new ScanWindow(BPoint(100,100));
	window->Show();
	window->Scan(m_controlPanel->GetSelectedDeviceHandle());
}


// -------------------------------------------------
void Sanity::AboutRequested( void ) {
	BAlert * pAboutBox;
	
	pAboutBox = new BAlert(STR_ABOUT_TITLE, STR_ABOUT_TEXT, STR_ABOUT_BUTTON);
	pAboutBox->Go();
}

