#ifndef SCANWINDOW_H
#define SCANWINDOW_H

#include <InterfaceKit.h>
#include <kernel/OS.h>

#include "BeSANE.h"

class ScanWindow : public BWindow {
	public:
								ScanWindow(BPoint point);
								~ScanWindow();
							
		typedef BWindow 		inherited;

		// Virtual function overrides
	public:	
		// public constantes
		enum {
			SCAN_COMPLETE 	= 'scok',
			SCAN_ERROR		= 'scer',
			SCAN_CANCEL		= 'sccl',
			SCAN_START		= 'scst',
			SCAN_UPDATE		= 'scup'
		};
		
		void					Scan(SANE_Handle device);
		
		virtual void			MessageReceived(BMessage * msg);
		virtual	bool			QuitRequested(void);

	private:
		static int32			doScan(void *data);
		
		BStatusBar*				m_statusBar;
		BButton*				m_cancelButton;
		BBitmap*				m_image;
		thread_id				m_scanThread;
		SANE_Handle				m_device;
		BLooper*				m_target;
		volatile bool			m_cancel;
};


#endif
