#ifndef _BITMAPVIEW_H
#define _BITMAPVIEW_H

#include <InterfaceKit.h>


class BitmapView : public BView
{
	public:
		// Constructors, destructors, operators...
						BitmapView(BRect frame, BBitmap * bitmap);
						~BitmapView();
		
		typedef BView	inherited;
	
		// Virtual function overrides
	public:	
		virtual void 	Draw(BRect invalid);
		virtual void 	AttachedToWindow(void);
		virtual void 	FrameResized(float width, float height);

		// Public methods
	public:
		void			SetBitmap(BBitmap * bitmap);
		BBitmap *		GetBitmap() const;
		void			SetZoom(float factor);
		float			GetZoom(void) const;

		// From here, it's none of your business! ;-)
	private:
		void 		SetScrollbars(void);

		BBitmap *	m_image;
		BBitmap *	m_background;
		float		m_zoom;
};

#endif	// if BITMAPVIEW_H
