#ifndef CONTROLPANEL_H
#define CONTROLPANEL_H

#include <InterfaceKit.h>


#include "BeSANE.h"


class ControlPanel : public BWindow {
	public:
								ControlPanel();
								~ControlPanel();
							
		typedef BWindow 		inherited;

		// Virtual function overrides
	public:	
		// public constantes
		enum	{
			SET_DEVICE_MSG			= 'sdev',
			SET_BOOL_PROPERTY		= 'bprp',
			SET_INT_PROPERTY		= 'iprp',
			SET_INTLIST_PROPERTY	= 'ilpr',
			SET_INTRANGE_PROPERTY	= 'irpr',
			SET_STRING_PROPERTY		= 'sprp',
			SET_STRINGLIST_PROPERTY = 'slpr',
			SET_BUTTON_PROPERTY 	= 'bupr'
		};

		virtual void			MessageReceived(BMessage * msg);
		virtual	bool			QuitRequested(void);
		
		const SANE_Device*		GetSelectedDevice() const;
		SANE_Handle				GetSelectedDeviceHandle() const;

	private:
		bool					CreatePropertyPanel(void);
		bool					UpdatePropertyPanel(void);
	
		BView*					CreateBoolProperty(int idx, int x, int y);
		BView*					CreateNumberProperty(int idx, int x, int y);
		BView*					CreateRangeProperty(int idx, int x, int y);
		BView*					CreateStringProperty(int idx, int x, int y);
		BView*					CreateStringListProperty(int idx, int x, int y);
		BView*					CreateIntegerListProperty(int idx, int x, int y);
		BView*					CreateButtonProperty(int idx, int x, int y);
		BView*					CreateGroupProperty(int idx, int x, int y);
		
		bool					EnableNumberProperty(BView* parent, int idx);
		bool					EnableBoolProperty(BView* parent, int idx);
	
		const SANE_Device*		m_selectedDevice;
		SANE_Handle				m_selectedDeviceHandle;
		BView*					m_propertyPanel;
		BView*					m_locationPanel;
		BView*					m_colourPanel;
		BTabView*				m_tabView;
};

#endif
