#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <InterfaceKit.h>

#include "BeSANE.h"
#include "BitmapView.h"
#include "TranslatorSavePanel.h"
#include "ControlPanel.h"


// THE window class
class MainWindow : public BWindow {
	public:
		// Constructors, destructors, operators...
								MainWindow(BRect Frame);
								~MainWindow();
							
		typedef BWindow 		inherited;


		// public constantes
		enum	{
			SAVE_AS_MSG			= 'sava',
			SAVE_FILE_PANEL_MSG	= 'sfpm',
			SCAN_MSG 			= 'scan',
			ZOOM_MSG_12			= '012%',
			ZOOM_MSG_25			= '025%',
			ZOOM_MSG_50			= '050%',
			ZOOM_MSG_100		= '100%',
			ZOOM_MSG_200		= '200%',
			ZOOM_MSG_300		= '300%',
			ZOOM_MSG_400		= '400%',
			ZOOM_MSG_500		= '500%'
		};
				
		// Virtual function overrides
	public:	
		virtual void			MessageReceived(BMessage * msg);
		virtual	bool			QuitRequested(void);
		
		// From here, it's none of your business! ;-)
	protected:
		void					UpdateStatus(void);
		void					doSaveAs(void);
		void					doScan(void);
		void					doFilePanel(BMessage* msg);
		
	private:
		BBitmap*				m_image;
		TranslatorSavePanel*	m_savePanel;
		BitmapView*				m_bitmapView;
		BStringView*			m_statusText;
};


#endif // ifdef MAINWINDOW_H

