#ifndef SANITY_H
#define SANITY_H

#include <Application.h>
#include <Window.h>

#include "ControlPanel.h"


#define SOFTWARE_EDITOR			"prds"
#define SOFTWARE_NAME			"Sanity"
#define SOFTWARE_VERSION_LABEL	"majix:0.2.1"


class Sanity : public BApplication {
	public:
		// Constructors, destructors, operators...
						Sanity();
						~Sanity();

		typedef BApplication _inherited;
		
		// public constantes
		enum	{
			NEW_WINDOW_MSG		= 'neww',
			WINDOW_CLOSED_MSG	= 'wcls'
		};
				
	public:
		// Virtual function overrides
		virtual	void	MessageReceived(BMessage * msg);	
		virtual void	RefsReceived(BMessage * msg);
		virtual void	AboutRequested(void);
		virtual bool	QuitRequested(void);
		void			ReadyToRun(void);
		
		void			Scan(void);
		
		// From here, it's none of your business! ;-)
	private:
		BRect			m_windowRect;
		int				m_windowCount;
		ControlPanel*	m_controlPanel;
};

#endif // ifdef SANITY_H
